/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public class CBinaryExpression
extends ABinaryExpression
implements CExpression {
    private static final long serialVersionUID = 1902123965106390020L;
    private final CType calculationType;

    public CBinaryExpression(FileLocation pFileLocation, CType pExpressionType, CType pCalculationType, CExpression pOperand1, CExpression pOperand2, BinaryOperator pOperator) {
        super(pFileLocation, pExpressionType, pOperand1, pOperand2, pOperator);
        this.calculationType = pCalculationType;
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    public CType getCalculationType() {
        return this.calculationType;
    }

    @Override
    public CExpression getOperand1() {
        return (CExpression)super.getOperand1();
    }

    @Override
    public CExpression getOperand2() {
        return (CExpression)super.getOperand2();
    }

    @Override
    public BinaryOperator getOperator() {
        return (BinaryOperator)super.getOperator();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.calculationType) * 31 + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CBinaryExpression)) {
            return false;
        }
        CBinaryExpression other = (CBinaryExpression)obj;
        return Objects.equals(other.calculationType, this.calculationType) && super.equals(obj);
    }

    public static final class BinaryOperator
    extends Enum<BinaryOperator>
    implements ABinaryExpression.ABinaryOperator {
        public static final /* enum */ BinaryOperator MULTIPLY = new BinaryOperator("*");
        public static final /* enum */ BinaryOperator DIVIDE = new BinaryOperator("/");
        public static final /* enum */ BinaryOperator MODULO = new BinaryOperator("%");
        public static final /* enum */ BinaryOperator PLUS = new BinaryOperator("+");
        public static final /* enum */ BinaryOperator MINUS = new BinaryOperator("-");
        public static final /* enum */ BinaryOperator SHIFT_LEFT = new BinaryOperator("<<");
        public static final /* enum */ BinaryOperator SHIFT_RIGHT = new BinaryOperator(">>");
        public static final /* enum */ BinaryOperator LESS_THAN = new BinaryOperator("<");
        public static final /* enum */ BinaryOperator GREATER_THAN = new BinaryOperator(">");
        public static final /* enum */ BinaryOperator LESS_EQUAL = new BinaryOperator("<=");
        public static final /* enum */ BinaryOperator GREATER_EQUAL = new BinaryOperator(">=");
        public static final /* enum */ BinaryOperator BINARY_AND = new BinaryOperator("&");
        public static final /* enum */ BinaryOperator BINARY_XOR = new BinaryOperator("^");
        public static final /* enum */ BinaryOperator BINARY_OR = new BinaryOperator("|");
        public static final /* enum */ BinaryOperator EQUALS = new BinaryOperator("==");
        public static final /* enum */ BinaryOperator NOT_EQUALS = new BinaryOperator("!=");
        private final String op;
        private static final /* synthetic */ BinaryOperator[] $VALUES;

        public static BinaryOperator[] values() {
            return (BinaryOperator[])$VALUES.clone();
        }

        public static BinaryOperator valueOf(String name) {
            return Enum.valueOf(BinaryOperator.class, name);
        }

        private BinaryOperator(String pOp) {
            this.op = pOp;
        }

        @Override
        public String getOperator() {
            return this.op;
        }

        public boolean isLogicalOperator() {
            switch (this) {
                case MULTIPLY: 
                case DIVIDE: 
                case MODULO: 
                case PLUS: 
                case MINUS: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: 
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: {
                    return false;
                }
                case LESS_EQUAL: 
                case LESS_THAN: 
                case GREATER_EQUAL: 
                case GREATER_THAN: 
                case EQUALS: 
                case NOT_EQUALS: {
                    return true;
                }
            }
            throw new AssertionError((Object)"Unhandled case statement");
        }

        public BinaryOperator getSwitchOperandsSidesLogicalOperator() {
            assert (this.isLogicalOperator());
            switch (this) {
                case LESS_EQUAL: {
                    return GREATER_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case GREATER_EQUAL: {
                    return LESS_EQUAL;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
                case EQUALS: {
                    return EQUALS;
                }
                case NOT_EQUALS: {
                    return NOT_EQUALS;
                }
            }
            return this;
        }

        public BinaryOperator getOppositLogicalOperator() {
            assert (this.isLogicalOperator());
            switch (this) {
                case LESS_EQUAL: {
                    return GREATER_THAN;
                }
                case LESS_THAN: {
                    return GREATER_EQUAL;
                }
                case GREATER_EQUAL: {
                    return LESS_THAN;
                }
                case GREATER_THAN: {
                    return LESS_EQUAL;
                }
                case EQUALS: {
                    return NOT_EQUALS;
                }
                case NOT_EQUALS: {
                    return EQUALS;
                }
            }
            return this;
        }

        static {
            $VALUES = new BinaryOperator[]{MULTIPLY, DIVIDE, MODULO, PLUS, MINUS, SHIFT_LEFT, SHIFT_RIGHT, LESS_THAN, GREATER_THAN, LESS_EQUAL, GREATER_EQUAL, BINARY_AND, BINARY_XOR, BINARY_OR, EQUALS, NOT_EQUALS};
        }
    }
}

