/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

@RunWith(value=Parameterized.class)
public class CBinaryExpressionBuilderTest {
    @Parameterized.Parameter(value=0)
    public MachineModel machineModel;
    private static final CSimpleType S_CHAR = CNumericTypes.SIGNED_CHAR;
    private static final CSimpleType U_CHAR = CNumericTypes.UNSIGNED_CHAR;
    private static final CSimpleType S_SHORT_INT = CNumericTypes.SHORT_INT.getCanonicalType();
    private static final CSimpleType U_SHORT_INT = CNumericTypes.UNSIGNED_SHORT_INT;
    private static final CSimpleType S_INT = CNumericTypes.INT.getCanonicalType();
    private static final CSimpleType U_INT = CNumericTypes.UNSIGNED_INT;
    private static final CSimpleType S_LONG_INT = CNumericTypes.LONG_INT.getCanonicalType();
    private static final CSimpleType U_LONG_INT = CNumericTypes.UNSIGNED_LONG_INT;
    private static final CSimpleType S_LONG_LONG_INT = CNumericTypes.LONG_LONG_INT.getCanonicalType();
    private static final CSimpleType U_LONG_LONG_INT = CNumericTypes.UNSIGNED_LONG_LONG_INT;
    private static final List<CSimpleType> smallTypes = ImmutableList.of((Object)S_CHAR, (Object)U_CHAR, (Object)S_SHORT_INT, (Object)U_SHORT_INT, (Object)S_INT);
    private static final List<CSimpleType> bigTypes = ImmutableList.of((Object)U_INT, (Object)S_LONG_INT, (Object)U_LONG_INT, (Object)S_LONG_LONG_INT, (Object)U_LONG_LONG_INT);
    private LogManager logger;
    private CBinaryExpressionBuilder c;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getMachineModels() {
        return MachineModel.values();
    }

    @Before
    public void init() {
        this.logger = LogManager.createTestLogManager();
        this.c = new CBinaryExpressionBuilder(this.machineModel, this.logger);
    }

    @Test
    public void checkTypeForBinaryOperation() throws UnrecognizedCodeException {
        this.checkArithmeticTypes(CBinaryExpression.BinaryOperator.PLUS);
        this.checkArithmeticTypes(CBinaryExpression.BinaryOperator.MINUS);
        this.checkArithmeticTypes(CBinaryExpression.BinaryOperator.MULTIPLY);
        this.checkArithmeticCalculationTypes(CBinaryExpression.BinaryOperator.PLUS);
        this.checkArithmeticCalculationTypes(CBinaryExpression.BinaryOperator.MINUS);
        this.checkArithmeticCalculationTypes(CBinaryExpression.BinaryOperator.MULTIPLY);
        this.checkRelationalTypes(CBinaryExpression.BinaryOperator.EQUALS);
        this.checkRelationalTypes(CBinaryExpression.BinaryOperator.LESS_THAN);
        this.checkRelationalTypes(CBinaryExpression.BinaryOperator.GREATER_EQUAL);
    }

    private void checkArithmeticTypes(CBinaryExpression.BinaryOperator op) throws UnrecognizedCodeException {
        for (CSimpleType small1 : smallTypes) {
            for (CSimpleType small2 : smallTypes) {
                this.checkResult(op, small1, small2, S_INT);
                this.checkCalculation(op, small1, small2, S_INT);
            }
        }
        for (CSimpleType big : bigTypes) {
            for (CSimpleType small : smallTypes) {
                this.checkResult(op, big, small, big);
                this.checkCalculation(op, big, small, big);
            }
        }
    }

    private void checkRelationalTypes(CBinaryExpression.BinaryOperator op) throws UnrecognizedCodeException {
        for (CSimpleType small1 : smallTypes) {
            for (CSimpleType small2 : smallTypes) {
                this.checkResult(op, small1, small2, S_INT);
                this.checkCalculation(op, small1, small2, S_INT);
            }
        }
        for (CSimpleType big : bigTypes) {
            for (CSimpleType small : smallTypes) {
                this.checkResult(op, big, small, S_INT);
                this.checkCalculation(op, big, small, big);
            }
            for (CSimpleType big2 : bigTypes) {
                this.checkResult(op, big, big2, S_INT);
            }
        }
    }

    private void checkArithmeticCalculationTypes(CBinaryExpression.BinaryOperator op) throws UnrecognizedCodeException {
        this.checkCalculation(op, U_INT, U_INT, U_INT);
        if (this.machineModel == MachineModel.LINUX32 || this.machineModel == MachineModel.ARM) {
            this.checkCalculation(op, U_INT, S_LONG_INT, U_LONG_INT);
        } else {
            this.checkCalculation(op, U_INT, S_LONG_INT, S_LONG_INT);
        }
        this.checkCalculation(op, U_INT, U_LONG_INT, U_LONG_INT);
        this.checkCalculation(op, U_INT, S_LONG_LONG_INT, S_LONG_LONG_INT);
        this.checkCalculation(op, U_INT, U_LONG_LONG_INT, U_LONG_LONG_INT);
        this.checkCalculation(op, S_LONG_INT, S_LONG_INT, S_LONG_INT);
        this.checkCalculation(op, S_LONG_INT, U_LONG_INT, U_LONG_INT);
        this.checkCalculation(op, S_LONG_INT, S_LONG_LONG_INT, S_LONG_LONG_INT);
        this.checkCalculation(op, S_LONG_INT, U_LONG_LONG_INT, U_LONG_LONG_INT);
        this.checkCalculation(op, U_LONG_INT, U_LONG_INT, U_LONG_INT);
        if (this.machineModel == MachineModel.LINUX64 || this.machineModel == MachineModel.ARM64) {
            this.checkCalculation(op, U_LONG_INT, S_LONG_LONG_INT, U_LONG_LONG_INT);
        } else {
            this.checkCalculation(op, U_LONG_INT, S_LONG_LONG_INT, S_LONG_LONG_INT);
        }
        this.checkCalculation(op, U_LONG_INT, U_LONG_LONG_INT, U_LONG_LONG_INT);
        this.checkCalculation(op, S_LONG_LONG_INT, S_LONG_LONG_INT, S_LONG_LONG_INT);
        this.checkCalculation(op, S_LONG_LONG_INT, U_LONG_LONG_INT, U_LONG_LONG_INT);
        this.checkCalculation(op, U_LONG_LONG_INT, U_LONG_LONG_INT, U_LONG_LONG_INT);
    }

    private void checkCalculation(CBinaryExpression.BinaryOperator op, CType t1, CType t2, CType target) throws UnrecognizedCodeException {
        Truth.assertThat((Object)this.c.getCalculationTypeForBinaryOperation(t1, t2, op, CIntegerLiteralExpression.ZERO, CIntegerLiteralExpression.ZERO)).isEqualTo((Object)target);
        Truth.assertThat((Object)this.c.getCalculationTypeForBinaryOperation(t2, t1, op, CIntegerLiteralExpression.ZERO, CIntegerLiteralExpression.ZERO)).isEqualTo((Object)target);
    }

    private void checkResult(CBinaryExpression.BinaryOperator op, CType t1, CType t2, CType target) throws UnrecognizedCodeException {
        Truth.assertThat((Object)this.c.getResultTypeForBinaryOperation(t1, t2, op, CIntegerLiteralExpression.ZERO, CIntegerLiteralExpression.ZERO)).isEqualTo((Object)target);
        Truth.assertThat((Object)this.c.getResultTypeForBinaryOperation(t2, t1, op, CIntegerLiteralExpression.ZERO, CIntegerLiteralExpression.ZERO)).isEqualTo((Object)target);
    }
}

