/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public final class CComplexCastExpression
extends AbstractExpression
implements CLeftHandSide {
    private static final long serialVersionUID = -3131719369492162894L;
    private final CExpression operand;
    private final CType type;
    private final boolean isReal;

    public CComplexCastExpression(FileLocation pFileLocation, CType pExpressionType, CExpression pOperand, CType pType, boolean pIsRealCast) {
        super(pFileLocation, pExpressionType);
        this.isReal = pIsRealCast;
        this.operand = pOperand;
        this.type = pType;
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    public CExpression getOperand() {
        return this.operand;
    }

    public CType getType() {
        return this.type;
    }

    public boolean isImaginaryCast() {
        return !this.isReal;
    }

    public boolean isRealCast() {
        return this.isReal;
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CLeftHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString(boolean pQualified) {
        if (this.isReal) {
            return "__real__ " + this.operand.toASTString(pQualified);
        }
        return "__imag__ " + this.operand.toASTString(pQualified);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.operand, this.type, this.isReal) * 31 + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CComplexCastExpression) || !super.equals(obj)) {
            return false;
        }
        CComplexCastExpression other = (CComplexCastExpression)obj;
        return Objects.equals(other.operand, this.operand) && Objects.equals(other.type, this.type) && other.isReal == this.isReal;
    }
}

