/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public final class CFieldReference
extends AbstractExpression
implements CLeftHandSide {
    private static final long serialVersionUID = 3207784831993480113L;
    private final String name;
    private final CExpression owner;
    private final boolean isPointerDereference;

    public CFieldReference(FileLocation pFileLocation, CType pType, String pName, CExpression pOwner, boolean pIsPointerDereference) {
        super(pFileLocation, pType);
        this.name = pName;
        this.owner = pOwner;
        this.isPointerDereference = pIsPointerDereference;
        assert (this.checkFieldAccess());
    }

    private boolean checkFieldAccess() throws IllegalArgumentException {
        CType structType = this.owner.getExpressionType().getCanonicalType();
        if (structType instanceof CProblemType) {
            return true;
        }
        if (structType instanceof CPointerType) {
            Preconditions.checkArgument((boolean)this.isPointerDereference, (String)"Field access for pointer type in %s", (Object)this);
            structType = ((CPointerType)structType).getType();
            if (structType instanceof CProblemType) {
                return true;
            }
        } else {
            Preconditions.checkArgument((!this.isPointerDereference ? 1 : 0) != 0, (String)"Pointer dereference of non-pointer in %s", (Object)this);
        }
        Preconditions.checkArgument((boolean)(structType instanceof CCompositeType), (String)"Field access for non-composite type %s in %s", (Object)structType, (Object)this);
        boolean found = false;
        for (CCompositeType.CCompositeTypeMemberDeclaration field : ((CCompositeType)structType).getMembers()) {
            if (!field.getName().equals(this.name)) continue;
            found = true;
            break;
        }
        Preconditions.checkArgument((boolean)found, (String)"Accessing unknown field %s of type %s in %s", (Object)this.name, (Object)structType, (Object)this);
        return true;
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    public String getFieldName() {
        return this.name;
    }

    public CExpression getFieldOwner() {
        return this.owner;
    }

    public boolean isPointerDereference() {
        return this.isPointerDereference;
    }

    public CFieldReference withExplicitPointerDereference() {
        CType structType;
        if (!this.isPointerDereference) {
            return this;
        }
        CType pointerType = this.owner.getExpressionType().getCanonicalType();
        if (pointerType instanceof CProblemType) {
            structType = pointerType;
        } else if (pointerType instanceof CPointerType) {
            structType = ((CPointerType)pointerType).getType();
        } else {
            throw new AssertionError((Object)("Pointer dereference of non-pointer in " + this));
        }
        CPointerExpression pointerDereference = new CPointerExpression(this.getFileLocation(), structType, this.owner);
        return new CFieldReference(this.getFileLocation(), this.getExpressionType(), this.name, pointerDereference, false);
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CLeftHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public String toASTString(boolean pQualified) {
        String left = this.owner instanceof CFieldReference ? this.owner.toASTString(pQualified) : this.owner.toParenthesizedASTString(pQualified);
        String op = this.isPointerDereference ? "->" : ".";
        return left + op + this.name;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isPointerDereference, this.name, this.owner) * 31 + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CFieldReference) || !super.equals(obj)) {
            return false;
        }
        CFieldReference other = (CFieldReference)obj;
        return other.isPointerDereference == this.isPointerDereference && Objects.equals(other.name, this.name) && Objects.equals(other.owner, this.owner);
    }
}

