/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.math.BigDecimal;
import org.sosy_lab.cpachecker.cfa.ast.AFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public final class CFloatLiteralExpression
extends AFloatLiteralExpression
implements CLiteralExpression {
    private static final long serialVersionUID = 5021145411123854111L;

    public CFloatLiteralExpression(FileLocation pFileLocation, CType pType, BigDecimal pValue) {
        super(pFileLocation, pType, pValue);
    }

    public static CFloatLiteralExpression forPositiveInfinity(FileLocation pFileLocation, CType pType) throws NumberFormatException {
        return new CFloatLiteralExpression(pFileLocation, pType, CFloatLiteralExpression.getInfinityApprox(false, pType));
    }

    public static CFloatLiteralExpression forNegativeInfinity(FileLocation pFileLocation, CType pType) throws NumberFormatException {
        return new CFloatLiteralExpression(pFileLocation, pType, CFloatLiteralExpression.getInfinityApprox(true, pType));
    }

    private static BigDecimal getInfinityApprox(boolean pIsNegative, CType pType) {
        BigDecimal APPROX_INFINITY = BigDecimal.valueOf(Double.MAX_VALUE).add(BigDecimal.valueOf(Double.MAX_VALUE));
        CBasicType basicType = ((CSimpleType)pType).getType();
        switch (basicType) {
            case FLOAT: 
            case DOUBLE: {
                if (pIsNegative) {
                    return APPROX_INFINITY.negate();
                }
                return APPROX_INFINITY;
            }
        }
        throw new NumberFormatException(String.format("Invalid type for float infinity: %s", pType));
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CFloatLiteralExpression)) {
            return false;
        }
        return super.equals(obj);
    }
}

