/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.AStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public final class CStringLiteralExpression
extends AStringLiteralExpression
implements CLiteralExpression {
    private static final long serialVersionUID = 2656216584704518185L;

    public CStringLiteralExpression(FileLocation pFileLocation, CType pType, String pValue) {
        super(pFileLocation, pType, pValue);
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public String toASTString() {
        return this.getValue();
    }

    public String getContentString() {
        String literal = this.getValue();
        return literal.substring(1, literal.length() - 1);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CStringLiteralExpression)) {
            return false;
        }
        return super.equals(obj);
    }

    public List<CCharLiteralExpression> expandStringLiteral(CArrayType type) {
        int i;
        String s = this.getContentString();
        int length = type.getLengthAsInt().orElse(s.length() + 1);
        assert (length >= s.length());
        ArrayList<CCharLiteralExpression> result = new ArrayList<CCharLiteralExpression>();
        for (i = 0; i < s.length(); ++i) {
            result.add(new CCharLiteralExpression(this.getFileLocation(), CNumericTypes.SIGNED_CHAR, s.charAt(i)));
        }
        for (i = s.length(); i < length; ++i) {
            result.add(new CCharLiteralExpression(this.getFileLocation(), CNumericTypes.SIGNED_CHAR, '\u0000'));
        }
        return result;
    }

    public CArrayType transformTypeToArrayType() throws UnrecognizedCodeException {
        CIntegerLiteralExpression length = new CIntegerLiteralExpression(this.getFileLocation(), new CSimpleType(false, false, CBasicType.INT, false, false, false, false, false, false, false), BigInteger.valueOf(this.getValue().length() - 1));
        if (this.getExpressionType() instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)this.getExpressionType();
            if (arrayType.getLengthAsInt().orElse(0) == 0) {
                arrayType = new CArrayType(false, false, arrayType.getType(), length);
            }
            return arrayType;
        }
        if (this.getExpressionType() instanceof CPointerType) {
            return new CArrayType(false, false, ((CPointerType)this.getExpressionType()).getType(), length);
        }
        throw new UnrecognizedCodeException("Assigning string literal to " + this.getExpressionType(), this);
    }
}

