/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;

public class CThreadOperationStatement
extends CFunctionCallStatement {
    private static final long serialVersionUID = -7543988390816591658L;
    private final boolean isSelfParallel;
    private final String assosiatedVariable;

    public CThreadOperationStatement(FileLocation pFileLocation, CFunctionCallExpression pFunctionCall, boolean selfParallel, String varName) {
        super(pFileLocation, pFunctionCall);
        this.isSelfParallel = selfParallel;
        this.assosiatedVariable = varName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.assosiatedVariable);
        result = 31 * result + (this.isSelfParallel ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CThreadOperationStatement other = (CThreadOperationStatement)obj;
        return this.isSelfParallel == other.isSelfParallel && Objects.equals(this.assosiatedVariable, other.assosiatedVariable);
    }

    public boolean isSelfParallel() {
        return this.isSelfParallel;
    }

    public String getVariableName() {
        return this.assosiatedVariable;
    }

    public static class CThreadJoinStatement
    extends CThreadOperationStatement {
        private static final long serialVersionUID = -2328781305617198230L;

        public CThreadJoinStatement(FileLocation pFileLocation, CFunctionCallExpression pFunctionCall, boolean pSelfParallel, String pVarName) {
            super(pFileLocation, pFunctionCall, pSelfParallel, pVarName);
        }
    }

    public static class CThreadCreateStatement
    extends CThreadOperationStatement {
        private static final long serialVersionUID = -1211707394397959801L;

        public CThreadCreateStatement(FileLocation pFileLocation, CFunctionCallExpression pFunctionCall, boolean pSelfParallel, String pVarName) {
            super(pFileLocation, pFunctionCall, pSelfParallel, pVarName);
        }
    }
}

