/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public final class CTypeIdExpression
extends AbstractExpression
implements CExpression {
    private static final long serialVersionUID = -665995216646475799L;
    private final TypeIdOperator operator;
    private final CType type;

    public CTypeIdExpression(FileLocation pFileLocation, CType pExpressionType, TypeIdOperator pOperator, CType pType) {
        super(pFileLocation, pExpressionType);
        this.operator = pOperator;
        this.type = pType;
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    public TypeIdOperator getOperator() {
        return this.operator;
    }

    public CType getType() {
        return this.type;
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public String toASTString(boolean pQualified) {
        return this.toASTString();
    }

    @Override
    public String toASTString() {
        return this.operator.getOperator() + "(" + this.type.toASTString("") + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.type}) * 31 + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CTypeIdExpression) || !super.equals(obj)) {
            return false;
        }
        CTypeIdExpression other = (CTypeIdExpression)obj;
        return Objects.equals((Object)other.operator, (Object)this.operator) && Objects.equals(other.type, this.type);
    }

    public static enum TypeIdOperator {
        SIZEOF("sizeof"),
        ALIGNOF("_Alignof"),
        TYPEOF("typeof");

        private final String cRepresentation;

        private TypeIdOperator(String pCRepresentation) {
            this.cRepresentation = pCRepresentation;
        }

        public String getOperator() {
            return this.cRepresentation;
        }
    }
}

