/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclarationVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public final class CVariableDeclaration
extends AVariableDeclaration
implements CDeclaration {
    private static final long serialVersionUID = 8303959164064236061L;
    private final CStorageClass cStorageClass;

    public CVariableDeclaration(FileLocation pFileLocation, boolean pIsGlobal, CStorageClass pCStorageClass, CType pType, String pName, String pOrigName, String pQualifiedName, CInitializer pInitializer) {
        super(pFileLocation, pIsGlobal, pType, (String)Preconditions.checkNotNull((Object)pName), pOrigName, pQualifiedName, pInitializer);
        this.cStorageClass = pCStorageClass;
        Preconditions.checkArgument((this.cStorageClass != CStorageClass.EXTERN || this.getInitializer() == null ? 1 : 0) != 0, (Object)"Extern declarations cannot have an initializer");
        Preconditions.checkArgument((this.cStorageClass == CStorageClass.EXTERN || this.cStorageClass == CStorageClass.AUTO ? 1 : 0) != 0, (String)"CStorageClass is %s", (Object)((Object)this.cStorageClass));
        Preconditions.checkArgument((pIsGlobal || this.cStorageClass == CStorageClass.AUTO ? 1 : 0) != 0);
        Preconditions.checkArgument((this.cStorageClass == CStorageClass.EXTERN || !(pType.getCanonicalType() instanceof CVoidType) ? 1 : 0) != 0, (String)"Cannot declare variable of type void: %s", (Object)this);
    }

    @Override
    public CType getType() {
        return (CType)super.getType();
    }

    public CStorageClass getCStorageClass() {
        return this.cStorageClass;
    }

    @Override
    public CInitializer getInitializer() {
        return (CInitializer)super.getInitializer();
    }

    public void addInitializer(CInitializer pCInitializer) {
        super.addInitializer(pCInitializer);
    }

    @Override
    public String toASTString(boolean pQualified) {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append(this.cStorageClass.toASTString());
        if (pQualified) {
            lASTString.append(this.getType().toASTString(this.getQualifiedName().replace("::", "__")));
        } else {
            lASTString.append(this.getType().toASTString(this.getName()));
        }
        if (this.getInitializer() != null) {
            lASTString.append(" = ");
            lASTString.append(this.getInitializer().toASTString(pQualified));
        }
        lASTString.append(";");
        return lASTString.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode((Object)this.cStorageClass);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CVariableDeclaration) || !super.equals(obj)) {
            return false;
        }
        CVariableDeclaration other = (CVariableDeclaration)obj;
        return Objects.equals((Object)other.cStorageClass, (Object)this.cStorageClass);
    }

    public int hashCodeWithOutStorageClass() {
        int prime = 31;
        int result = 7;
        return 31 * result + super.hashCode();
    }

    public boolean equalsWithoutStorageClass(Object obj) {
        return super.equals(obj);
    }

    @Override
    public <R, X extends Exception> R accept(CSimpleDeclarationVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }
}

