/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;

public interface TransformingCAstNodeVisitor<X extends Exception>
extends CAstNodeVisitor<CAstNode, X> {
    @Override
    default public CAstNode visit(CArrayDesignator pCArrayDesignator) throws X {
        CExpression newSubscriptExpression;
        CExpression oldSubscriptExpression = pCArrayDesignator.getSubscriptExpression();
        if (oldSubscriptExpression != (newSubscriptExpression = (CExpression)oldSubscriptExpression.accept(this))) {
            return new CArrayDesignator(pCArrayDesignator.getFileLocation(), newSubscriptExpression);
        }
        return pCArrayDesignator;
    }

    @Override
    default public CAstNode visit(CArrayRangeDesignator pCArrayRangeDesignator) throws X {
        CExpression oldFloorExpression = pCArrayRangeDesignator.getFloorExpression();
        CExpression newFloorExpression = (CExpression)oldFloorExpression.accept(this);
        CExpression oldCeilExpression = pCArrayRangeDesignator.getCeilExpression();
        CExpression newCeilExpression = (CExpression)oldCeilExpression.accept(this);
        if (oldFloorExpression != newFloorExpression || oldCeilExpression != newCeilExpression) {
            return new CArrayRangeDesignator(pCArrayRangeDesignator.getFileLocation(), newFloorExpression, newCeilExpression);
        }
        return pCArrayRangeDesignator;
    }

    @Override
    default public CAstNode visit(CFieldDesignator pCFieldDesignator) throws X {
        return pCFieldDesignator;
    }

    @Override
    default public CAstNode visit(CInitializerExpression pCInitializerExpression) throws X {
        CExpression newExpression;
        CExpression oldExpression = pCInitializerExpression.getExpression();
        if (oldExpression != (newExpression = (CExpression)oldExpression.accept(this))) {
            return new CInitializerExpression(pCInitializerExpression.getFileLocation(), newExpression);
        }
        return pCInitializerExpression;
    }

    @Override
    default public CAstNode visit(CInitializerList pCInitializerList) throws X {
        boolean initializersChanged = false;
        ImmutableList.Builder initializersBuilder = ImmutableList.builderWithExpectedSize((int)pCInitializerList.getInitializers().size());
        for (CInitializer oldInitializer : pCInitializerList.getInitializers()) {
            CInitializer newInitializer = (CInitializer)oldInitializer.accept(this);
            initializersBuilder.add((Object)newInitializer);
            if (oldInitializer == newInitializer) continue;
            initializersChanged = true;
        }
        if (initializersChanged) {
            return new CInitializerList(pCInitializerList.getFileLocation(), (List<CInitializer>)initializersBuilder.build());
        }
        return pCInitializerList;
    }

    @Override
    default public CAstNode visit(CDesignatedInitializer pDesignatedInitializer) throws X {
        boolean designatorsChanged = false;
        ImmutableList.Builder designatorsBuilder = ImmutableList.builderWithExpectedSize((int)pDesignatedInitializer.getDesignators().size());
        for (CDesignator oldDesignator : pDesignatedInitializer.getDesignators()) {
            CDesignator newDesignator = (CDesignator)oldDesignator.accept(this);
            designatorsBuilder.add((Object)newDesignator);
            if (oldDesignator == newDesignator) continue;
            designatorsChanged = true;
        }
        CInitializer oldRightHandSide = pDesignatedInitializer.getRightHandSide();
        CInitializer newRightHandSide = (CInitializer)oldRightHandSide.accept(this);
        if (designatorsChanged || oldRightHandSide != newRightHandSide) {
            return new CDesignatedInitializer(pDesignatedInitializer.getFileLocation(), (List<CDesignator>)designatorsBuilder.build(), newRightHandSide);
        }
        return pDesignatedInitializer;
    }

    @Override
    default public CAstNode visit(CFunctionCallExpression pCFunctionCallExpression) throws X {
        boolean parameterExpressionsChanged = false;
        ImmutableList.Builder parameterExpressionsBuilder = ImmutableList.builderWithExpectedSize((int)pCFunctionCallExpression.getParameterExpressions().size());
        for (CExpression oldParameterExpression : pCFunctionCallExpression.getParameterExpressions()) {
            CExpression newParameterExpression = (CExpression)oldParameterExpression.accept(this);
            parameterExpressionsBuilder.add((Object)newParameterExpression);
            if (oldParameterExpression == newParameterExpression) continue;
            parameterExpressionsChanged = true;
        }
        CFunctionDeclaration oldFunctionDeclaration = pCFunctionCallExpression.getDeclaration();
        CFunctionDeclaration newFunctionDeclaration = null;
        if (oldFunctionDeclaration != null) {
            newFunctionDeclaration = (CFunctionDeclaration)oldFunctionDeclaration.accept(this);
        }
        CExpression oldFunctionNameExpression = pCFunctionCallExpression.getFunctionNameExpression();
        CExpression newFunctionNameExpression = (CExpression)oldFunctionNameExpression.accept(this);
        if (parameterExpressionsChanged || oldFunctionDeclaration != newFunctionDeclaration || oldFunctionNameExpression != newFunctionNameExpression) {
            return new CFunctionCallExpression(pCFunctionCallExpression.getFileLocation(), pCFunctionCallExpression.getExpressionType(), newFunctionNameExpression, (List<CExpression>)parameterExpressionsBuilder.build(), newFunctionDeclaration);
        }
        return pCFunctionCallExpression;
    }

    @Override
    default public CAstNode visit(CBinaryExpression pCBinaryExpression) throws X {
        CExpression oldOperand1Expression = pCBinaryExpression.getOperand1();
        CExpression newOperand1Expression = (CExpression)oldOperand1Expression.accept(this);
        CExpression oldOperand2Expression = pCBinaryExpression.getOperand2();
        CExpression newOperand2Expression = (CExpression)oldOperand2Expression.accept(this);
        if (oldOperand1Expression != newOperand1Expression || oldOperand2Expression != newOperand2Expression) {
            return new CBinaryExpression(pCBinaryExpression.getFileLocation(), pCBinaryExpression.getExpressionType(), pCBinaryExpression.getCalculationType(), newOperand1Expression, newOperand2Expression, pCBinaryExpression.getOperator());
        }
        return pCBinaryExpression;
    }

    @Override
    default public CAstNode visit(CCastExpression pCCastExpression) throws X {
        CExpression newOperandExpression;
        CExpression oldOperandExpression = pCCastExpression.getOperand();
        if (oldOperandExpression != (newOperandExpression = (CExpression)oldOperandExpression.accept(this))) {
            return new CCastExpression(pCCastExpression.getFileLocation(), pCCastExpression.getExpressionType(), newOperandExpression);
        }
        return pCCastExpression;
    }

    @Override
    default public CAstNode visit(CCharLiteralExpression pCCharLiteralExpression) throws X {
        return pCCharLiteralExpression;
    }

    @Override
    default public CAstNode visit(CFloatLiteralExpression pCFloatLiteralExpression) throws X {
        return pCFloatLiteralExpression;
    }

    @Override
    default public CAstNode visit(CIntegerLiteralExpression pCIntegerLiteralExpression) throws X {
        return pCIntegerLiteralExpression;
    }

    @Override
    default public CAstNode visit(CStringLiteralExpression pCStringLiteralExpression) throws X {
        return pCStringLiteralExpression;
    }

    @Override
    default public CAstNode visit(CTypeIdExpression pCTypeIdExpression) throws X {
        return pCTypeIdExpression;
    }

    @Override
    default public CAstNode visit(CUnaryExpression pCUnaryExpression) throws X {
        CExpression newOperandExpression;
        CExpression oldOperandExpression = pCUnaryExpression.getOperand();
        if (oldOperandExpression != (newOperandExpression = (CExpression)oldOperandExpression.accept(this))) {
            return new CUnaryExpression(pCUnaryExpression.getFileLocation(), pCUnaryExpression.getExpressionType(), newOperandExpression, pCUnaryExpression.getOperator());
        }
        return pCUnaryExpression;
    }

    @Override
    default public CAstNode visit(CImaginaryLiteralExpression pCImaginaryLiteralExpression) throws X {
        CLiteralExpression newValueExpression;
        CLiteralExpression oldValueExpression = pCImaginaryLiteralExpression.getValue();
        if (oldValueExpression != (newValueExpression = (CLiteralExpression)oldValueExpression.accept(this))) {
            return new CImaginaryLiteralExpression(pCImaginaryLiteralExpression.getFileLocation(), pCImaginaryLiteralExpression.getExpressionType(), newValueExpression);
        }
        return pCImaginaryLiteralExpression;
    }

    @Override
    default public CAstNode visit(CAddressOfLabelExpression pCAddressOfLabelExpression) throws X {
        return pCAddressOfLabelExpression;
    }

    @Override
    default public CAstNode visit(CArraySubscriptExpression pCArraySubscriptExpression) throws X {
        CExpression oldArrayExpression = pCArraySubscriptExpression.getArrayExpression();
        CExpression newArrayExpression = (CExpression)oldArrayExpression.accept(this);
        CExpression oldSubscriptExpression = pCArraySubscriptExpression.getSubscriptExpression();
        CExpression newSubscriptExpression = (CExpression)oldSubscriptExpression.accept(this);
        if (oldArrayExpression != newArrayExpression || oldSubscriptExpression != newSubscriptExpression) {
            return new CArraySubscriptExpression(pCArraySubscriptExpression.getFileLocation(), pCArraySubscriptExpression.getExpressionType(), newArrayExpression, newSubscriptExpression);
        }
        return pCArraySubscriptExpression;
    }

    @Override
    default public CAstNode visit(CFieldReference pCFieldReference) throws X {
        CExpression newFieldOwnerExpression;
        CExpression oldFieldOwnerExpression = pCFieldReference.getFieldOwner();
        if (oldFieldOwnerExpression != (newFieldOwnerExpression = (CExpression)oldFieldOwnerExpression.accept(this))) {
            return new CFieldReference(pCFieldReference.getFileLocation(), pCFieldReference.getExpressionType(), pCFieldReference.getFieldName(), newFieldOwnerExpression, pCFieldReference.isPointerDereference());
        }
        return pCFieldReference;
    }

    @Override
    default public CAstNode visit(CIdExpression pCIdExpression) throws X {
        CSimpleDeclaration oldDeclaration = pCIdExpression.getDeclaration();
        CSimpleDeclaration newDeclaration = null;
        if (oldDeclaration != null) {
            newDeclaration = (CSimpleDeclaration)oldDeclaration.accept(this);
        }
        if (oldDeclaration != newDeclaration) {
            return new CIdExpression(pCIdExpression.getFileLocation(), pCIdExpression.getExpressionType(), pCIdExpression.getName(), newDeclaration);
        }
        return pCIdExpression;
    }

    @Override
    default public CAstNode visit(CPointerExpression pCPointerExpression) throws X {
        CExpression newOperandExpression;
        CExpression oldOperandExpression = pCPointerExpression.getOperand();
        if (oldOperandExpression != (newOperandExpression = (CExpression)oldOperandExpression.accept(this))) {
            return new CPointerExpression(pCPointerExpression.getFileLocation(), pCPointerExpression.getExpressionType(), newOperandExpression);
        }
        return pCPointerExpression;
    }

    @Override
    default public CAstNode visit(CComplexCastExpression pCComplexCastExpression) throws X {
        CExpression newOperandExpression;
        CExpression oldOperandExpression = pCComplexCastExpression.getOperand();
        if (oldOperandExpression != (newOperandExpression = (CExpression)oldOperandExpression.accept(this))) {
            return new CComplexCastExpression(pCComplexCastExpression.getFileLocation(), pCComplexCastExpression.getExpressionType(), newOperandExpression, pCComplexCastExpression.getType(), pCComplexCastExpression.isRealCast());
        }
        return pCComplexCastExpression;
    }

    @Override
    default public CAstNode visit(CFunctionDeclaration pCFunctionDeclaration) throws X {
        boolean parametersChanged = false;
        ImmutableList.Builder parametersBuilder = ImmutableList.builderWithExpectedSize((int)pCFunctionDeclaration.getParameters().size());
        for (CParameterDeclaration oldParameterDeclaration : pCFunctionDeclaration.getParameters()) {
            CParameterDeclaration newParameterDeclaration = (CParameterDeclaration)oldParameterDeclaration.accept(this);
            parametersBuilder.add((Object)newParameterDeclaration);
            if (oldParameterDeclaration == newParameterDeclaration) continue;
            parametersChanged = true;
        }
        if (parametersChanged) {
            return new CFunctionDeclaration(pCFunctionDeclaration.getFileLocation(), pCFunctionDeclaration.getType(), pCFunctionDeclaration.getName(), pCFunctionDeclaration.getOrigName(), (List<CParameterDeclaration>)parametersBuilder.build(), pCFunctionDeclaration.getAttributes());
        }
        return pCFunctionDeclaration;
    }

    @Override
    default public CAstNode visit(CComplexTypeDeclaration pCComplexTypeDeclaration) throws X {
        return pCComplexTypeDeclaration;
    }

    @Override
    default public CAstNode visit(CTypeDefDeclaration pCTypeDefDeclaration) throws X {
        return pCTypeDefDeclaration;
    }

    @Override
    default public CAstNode visit(CVariableDeclaration pCVariableDeclaration) throws X {
        CInitializer oldInitializer = pCVariableDeclaration.getInitializer();
        CInitializer newInitializer = null;
        if (oldInitializer != null) {
            newInitializer = (CInitializer)oldInitializer.accept(this);
        }
        if (oldInitializer != newInitializer) {
            return new CVariableDeclaration(pCVariableDeclaration.getFileLocation(), pCVariableDeclaration.isGlobal(), pCVariableDeclaration.getCStorageClass(), pCVariableDeclaration.getType(), pCVariableDeclaration.getName(), pCVariableDeclaration.getOrigName(), pCVariableDeclaration.getQualifiedName(), newInitializer);
        }
        return pCVariableDeclaration;
    }

    @Override
    default public CAstNode visit(CParameterDeclaration pCParameterDeclaration) throws X {
        return pCParameterDeclaration;
    }

    @Override
    default public CAstNode visit(CEnumType.CEnumerator pCEnumerator) throws X {
        return pCEnumerator;
    }

    @Override
    default public CAstNode visit(CExpressionStatement pCExpressionStatement) throws X {
        CExpression newExpression;
        CExpression oldExpression = pCExpressionStatement.getExpression();
        if (oldExpression != (newExpression = (CExpression)oldExpression.accept(this))) {
            return new CExpressionStatement(pCExpressionStatement.getFileLocation(), newExpression);
        }
        return pCExpressionStatement;
    }

    @Override
    default public CAstNode visit(CExpressionAssignmentStatement pCExpressionAssignmentStatement) throws X {
        CLeftHandSide oldLeftHandSide = pCExpressionAssignmentStatement.getLeftHandSide();
        CLeftHandSide newLeftHandSide = (CLeftHandSide)oldLeftHandSide.accept(this);
        CExpression oldRightHandSide = pCExpressionAssignmentStatement.getRightHandSide();
        CExpression newRightHandSide = (CExpression)oldRightHandSide.accept(this);
        if (oldLeftHandSide != newLeftHandSide || oldRightHandSide != newRightHandSide) {
            return new CExpressionAssignmentStatement(pCExpressionAssignmentStatement.getFileLocation(), newLeftHandSide, newRightHandSide);
        }
        return pCExpressionAssignmentStatement;
    }

    @Override
    default public CAstNode visit(CFunctionCallAssignmentStatement pCFunctionCallAssignmentStatement) throws X {
        CLeftHandSide oldLeftHandSide = pCFunctionCallAssignmentStatement.getLeftHandSide();
        CLeftHandSide newLeftHandSide = (CLeftHandSide)oldLeftHandSide.accept(this);
        CFunctionCallExpression oldFunctionCallExpression = pCFunctionCallAssignmentStatement.getFunctionCallExpression();
        CFunctionCallExpression newFunctionCallExpression = (CFunctionCallExpression)oldFunctionCallExpression.accept(this);
        if (oldLeftHandSide != newLeftHandSide || oldFunctionCallExpression != newFunctionCallExpression) {
            return new CFunctionCallAssignmentStatement(pCFunctionCallAssignmentStatement.getFileLocation(), newLeftHandSide, newFunctionCallExpression);
        }
        return pCFunctionCallAssignmentStatement;
    }

    @Override
    default public CAstNode visit(CFunctionCallStatement pCFunctionCallStatement) throws X {
        CFunctionCallExpression newFunctionCallExpression;
        CFunctionCallExpression oldFunctionCallExpression = pCFunctionCallStatement.getFunctionCallExpression();
        if (oldFunctionCallExpression != (newFunctionCallExpression = (CFunctionCallExpression)oldFunctionCallExpression.accept(this))) {
            return new CFunctionCallStatement(pCFunctionCallStatement.getFileLocation(), newFunctionCallExpression);
        }
        return pCFunctionCallStatement;
    }

    @Override
    default public CAstNode visit(CReturnStatement pCReturnStatement) throws X {
        boolean changed = false;
        Optional<CExpression> oldOptionalReturnValue = pCReturnStatement.getReturnValue();
        Optional<CExpression> newOptionalReturnValue = Optional.empty();
        if (oldOptionalReturnValue.isPresent()) {
            CExpression oldReturnValue = oldOptionalReturnValue.orElseThrow();
            CExpression newReturnValue = (CExpression)oldReturnValue.accept(this);
            newOptionalReturnValue = Optional.of(newReturnValue);
            if (oldReturnValue != newReturnValue) {
                changed = true;
            }
        }
        Optional<CAssignment> oldOptionalAssignment = pCReturnStatement.asAssignment();
        Optional<CAssignment> newOptionalAssignment = Optional.empty();
        if (oldOptionalAssignment.isPresent()) {
            CAssignment oldAssignment = oldOptionalAssignment.orElseThrow();
            CAssignment newAssignment = (CAssignment)oldAssignment.accept(this);
            newOptionalAssignment = Optional.of(newAssignment);
            if (oldAssignment != newAssignment) {
                changed = true;
            }
        }
        if (changed) {
            return new CReturnStatement(pCReturnStatement.getFileLocation(), newOptionalReturnValue, newOptionalAssignment);
        }
        return pCReturnStatement;
    }
}

