/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNode;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JInitializer;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;

public final class JArrayInitializer
extends AbstractExpression
implements JAstNode,
JInitializer,
JExpression {
    private static final long serialVersionUID = -9034136529891743726L;
    private final List<JExpression> initializerExpressions;

    public JArrayInitializer(FileLocation pFileLocation, List<JExpression> pInitializerExpression, JArrayType pType) {
        super(pFileLocation, pType);
        this.initializerExpressions = pInitializerExpression;
    }

    @Override
    public JArrayType getExpressionType() {
        return (JArrayType)super.getExpressionType();
    }

    public List<JExpression> getInitializerExpressions() {
        return this.initializerExpressions;
    }

    @Override
    public String toASTString(boolean pQualified) {
        StringBuilder astString = new StringBuilder("{");
        for (JExpression exp : this.initializerExpressions) {
            astString.append(exp.toASTString(pQualified) + ", ");
        }
        if (!this.initializerExpressions.isEmpty()) {
            int stringLength = astString.length();
            astString.delete(stringLength - 2, stringLength);
        }
        astString.append("}");
        return astString.toString();
    }

    @Override
    public <R, X extends Exception> R accept(JExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.initializerExpressions);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JArrayInitializer) || super.equals(obj)) {
            return false;
        }
        JArrayInitializer other = (JArrayInitializer)obj;
        return Objects.equals(other.initializerExpressions, this.initializerExpressions);
    }
}

