/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class JClassLiteralExpression
extends ALiteralExpression
implements JLiteralExpression {
    private static final long serialVersionUID = -5629884765912549873L;
    private final JType type;

    public JClassLiteralExpression(FileLocation pFileLocation, JType pJType) {
        super(pFileLocation, pJType);
        Preconditions.checkArgument((pJType instanceof JClassOrInterfaceType || pJType instanceof JArrayType || pJType instanceof JSimpleType ? 1 : 0) != 0, (Object)"Type of class literals can only be class, interface, array, or primitive type, or the pseudo-type void");
        this.type = pJType;
    }

    @Override
    public JType getExpressionType() {
        return (JType)super.getExpressionType();
    }

    @Override
    public JType getValue() {
        return this.type;
    }

    @Override
    public String toASTString() {
        return this.getValue() + ".class";
    }

    @Override
    public <R, X extends Exception> R accept(JExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }
}

