/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractInitializer;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public final class JFieldDeclaration
extends JVariableDeclaration {
    private static final long serialVersionUID = -4482849212846810730L;
    private static final boolean IS_FIELD = true;
    private static final JDeclaration UNRESOLVED_DECLARATION = new JFieldDeclaration(FileLocation.DUMMY, JSimpleType.getUnspecified(), "_unresolved_", "_unresolved_", false, false, false, false, VisibilityModifier.NONE);
    private final VisibilityModifier visibility;
    private final boolean isStatic;
    private final boolean isTransient;
    private final boolean isVolatile;
    private final String simpleName;

    public JFieldDeclaration(FileLocation pFileLocation, JType pType, String pName, String pSimpleName, boolean pIsFinal, boolean pIsStatic, boolean pIsTransient, boolean pIsVolatile, VisibilityModifier pVisibility) {
        super(pFileLocation, true, pType, pName, pName, pName, null, pIsFinal);
        this.isTransient = pIsTransient;
        this.isVolatile = pIsVolatile;
        this.isStatic = pIsStatic;
        this.visibility = pVisibility;
        this.simpleName = pSimpleName;
    }

    @Override
    public String toASTString(boolean pQualified) {
        StringBuilder lASTString = new StringBuilder();
        if (this.visibility != null) {
            lASTString.append(this.visibility.getModifierString() + " ");
        }
        if (this.isFinal()) {
            lASTString.append("final ");
        }
        if (this.isStatic) {
            lASTString.append("static ");
        }
        if (pQualified) {
            lASTString.append(this.getType().toASTString(this.getQualifiedName().replace("::", "__")));
        } else {
            lASTString.append(this.getType().toASTString(this.getName()));
        }
        if (this.getInitializer() != null) {
            lASTString.append(" = ");
            lASTString.append(this.getInitializer().toASTString(pQualified));
        }
        lASTString.append(";");
        return lASTString.toString();
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public VisibilityModifier getVisibility() {
        return this.visibility;
    }

    public void updateInitializer(AbstractInitializer initializer) {
        this.addInitializer(initializer);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.isTransient ? 1231 : 1237);
        result = 31 * result + (this.isVolatile ? 1231 : 1237);
        result = 31 * result + Objects.hashCode((Object)this.visibility);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JFieldDeclaration) || !super.equals(obj)) {
            return false;
        }
        JFieldDeclaration other = (JFieldDeclaration)obj;
        return other.isStatic == this.isStatic && other.isTransient == this.isTransient && other.isVolatile == this.isVolatile && Objects.equals((Object)other.visibility, (Object)this.visibility);
    }

    public static JDeclaration createUnresolvedFieldDeclaration() {
        return UNRESOLVED_DECLARATION;
    }

    public static JFieldDeclaration createExternFieldDeclaration(JType pType, String pName, String pSimpleName, boolean pIsFinal, boolean pIsStatic, boolean pIsTransient, boolean pIsVolatile, VisibilityModifier pVisibility) {
        return new JFieldDeclaration(FileLocation.DUMMY, pType, pName, pSimpleName, pIsFinal, pIsStatic, pIsTransient, pIsVolatile, pVisibility);
    }

    public String getSimpleName() {
        return this.simpleName;
    }
}

