/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JMethodType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class JMethodDeclaration
extends AFunctionDeclaration
implements JDeclaration {
    private static final long serialVersionUID = 2250464052511901845L;
    private final boolean isFinal;
    private final boolean isAbstract;
    private final boolean isStatic;
    private final boolean isNative;
    private final boolean isSynchronized;
    private final boolean isStrictfp;
    private final VisibilityModifier visibility;
    private final JClassOrInterfaceType declaringClass;
    private final String simpleName;
    private static final JMethodDeclaration UNRESOLVED_METHOD = new JMethodDeclaration(FileLocation.DUMMY, JMethodType.createUnresolvableType(), "__Unresolved__", "__Unresolved__", new ArrayList<JParameterDeclaration>(), VisibilityModifier.NONE, false, false, false, false, false, false, JClassType.createUnresolvableType());

    public JMethodDeclaration(FileLocation pFileLocation, JMethodType pType, String pName, String pSimpleName, List<JParameterDeclaration> pParameterDeclarations, VisibilityModifier pVisibility, boolean pIsFinal, boolean pIsAbstract, boolean pIsStatic, boolean pIsNative, boolean pIsSynchronized, boolean pIsStrictfp, JClassOrInterfaceType pDeclaringClass) {
        super(pFileLocation, pType, pName, pName, pParameterDeclarations);
        this.visibility = pVisibility;
        this.isFinal = pIsFinal;
        this.isAbstract = pIsAbstract;
        this.isStatic = pIsStatic;
        this.isNative = pIsNative;
        this.isSynchronized = pIsSynchronized;
        this.isStrictfp = pIsStrictfp;
        this.declaringClass = pDeclaringClass;
        this.simpleName = pSimpleName;
        Preconditions.checkNotNull((Object)pSimpleName);
        Preconditions.checkNotNull((Object)((Object)pVisibility));
        Preconditions.checkArgument((this.isAbstract() && !this.isStatic() && !this.isNative() && !this.isFinal() && !this.isSynchronized() && !this.isStrictfp() || !this.isAbstract() ? 1 : 0) != 0, (Object)"Abstract Method may only have one Modifier , either public or protected");
    }

    @Override
    public JMethodType getType() {
        return (JMethodType)super.getType();
    }

    public List<JParameterDeclaration> getParameters() {
        return super.getParameters();
    }

    @Override
    public String toASTString(boolean pQualified) {
        return this.toASTString();
    }

    @Override
    public String toASTString() {
        String name = Strings.nullToEmpty((String)this.getName());
        StringBuilder modifier = new StringBuilder();
        modifier.append(this.getVisibility().getModifierString() + " ");
        if (this.isAbstract()) {
            modifier.append("abstract ");
        }
        if (this.isStatic()) {
            modifier.append("static ");
        }
        if (this.isFinal()) {
            modifier.append("final ");
        }
        if (this.isSynchronized()) {
            modifier.append("synchronized ");
        }
        if (this.isNative()) {
            modifier.append("native ");
        }
        if (this.isStrictfp()) {
            modifier.append("strictfp ");
        }
        return modifier + this.getType().toASTString(name) + ";";
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean isStrictfp() {
        return this.isStrictfp;
    }

    public VisibilityModifier getVisibility() {
        return this.visibility;
    }

    public JClassOrInterfaceType getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public <R, X extends Exception> R accept(JAstNodeVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.declaringClass);
        result = 31 * result + (this.isAbstract ? 1231 : 1237);
        result = 31 * result + (this.isFinal ? 1231 : 1237);
        result = 31 * result + (this.isNative ? 1231 : 1237);
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.isStrictfp ? 1231 : 1237);
        result = 31 * result + (this.isSynchronized ? 1231 : 1237);
        result = 31 * result + Objects.hashCode((Object)this.visibility);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JMethodDeclaration) || !super.equals(obj)) {
            return false;
        }
        JMethodDeclaration other = (JMethodDeclaration)obj;
        return Objects.equals(other.declaringClass, this.declaringClass) && other.isAbstract == this.isAbstract && other.isFinal == this.isFinal && other.isNative == this.isNative && other.isStatic == this.isStatic && other.isStrictfp == this.isStrictfp && other.isSynchronized == this.isSynchronized && Objects.equals((Object)other.visibility, (Object)this.visibility);
    }

    public static JMethodDeclaration createUnresolvedMethodDeclaration() {
        return UNRESOLVED_METHOD;
    }

    public static JMethodDeclaration createExternMethodDeclaration(JMethodType pMethodType, String pName, String pSimpleName, VisibilityModifier pPublic, boolean pFinal, boolean pAbstract, boolean pStatic, boolean pNative, boolean pSynchronized, boolean pStrictFp, JClassOrInterfaceType pDeclaringClassType) {
        List<JType> parameterTypes = pMethodType.getParameters();
        ArrayList<JParameterDeclaration> parameters = new ArrayList<JParameterDeclaration>(parameterTypes.size());
        FileLocation externFileLoc = FileLocation.DUMMY;
        int i = 0;
        for (JType parameterType : parameterTypes) {
            String parameterName = "parameter" + i;
            parameters.add(new JParameterDeclaration(externFileLoc, parameterType, parameterName, pName + "::" + parameterName, false));
            ++i;
        }
        return new JMethodDeclaration(externFileLoc, pMethodType, pName, pSimpleName, parameters, pPublic, pFinal, pAbstract, pStatic, pNative, pSynchronized, pStrictFp, pDeclaringClassType);
    }

    public String getSimpleName() {
        return this.simpleName;
    }
}

