/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public final class JParameterDeclaration
extends AParameterDeclaration
implements JSimpleDeclaration {
    private static final long serialVersionUID = -5728272567926253312L;
    private final String qualifiedName;
    private final boolean isFinal;

    public JParameterDeclaration(FileLocation pFileLocation, JType pType, String pName, String pQualifiedName, boolean pIsFinal) {
        super(pFileLocation, pType, pName);
        this.qualifiedName = (String)Preconditions.checkNotNull((Object)pQualifiedName);
        this.isFinal = pIsFinal;
    }

    @Override
    public JType getType() {
        return (JType)super.getType();
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public <R, X extends Exception> R accept(JAstNodeVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + (this.isFinal ? 1231 : 1237);
        result = 31 * result + this.qualifiedName.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JParameterDeclaration) || !super.equals(obj)) {
            return false;
        }
        JParameterDeclaration other = (JParameterDeclaration)obj;
        return other.isFinal == this.isFinal && this.qualifiedName.equals(other.qualifiedName);
    }
}

