/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeExpression;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JReferenceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public final class JRunTimeTypeEqualsType
extends AbstractExpression
implements JExpression {
    private static final long serialVersionUID = -2513620435920744071L;
    private final JRunTimeTypeExpression runTimeTypeExpression;
    private final JReferenceType typeDef;

    public JRunTimeTypeEqualsType(FileLocation pFileLocation, JRunTimeTypeExpression pRunTimeTypeExpression, JReferenceType pTypeDef) {
        super(pFileLocation, JSimpleType.getBoolean());
        this.runTimeTypeExpression = pRunTimeTypeExpression;
        this.typeDef = pTypeDef;
        assert (this.getRunTimeTypeExpression() != null);
        assert (this.getTypeDef() != null);
    }

    @Override
    public JType getExpressionType() {
        return (JType)super.getExpressionType();
    }

    @Override
    public <R, X extends Exception> R accept(JExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString(boolean pQualified) {
        return this.toASTString();
    }

    @Override
    public String toASTString() {
        String name = this.getTypeDef() instanceof JClassOrInterfaceType ? ((JClassOrInterfaceType)this.getTypeDef()).getName() : ((JSimpleType)((Object)this.getTypeDef())).getType().toASTString();
        StringBuilder astString = new StringBuilder("(");
        astString.append(this.getRunTimeTypeExpression().toASTString());
        astString.append("_equals(");
        astString.append(name);
        astString.append("))");
        return astString.toString();
    }

    public JReferenceType getTypeDef() {
        return this.typeDef;
    }

    public JRunTimeTypeExpression getRunTimeTypeExpression() {
        return this.runTimeTypeExpression;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.runTimeTypeExpression);
        result = 31 * result + Objects.hashCode(this.typeDef);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JRunTimeTypeEqualsType) || !super.equals(obj)) {
            return false;
        }
        JRunTimeTypeEqualsType other = (JRunTimeTypeEqualsType)obj;
        return Objects.equals(other.runTimeTypeExpression, this.runTimeTypeExpression) && Objects.equals(other.typeDef, this.typeDef);
    }
}

