/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;

public class Block {
    private final ImmutableSet<ReferencedVariable> referencedVariables;
    private ImmutableSet<String> variables;
    private ImmutableSet<String> outOfScopeVariables;
    private ImmutableSet<String> functions;
    private final ImmutableSet<CFANode> callNodes;
    private final ImmutableSet<CFANode> returnNodes;
    private final ImmutableSet<CFANode> nodes;

    public Block(Iterable<ReferencedVariable> pReferencedVariables, Set<CFANode> pCallNodes, Set<CFANode> pReturnNodes, Iterable<CFANode> allNodes) {
        this.referencedVariables = ImmutableSet.copyOf(pReferencedVariables);
        this.callNodes = ImmutableSortedSet.copyOf(pCallNodes);
        this.returnNodes = ImmutableSortedSet.copyOf(pReturnNodes);
        this.nodes = ImmutableSortedSet.copyOf(allNodes);
    }

    public Set<CFANode> getCallNodes() {
        return this.callNodes;
    }

    public CFANode getCallNode() {
        assert (this.callNodes.size() == 1);
        return (CFANode)this.callNodes.iterator().next();
    }

    @Deprecated
    public Set<ReferencedVariable> getReferencedVariables() {
        return this.referencedVariables;
    }

    public Set<String> getVariables() {
        if (this.variables == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ReferencedVariable referencedVar : this.getReferencedVariables()) {
                builder.add((Object)referencedVar.getName());
            }
            this.variables = builder.build();
        }
        return this.variables;
    }

    public Set<String> getOutOfScopeVariables() {
        if (this.outOfScopeVariables == null) {
            LinkedHashSet<ASimpleDeclaration> declarations = new LinkedHashSet<ASimpleDeclaration>();
            for (CFANode node : this.nodes) {
                declarations.addAll(node.getOutOfScopeVariables());
                if (!(node instanceof FunctionExitNode)) continue;
                declarations.addAll(((FunctionExitNode)node).getEntryNode().getFunctionParameters());
            }
            this.outOfScopeVariables = Collections3.transformedImmutableSetCopy(declarations, ASimpleDeclaration::getQualifiedName);
        }
        return this.outOfScopeVariables;
    }

    public Set<String> getFunctions() {
        if (this.functions == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (CFANode node : this.getNodes()) {
                builder.add((Object)node.getFunctionName());
            }
            this.functions = builder.build();
        }
        return this.functions;
    }

    public Set<CFANode> getNodes() {
        return this.nodes;
    }

    public boolean isReturnNode(CFANode pNode) {
        return this.returnNodes.contains((Object)pNode);
    }

    public Set<CFANode> getReturnNodes() {
        return this.returnNodes;
    }

    public boolean isCallNode(CFANode pNode) {
        return this.callNodes.contains((Object)pNode);
    }

    public String toString() {
        return "Block (CallNodes: " + this.callNodes + ") (Nodes: " + (this.nodes.size() < 10 ? this.nodes : "[#=" + this.nodes.size() + "]") + ") (ReturnNodes: " + this.returnNodes + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Block)) {
            return false;
        }
        Block other = (Block)o;
        return this.callNodes.equals(other.callNodes) && this.returnNodes.equals(other.returnNodes) && this.nodes.equals(other.nodes) && this.referencedVariables.equals(other.referencedVariables);
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }
}

