/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public class BlockPartitioning {
    private final Block mainBlock;
    private final ImmutableMap<CFANode, Block> callNodeToBlock;
    private final ImmutableListMultimap<CFANode, Block> returnNodeToBlock;
    private final ImmutableSet<Block> blocks;

    public BlockPartitioning(Collection<Block> subtrees, CFANode mainFunction) {
        ImmutableMap.Builder callNodeToSubtree = ImmutableMap.builder();
        ImmutableListMultimap.Builder returnNodeToSubtree = ImmutableListMultimap.builder();
        for (Block subtree : subtrees) {
            for (CFANode callNode : subtree.getCallNodes()) {
                callNodeToSubtree.put((Object)callNode, (Object)subtree);
            }
            for (CFANode returnNode : subtree.getReturnNodes()) {
                returnNodeToSubtree.put((Object)returnNode, (Object)subtree);
            }
        }
        this.callNodeToBlock = callNodeToSubtree.buildOrThrow();
        this.returnNodeToBlock = returnNodeToSubtree.build();
        this.blocks = ImmutableSet.copyOf(subtrees);
        this.mainBlock = (Block)this.callNodeToBlock.get((Object)mainFunction);
    }

    public boolean isCallNode(CFANode node) {
        return this.callNodeToBlock.containsKey((Object)node);
    }

    public Block getBlockForCallNode(CFANode node) {
        return (Block)this.callNodeToBlock.get((Object)node);
    }

    public Block getMainBlock() {
        return this.mainBlock;
    }

    public boolean isReturnNode(CFANode node) {
        return this.returnNodeToBlock.containsKey((Object)node);
    }

    public ImmutableList<Block> getBlocksForReturnNode(CFANode pCurrentNode) {
        return this.returnNodeToBlock.get((Object)pCurrentNode);
    }

    public Set<Block> getBlocks() {
        return this.blocks;
    }
}

