/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.blocks.builder.ReferencedVariablesCollector;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class BlockPartitioningBuilder {
    private static final CFATraversal TRAVERSE_CFA_INSIDE_FUNCTION = CFATraversal.dfs().ignoreFunctionCalls();
    protected final Map<CFANode, Set<ReferencedVariable>> referencedVariablesMap = new HashMap<CFANode, Set<ReferencedVariable>>();
    protected final Map<CFANode, Set<CFANode>> callNodesMap = new HashMap<CFANode, Set<CFANode>>();
    protected final Map<CFANode, Set<CFANode>> returnNodesMap = new HashMap<CFANode, Set<CFANode>>();
    protected final Map<CFANode, Set<FunctionEntryNode>> innerFunctionCallsMap = new HashMap<CFANode, Set<FunctionEntryNode>>();
    protected final Map<CFANode, Set<CFANode>> blockNodesMap = new HashMap<CFANode, Set<CFANode>>();

    public BlockPartitioning build(CFA cfa) {
        HashMap<FunctionEntryNode, Set<CFANode>> functions = new HashMap<FunctionEntryNode, Set<CFANode>>();
        HashMap<FunctionEntryNode, Set<ReferencedVariable>> referencedVariables = new HashMap<FunctionEntryNode, Set<ReferencedVariable>>();
        HashMap<FunctionEntryNode, Set<FunctionEntryNode>> innerFunctionCalls = new HashMap<FunctionEntryNode, Set<FunctionEntryNode>>();
        for (FunctionEntryNode functionEntryNode : cfa.getAllFunctionHeads()) {
            Set<CFANode> body = TRAVERSE_CFA_INSIDE_FUNCTION.collectNodesReachableFrom(functionEntryNode);
            functions.put(functionEntryNode, body);
            referencedVariables.put(functionEntryNode, this.collectReferencedVariables(body));
            innerFunctionCalls.put(functionEntryNode, this.collectInnerFunctionCalls(body));
        }
        HashMap<CFANode, Set<FunctionEntryNode>> blockFunctionCalls = new HashMap<CFANode, Set<FunctionEntryNode>>();
        for (CFANode callNode : this.callNodesMap.keySet()) {
            Set<FunctionEntryNode> calledFunctions = BlockPartitioningBuilder.getAllCalledFunctions(innerFunctionCalls, this.collectInnerFunctionCalls(this.blockNodesMap.get(callNode)));
            blockFunctionCalls.put(callNode, calledFunctions);
        }
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (Map.Entry<CFANode, Set<CFANode>> entry : this.callNodesMap.entrySet()) {
            CFANode callNode = entry.getKey();
            ArrayList<Iterable> variables = new ArrayList<Iterable>();
            ArrayList<Iterable> blockNodes = new ArrayList<Iterable>();
            Set<CFANode> directNodes = this.blockNodesMap.get(callNode);
            blockNodes.add(directNodes);
            variables.add(this.referencedVariablesMap.get(callNode));
            for (FunctionEntryNode calledFunction : (Set)blockFunctionCalls.get(callNode)) {
                blockNodes.add((Iterable)functions.get(calledFunction));
                variables.add((Iterable)referencedVariables.get(calledFunction));
            }
            arrayList.add(new Block(Iterables.concat(variables), entry.getValue(), this.returnNodesMap.get(callNode), Iterables.concat(blockNodes)));
        }
        return new BlockPartitioning(arrayList, cfa.getMainFunction());
    }

    private static Set<FunctionEntryNode> getAllCalledFunctions(Map<FunctionEntryNode, Set<FunctionEntryNode>> innerFunctionCalls, Set<FunctionEntryNode> directFunctions) {
        HashSet<FunctionEntryNode> calledFunctions = new HashSet<FunctionEntryNode>();
        ArrayDeque<FunctionEntryNode> waitlist = new ArrayDeque<FunctionEntryNode>(directFunctions);
        while (!waitlist.isEmpty()) {
            FunctionEntryNode entry = (FunctionEntryNode)waitlist.pop();
            if (!calledFunctions.add(entry)) continue;
            waitlist.addAll((Collection<FunctionEntryNode>)innerFunctionCalls.get(entry));
        }
        return calledFunctions;
    }

    public void addBlock(Set<CFANode> nodes, CFANode blockHead) {
        Set<ReferencedVariable> referencedVariables = this.collectReferencedVariables(nodes);
        Set<CFANode> callNodes = this.collectCallNodes(nodes);
        Set<CFANode> returnNodes = this.collectReturnNodes(nodes);
        Set<FunctionEntryNode> innerFunctionCalls = this.collectInnerFunctionCalls(nodes);
        if (callNodes.isEmpty()) {
            return;
        }
        CFANode registerNode = null;
        Iterator<CFANode> iterator = callNodes.iterator();
        while (iterator.hasNext()) {
            CFANode node;
            registerNode = node = iterator.next();
            if (!(node instanceof FunctionEntryNode)) continue;
            break;
        }
        if (registerNode == null) {
            return;
        }
        this.referencedVariablesMap.put(registerNode, referencedVariables);
        this.callNodesMap.put(registerNode, callNodes);
        this.returnNodesMap.put(registerNode, returnNodes);
        this.innerFunctionCallsMap.put(registerNode, innerFunctionCalls);
        this.blockNodesMap.put(registerNode, nodes);
    }

    private Set<FunctionEntryNode> collectInnerFunctionCalls(Set<CFANode> pNodes) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (CFANode node : pNodes) {
            for (CFAEdge e : CFAUtils.leavingEdges(node).filter(CFunctionCallEdge.class)) {
                result.add((Object)((CFunctionCallEdge)e).getSuccessor());
            }
        }
        return result.build();
    }

    private Set<CFANode> collectCallNodes(Set<CFANode> pNodes) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (CFANode node : pNodes) {
            if (node.getNumEnteringEdges() == 0 && node.getNumLeavingEdges() == 0) continue;
            if (node.getNumEnteringEdges() == 0 && node.getEnteringSummaryEdge() == null) {
                result.add((Object)node);
                continue;
            }
            for (CFAEdge edge : CFAUtils.allEnteringEdges(node)) {
                if (edge.getEdgeType() == CFAEdgeType.FunctionReturnEdge || pNodes.contains(edge.getPredecessor())) continue;
                result.add((Object)node);
            }
        }
        return result.build();
    }

    private Set<CFANode> collectReturnNodes(Set<CFANode> pNodes) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (CFANode node : pNodes) {
            if (node.getNumEnteringEdges() == 0 && node.getNumLeavingEdges() == 0) continue;
            if (node.getNumLeavingEdges() == 0 && !(node instanceof CFATerminationNode)) {
                result.add((Object)node);
                continue;
            }
            for (CFAEdge edge : CFAUtils.allLeavingEdges(node)) {
                if (edge.getEdgeType() == CFAEdgeType.FunctionCallEdge || pNodes.contains(edge.getSuccessor())) continue;
                result.add((Object)node);
            }
        }
        return result.build();
    }

    private Set<ReferencedVariable> collectReferencedVariables(Set<CFANode> nodes) {
        return new ReferencedVariablesCollector(nodes).getVars();
    }
}

