/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import com.google.common.collect.ImmutableList;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public class CompositePartitioning
extends PartitioningHeuristic {
    private final ImmutableList<PartitioningHeuristic> partitionings;

    public CompositePartitioning(LogManager pLogger, CFA pCfa, Configuration pConfig, PartitioningHeuristic ... pPartitionings) {
        super(pLogger, pCfa, pConfig);
        this.partitionings = ImmutableList.copyOf((Object[])pPartitionings);
    }

    @Override
    protected @Nullable Set<CFANode> getBlockForNode(CFANode pBlockHead) {
        for (PartitioningHeuristic partitioning : this.partitionings) {
            Set<CFANode> nodes = partitioning.getBlockForNode(pBlockHead);
            if (nodes == null) continue;
            return nodes;
        }
        return null;
    }
}

