/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFATraversal;

@Options(prefix="cpa.bam.blockHeuristic.functionPartitioning")
public class FunctionPartitioning
extends PartitioningHeuristic {
    private static final CFATraversal TRAVERSE_CFA_INSIDE_FUNCTION = CFATraversal.dfs().ignoreFunctionCalls();
    @Option(secure=true, description="only consider function with a minimum number of CFA nodes. This approach is similar to 'inlining' small functions, when using BAM.")
    private int minFunctionSize = 0;
    @Option(secure=true, description="only consider function with a minimum number of calls. This approach is similar to 'inlining' functions used only a few times. Info: If a function is called several times in a loop, we only count 'one' call.")
    private int minFunctionCalls = 0;
    @Option(secure=true, description="only consider functions with a matching name, i.e., select only some functions directly.")
    private ImmutableSet<String> matchFunctions = null;

    public FunctionPartitioning(LogManager pLogger, CFA pCfa, Configuration pConfig) throws InvalidConfigurationException {
        super(pLogger, pCfa, pConfig);
        pConfig.inject((Object)this);
    }

    @Override
    protected Set<CFANode> getBlockForNode(CFANode pBlockHead) {
        if (pBlockHead instanceof FunctionEntryNode) {
            Set<CFANode> nodes = TRAVERSE_CFA_INSIDE_FUNCTION.collectNodesReachableFrom(pBlockHead);
            if (pBlockHead.getNumEnteringEdges() == 0) {
                return nodes;
            }
            if (this.matchFunctions != null && !this.matchFunctions.contains((Object)pBlockHead.getFunctionName())) {
                return null;
            }
            if (nodes.size() >= this.minFunctionSize && pBlockHead.getNumEnteringEdges() >= this.minFunctionCalls) {
                return nodes;
            }
        }
        return null;
    }
}

