/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.builder.BlockPartitioningBuilder;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public abstract class PartitioningHeuristic {
    protected final CFA cfa;
    protected final LogManager logger;

    protected PartitioningHeuristic(LogManager pLogger, CFA pCfa, Configuration pConfig) {
        this.cfa = pCfa;
        this.logger = pLogger;
    }

    public final BlockPartitioning buildPartitioning(BlockPartitioningBuilder builder) {
        HashSet<CFANode> seen = new HashSet<CFANode>();
        ArrayDeque<CFANode> stack = new ArrayDeque<CFANode>();
        FunctionEntryNode mainFunction = this.cfa.getMainFunction();
        seen.add(mainFunction);
        stack.push(mainFunction);
        while (!stack.isEmpty()) {
            CFANode node = (CFANode)stack.pop();
            Set<CFANode> subtree = this.getBlockForNode(node);
            if (subtree != null) {
                builder.addBlock(subtree, node);
            }
            for (CFANode nextNode : CFAUtils.successorsOf(node)) {
                if (seen.contains(nextNode)) continue;
                stack.push(nextNode);
                seen.add(nextNode);
            }
        }
        return builder.build(this.cfa);
    }

    protected abstract @Nullable Set<CFANode> getBlockForNode(CFANode var1);

    public static interface Factory {
        public PartitioningHeuristic create(LogManager var1, CFA var2, Configuration var3) throws CPAException, InvalidConfigurationException;
    }
}

