/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class ReferencedVariablesCollector {
    final Map<String, ReferencedVariable> collectedVars = new HashMap<String, ReferencedVariable>();
    final Set<String> allVars = new HashSet<String>();
    final Set<String> varsInConditions = new HashSet<String>();
    final Multimap<String, String> varsToRHS = HashMultimap.create();

    public ReferencedVariablesCollector(Collection<CFANode> mainNodes) {
        this.collectVars(mainNodes);
    }

    public Set<ReferencedVariable> getVars() {
        return new HashSet<ReferencedVariable>(this.collectedVars.values());
    }

    private void collectVars(Collection<CFANode> nodes) {
        for (CFANode node : nodes) {
            for (CFAEdge leavingEdge : CFAUtils.allLeavingEdges(node)) {
                if (!nodes.contains(leavingEdge.getSuccessor()) && !(leavingEdge instanceof CFunctionCallEdge)) continue;
                this.collectVars(leavingEdge);
            }
        }
        for (String var : this.allVars) {
            ReferencedVariable ref = new ReferencedVariable(var, this.varsInConditions.contains(var), new HashSet<ReferencedVariable>());
            this.collectedVars.put(var, ref);
        }
        for (ReferencedVariable ref : this.collectedVars.values()) {
            for (String rhs : this.varsToRHS.get((Object)ref.getName())) {
                ref.getInfluencingVariables().add(this.collectedVars.get(rhs));
            }
        }
    }

    private void collectVars(CFAEdge edge) {
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)edge;
                Set<String> vars = this.collectVars(assumeEdge.getExpression());
                this.varsInConditions.addAll(vars);
                this.allVars.addAll(vars);
                break;
            }
            case DeclarationEdge: {
                CDeclaration declaration = ((CDeclarationEdge)edge).getDeclaration();
                String lhsVarName = declaration.getQualifiedName();
                if (!(declaration instanceof CVariableDeclaration)) break;
                this.allVars.add(lhsVarName);
                CInitializer init = ((CVariableDeclaration)declaration).getInitializer();
                if (!(init instanceof CInitializerExpression)) break;
                Set<String> vars = this.collectVars(((CInitializerExpression)init).getExpression());
                this.varsToRHS.putAll((Object)lhsVarName, vars);
                this.allVars.addAll(vars);
                break;
            }
            case FunctionCallEdge: {
                Set<String> vars;
                CFunctionCallEdge functionCallEdge = (CFunctionCallEdge)edge;
                for (CExpression argument : functionCallEdge.getArguments()) {
                    vars = this.collectVars(argument);
                    this.allVars.addAll(vars);
                }
                for (CExpression parameter : functionCallEdge.getSummaryEdge().getExpression().getFunctionCallExpression().getParameterExpressions()) {
                    vars = this.collectVars(parameter);
                    this.allVars.addAll(vars);
                }
                break;
            }
            case StatementEdge: {
                CStatement statement = ((CStatementEdge)edge).getStatement();
                if (!(statement instanceof CAssignment)) break;
                CAssignment assignment = (CAssignment)statement;
                this.handleAssignment(assignment);
                break;
            }
            case ReturnStatementEdge: {
                Optional<CAssignment> returnExprAssignment = ((CReturnStatementEdge)edge).asAssignment();
                if (!returnExprAssignment.isPresent()) break;
                this.handleAssignment(returnExprAssignment.orElseThrow());
                break;
            }
            case CallToReturnEdge: {
                CFunctionCall funcCall = ((CFunctionSummaryEdge)edge).getExpression();
                if (!(funcCall instanceof CFunctionCallAssignmentStatement)) break;
                CFunctionCallAssignmentStatement assignment = (CFunctionCallAssignmentStatement)funcCall;
                this.handleAssignment(assignment);
                break;
            }
            case BlankEdge: 
            case FunctionReturnEdge: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unhandled type of edge: " + edge.getEdgeType()));
            }
        }
    }

    private void handleAssignment(CAssignment assignment) {
        String lhsVarName = this.getVarname(assignment.getLeftHandSide());
        Set<String> lhsVars = this.collectVars(assignment.getLeftHandSide());
        Set<String> vars = this.collectVars(assignment.getRightHandSide());
        this.varsToRHS.putAll((Object)lhsVarName, vars);
        this.allVars.addAll(lhsVars);
        this.allVars.addAll(vars);
    }

    private Set<String> collectVars(CRightHandSide pNode) {
        CollectVariablesVisitor cvv = new CollectVariablesVisitor();
        pNode.accept(cvv);
        return cvv.vars;
    }

    private String getVarname(CLeftHandSide pNode) {
        CExpression expr;
        if (pNode instanceof CIdExpression) {
            return ((CIdExpression)pNode).getDeclaration().getQualifiedName();
        }
        if (pNode instanceof CArraySubscriptExpression) {
            expr = ((CArraySubscriptExpression)pNode).getArrayExpression();
        } else if (pNode instanceof CPointerExpression) {
            expr = ((CPointerExpression)pNode).getOperand();
        } else {
            return pNode.toASTString();
        }
        if (expr instanceof CLeftHandSide) {
            return this.getVarname((CLeftHandSide)expr);
        }
        return expr.toASTString();
    }

    private static class CollectVariablesVisitor
    extends DefaultCExpressionVisitor<Void, NoException>
    implements CRightHandSideVisitor<Void, NoException> {
        Set<String> vars = new HashSet<String>();

        private CollectVariablesVisitor() {
        }

        private void collectVar(String var) {
            this.vars.add(var);
        }

        @Override
        public Void visit(CIdExpression pE) {
            if (pE.getDeclaration() != null) {
                this.collectVar(pE.getDeclaration().getQualifiedName());
            }
            return null;
        }

        @Override
        public Void visit(CArraySubscriptExpression pE) {
            this.collectVar(pE.toASTString());
            pE.getArrayExpression().accept(this);
            pE.getSubscriptExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CBinaryExpression pE) {
            pE.getOperand1().accept(this);
            pE.getOperand2().accept(this);
            return null;
        }

        @Override
        public Void visit(CCastExpression pE) {
            pE.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CComplexCastExpression pE) {
            pE.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CFieldReference pE) {
            this.collectVar(pE.toASTString());
            pE.getFieldOwner().accept(this);
            return null;
        }

        @Override
        public Void visit(CFunctionCallExpression pE) {
            pE.getFunctionNameExpression().accept(this);
            for (CExpression param : pE.getParameterExpressions()) {
                param.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CUnaryExpression pE) {
            CUnaryExpression.UnaryOperator op = pE.getOperator();
            if (op == CUnaryExpression.UnaryOperator.AMPER) {
                this.collectVar(pE.toASTString());
            }
            pE.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CPointerExpression pE) {
            this.collectVar(pE.toASTString());
            pE.getOperand().accept(this);
            return null;
        }

        @Override
        protected Void visitDefault(CExpression pExp) {
            return null;
        }
    }
}

