/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.export;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.html.HtmlEscapers;
import com.google.common.io.MoreFiles;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.JSON;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

public final class DOTBuilder2 {
    private final CFA cfa;
    private final CFAJSONBuilder jsoner;
    private final DOTViewBuilder dotter;

    public DOTBuilder2(CFA pCfa) {
        this.cfa = (CFA)Preconditions.checkNotNull((Object)pCfa);
        this.jsoner = new CFAJSONBuilder();
        this.dotter = new DOTViewBuilder(this.cfa);
        CFATraversal.NodeCollectingCFAVisitor vis = new CFATraversal.NodeCollectingCFAVisitor(new CFATraversal.CompositeCFAVisitor(this.jsoner, this.dotter));
        for (FunctionEntryNode entryNode : this.cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().ignoreFunctionCalls().traverse(entryNode, vis);
        }
        this.dotter.postProcessing();
    }

    public void writeGraphs(Path outdir) throws IOException {
        for (FunctionEntryNode entryNode : this.cfa.getAllFunctionHeads()) {
            this.dotter.writeFunctionFile(entryNode.getFunctionName(), outdir);
        }
    }

    public void writeCfaInfo(Writer out) throws IOException {
        out.write("\"nodes\":");
        JSON.writeJSONString(this.jsoner.getNodes(), (Appendable)out);
        out.write(",\n\"edges\":");
        JSON.writeJSONString(this.jsoner.getEdges(), (Appendable)out);
    }

    public void writeFunctionCallEdges(Writer out) throws IOException {
        JSON.writeJSONString(this.dotter.virtFuncCallEdges, (Appendable)out);
    }

    public void writeCombinedNodes(Writer out) throws IOException {
        JSON.writeJSONString(this.dotter.comboNodes, (Appendable)out);
    }

    public void writeCombinedNodesLabels(Writer out) throws IOException {
        JSON.writeJSONString(this.dotter.comboNodesLabels, (Appendable)out);
    }

    public void writeMergedNodesList(Writer out) throws IOException {
        JSON.writeJSONString(this.dotter.mergedNodes, (Appendable)out);
    }

    private static String getEdgeText(CFAEdge edge) {
        return DOTBuilder.escapeGraphvizLabel(edge.getDescription(), " ");
    }

    private static class CFAJSONBuilder
    extends CFATraversal.DefaultCFAVisitor {
        private final Map<Integer, Object> nodes = new HashMap<Integer, Object>();
        private final Map<String, Object> edges = new HashMap<String, Object>();

        private CFAJSONBuilder() {
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode node) {
            HashMap<String, Object> jnode = new HashMap<String, Object>();
            jnode.put("index", node.getNodeNumber());
            jnode.put("rpid", node.getReversePostorderId());
            jnode.put("func", node.getFunctionName());
            jnode.put("type", this.determineNodeType(node));
            jnode.put("loop", node.isLoopStart());
            this.nodes.put(node.getNodeNumber(), jnode);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            HashMap<String, Object> jedge = new HashMap<String, Object>();
            int src = edge.getPredecessor().getNodeNumber();
            int target = edge.getSuccessor().getNodeNumber();
            jedge.put("line", edge.getFileLocation().getStartingLineInOrigin());
            jedge.put("file", edge.getFileLocation().getFileName());
            jedge.put("source", src);
            jedge.put("target", target);
            jedge.put("stmt", DOTBuilder2.getEdgeText(edge));
            jedge.put("type", edge.getEdgeType().toString());
            this.edges.put(src + "->" + target, jedge);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        private String determineNodeType(CFANode node) {
            if (node instanceof FunctionEntryNode) {
                return "entry";
            }
            if (node instanceof FunctionExitNode) {
                return "exit";
            }
            return "";
        }

        Collection<Object> getNodes() {
            return this.nodes.values();
        }

        Collection<Object> getEdges() {
            return this.edges.values();
        }
    }

    private static class DOTViewBuilder
    extends CFATraversal.DefaultCFAVisitor {
        private final Map<Integer, Set<Integer>> comboNodes = new HashMap<Integer, Set<Integer>>();
        private final Map<Integer, StringBuilder> comboNodesLabels = new HashMap<Integer, StringBuilder>();
        private final Set<Integer> mergedNodes = new LinkedHashSet<Integer>();
        private final Map<Integer, List<Integer>> virtFuncCallEdges = new HashMap<Integer, List<Integer>>();
        private int virtFuncCallNodeIdCounter = 100000;
        private final SetMultimap<String, CFANode> nodes = MultimapBuilder.hashKeys().linkedHashSetValues().build();
        private final ListMultimap<String, CFAEdge> edges = MultimapBuilder.hashKeys().arrayListValues().build();
        private final ListMultimap<String, List<CFAEdge>> comboedges = MultimapBuilder.hashKeys().arrayListValues().build();
        private List<CFAEdge> currentComboEdge = null;
        private final Optional<ImmutableSet<CFANode>> loopHeads;

        private DOTViewBuilder(CFA cfa) {
            this.loopHeads = cfa.getAllLoopHeads();
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            CFANode predecessor = edge.getPredecessor();
            String funcname = predecessor.getFunctionName();
            if (predecessor.isLoopStart() || predecessor.getNumEnteringEdges() != 1 || predecessor.getNumLeavingEdges() != 1 || this.currentComboEdge != null && !predecessor.equals(this.currentComboEdge.get(this.currentComboEdge.size() - 1).getSuccessor()) || edge.getEdgeType() == CFAEdgeType.CallToReturnEdge || edge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                this.edges.put((Object)funcname, (Object)edge);
                this.currentComboEdge = null;
                this.nodes.put((Object)funcname, (Object)predecessor);
                this.nodes.put((Object)funcname, (Object)edge.getSuccessor());
            } else {
                if (this.currentComboEdge == null) {
                    this.currentComboEdge = new ArrayList<CFAEdge>();
                    this.comboedges.put((Object)funcname, this.currentComboEdge);
                }
                this.currentComboEdge.add(edge);
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        private void postProcessing() {
            Iterator it = this.comboedges.entries().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                List combinedEdges = (List)entry.getValue();
                String functionName = (String)entry.getKey();
                if (combinedEdges.size() == 1) {
                    it.remove();
                    CFAEdge firstEdge = (CFAEdge)combinedEdges.get(0);
                    this.edges.put((Object)functionName, (Object)firstEdge);
                    this.nodes.put((Object)functionName, (Object)firstEdge.getPredecessor());
                    this.nodes.put((Object)functionName, (Object)firstEdge.getSuccessor());
                    continue;
                }
                if (combinedEdges.size() <= 1) continue;
                CFAEdge first = (CFAEdge)combinedEdges.get(0);
                int firstNode = first.getPredecessor().getNodeNumber();
                Set<Integer> combinedNodes = this.comboNodes.get(firstNode);
                StringBuilder label = this.comboNodesLabels.get(firstNode);
                if (combinedNodes == null) {
                    assert (label == null) : "label and combinedNodes should always be initialized and changed together";
                    combinedNodes = new LinkedHashSet<Integer>();
                    this.comboNodes.put(firstNode, combinedNodes);
                    label = new StringBuilder();
                    this.comboNodesLabels.put(firstNode, label);
                }
                for (CFAEdge edge : combinedEdges) {
                    int predNumber = edge.getPredecessor().getNodeNumber();
                    if (!combinedNodes.add(predNumber)) continue;
                    if (combinedNodes.size() > 1) {
                        label.append("\n");
                    }
                    label.append(predNumber);
                    label.append(" ");
                    label.append(edge.getDescription());
                }
                this.comboNodes.forEach((k, v) -> {
                    v.remove(k);
                    this.mergedNodes.addAll((Collection<Integer>)v);
                });
            }
            for (CFAEdge edge : this.edges.values()) {
                if (edge.getEdgeType() != CFAEdgeType.CallToReturnEdge) continue;
                int from = edge.getPredecessor().getNodeNumber();
                int to = edge.getSuccessor().getNodeNumber();
                this.virtFuncCallEdges.put(from, Lists.newArrayList((Object[])new Integer[]{++this.virtFuncCallNodeIdCounter, to}));
            }
        }

        void writeFunctionFile(String funcname, Path outdir) throws IOException {
            Path cfaFile = outdir.resolve("cfa__" + funcname + ".dot");
            MoreFiles.createParentDirectories((Path)cfaFile, (FileAttribute[])new FileAttribute[0]);
            try (BufferedWriter out = Files.newBufferedWriter(cfaFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                out.write("digraph " + funcname + " {\n");
                StringBuilder outb = new StringBuilder();
                for (List combo : this.comboedges.get((Object)funcname)) {
                    outb.append(this.comboToDot(combo));
                    CFAEdge first = (CFAEdge)combo.get(0);
                    CFAEdge last = (CFAEdge)combo.get(combo.size() - 1);
                    outb.append(first.getPredecessor().getNodeNumber());
                    outb.append(" -> ");
                    outb.append(last.getSuccessor().getNodeNumber());
                    outb.append("[label=\"\"]\n");
                }
                for (CFANode node : this.nodes.get((Object)funcname)) {
                    out.write(DOTBuilder.formatNode(node, this.loopHeads));
                    ((Writer)out).write(10);
                }
                out.write(outb.toString());
                for (CFAEdge edge : this.edges.get((Object)funcname)) {
                    out.write(this.edgeToDot(edge));
                }
                out.write("}");
            }
        }

        private String edgeToDot(CFAEdge edge) {
            if (edge.getEdgeType() == CFAEdgeType.CallToReturnEdge) {
                CFANode functionEntryNode = (CFANode)Iterables.getOnlyElement((Iterable)CFAUtils.successorsOf(edge.getPredecessor()).filter(FunctionEntryNode.class));
                String calledFunction = functionEntryNode.getFunctionName();
                int from = edge.getPredecessor().getNodeNumber();
                Integer virtFuncCallNodeId = this.virtFuncCallEdges.get(from).get(0);
                String ret = virtFuncCallNodeId + " [shape=\"component\" label=\"" + calledFunction + "\"]\n";
                ret = ret + String.format("%d -> %d [label=\"%s\" fontname=\"Courier New\"]%n", from, virtFuncCallNodeId, DOTBuilder2.getEdgeText(edge));
                int to = edge.getSuccessor().getNodeNumber();
                ret = ret + String.format("%d -> %d [label=\"\" fontname=\"Courier New\"]%n", virtFuncCallNodeId, to);
                return ret;
            }
            return String.format("%d -> %d [label=\"%s\" fontname=\"Courier New\"]%n", edge.getPredecessor().getNodeNumber(), edge.getSuccessor().getNodeNumber(), DOTBuilder2.getEdgeText(edge));
        }

        private String comboToDot(List<CFAEdge> combo) {
            CFAEdge first = combo.get(0);
            StringBuilder sb = new StringBuilder();
            int firstNo = first.getPredecessor().getNodeNumber();
            sb.append(firstNo);
            sb.append(" [style=\"filled,bold\" penwidth=\"1\" fillcolor=\"white\" fontname=\"Courier New\" shape=\"Mrecord\" label=");
            if (combo.size() > 20) {
                CFAEdge last = combo.get(combo.size() - 1);
                int lastNo = last.getPredecessor().getNodeNumber();
                sb.append("\"Long linear chain of edges between nodes ");
                sb.append(firstNo);
                sb.append(" and ");
                sb.append(lastNo);
                sb.append('\"');
            } else {
                sb.append("<<table border=\"0\" cellborder=\"0\" cellpadding=\"3\" bgcolor=\"white\">");
                for (CFAEdge edge : combo) {
                    sb.append("<tr><td align=\"right\">");
                    sb.append("" + edge.getPredecessor().getNodeNumber());
                    sb.append("</td><td align=\"left\">");
                    sb.append(HtmlEscapers.htmlEscaper().escape(DOTBuilder2.getEdgeText(edge)).replace("|", "&#124;").replace("{", "&#123;").replace("}", "&#125;"));
                    sb.append("</td></tr>");
                }
                sb.append("</table>>");
            }
            sb.append("]\n");
            return sb.toString();
        }
    }
}

