/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.export;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class FunctionCallDumper {
    public static void dump(Appendable pAppender, CFA pCfa, boolean usedFromMainOnly) throws IOException {
        CFAFunctionCallFinder finder = new CFAFunctionCallFinder(pCfa);
        for (FunctionEntryNode entryNode : pCfa.getAllFunctionHeads()) {
            CFATraversal.dfs().ignoreFunctionCalls().traverseOnce(entryNode, finder);
        }
        pAppender.append("digraph functioncalls {\n");
        pAppender.append("rankdir=LR;\n\n");
        NavigableSet<String> functionNames = pCfa.getAllFunctionNames();
        String mainFunction = pCfa.getMainFunction().getFunctionName();
        pAppender.append(mainFunction + " [shape=\"box\", color=blue];\n");
        HashMap<String, String> escapedNames = new HashMap<String, String>();
        HashSet<String> writtenNames = new HashSet<String>();
        for (String callerFunctionName : FunctionCallDumper.filterCalls(finder.functionCalls, finder.threadCreations, mainFunction, usedFromMainOnly)) {
            String callee;
            String caller;
            for (String calleeFunctionName : finder.functionCalls.get((Object)callerFunctionName)) {
                caller = FunctionCallDumper.escape(escapedNames, callerFunctionName);
                callee = FunctionCallDumper.escape(escapedNames, calleeFunctionName);
                if (writtenNames.add(calleeFunctionName)) {
                    pAppender.append(FunctionCallDumper.formatFunctionNode(finder, functionNames, calleeFunctionName, callee));
                }
                pAppender.append(String.format("%s -> %s;%n", caller, callee));
            }
            for (String calleeFunctionName : finder.threadCreations.get((Object)callerFunctionName)) {
                caller = FunctionCallDumper.escape(escapedNames, callerFunctionName);
                callee = FunctionCallDumper.escape(escapedNames, calleeFunctionName);
                if (writtenNames.add(calleeFunctionName)) {
                    pAppender.append(FunctionCallDumper.formatFunctionNode(finder, functionNames, calleeFunctionName, callee));
                }
                pAppender.append(String.format("%s -> %s [style=\"dashed\" label=\"%s\"];%n", caller, callee, "pthread_create"));
            }
        }
        pAppender.append("}\n");
    }

    private static String formatFunctionNode(CFAFunctionCallFinder finder, Set<String> functionNames, String calleeFunctionName, String callee) {
        Object label = calleeFunctionName;
        Collection origNames = finder.originalNames.get((Object)calleeFunctionName);
        origNames.remove(calleeFunctionName);
        if (!origNames.isEmpty()) {
            label = (String)label + "\\n(" + Joiner.on((String)", ").join((Iterable)origNames) + ")";
        }
        String format = functionNames.contains(calleeFunctionName) ? "" : "shape=\"box\", color=grey";
        return String.format("%s [label=\"%s\", %s];%n", callee, DOTBuilder.escapeGraphvizLabel((String)label, " "), format);
    }

    private static Set<String> filterCalls(Multimap<String, String> functionCalls, Multimap<String, String> threadCreations, String mainFunction, boolean usedFromMainOnly) {
        if (!usedFromMainOnly) {
            return functionCalls.keySet();
        }
        LinkedHashSet<String> calls = new LinkedHashSet<String>();
        ArrayDeque<String> worklist = new ArrayDeque<String>();
        worklist.push(mainFunction);
        while (!worklist.isEmpty()) {
            String nextFunction = (String)worklist.pop();
            if (!calls.add(nextFunction)) continue;
            worklist.addAll(functionCalls.get((Object)nextFunction));
            worklist.addAll(threadCreations.get((Object)nextFunction));
        }
        return calls;
    }

    private static String escape(Map<String, String> escapedNames, String functionName) {
        return escapedNames.computeIfAbsent(functionName, str -> str.matches("[a-zA-Z0-9_]*") ? str : "escapedFunctionName_" + escapedNames.size());
    }

    private static class CFAFunctionCallFinder
    extends CFATraversal.DefaultCFAVisitor {
        final Multimap<String, String> functionCalls = LinkedHashMultimap.create();
        final Multimap<String, String> originalNames = LinkedHashMultimap.create();
        final Multimap<String, String> threadCreations = LinkedHashMultimap.create();
        private final CFA cfa;

        private CFAFunctionCallFinder(CFA pCfa) {
            this.cfa = pCfa;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            switch (pEdge.getEdgeType()) {
                case CallToReturnEdge: {
                    FunctionSummaryEdge function = (FunctionSummaryEdge)pEdge;
                    String functionName = function.getPredecessor().getFunctionName();
                    AFunctionDeclaration calledFunctionDecl = ((FunctionCallEdge)CFAUtils.leavingEdges(function.getPredecessor()).filter(FunctionCallEdge.class).first().toJavaUtil().orElseThrow(() -> new IllegalStateException("internal function without body"))).getSuccessor().getFunctionDefinition();
                    this.functionCalls.put((Object)functionName, (Object)calledFunctionDecl.getName());
                    this.originalNames.put((Object)calledFunctionDecl.getName(), (Object)calledFunctionDecl.getOrigName());
                    break;
                }
                case StatementEdge: {
                    CExpression expr2;
                    AFunctionCall functionCall;
                    AFunctionCallExpression functionCallExpression;
                    AFunctionDeclaration declaration;
                    AStatementEdge edge = (AStatementEdge)pEdge;
                    if (!(edge.getStatement() instanceof AFunctionCall) || (declaration = (functionCallExpression = (functionCall = (AFunctionCall)edge.getStatement()).getFunctionCallExpression()).getDeclaration()) == null) break;
                    String functionName = pEdge.getPredecessor().getFunctionName();
                    String calledFunction = declaration.getName();
                    this.functionCalls.put((Object)functionName, (Object)calledFunction);
                    this.originalNames.put((Object)declaration.getName(), (Object)declaration.getOrigName());
                    AExpression functionNameExp = functionCallExpression.getFunctionNameExpression();
                    List<? extends AExpression> params = functionCall.getFunctionCallExpression().getParameterExpressions();
                    if (!(functionNameExp instanceof AIdExpression) || !"pthread_create".equals(((AIdExpression)functionNameExp).getName()) || !(params.get(2) instanceof CUnaryExpression) || !((expr2 = ((CUnaryExpression)params.get(2)).getOperand()) instanceof CIdExpression)) break;
                    AFunctionDeclaration functionDecl = (AFunctionDeclaration)((Object)((CIdExpression)expr2).getDeclaration());
                    String calledThreadFunction = functionDecl.getName();
                    this.threadCreations.put((Object)functionName, (Object)calledThreadFunction);
                    this.originalNames.put((Object)functionDecl.getName(), (Object)functionDecl.getOrigName());
                    for (String name : this.cfa.getAllFunctions().keySet()) {
                        if (!name.startsWith(calledThreadFunction + "__cloned_function__")) continue;
                        this.threadCreations.put((Object)functionName, (Object)name);
                        this.originalNames.put((Object)name, (Object)calledThreadFunction);
                    }
                    break;
                }
                case FunctionCallEdge: {
                    throw new AssertionError((Object)"traversal-strategy should ignore functioncalls");
                }
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }
}

