/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public abstract class AbstractCFAEdge
implements CFAEdge {
    private static final long serialVersionUID = -8493135984889665408L;
    private final CFANode predecessor;
    private final CFANode successor;
    private final String rawStatement;
    private final FileLocation fileLocation;

    protected AbstractCFAEdge(String pRawStatement, FileLocation pFileLocation, CFANode pPredecessor, CFANode pSuccessor) {
        Preconditions.checkNotNull((Object)pRawStatement);
        Preconditions.checkNotNull((Object)pPredecessor);
        Preconditions.checkNotNull((Object)pSuccessor);
        this.predecessor = pPredecessor;
        this.successor = pSuccessor;
        this.rawStatement = pRawStatement;
        this.fileLocation = (FileLocation)Preconditions.checkNotNull((Object)pFileLocation);
    }

    @Override
    public CFANode getPredecessor() {
        return this.predecessor;
    }

    @Override
    public CFANode getSuccessor() {
        return this.successor;
    }

    @Override
    public String getRawStatement() {
        return this.rawStatement;
    }

    @Override
    public Optional<AAstNode> getRawAST() {
        return Optional.empty();
    }

    @Override
    public String getDescription() {
        return this.getCode();
    }

    @Override
    public int getLineNumber() {
        return this.fileLocation.getStartingLineNumber();
    }

    @Override
    public FileLocation getFileLocation() {
        return this.fileLocation;
    }

    public int hashCode() {
        return 31 * this.predecessor.hashCode() + this.successor.hashCode();
    }

    public boolean equals(Object pOther) {
        if (!(pOther instanceof AbstractCFAEdge)) {
            return false;
        }
        AbstractCFAEdge otherEdge = (AbstractCFAEdge)pOther;
        return this.predecessor.equals(otherEdge.predecessor) && this.successor.equals(otherEdge.successor);
    }

    @Override
    public String toString() {
        return this.getFileLocation() + ":\t" + this.getPredecessor() + " -{" + this.getDescription().replace('\n', ' ') + "}-> " + this.getSuccessor();
    }
}

