/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public class AssumeEdge
extends AbstractCFAEdge {
    private static final long serialVersionUID = 1953381509820035275L;
    private final boolean truthAssumption;
    private final boolean swapped;
    private final boolean artificialIntermediate;
    protected final AExpression expression;

    protected AssumeEdge(String pRawStatement, FileLocation pFileLocation, CFANode pPredecessor, CFANode pSuccessor, AExpression pExpression, boolean pTruthAssumption, boolean pSwapped, boolean pArtificialIntermediate) {
        super("[" + pRawStatement + "]", pFileLocation, pPredecessor, pSuccessor);
        this.truthAssumption = pTruthAssumption;
        this.expression = pExpression;
        this.swapped = pSwapped;
        this.artificialIntermediate = pArtificialIntermediate;
    }

    @Override
    public CFAEdgeType getEdgeType() {
        return CFAEdgeType.AssumeEdge;
    }

    public boolean getTruthAssumption() {
        return this.truthAssumption;
    }

    public AExpression getExpression() {
        return this.expression;
    }

    @Override
    public String getCode() {
        if (this.truthAssumption) {
            return this.expression.toASTString();
        }
        return "!(" + this.expression.toASTString() + ")";
    }

    @Override
    public String getDescription() {
        return "[" + this.getCode() + "]";
    }

    @Override
    public Optional<AAstNode> getRawAST() {
        return Optional.of(this.expression);
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    public boolean isArtificialIntermediate() {
        return this.artificialIntermediate;
    }
}

