/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;

public class CFANode
implements Comparable<CFANode>,
Serializable {
    private static final long serialVersionUID = 5168350921309486536L;
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final int nodeNumber;
    private transient List<CFAEdge> leavingEdges = new ArrayList<CFAEdge>(1);
    private transient List<CFAEdge> enteringEdges = new ArrayList<CFAEdge>(1);
    private boolean isLoopStart = false;
    private final AFunctionDeclaration function;
    private Set<CSimpleDeclaration> outOfScopeVariables = null;
    private FunctionSummaryEdge leavingSummaryEdge = null;
    private FunctionSummaryEdge enteringSummaryEdge = null;
    private int reversePostorderId = 0;

    public static CFANode newDummyCFANode(String functionName) {
        return new CFANode(new CFunctionDeclaration(FileLocation.DUMMY, CFunctionType.NO_ARGS_VOID_FUNCTION, functionName, (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of()));
    }

    public static CFANode newDummyCFANode() {
        return new CFANode(CFunctionDeclaration.DUMMY);
    }

    public CFANode(AFunctionDeclaration pFunction) {
        this.function = pFunction;
        this.nodeNumber = idGenerator.getFreshId();
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public int getReversePostorderId() {
        return this.reversePostorderId;
    }

    public void setReversePostorderId(int pId) {
        this.reversePostorderId = pId;
    }

    public void addLeavingEdge(CFAEdge pNewLeavingEdge) {
        Preconditions.checkArgument((boolean)pNewLeavingEdge.getPredecessor().equals(this), (String)"Cannot add edge \"%s\" to node %s as leaving edge", (Object)pNewLeavingEdge, (Object)this);
        this.leavingEdges.add(pNewLeavingEdge);
    }

    public void removeLeavingEdge(CFAEdge pEdge) {
        boolean removed = this.leavingEdges.remove(pEdge);
        Preconditions.checkArgument((boolean)removed, (String)"Cannot remove non-existing leaving edge \"%s\" from node %s", (Object)pEdge, (Object)this);
    }

    public int getNumLeavingEdges() {
        return this.leavingEdges.size();
    }

    public CFAEdge getLeavingEdge(int pIndex) {
        return this.leavingEdges.get(pIndex);
    }

    public void addEnteringEdge(CFAEdge pEnteringEdge) {
        Preconditions.checkArgument((boolean)pEnteringEdge.getSuccessor().equals(this), (String)"Cannot add edge \"%s\" to node %s as entering edge", (Object)pEnteringEdge, (Object)this);
        this.enteringEdges.add(pEnteringEdge);
    }

    public void removeEnteringEdge(CFAEdge pEdge) {
        boolean removed = this.enteringEdges.remove(pEdge);
        Preconditions.checkArgument((boolean)removed, (String)"Cannot remove non-existing entering edge \"%s\" from node %s", (Object)pEdge, (Object)this);
    }

    public int getNumEnteringEdges() {
        return this.enteringEdges.size();
    }

    public CFAEdge getEnteringEdge(int pIndex) {
        return this.enteringEdges.get(pIndex);
    }

    public CFAEdge getEdgeTo(CFANode pOther) {
        for (CFAEdge edge : this.leavingEdges) {
            if (!edge.getSuccessor().equals(pOther)) continue;
            return edge;
        }
        throw new IllegalArgumentException("there is no edge from " + this + " to " + pOther);
    }

    public boolean hasEdgeTo(CFANode pOther) {
        boolean hasEdge = false;
        for (CFAEdge edge : this.leavingEdges) {
            if (!edge.getSuccessor().equals(pOther)) continue;
            hasEdge = true;
            break;
        }
        return hasEdge;
    }

    public void setLoopStart() {
        this.isLoopStart = true;
    }

    public boolean isLoopStart() {
        return this.isLoopStart;
    }

    public String getFunctionName() {
        return this.function.getName();
    }

    public AFunctionDeclaration getFunction() {
        return this.function;
    }

    public void addEnteringSummaryEdge(FunctionSummaryEdge pEdge) {
        Preconditions.checkState((this.enteringSummaryEdge == null ? 1 : 0) != 0, (String)"Cannot add two entering summary edges to node %s", (Object)this);
        this.enteringSummaryEdge = pEdge;
    }

    public void addLeavingSummaryEdge(FunctionSummaryEdge pEdge) {
        Preconditions.checkState((this.leavingSummaryEdge == null ? 1 : 0) != 0, (String)"Cannot add two leaving summary edges to node %s", (Object)this);
        this.leavingSummaryEdge = pEdge;
    }

    public FunctionSummaryEdge getEnteringSummaryEdge() {
        return this.enteringSummaryEdge;
    }

    public FunctionSummaryEdge getLeavingSummaryEdge() {
        return this.leavingSummaryEdge;
    }

    public void removeEnteringSummaryEdge(FunctionSummaryEdge pEdge) {
        Preconditions.checkArgument((boolean)this.enteringSummaryEdge.equals(pEdge), (String)"Cannot remove non-existing entering summary edge \"%s\" from node \"%s\"", (Object)pEdge, (Object)this);
        this.enteringSummaryEdge = null;
    }

    public void removeLeavingSummaryEdge(FunctionSummaryEdge pEdge) {
        Preconditions.checkArgument((boolean)this.leavingSummaryEdge.equals(pEdge), (String)"Cannot remove non-existing leaving summary edge \"%s\" from node \"%s\"", (Object)pEdge, (Object)this);
        this.leavingSummaryEdge = null;
    }

    public String toString() {
        return "N" + this.nodeNumber;
    }

    @Override
    public final int compareTo(CFANode pOther) {
        return Integer.compare(this.nodeNumber, pOther.nodeNumber);
    }

    public final boolean equals(Object pObj) {
        return super.equals(pObj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String describeFileLocation() {
        CFAEdge edge;
        if (this instanceof FunctionEntryNode) {
            return "entry of function " + this.getFunctionName() + " in " + ((FunctionEntryNode)this).getFileLocation();
        }
        if (this instanceof FunctionExitNode) {
            return "exit of function " + this.getFunctionName() + " in " + ((FunctionExitNode)this).getEntryNode().getFileLocation();
        }
        if (this.getNumLeavingEdges() > 0 && (edge = this.getLeavingEdge(0)).getFileLocation().isRealLocation()) {
            return "before " + edge.getFileLocation();
        }
        if (this.getNumEnteringEdges() > 0 && (edge = this.getEnteringEdge(0)).getFileLocation().isRealLocation()) {
            return "after " + edge.getFileLocation();
        }
        return "";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.leavingEdges = new ArrayList<CFAEdge>(1);
        this.enteringEdges = new ArrayList<CFAEdge>(1);
    }

    public void addOutOfScopeVariables(Collection<CSimpleDeclaration> pOutOfScopeVariables) {
        if (this.outOfScopeVariables == null) {
            this.outOfScopeVariables = new LinkedHashSet<CSimpleDeclaration>();
        }
        this.outOfScopeVariables.addAll((Collection)pOutOfScopeVariables.stream().filter(decl -> !(decl instanceof CVariableDeclaration) || !((CVariableDeclaration)decl).isGlobal()).collect(ImmutableSet.toImmutableSet()));
    }

    public Set<CSimpleDeclaration> getOutOfScopeVariables() {
        if (this.outOfScopeVariables == null) {
            return ImmutableSet.of();
        }
        return Collections.unmodifiableSet(this.outOfScopeVariables);
    }
}

