/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;

public class FunctionCallEdge
extends AbstractCFAEdge {
    private static final long serialVersionUID = -7848426105619928428L;
    protected final AFunctionCall functionCall;
    protected final FunctionSummaryEdge summaryEdge;

    protected FunctionCallEdge(String pRawStatement, FileLocation pFileLocation, CFANode pPredecessor, CFANode pSuccessor, AFunctionCall pFunctionCall, FunctionSummaryEdge pSummaryEdge) {
        super(pRawStatement, pFileLocation, pPredecessor, pSuccessor);
        this.functionCall = pFunctionCall;
        this.summaryEdge = pSummaryEdge;
    }

    @Override
    public CFAEdgeType getEdgeType() {
        return CFAEdgeType.FunctionCallEdge;
    }

    public FunctionSummaryEdge getSummaryEdge() {
        return this.summaryEdge;
    }

    public AFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public AFunctionCallExpression getFunctionCallExpression() {
        return this.getFunctionCall().getFunctionCallExpression();
    }

    public List<? extends AExpression> getArguments() {
        return this.getFunctionCallExpression().getParameterExpressions();
    }

    @Override
    public String getCode() {
        return this.functionCall.getFunctionCallExpression().toASTString();
    }

    @Override
    public Optional<AAstNode> getRawAST() {
        return Optional.of(this.functionCall);
    }

    @Override
    public FunctionEntryNode getSuccessor() {
        return (FunctionEntryNode)super.getSuccessor();
    }
}

