/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;

public abstract class FunctionEntryNode
extends CFANode {
    private static final long serialVersionUID = 1837494813423960670L;
    private final FileLocation location;
    private final AFunctionDeclaration functionDefinition;
    private final @Nullable AVariableDeclaration returnVariable;
    private final FunctionExitNode exitNode;

    protected FunctionEntryNode(FileLocation pFileLocation, FunctionExitNode pExitNode, AFunctionDeclaration pFunctionDefinition, Optional<? extends AVariableDeclaration> pReturnVariable) {
        super(pFunctionDefinition);
        this.location = (FileLocation)Preconditions.checkNotNull((Object)pFileLocation);
        this.functionDefinition = pFunctionDefinition;
        this.exitNode = pExitNode;
        this.returnVariable = pReturnVariable.orElse(null);
    }

    public FileLocation getFileLocation() {
        return this.location;
    }

    public FunctionExitNode getExitNode() {
        return this.exitNode;
    }

    public AFunctionDeclaration getFunctionDefinition() {
        return this.functionDefinition;
    }

    public List<String> getFunctionParameterNames() {
        return Lists.transform(this.functionDefinition.getParameters(), AbstractSimpleDeclaration::getName);
    }

    public abstract List<? extends AParameterDeclaration> getFunctionParameters();

    public Optional<? extends AVariableDeclaration> getReturnVariable() {
        return Optional.ofNullable(this.returnVariable);
    }
}

