/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser;

import com.google.common.collect.ImmutableSet;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.export.CWriter;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;

@SuppressForbidden(value="reflection necessary")
public class Parsers {
    private static final Pattern OUR_CLASSES = Pattern.compile("^(org\\.eclipse|org\\.sosy_lab\\.cpachecker\\.cfa\\.parser\\.(eclipse\\..*|llvm)\\.*)\\..*");
    private static final String C_PARSER_CLASS = "org.sosy_lab.cpachecker.cfa.parser.eclipse.c.EclipseCParser";
    private static final String JAVA_PARSER_CLASS = "org.sosy_lab.cpachecker.cfa.parser.eclipse.java.EclipseJavaParser";
    private static final String LLVM_PARSER_CLASS = "org.sosy_lab.cpachecker.cfa.parser.llvm.LlvmParser";
    private static final String C_WRITER_CLASS = "org.sosy_lab.cpachecker.cfa.parser.eclipse.c.export.EclipseCWriter";
    private static WeakReference<ClassLoader> loadedClassLoader = new WeakReference<Object>(null);
    private static WeakReference<Constructor<? extends CParser>> loadedCParser = new WeakReference<Object>(null);
    private static WeakReference<Constructor<? extends Parser>> loadedJavaParser = new WeakReference<Object>(null);
    private static WeakReference<Constructor<? extends Parser>> loadedLlvmParser = new WeakReference<Object>(null);
    private static WeakReference<Constructor<? extends CWriter>> loadedCWriter = new WeakReference<Object>(null);
    private static final AtomicInteger loadingCount = new AtomicInteger(0);

    private Parsers() {
    }

    private static ClassLoader getClassLoader(LogManager logger) {
        ClassLoader classLoader = (ClassLoader)loadedClassLoader.get();
        if (classLoader != null) {
            return classLoader;
        }
        if (loadingCount.incrementAndGet() > 1) {
            logger.log(Level.INFO, new Object[]{"Repeated loading of Eclipse source parser"});
        }
        if ((classLoader = Parsers.class.getClassLoader()) instanceof URLClassLoader) {
            classLoader = Classes.makeExtendedURLClassLoader().setParent(classLoader).setUrls(((URLClassLoader)classLoader).getURLs()).setDirectLoadClasses(OUR_CLASSES).build();
        }
        loadedClassLoader = new WeakReference<ClassLoader>(classLoader);
        return classLoader;
    }

    public static CParser getCParser(LogManager logger, EclipseCParserOptions options, MachineModel machine, ShutdownNotifier shutdownNotifier) {
        try {
            Constructor<?> parserConstructor = (Constructor<?>)loadedCParser.get();
            if (parserConstructor == null) {
                ClassLoader classLoader = Parsers.getClassLoader(logger);
                Class<?> parserClass = classLoader.loadClass(C_PARSER_CLASS);
                parserConstructor = parserClass.getConstructor(LogManager.class, EclipseCParserOptions.class, MachineModel.class, ShutdownNotifier.class);
                parserConstructor.setAccessible(true);
                loadedCParser = new WeakReference(parserConstructor);
            }
            return (CParser)parserConstructor.newInstance(new Object[]{logger, options, machine, shutdownNotifier});
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to create Eclipse CDT parser", (Throwable)e);
        }
    }

    public static Parser getJavaParser(LogManager logger, Configuration config, String entryMethod) throws InvalidConfigurationException {
        try {
            Constructor<?> parserConstructor = (Constructor<?>)loadedJavaParser.get();
            if (parserConstructor == null) {
                ClassLoader classLoader = Parsers.getClassLoader(logger);
                Class<?> parserClass = classLoader.loadClass(JAVA_PARSER_CLASS);
                parserConstructor = parserClass.getConstructor(LogManager.class, Configuration.class, String.class);
                parserConstructor.setAccessible(true);
                loadedJavaParser = new WeakReference(parserConstructor);
            }
            try {
                return (Parser)parserConstructor.newInstance(logger, config, entryMethod);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof InvalidConfigurationException) {
                    throw (InvalidConfigurationException)e.getCause();
                }
                throw e;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to create Eclipse Java parser", (Throwable)e);
        }
    }

    public static Parser getLlvmParser(LogManager pLogger, MachineModel pMachineModel) throws InvalidConfigurationException {
        try {
            Constructor<?> parserConstructor = (Constructor<?>)loadedLlvmParser.get();
            if (parserConstructor == null) {
                ClassLoader classLoader = Parsers.getClassLoader(pLogger);
                Class<?> parserClass = classLoader.loadClass(LLVM_PARSER_CLASS);
                parserConstructor = parserClass.getConstructor(LogManager.class, MachineModel.class);
                parserConstructor.setAccessible(true);
                loadedLlvmParser = new WeakReference(parserConstructor);
            }
            try {
                return (Parser)parserConstructor.newInstance(new Object[]{pLogger, pMachineModel});
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof InvalidConfigurationException) {
                    throw (InvalidConfigurationException)e.getCause();
                }
                throw e;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to create LLVM parser", (Throwable)e);
        }
    }

    public static CWriter getCWriter(LogManager pLogger, CParser.ParserOptions pOptions, ShutdownNotifier pShutdownNotifier) {
        try {
            Constructor<?> writerConstructor = (Constructor<?>)loadedCWriter.get();
            if (writerConstructor == null) {
                ClassLoader classLoader = Parsers.getClassLoader(pLogger);
                Class<?> writerClass = classLoader.loadClass(C_WRITER_CLASS);
                writerConstructor = writerClass.getConstructor(CParser.ParserOptions.class, ShutdownNotifier.class);
                writerConstructor.setAccessible(true);
                loadedCWriter = new WeakReference(writerConstructor);
            }
            return (CWriter)writerConstructor.newInstance(pOptions, pShutdownNotifier);
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to create Eclipse CDT writer", (Throwable)e);
        }
    }

    @Options(prefix="cfa")
    public static class EclipseCParserOptions
    extends CParser.ParserOptions {
        @Option(secure=true, description="Also initialize local variables with default values, or leave them uninitialized.")
        private boolean initializeAllVariables = false;
        @Option(secure=true, description="Show messages when dead code is encountered during parsing.")
        private boolean showDeadCode = true;
        @Option(secure=true, description="simplify pointer expressions like s->f to (*s).f with this option the cfa is simplified until at maximum one pointer is allowed for left- and rightHandSide")
        private boolean simplifyPointerExpressions = false;
        @Option(secure=true, description="simplify simple const expressions like 1+2")
        private boolean simplifyConstExpressions = true;
        @Option(secure=true, name="nonReturningFunctions", description="Which functions should be interpreted as never returning to their call site")
        private Set<String> noReturnFunctions = ImmutableSet.of((Object)"abort", (Object)"exit");

        public boolean initializeAllVariables() {
            return this.initializeAllVariables;
        }

        public boolean showDeadCode() {
            return this.showDeadCode;
        }

        public boolean simplifyPointerExpressions() {
            return this.simplifyPointerExpressions;
        }

        public boolean simplifyConstExpressions() {
            return this.simplifyConstExpressions;
        }

        public boolean isNonReturningFunction(String functionName) {
            return this.noReturnFunctions.contains(functionName);
        }
    }
}

