/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.dom.ast.gnu.c.IGCCASTArrayRangeDesignator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTArrayDesignator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTArrayRangeDesignator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTLiteralExpression;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.Parsers;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTLiteralConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTOperatorConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FillInBindingVisitor;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FunctionScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ParseContext;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.Sideassignments;
import org.sosy_lab.cpachecker.cfa.simplification.ExpressionSimplificationVisitor;
import org.sosy_lab.cpachecker.cfa.simplification.NonRecursiveExpressionSimplificationVisitor;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.BuiltinOverflowFunctions;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;

class ASTConverter {
    private static final ImmutableMap<String, Optional<CFunctionDeclaration.FunctionAttribute>> KNOWN_FUNCTION_ATTRIBUTES;
    private static final String FUNC_CONSTANT = "__builtin_constant_p";
    private static final String FUNC_OFFSETOF = "__builtin_offsetof";
    private static final String FUNC_EXPECT = "__builtin_expect";
    private static final String FUNC_TYPES_COMPATIBLE = "__builtin_types_compatible_p";
    private final ExpressionSimplificationVisitor expressionSimplificator;
    private final NonRecursiveExpressionSimplificationVisitor nonRecursiveExpressionSimplificator;
    private final CBinaryExpressionBuilder binExprBuilder;
    private final Parsers.EclipseCParserOptions options;
    private final LogManager logger;
    private final ASTLiteralConverter literalConverter;
    private final ASTOperatorConverter operatorConverter;
    private final ASTTypeConverter typeConverter;
    private final MachineModel machinemodel;
    private final ParseContext parseContext;
    private final Scope scope;
    private static int anonTypeCounter;
    private final Sideassignments sideAssignmentStack;
    private final String staticVariablePrefix;
    private static final ContainsProblemTypeVisitor containsProblemTypeVisitor;
    private static final ImmutableList<CSimpleType> ENUM_REPRESENTATION_CANDIDATE_TYPES;

    public ASTConverter(Parsers.EclipseCParserOptions pOptions, Scope pScope, LogManagerWithoutDuplicates pLogger, ParseContext pParseContext, MachineModel pMachineModel, String pStaticVariablePrefix, Sideassignments pSideAssignmentStack) {
        this.options = pOptions;
        this.scope = pScope;
        this.logger = pLogger;
        this.typeConverter = new ASTTypeConverter(this.scope, this, pStaticVariablePrefix, pParseContext);
        this.literalConverter = new ASTLiteralConverter(pMachineModel, pParseContext);
        this.operatorConverter = new ASTOperatorConverter(pParseContext);
        this.parseContext = pParseContext;
        this.machinemodel = pMachineModel;
        this.staticVariablePrefix = pStaticVariablePrefix;
        this.sideAssignmentStack = pSideAssignmentStack;
        this.expressionSimplificator = new ExpressionSimplificationVisitor(pMachineModel, pLogger);
        this.nonRecursiveExpressionSimplificator = new NonRecursiveExpressionSimplificationVisitor(pMachineModel, pLogger);
        this.binExprBuilder = new CBinaryExpressionBuilder(pMachineModel, (LogManager)pLogger);
    }

    public CExpression convertExpressionWithoutSideEffects(IASTExpression e) {
        CAstNode node = this.convertExpressionWithSideEffects(e);
        if (node == null || node instanceof CExpression) {
            return (CExpression)node;
        }
        if (node instanceof CFunctionCallExpression) {
            return this.addSideassignmentsForExpressionsWithoutSideEffects(node, e);
        }
        if (e instanceof IASTUnaryExpression && (((IASTUnaryExpression)e).getOperator() == 10 || ((IASTUnaryExpression)e).getOperator() == 9)) {
            return this.addSideAssignmentsForUnaryExpressions(((CAssignment)node).getLeftHandSide(), node.getFileLocation(), ((CBinaryExpression)((CAssignment)node).getRightHandSide()).getOperator());
        }
        if (node instanceof CAssignment) {
            this.sideAssignmentStack.addPreSideAssignment(node);
            return ((CAssignment)node).getLeftHandSide();
        }
        throw new AssertionError((Object)("unknown expression " + node));
    }

    CExpression simplifyExpressionRecursively(CExpression exp) {
        return exp.accept(this.expressionSimplificator);
    }

    CExpression simplifyExpressionOneStep(CExpression exp) {
        return exp.accept(this.nonRecursiveExpressionSimplificator);
    }

    private CExpression addSideassignmentsForExpressionsWithoutSideEffects(CAstNode node, IASTExpression e) {
        CIdExpression tmp = e.getExpressionType() instanceof IProblemType ? this.createInitializedTemporaryVariable(this.getLocation((IASTNode)e), ((CRightHandSide)node).getExpressionType(), (CInitializer)null) : this.createTemporaryVariable(e);
        this.sideAssignmentStack.addPreSideAssignment(new CFunctionCallAssignmentStatement(this.getLocation((IASTNode)e), tmp, (CFunctionCallExpression)node));
        return tmp;
    }

    private CIdExpression addSideAssignmentsForUnaryExpressions(CLeftHandSide exp, FileLocation fileLoc, CBinaryExpression.BinaryOperator op) {
        CIdExpression tmp = this.createInitializedTemporaryVariable(fileLoc, exp.getExpressionType(), exp);
        CBinaryExpression postExp = this.buildBinaryExpression(exp, CIntegerLiteralExpression.ONE, op);
        this.sideAssignmentStack.addPreSideAssignment(new CExpressionAssignmentStatement(fileLoc, exp, postExp));
        return tmp;
    }

    private void addSideEffectDeclarationForType(CCompositeType type, FileLocation loc) {
        CComplexTypeDeclaration decl = new CComplexTypeDeclaration(loc, this.scope.isGlobalScope(), type);
        if (this.scope.registerTypeDeclaration(decl)) {
            this.sideAssignmentStack.addPreSideAssignment(decl);
        }
    }

    protected CAstNode convertExpressionWithSideEffects(IASTExpression e) {
        CAstNode converted = this.convertExpressionWithSideEffectsNotSimplified(e);
        if (converted == null || !this.options.simplifyConstExpressions() || !(converted instanceof CExpression)) {
            return converted;
        }
        return this.simplifyExpressionOneStep((CExpression)converted);
    }

    private CAstNode convertExpressionWithSideEffectsNotSimplified(IASTExpression e) {
        assert (!(e instanceof CExpression));
        if (e == null) {
            return null;
        }
        if (e instanceof IASTArraySubscriptExpression) {
            return this.convert((IASTArraySubscriptExpression)e);
        }
        if (e instanceof IASTBinaryExpression) {
            return this.convert((IASTBinaryExpression)e);
        }
        if (e instanceof IASTCastExpression) {
            return this.convert((IASTCastExpression)e);
        }
        if (e instanceof IASTFieldReference) {
            return this.convert((IASTFieldReference)e);
        }
        if (e instanceof IASTFunctionCallExpression) {
            return this.convert((IASTFunctionCallExpression)e);
        }
        if (e instanceof IASTIdExpression) {
            AbstractExpression exp = this.convert((IASTIdExpression)e);
            CType type = exp.getExpressionType();
            if (type instanceof CFunctionType && !this.isFunctionCallNameExpression(e) && !this.isAddressOfArgument(e)) {
                exp = new CUnaryExpression(exp.getFileLocation(), new CPointerType(type.isConst(), type.isVolatile(), type), (CExpression)((Object)exp), CUnaryExpression.UnaryOperator.AMPER);
            }
            return exp;
        }
        if (e instanceof IASTLiteralExpression) {
            CType type = this.typeConverter.convert(e.getExpressionType());
            return this.literalConverter.convert((IASTLiteralExpression)e, type, this.getLocation((IASTNode)e));
        }
        if (e instanceof IASTUnaryExpression) {
            return this.convert((IASTUnaryExpression)e);
        }
        if (e instanceof IASTTypeIdExpression) {
            return this.convert((IASTTypeIdExpression)e);
        }
        if (e instanceof IASTTypeIdInitializerExpression) {
            return this.convert((IASTTypeIdInitializerExpression)e);
        }
        if (e instanceof IASTConditionalExpression) {
            return this.convert((IASTConditionalExpression)e);
        }
        if (e instanceof IGNUASTCompoundStatementExpression) {
            return this.convert((IGNUASTCompoundStatementExpression)e);
        }
        if (e instanceof IASTExpressionList) {
            return this.convertExpressionListAsExpression((IASTExpressionList)e);
        }
        throw this.parseContext.parseError("Unknown expression type " + e.getClass().getSimpleName(), (IASTNode)e);
    }

    private boolean isFunctionCallNameExpression(IASTExpression e) {
        return e.getParent() instanceof IASTFunctionCallExpression && e.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME;
    }

    private boolean isAddressOfArgument(IASTExpression e) {
        return e.getParent() instanceof IASTUnaryExpression && ((IASTUnaryExpression)e.getParent()).getOperator() == 5;
    }

    CONDITION getConditionKind(CExpression condition) {
        if (condition instanceof CIntegerLiteralExpression || condition instanceof CCharLiteralExpression) {
            if (this.isZero(condition)) {
                return CONDITION.ALWAYS_FALSE;
            }
            return CONDITION.ALWAYS_TRUE;
        }
        return CONDITION.NORMAL;
    }

    private CAstNode convert(IASTConditionalExpression e) {
        CONDITION conditionKind = this.getConditionKind(e.getLogicalConditionExpression());
        switch (conditionKind) {
            case ALWAYS_TRUE: {
                return this.convertExpressionWithSideEffects(e.getPositiveResultExpression());
            }
            case ALWAYS_FALSE: {
                return this.convertExpressionWithSideEffects(e.getNegativeResultExpression());
            }
            case NORMAL: {
                if (this.convertType((IASTExpression)e) instanceof CVoidType) {
                    this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, null);
                    return CIntegerLiteralExpression.ZERO;
                }
                CIdExpression tmp = this.createTemporaryVariable((IASTExpression)e);
                assert (!(tmp.getExpressionType() instanceof CVoidType));
                this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, tmp);
                return tmp;
            }
        }
        throw new AssertionError((Object)("Unhandled case statement: " + conditionKind));
    }

    private CONDITION getConditionKind(IASTExpression exp) {
        if (exp instanceof IASTBinaryExpression && (((IASTBinaryExpression)exp).getOperator() == 15 || ((IASTBinaryExpression)exp).getOperator() == 16)) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)exp;
            switch (binExp.getOperator()) {
                case 15: {
                    CONDITION left = this.getConditionKind(binExp.getOperand1());
                    switch (left) {
                        case ALWAYS_TRUE: {
                            return this.getConditionKind(binExp.getOperand2());
                        }
                        case ALWAYS_FALSE: {
                            return left;
                        }
                        case NORMAL: {
                            if (this.getConditionKind(binExp.getOperand2()) == CONDITION.ALWAYS_FALSE) {
                                return CONDITION.ALWAYS_FALSE;
                            }
                            return CONDITION.NORMAL;
                        }
                    }
                    throw new AssertionError((Object)"unhandled case statement");
                }
                case 16: {
                    CONDITION left = this.getConditionKind(binExp.getOperand1());
                    switch (left) {
                        case ALWAYS_TRUE: {
                            return CONDITION.ALWAYS_TRUE;
                        }
                        case ALWAYS_FALSE: {
                            return this.getConditionKind(binExp.getOperand2());
                        }
                        case NORMAL: {
                            CONDITION right = this.getConditionKind(binExp.getOperand2());
                            if (right == CONDITION.ALWAYS_FALSE) {
                                return CONDITION.NORMAL;
                            }
                            return right;
                        }
                    }
                    throw new AssertionError((Object)"unhandled case statement");
                }
            }
            throw new AssertionError((Object)"unhandled case statement");
        }
        this.sideAssignmentStack.enterBlock();
        CExpression simplifiedExp = this.simplifyExpressionRecursively(this.convertExpressionWithoutSideEffects(exp));
        this.sideAssignmentStack.getAndResetConditionalExpressions();
        this.sideAssignmentStack.getAndResetPostSideAssignments();
        this.sideAssignmentStack.getAndResetPreSideAssignments();
        this.sideAssignmentStack.leaveBlock();
        return this.getConditionKind(simplifiedExp);
    }

    private boolean isZero(CExpression exp) {
        if (exp instanceof CIntegerLiteralExpression) {
            BigInteger value = ((CIntegerLiteralExpression)exp).getValue();
            return value.equals(BigInteger.ZERO);
        }
        if (exp instanceof CCharLiteralExpression) {
            char value = ((CCharLiteralExpression)exp).getCharacter();
            return value == '\u0000';
        }
        return false;
    }

    private BigInteger evaluateIntegerConstantExpression(IASTExpression exp) {
        CAstNode n = this.convertExpressionWithSideEffectsNotSimplified(exp);
        if (!(n instanceof CExpression)) {
            throw this.parseContext.parseError("Constant expression with side effect", (IASTNode)exp);
        }
        CExpression e = this.simplifyExpressionRecursively((CExpression)n);
        if (e instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)e).getValue();
        }
        if (e instanceof CCharLiteralExpression) {
            return BigInteger.valueOf(((CCharLiteralExpression)e).getCharacter());
        }
        throw this.parseContext.parseError("Integer constant expression could not be evaluated", n);
    }

    private CAstNode convert(IGNUASTCompoundStatementExpression e) {
        CIdExpression tmp = this.createTemporaryVariable((IASTExpression)e);
        this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, tmp);
        return tmp;
    }

    private CAstNode convertExpressionListAsExpression(IASTExpressionList e) {
        CIdExpression tmp = this.createTemporaryVariable((IASTExpression)e);
        this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, tmp);
        return tmp;
    }

    private CArraySubscriptExpression convert(IASTArraySubscriptExpression e) {
        CExpression arrayExpr = this.convertExpressionWithoutSideEffects(e.getArrayExpression());
        CExpression subscriptExpr = this.convertExpressionWithoutSideEffects(this.toExpression(e.getArgument()));
        CType resultType = arrayExpr.getExpressionType();
        while (resultType instanceof CTypedefType) {
            resultType = ((CTypedefType)resultType).getRealType();
        }
        resultType = resultType instanceof CArrayType ? ((CArrayType)resultType).getType() : (resultType instanceof CPointerType ? ((CPointerType)resultType).getType() : this.typeConverter.convert(e.getExpressionType()));
        return new CArraySubscriptExpression(this.getLocation((IASTNode)e), resultType, arrayExpr, subscriptExpr);
    }

    private CIdExpression createTemporaryVariable(IASTExpression e) {
        CType type = this.convertType(e);
        if (type instanceof CVoidType) {
            return null;
        }
        return this.createInitializedTemporaryVariable(this.getLocation((IASTNode)e), type, (CInitializer)null);
    }

    private CType convertType(IASTExpression e) {
        CType type = this.typeConverter.convert(e.getExpressionType());
        if (type.getCanonicalType() instanceof CVoidType) {
            if (e instanceof IASTFunctionCallExpression) {
                return CNumericTypes.INT;
            }
        } else if (type instanceof CProblemType) {
            IGNUASTCompoundStatementExpression statementExpression;
            IASTStatement[] statements;
            if (e instanceof IASTConditionalExpression) {
                return this.typeConverter.convert(((IASTConditionalExpression)e).getNegativeResultExpression().getExpressionType());
            }
            if (e instanceof IGNUASTCompoundStatementExpression && (statements = (statementExpression = (IGNUASTCompoundStatementExpression)e).getCompoundStatement().getStatements()).length > 0) {
                IASTStatement lastStatement = statements[statements.length - 1];
                if (lastStatement instanceof IASTExpressionStatement) {
                    IASTExpression lastExpression = ((IASTExpressionStatement)lastStatement).getExpression();
                    return this.convertType(lastExpression);
                }
                return CVoidType.create(false, false);
            }
        }
        return type;
    }

    private CIdExpression createInitializedTemporaryVariable(FileLocation loc, CType pType, @Nullable CExpression initializer) {
        return this.createInitializedTemporaryVariable(loc, pType, initializer == null ? null : new CInitializerExpression(loc, initializer));
    }

    private CIdExpression createInitializedTemporaryVariable(FileLocation loc, CType pType, @Nullable CInitializer initializer) {
        CType type;
        Object name = "__CPAchecker_TMP_";
        int i = 0;
        while (this.scope.variableNameInUse((String)name + i)) {
            ++i;
        }
        name = (String)name + i;
        CType cType = type = initializer == null ? CTypes.withoutConst(pType) : pType;
        if (type instanceof CArrayType && !(initializer instanceof CInitializerList)) {
            type = new CPointerType(type.isConst(), type.isVolatile(), ((CArrayType)type).getType());
        } else if (type instanceof CFunctionType) {
            type = new CPointerType(false, false, type);
        }
        CVariableDeclaration decl = new CVariableDeclaration(loc, this.scope.isGlobalScope(), CStorageClass.AUTO, type, (String)name, (String)name, this.scope.createScopedNameOf((String)name), initializer);
        this.scope.registerDeclaration(decl);
        this.sideAssignmentStack.addPreSideAssignment(decl);
        return new CIdExpression(loc, decl);
    }

    private CAstNode convert(IASTBinaryExpression e) {
        int eop = e.getOperator();
        if (eop == 16 || eop == 15) {
            CONDITION o1 = this.getConditionKind(e.getOperand1());
            CONDITION o2 = this.getConditionKind(e.getOperand2());
            if (o1 == CONDITION.NORMAL || o2 == CONDITION.NORMAL) {
                CIdExpression tmp = this.createTemporaryVariable((IASTExpression)e);
                this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, tmp);
                return tmp;
            }
            if (eop == 15 && (o1 == CONDITION.ALWAYS_FALSE || o2 == CONDITION.ALWAYS_FALSE) || o1 == CONDITION.ALWAYS_FALSE && o2 == CONDITION.ALWAYS_FALSE) {
                return CIntegerLiteralExpression.ZERO;
            }
            return CIntegerLiteralExpression.ONE;
        }
        Pair<CBinaryExpression.BinaryOperator, Boolean> opPair = this.operatorConverter.convertBinaryOperator(e);
        CBinaryExpression.BinaryOperator op = opPair.getFirst();
        boolean isAssign = opPair.getSecond();
        FileLocation fileLoc = this.getLocation((IASTNode)e);
        CExpression leftHandSide = this.convertExpressionWithoutSideEffects(e.getOperand1());
        if (isAssign) {
            if (!(leftHandSide instanceof CLeftHandSide)) {
                throw this.parseContext.parseError("Lefthandside of Assignment " + e.getRawSignature() + " is no CLeftHandside but should be.", leftHandSide);
            }
            CLeftHandSide lhs = (CLeftHandSide)leftHandSide;
            if (op == null) {
                CAstNode rightHandSide = this.convertExpressionWithSideEffects(e.getOperand2());
                if (rightHandSide instanceof CExpression) {
                    return new CExpressionAssignmentStatement(fileLoc, lhs, (CExpression)rightHandSide);
                }
                if (rightHandSide instanceof CFunctionCallExpression) {
                    return new CFunctionCallAssignmentStatement(fileLoc, lhs, (CFunctionCallExpression)rightHandSide);
                }
                if (rightHandSide instanceof CAssignment) {
                    this.sideAssignmentStack.addPreSideAssignment(rightHandSide);
                    return new CExpressionAssignmentStatement(fileLoc, lhs, ((CAssignment)rightHandSide).getLeftHandSide());
                }
                throw this.parseContext.parseError("Expression is not free of side-effects", (IASTNode)e);
            }
            CExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getOperand2());
            CBinaryExpression exp = this.buildBinaryExpression(leftHandSide, rightHandSide, op);
            return new CExpressionAssignmentStatement(fileLoc, lhs, exp);
        }
        CExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getOperand2());
        return this.buildBinaryExpression(leftHandSide, rightHandSide, op);
    }

    private CBinaryExpression buildBinaryExpression(CExpression operand1, CExpression operand2, CBinaryExpression.BinaryOperator op) {
        try {
            return this.binExprBuilder.buildBinaryExpression(operand1, operand2, op);
        }
        catch (UnrecognizedCodeException e) {
            throw new CFAGenerationRuntimeException(e);
        }
    }

    private static boolean isPointerToVoid(IASTExpression e) {
        return e.getExpressionType() instanceof IPointerType && ((IPointerType)e.getExpressionType()).getType() instanceof IBasicType && ((IBasicType)((IPointerType)e.getExpressionType()).getType()).getKind() == IBasicType.Kind.eVoid;
    }

    private static boolean isRightHandSide(IASTExpression e) {
        return e.getParent() instanceof IASTBinaryExpression && ((IASTBinaryExpression)e.getParent()).getOperator() == 17 && ((IASTBinaryExpression)e.getParent()).getOperand2() == e;
    }

    private CAstNode convert(IASTCastExpression e) {
        FileLocation loc = this.getLocation((IASTNode)e);
        CType castType = this.convert(e.getTypeId());
        if (castType.equals(CVoidType.VOID)) {
            return this.convertExpressionWithSideEffects(e.getOperand());
        }
        if (e.getOperand() instanceof CASTFunctionCallExpression && castType.getCanonicalType() instanceof CPointerType && ASTConverter.isRightHandSide((IASTExpression)e) && ASTConverter.isPointerToVoid(e.getOperand())) {
            return this.convertExpressionWithSideEffects(e.getOperand());
        }
        CExpression operand = this.convertExpressionWithoutSideEffects(e.getOperand());
        if ("__imag__".equals(e.getTypeId().getRawSignature())) {
            return new CComplexCastExpression(loc, castType, operand, castType, false);
        }
        if ("__real__".equals(e.getTypeId().getRawSignature())) {
            return new CComplexCastExpression(loc, castType, operand, castType, true);
        }
        if (e.getOperand() instanceof IASTFieldReference && ((IASTFieldReference)e.getOperand()).isPointerDereference()) {
            return this.createInitializedTemporaryVariable(loc, castType, new CCastExpression(loc, castType, operand));
        }
        return new CCastExpression(loc, castType, operand);
    }

    private static boolean containsProblemType(CType type) {
        return type.accept(containsProblemTypeVisitor);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CFieldReference convert(IASTFieldReference e) {
        CFieldReference fullFieldReference;
        CExpression owner = this.convertExpressionWithoutSideEffects(e.getFieldOwner());
        String fieldName = ASTConverter.convert(e.getFieldName());
        FileLocation loc = this.getLocation((IASTNode)e);
        CType ownerType = owner.getExpressionType().getCanonicalType();
        if (e.isPointerDereference()) {
            if (ownerType instanceof CPointerType) {
                ownerType = ((CPointerType)ownerType).getType();
            } else if (!(ownerType instanceof CProblemType)) {
                throw this.parseContext.parseError("Pointer dereference of non-pointer type " + ownerType, (IASTNode)e);
            }
        }
        Object wayToInnerField = ImmutableList.of();
        if (ownerType instanceof CElaboratedType) {
            if ($assertionsDisabled || ((CElaboratedType)ownerType).getRealType() == null) throw this.parseContext.parseError("Cannot access the field " + fieldName + " in type " + ownerType + " which does not have a definition", (IASTNode)e);
            throw new AssertionError();
        }
        if (ownerType instanceof CProblemType) {
            fullFieldReference = new CFieldReference(loc, this.typeConverter.convert(e.getExpressionType()), fieldName, owner, e.isPointerDereference());
        } else {
            void var8_9;
            if (!(ownerType instanceof CCompositeType)) throw this.parseContext.parseError("Cannot access field " + fieldName + " in type " + ownerType + " which is not a composite type", (IASTNode)e);
            wayToInnerField = ASTConverter.getWayToInnerField((CCompositeType)ownerType, fieldName, loc, new ArrayList<Pair<String, CType>>());
            if (wayToInnerField.isEmpty()) throw this.parseContext.parseError("Accessing unknown field " + fieldName + " in type " + ownerType, (IASTNode)e);
            CExpression cExpression = owner;
            boolean isPointerDereference = e.isPointerDereference();
            Iterator iterator = wayToInnerField.iterator();
            while (iterator.hasNext()) {
                Pair field = (Pair)iterator.next();
                CFieldReference cFieldReference = new CFieldReference(loc, (CType)field.getSecond(), (String)field.getFirst(), (CExpression)var8_9, isPointerDereference);
                isPointerDereference = false;
            }
            fullFieldReference = (CFieldReference)var8_9;
        }
        if (this.options.simplifyPointerExpressions() && (wayToInnerField.size() > 1 || owner instanceof CFieldReference) && !this.scope.isGlobalScope()) {
            void var8_12;
            CFieldReference cFieldReference = fullFieldReference;
            ArrayDeque<Pair<CType, String>> fields = new ArrayDeque<Pair<CType, String>>();
            while (var8_12 != owner) {
                fields.push(Pair.of(var8_12.getExpressionType(), ((CFieldReference)var8_12).getFieldName()));
                CExpression cExpression = ((CFieldReference)var8_12).getFieldOwner();
            }
            boolean isFirstVisit = true;
            while (!fields.isEmpty()) {
                CFieldReference tmpOwner;
                CPointerExpression exp;
                Pair actField = (Pair)fields.pop();
                if (fields.isEmpty()) {
                    if (isFirstVisit && e.isPointerDereference()) {
                        exp = new CPointerExpression(loc, owner.getExpressionType(), owner);
                        tmpOwner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), exp, false);
                        owner = this.createInitializedTemporaryVariable(loc, tmpOwner.getExpressionType(), tmpOwner);
                        continue;
                    }
                    owner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), owner, false);
                    continue;
                }
                if (isFirstVisit) {
                    if (e.isPointerDereference()) {
                        exp = new CPointerExpression(loc, owner.getExpressionType(), owner);
                        tmpOwner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), exp, false);
                        owner = this.createInitializedTemporaryVariable(loc, tmpOwner.getExpressionType(), tmpOwner);
                    } else {
                        owner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), owner, false);
                    }
                    isFirstVisit = false;
                    continue;
                }
                owner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), owner, false);
            }
            return (CFieldReference)owner;
        }
        if (!this.options.simplifyPointerExpressions()) return fullFieldReference;
        return fullFieldReference.withExplicitPointerDereference();
    }

    private static List<Pair<String, CType>> getWayToInnerField(CCompositeType owner, String fieldName, FileLocation loc, List<Pair<String, CType>> allReferences) {
        for (CCompositeType.CCompositeTypeMemberDeclaration member : owner.getMembers()) {
            if (!member.getName().equals(fieldName)) continue;
            allReferences.add(Pair.of(member.getName(), member.getType()));
            return ImmutableList.copyOf(allReferences);
        }
        for (CCompositeType.CCompositeTypeMemberDeclaration member : owner.getMembers()) {
            CType memberType = member.getType().getCanonicalType();
            if (!(memberType instanceof CCompositeType) || !member.getName().contains("__anon_type_member_")) continue;
            List<Pair<String, CType>> tmp = new ArrayList<Pair<String, CType>>(allReferences);
            tmp.add(Pair.of(member.getName(), member.getType()));
            if ((tmp = ASTConverter.getWayToInnerField((CCompositeType)memberType, fieldName, loc, tmp)).isEmpty()) continue;
            return ImmutableList.copyOf(tmp);
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - void declaration
     */
    private CRightHandSide convert(IASTFunctionCallExpression e) {
        void var6_13;
        ArrayList<CExpression> params;
        CExpression functionNameExpression = this.convertExpressionWithoutSideEffects(e.getFunctionNameExpression());
        CFunctionDeclaration declaration = null;
        FileLocation loc = this.getLocation((IASTNode)e);
        if (functionNameExpression instanceof CIdExpression && FUNC_TYPES_COMPATIBLE.equals(((CIdExpression)functionNameExpression).getName())) {
            this.sideAssignmentStack.enterBlock();
            params = new ArrayList();
            IASTInitializerClause[] iASTInitializerClauseArray = e.getArguments();
            int n = iASTInitializerClauseArray.length;
            for (int i = 0; i < n; ++i) {
                IASTInitializerClause i2 = iASTInitializerClauseArray[i];
                params.add(this.convertExpressionWithoutSideEffects(this.toExpression(i2)));
            }
            this.sideAssignmentStack.getAndResetConditionalExpressions();
            this.sideAssignmentStack.getAndResetPostSideAssignments();
            this.sideAssignmentStack.getAndResetPreSideAssignments();
            this.sideAssignmentStack.leaveBlock();
            if (params.size() == 2) {
                CVoidType type2;
                CVoidType cVoidType = params.get(0) == null ? CVoidType.VOID : ((CExpression)params.get(0)).getExpressionType();
                CType cType = type2 = params.get(1) == null ? CVoidType.VOID : ((CExpression)params.get(1)).getExpressionType();
                if (this.areCompatibleTypes(cVoidType, type2)) {
                    return CIntegerLiteralExpression.ONE;
                }
                return CIntegerLiteralExpression.ZERO;
            }
        }
        params = new ArrayList<CExpression>();
        for (IASTInitializerClause i2 : e.getArguments()) {
            params.add(this.convertExpressionWithoutSideEffects(this.toExpression(i2)));
        }
        if (functionNameExpression instanceof CIdExpression) {
            if (((CIdExpression)functionNameExpression).getName().equals(FUNC_CONSTANT) && params.size() == 1 && this.scope.lookupFunction(FUNC_CONSTANT) == null) {
                if (params.get(0) instanceof CLiteralExpression) {
                    return CIntegerLiteralExpression.ONE;
                }
                return CIntegerLiteralExpression.ZERO;
            }
            if (((CIdExpression)functionNameExpression).getName().equals(FUNC_OFFSETOF) && params.size() == 1 && params.get(0) instanceof CFieldReference) {
                BigInteger byteInBit;
                CFieldReference cFieldReference = (CFieldReference)params.get(0);
                BigInteger offset = this.handleBuiltinOffsetOfFunction(cFieldReference, e);
                if (offset.remainder(byteInBit = new BigInteger("8")).equals(BigInteger.ZERO)) {
                    return new CIntegerLiteralExpression(loc, CNumericTypes.INT, offset.divide(byteInBit));
                }
                throw this.parseContext.parseError("__builtin_offset is not applicable to bitfields ", cFieldReference);
            }
            CSimpleDeclaration cSimpleDeclaration = ((CIdExpression)functionNameExpression).getDeclaration();
            if (cSimpleDeclaration instanceof CFunctionDeclaration) {
                declaration = (CFunctionDeclaration)cSimpleDeclaration;
            }
            if (declaration == null && FUNC_EXPECT.equals(((CIdExpression)functionNameExpression).getName()) && params.size() == 2) {
                return this.buildBinaryExpression((CExpression)params.get(0), (CExpression)params.get(1), CBinaryExpression.BinaryOperator.EQUALS);
            }
        }
        CType cType = functionNameExpression.getExpressionType();
        while (var6_13 instanceof CTypedefType) {
            CType cType2 = ((CTypedefType)var6_13).getRealType();
        }
        if (var6_13 instanceof CPointerType && ((CPointerType)var6_13).getType().getCanonicalType() instanceof CFunctionType) {
            functionNameExpression = new CPointerExpression(functionNameExpression.getFileLocation(), ((CPointerType)var6_13).getType(), functionNameExpression);
        }
        if (functionNameExpression instanceof CIdExpression && BuiltinOverflowFunctions.isBuiltinOverflowFunction(((CIdExpression)functionNameExpression).getName())) {
            CSimpleType returnType = CNumericTypes.BOOL;
            return new CFunctionCallExpression(loc, returnType, functionNameExpression, params, declaration);
        }
        CType returnType = this.typeConverter.convert(e.getExpressionType());
        if (ASTConverter.containsProblemType(returnType)) {
            if (declaration != null) {
                returnType = declaration.getType().getReturnType();
                this.logger.log(Level.FINE, new Object[]{loc + ":", "Replacing return type", returnType, "of function call", e.getRawSignature(), "with", returnType});
            } else {
                CType functionType = functionNameExpression.getExpressionType().getCanonicalType();
                if (functionType instanceof CFunctionType) {
                    returnType = ((CFunctionType)functionType).getReturnType();
                    this.logger.log(Level.FINE, new Object[]{loc + ":", "Replacing return type", returnType, "of function call", e.getRawSignature(), "with", returnType});
                }
            }
        }
        if (declaration == null && functionNameExpression instanceof CIdExpression && returnType instanceof CVoidType) {
            this.logger.log(Level.FINE, new Object[]{loc + ":", "Setting return type of of undeclared function", functionNameExpression, "to int."});
            returnType = CNumericTypes.INT;
        }
        return new CFunctionCallExpression(loc, returnType, functionNameExpression, params, declaration);
    }

    private BigInteger handleBuiltinOffsetOfFunction(CFieldReference exp, IASTFunctionCallExpression e) {
        ArrayList<CFieldReference> fields = new ArrayList<CFieldReference>();
        fields.add(exp);
        while (exp.getFieldOwner() instanceof CFieldReference) {
            CFieldReference tmp;
            exp = tmp = (CFieldReference)exp.getFieldOwner();
            fields.add(exp);
        }
        if (!(exp.getFieldOwner() instanceof CIdExpression)) {
            throw this.parseContext.parseError("unexpected type " + exp.getFieldOwner() + " in __builtin_offsetof argument: ", (IASTNode)e);
        }
        CType ownerType = exp.getFieldOwner().getExpressionType().getCanonicalType();
        if (!(ownerType instanceof CCompositeType)) {
            throw this.parseContext.parseError("unexpected type " + ownerType + " in __builtin_offsetof argument", (IASTNode)e);
        }
        CCompositeType structType = (CCompositeType)ownerType;
        BigInteger sumOffset = BigInteger.ZERO;
        Collections.reverse(fields);
        for (CFieldReference field : fields) {
            BigInteger offset = this.machinemodel.getFieldOffsetInBits(structType, field.getFieldName());
            sumOffset = sumOffset.add(offset);
            CFieldReference lastField = (CFieldReference)fields.get(fields.size() - 1);
            if (field.equals(lastField)) continue;
            CType fieldType = field.getExpressionType().getCanonicalType();
            if (!(fieldType instanceof CCompositeType)) {
                throw this.parseContext.parseError("unexpected type " + fieldType + " in __builtin_offsetof argument", (IASTNode)e);
            }
            structType = (CCompositeType)fieldType;
        }
        return sumOffset;
    }

    private boolean areCompatibleTypes(CType a, CType b) {
        if ((a = CTypes.withoutConst(CTypes.withoutVolatile(a.getCanonicalType()))).equals(b = CTypes.withoutConst(CTypes.withoutVolatile(b.getCanonicalType())))) {
            return true;
        }
        if (a instanceof CArrayType && b instanceof CArrayType) {
            CArrayType arrayA = (CArrayType)a;
            CArrayType arrayB = (CArrayType)b;
            if (arrayA.getType().equals(arrayB.getType()) && (arrayA.getLength() == null || arrayB.getLength() == null)) {
                return true;
            }
        }
        return false;
    }

    private CIdExpression convert(IASTIdExpression e) {
        CEnumType enumType;
        String name = ASTConverter.convert(e.getName());
        CSimpleDeclaration declaration = this.scope.lookupVariable(this.staticVariablePrefix + name);
        if (declaration == null) {
            declaration = this.scope.lookupVariable(name);
        }
        if (declaration == null) {
            declaration = this.scope.lookupFunction(this.staticVariablePrefix + name);
        }
        if (declaration == null) {
            declaration = this.scope.lookupFunction(name);
        }
        if (BuiltinOverflowFunctions.isBuiltinOverflowFunction(name)) {
            List<CType> parameterTypes = BuiltinOverflowFunctions.getParameterTypes(name);
            CFunctionType functionType = new CFunctionType(CNumericTypes.BOOL, parameterTypes, false);
            ImmutableList parameterDeclarations = Collections3.transformedImmutableListCopy(parameterTypes, paramType -> new CParameterDeclaration(FileLocation.DUMMY, (CType)paramType, "p"));
            declaration = new CFunctionDeclaration(FileLocation.DUMMY, functionType, name, (List<CParameterDeclaration>)parameterDeclarations, (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
        }
        if (declaration != null) {
            name = declaration.getName();
        }
        CType type = declaration != null ? declaration.getType() : this.typeConverter.convert(e.getExpressionType());
        if (declaration instanceof CEnumType.CEnumerator && type instanceof CElaboratedType && ((CElaboratedType)type).getKind() == CComplexType.ComplexTypeKind.ENUM && ((CElaboratedType)type).getRealType() == null && (enumType = ((CEnumType.CEnumerator)declaration).getEnum()) != null) {
            type = new CElaboratedType(type.isConst(), type.isVolatile(), CComplexType.ComplexTypeKind.ENUM, enumType.getName(), enumType.getOrigName(), enumType);
        }
        return new CIdExpression(this.getLocation((IASTNode)e), type, name, declaration);
    }

    private CAstNode convert(IASTUnaryExpression e) {
        CSimpleType innerType;
        if (e.getOperator() == 11) {
            return this.convertExpressionWithSideEffects(e.getOperand());
        }
        CExpression operand = this.convertExpressionWithoutSideEffects(e.getOperand());
        if (operand == null) {
            return operand;
        }
        FileLocation fileLoc = this.getLocation((IASTNode)e);
        CType operandType = operand.getExpressionType();
        switch (e.getOperator()) {
            case 11: {
                throw new AssertionError((Object)"handled above");
            }
            case 2: {
                return operand;
            }
            case 4: {
                CType type;
                if (operandType instanceof CPointerType) {
                    type = ((CPointerType)operandType).getType();
                } else if (operandType instanceof CArrayType) {
                    type = ((CArrayType)operandType).getType();
                } else {
                    if (!(operandType instanceof CProblemType)) {
                        this.logger.logf(Level.WARNING, "%s: Dereferencing of non-pointer type %s in expression %s", new Object[]{fileLoc, operandType, e.getRawSignature()});
                    }
                    type = this.typeConverter.convert(e.getExpressionType());
                }
                return this.simplifyUnaryPointerExpression(operand, fileLoc, type);
            }
            case 5: {
                if (this.options.simplifyPointerExpressions() && operand instanceof CPointerExpression) {
                    return ((CPointerExpression)operand).getOperand();
                }
                CType type = this.typeConverter.convert(e.getExpressionType());
                if (ASTConverter.containsProblemType(type)) {
                    type = new CPointerType(true, false, operandType);
                }
                return new CUnaryExpression(fileLoc, type, operand, CUnaryExpression.UnaryOperator.AMPER);
            }
            case 18: {
                if (!(operand instanceof CIdExpression)) {
                    throw this.parseContext.parseError("Invalid operand for address-of-label operator", (IASTNode)e);
                }
                String labelName = ((CIdExpression)operand).getName();
                return new CAddressOfLabelExpression(fileLoc, CPointerType.POINTER_TO_VOID, labelName);
            }
            case 0: 
            case 1: {
                CBinaryExpression.BinaryOperator preOp;
                switch (e.getOperator()) {
                    case 0: {
                        preOp = CBinaryExpression.BinaryOperator.PLUS;
                        break;
                    }
                    case 1: {
                        preOp = CBinaryExpression.BinaryOperator.MINUS;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                CBinaryExpression preExp = this.buildBinaryExpression(operand, CIntegerLiteralExpression.ONE, preOp);
                CLeftHandSide lhsPre = (CLeftHandSide)operand;
                return new CExpressionAssignmentStatement(fileLoc, lhsPre, preExp);
            }
            case 9: 
            case 10: {
                CBinaryExpression.BinaryOperator postOp;
                switch (e.getOperator()) {
                    case 9: {
                        postOp = CBinaryExpression.BinaryOperator.PLUS;
                        break;
                    }
                    case 10: {
                        postOp = CBinaryExpression.BinaryOperator.MINUS;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                CBinaryExpression postExp = this.buildBinaryExpression(operand, CIntegerLiteralExpression.ONE, postOp);
                CLeftHandSide lhsPost = (CLeftHandSide)operand;
                CExpressionAssignmentStatement result = new CExpressionAssignmentStatement(fileLoc, lhsPost, postExp);
                if (e.getParent() instanceof IASTForStatement && e.getPropertyInParent() == IASTForStatement.ITERATION) {
                    return result;
                }
                CIdExpression tmp = this.createInitializedTemporaryVariable(fileLoc, lhsPost.getExpressionType(), lhsPost);
                this.sideAssignmentStack.addPreSideAssignment(result);
                return tmp;
            }
            case 7: {
                try {
                    return this.binExprBuilder.negateExpressionAndSimplify(operand);
                }
                catch (UnrecognizedCodeException ex) {
                    throw new CFAGenerationRuntimeException(ex);
                }
            }
        }
        CType type = e.getOperator() == 15 || e.getOperator() == 8 ? CNumericTypes.SIZE_T : (e.getOperator() == 3 && operand.getExpressionType() instanceof CSimpleType ? (CTypes.isIntegerType(innerType = (CSimpleType)operand.getExpressionType()) ? this.machinemodel.applyIntegerPromotion(innerType) : innerType) : this.typeConverter.convert(e.getExpressionType()));
        return new CUnaryExpression(fileLoc, type, operand, this.operatorConverter.convertUnaryOperator(e));
    }

    private CExpression simplifyUnaryPointerExpression(CExpression operand, FileLocation fileLoc, CType type) {
        if (this.options.simplifyPointerExpressions()) {
            CType operandType = operand.getExpressionType();
            if (operand instanceof CFieldReference) {
                CIdExpression tmpVar = this.createInitializedTemporaryVariable(fileLoc, operandType, operand);
                return new CPointerExpression(fileLoc, type, tmpVar);
            }
            if (operand instanceof CArraySubscriptExpression) {
                CIdExpression tmpVar = this.createInitializedTemporaryVariable(fileLoc, operandType, operand);
                return new CPointerExpression(fileLoc, type, tmpVar);
            }
            if (operand instanceof CUnaryExpression && ((CUnaryExpression)operand).getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
                return ((CUnaryExpression)operand).getOperand();
            }
            if (operand instanceof CPointerExpression) {
                CIdExpression tmpVar = this.createInitializedTemporaryVariable(fileLoc, operandType, operand);
                return new CPointerExpression(fileLoc, type, tmpVar);
            }
            if (operand instanceof CBinaryExpression) {
                CIdExpression tmpVar = this.createInitializedTemporaryVariable(fileLoc, operandType, operand);
                return new CPointerExpression(fileLoc, type, tmpVar);
            }
        }
        return new CPointerExpression(fileLoc, type, operand);
    }

    private CTypeIdExpression convert(IASTTypeIdExpression e) {
        CType expressionType;
        CTypeIdExpression.TypeIdOperator typeIdOperator = this.operatorConverter.convertTypeIdOperator(e);
        CType typeId = this.convert(e.getTypeId());
        if (typeIdOperator == CTypeIdExpression.TypeIdOperator.ALIGNOF || typeIdOperator == CTypeIdExpression.TypeIdOperator.SIZEOF) {
            if (typeId.isIncomplete()) {
                throw this.parseContext.parseError("Invalid application of " + typeIdOperator.getOperator() + " to incomplete type " + typeId, (IASTNode)e);
            }
            expressionType = CNumericTypes.SIZE_T;
        } else {
            expressionType = this.typeConverter.convert(e.getExpressionType());
        }
        return new CTypeIdExpression(this.getLocation((IASTNode)e), expressionType, typeIdOperator, typeId);
    }

    private CExpression convert(IASTTypeIdInitializerExpression e) {
        FileLocation fileLoc = this.getLocation((IASTNode)e);
        CType type = this.convert(e.getTypeId());
        CInitializer initializer = this.convert(e.getInitializer(), type, null);
        return this.createInitializedTemporaryVariable(fileLoc, type, initializer);
    }

    public CAstNode convert(IASTStatement s) {
        if (s instanceof IASTExpressionStatement) {
            return this.convert((IASTExpressionStatement)s);
        }
        if (s instanceof IASTReturnStatement) {
            return this.convert((IASTReturnStatement)s);
        }
        if (s instanceof IASTProblemStatement) {
            throw this.parseContext.parseError((IASTProblemStatement)s);
        }
        throw this.parseContext.parseError("unknown statement: " + s.getClass(), (IASTNode)s);
    }

    public CStatement convert(IASTExpressionStatement s) {
        return this.convertExpressionToStatement(s.getExpression());
    }

    public CStatement convertExpressionToStatement(IASTExpression e) {
        CAstNode node = this.convertExpressionWithSideEffects(e);
        if (node instanceof CExpressionAssignmentStatement) {
            return (CExpressionAssignmentStatement)node;
        }
        if (node instanceof CFunctionCallAssignmentStatement) {
            return (CFunctionCallAssignmentStatement)node;
        }
        if (node instanceof CFunctionCallExpression) {
            return new CFunctionCallStatement(this.getLocation((IASTNode)e), (CFunctionCallExpression)node);
        }
        if (node instanceof CExpression) {
            return new CExpressionStatement(this.getLocation((IASTNode)e), (CExpression)node);
        }
        if (node == null) {
            return null;
        }
        throw new AssertionError();
    }

    public CReturnStatement convert(IASTReturnStatement s) {
        Optional<CAssignment> returnAssignment;
        FileLocation loc = this.getLocation((IASTNode)s);
        Optional<CExpression> returnExp = Optional.ofNullable(this.convertExpressionWithoutSideEffects(s.getReturnValue()));
        Optional<CVariableDeclaration> returnVariableDeclaration = ((FunctionScope)this.scope).getReturnVariable();
        if (returnVariableDeclaration.isPresent()) {
            CIdExpression lhs = new CIdExpression(loc, returnVariableDeclaration.orElseThrow());
            CExpression rhs = null;
            if (returnExp.isPresent()) {
                rhs = returnExp.orElseThrow();
            } else {
                this.logger.log(Level.WARNING, new Object[]{loc + ":", "Return statement without expression in non-void function."});
                CInitializer defaultValue = CDefaults.forType(returnVariableDeclaration.orElseThrow().getType(), loc);
                if (defaultValue instanceof CInitializerExpression) {
                    rhs = ((CInitializerExpression)defaultValue).getExpression();
                }
            }
            returnAssignment = rhs != null ? Optional.of(new CExpressionAssignmentStatement(loc, lhs, rhs)) : Optional.empty();
        } else {
            if (returnExp.isPresent()) {
                this.logger.log(Level.WARNING, new Object[]{loc + ":", "Return statement with expression", returnExp.orElseThrow(), "in void function."});
            }
            returnAssignment = Optional.empty();
        }
        return new CReturnStatement(loc, returnExp, returnAssignment);
    }

    public CFunctionDeclaration convert(IASTFunctionDefinition f) {
        Pair<CStorageClass, ? extends CType> specifier = this.convert(f.getDeclSpecifier());
        CStorageClass cStorageClass = specifier.getFirst();
        if (cStorageClass != CStorageClass.AUTO && cStorageClass != CStorageClass.STATIC && cStorageClass != CStorageClass.EXTERN) {
            throw this.parseContext.parseError("Unsupported storage class for function definition", (IASTNode)f);
        }
        Triple<CType, IASTInitializer, String> declarator = this.convert(f.getDeclarator(), specifier.getSecond(), cStorageClass == CStorageClass.STATIC);
        if (!(declarator.getFirst() instanceof CFunctionTypeWithNames)) {
            throw this.parseContext.parseError("Unsupported nested declarator for function definition", (IASTNode)f);
        }
        if (declarator.getSecond() != null) {
            throw this.parseContext.parseError("Unsupported initializer for function definition", (IASTNode)f);
        }
        if (declarator.getThird() == null) {
            throw this.parseContext.parseError("Missing name for function definition", (IASTNode)f);
        }
        CFunctionTypeWithNames declSpec = (CFunctionTypeWithNames)declarator.getFirst();
        return new CFunctionDeclaration(this.getLocation((IASTNode)f), declSpec, declSpec.getName(), declarator.getThird(), declSpec.getParameterDeclarations(), this.getAttributes(f.getDeclarator()));
    }

    public List<CDeclaration> convert(IASTSimpleDeclaration d) {
        FileLocation fileLoc = this.getLocation((IASTNode)d);
        Pair<CStorageClass, ? extends CType> specifier = this.convert(d.getDeclSpecifier());
        CStorageClass cStorageClass = specifier.getFirst();
        CType type = specifier.getSecond();
        IASTDeclarator[] declarators = d.getDeclarators();
        ArrayList<CDeclaration> result = new ArrayList<CDeclaration>();
        if (type instanceof CCompositeType || type instanceof CEnumType) {
            CComplexType complexType = (CComplexType)type;
            if (declarators.length > 0 && type instanceof CCompositeType) {
                this.addSideEffectDeclarationForType((CCompositeType)complexType, fileLoc);
                complexType = this.scope.lookupType(complexType.getQualifiedName());
            } else {
                result.add(new CComplexTypeDeclaration(fileLoc, this.scope.isGlobalScope(), complexType));
            }
            type = new CElaboratedType(type.isConst(), type.isVolatile(), complexType.getKind(), complexType.getName(), complexType.getOrigName(), complexType);
        } else if (type instanceof CElaboratedType) {
            boolean variableDeclaration;
            boolean typeAlreadyKnown = this.scope.lookupType(((CElaboratedType)type).getQualifiedName()) != null;
            boolean bl = variableDeclaration = declarators != null && declarators.length > 0;
            if (!typeAlreadyKnown || !variableDeclaration) {
                CComplexTypeDeclaration newD = new CComplexTypeDeclaration(fileLoc, this.scope.isGlobalScope(), (CElaboratedType)type);
                result.add(newD);
            }
        }
        if (declarators != null) {
            for (IASTDeclarator c : declarators) {
                FileLocation declaratorLocation = this.getLocation((IASTNode)c);
                if (!declaratorLocation.isRealLocation()) {
                    declaratorLocation = fileLoc;
                } else if (c == declarators[0]) {
                    declaratorLocation = new FileLocation(fileLoc.getFileName(), fileLoc.getNiceFileName(), fileLoc.getNodeOffset(), declaratorLocation.getNodeOffset() - fileLoc.getNodeOffset() + declaratorLocation.getNodeLength(), fileLoc.getStartingLineNumber(), declaratorLocation.getEndingLineNumber(), fileLoc.getStartingLineInOrigin(), fileLoc.getEndingLineInOrigin(), fileLoc.isOffsetRelatedToOrigin());
                }
                result.add(this.createDeclaration(declaratorLocation, cStorageClass, type, c));
            }
        }
        return result;
    }

    private CDeclaration createDeclaration(FileLocation fileLoc, CStorageClass cStorageClass, CType type, IASTDeclarator d) {
        boolean isGlobal = this.scope.isGlobalScope();
        if (d != null) {
            Triple<CType, IASTInitializer, String> declarator = this.convert(d, type);
            type = declarator.getFirst();
            IASTInitializer initializer = declarator.getSecond();
            Object name = declarator.getThird();
            if (name == null) {
                throw this.parseContext.parseError("Declaration without name", (IASTNode)d);
            }
            if (cStorageClass == CStorageClass.TYPEDEF) {
                if (initializer != null) {
                    throw this.parseContext.parseError("Typedef with initializer", (IASTNode)d);
                }
                name = this.scope.getFileSpecificTypeName((String)name);
                return new CTypeDefDeclaration(fileLoc, isGlobal, type, (String)name, this.scope.createScopedNameOf((String)name));
            }
            CType innerType = type;
            while (innerType instanceof CTypedefType) {
                innerType = ((CTypedefType)innerType).getRealType();
            }
            if (innerType instanceof CFunctionType) {
                List<CParameterDeclaration> params;
                if (initializer != null) {
                    throw this.parseContext.parseError("Function definition with initializer", (IASTNode)d);
                }
                CFunctionType functionType = (CFunctionType)innerType;
                if (functionType instanceof CFunctionTypeWithNames) {
                    params = ((CFunctionTypeWithNames)functionType).getParameterDeclarations();
                } else {
                    params = new ArrayList<CParameterDeclaration>(functionType.getParameters().size());
                    int i = 0;
                    for (CType paramType : functionType.getParameters()) {
                        params.add(new CParameterDeclaration(fileLoc, paramType, "__param" + i++));
                    }
                }
                ImmutableSet<CFunctionDeclaration.FunctionAttribute> attributes = d instanceof IASTFunctionDeclarator ? this.getAttributes((IASTFunctionDeclarator)d) : ImmutableSet.of();
                return new CFunctionDeclaration(fileLoc, functionType, (String)name, params, attributes);
            }
            if (cStorageClass == CStorageClass.EXTERN && initializer != null) {
                throw this.parseContext.parseError("Extern declarations cannot have initializers", (IASTNode)d);
            }
            if (cStorageClass != CStorageClass.EXTERN && innerType instanceof CVoidType) {
                throw this.parseContext.parseError("Variable cannot have type void", (IASTNode)d);
            }
            String origName = name;
            if (cStorageClass == CStorageClass.STATIC) {
                if (!isGlobal) {
                    isGlobal = true;
                    name = "static__" + ((FunctionScope)this.scope).getCurrentFunctionName() + "__" + (String)name;
                } else {
                    name = this.staticVariablePrefix + (String)name;
                }
                cStorageClass = CStorageClass.AUTO;
            }
            if (!isGlobal && cStorageClass == CStorageClass.EXTERN) {
                throw this.parseContext.parseError("Local variable declared extern is unsupported", (IASTNode)d);
            }
            if (!isGlobal && this.scope.variableNameInUse((String)name)) {
                String sep = "__";
                int index = 1;
                while (this.scope.variableNameInUse((String)name + sep + index)) {
                    ++index;
                }
                name = (String)name + sep + index;
            }
            Object scopedName = isGlobal ? name : this.scope.createScopedNameOf((String)name);
            CVariableDeclaration declaration = new CVariableDeclaration(fileLoc, isGlobal, cStorageClass, type, (String)name, origName, (String)scopedName, null);
            this.scope.registerDeclaration(declaration);
            declaration.addInitializer(this.convert(initializer, declaration.getType(), declaration));
            return declaration;
        }
        throw new CFAGenerationRuntimeException("Declaration without declarator, but type is unknown: " + type.toASTString(""));
    }

    private List<CCompositeType.CCompositeTypeMemberDeclaration> convertDeclarationInCompositeType(IASTDeclaration d, int nofMember) {
        List<CCompositeType.CCompositeTypeMemberDeclaration> result;
        IASTDeclarator[] declarators;
        if (d.getParent() instanceof CASTCompositeTypeSpecifier) {
            // empty if block
        }
        if (d instanceof IASTProblemDeclaration) {
            throw this.parseContext.parseError((IASTProblemDeclaration)d);
        }
        if (!(d instanceof IASTSimpleDeclaration)) {
            throw this.parseContext.parseError("unknown declaration type " + d.getClass().getSimpleName(), (IASTNode)d);
        }
        IASTSimpleDeclaration sd = (IASTSimpleDeclaration)d;
        Pair<CStorageClass, ? extends CType> specifier = this.convert(sd.getDeclSpecifier());
        if (specifier.getFirst() != CStorageClass.AUTO) {
            throw this.parseContext.parseError("Unsupported storage class inside composite type", (IASTNode)d);
        }
        CType type = specifier.getSecond();
        if (type instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)type;
            this.addSideEffectDeclarationForType(compositeType, this.getLocation((IASTNode)d));
            type = new CElaboratedType(compositeType.isConst(), compositeType.isVolatile(), compositeType.getKind(), compositeType.getName(), compositeType.getOrigName(), compositeType);
        }
        if ((declarators = sd.getDeclarators()) == null || declarators.length == 0) {
            CCompositeType.CCompositeTypeMemberDeclaration newD = this.createDeclarationForCompositeType(type, null, nofMember);
            result = Collections.singletonList(newD);
        } else if (declarators.length == 1) {
            CCompositeType.CCompositeTypeMemberDeclaration newD = this.createDeclarationForCompositeType(type, declarators[0], nofMember);
            result = Collections.singletonList(newD);
        } else {
            result = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(declarators.length);
            for (IASTDeclarator c : declarators) {
                result.add(this.createDeclarationForCompositeType(type, c, nofMember));
            }
        }
        return result;
    }

    private CCompositeType.CCompositeTypeMemberDeclaration createDeclarationForCompositeType(CType type, IASTDeclarator d, int nofMember) {
        Object name = null;
        if (d != null) {
            Triple<CType, IASTInitializer, String> declarator = this.convert(d, type);
            if (declarator.getSecond() != null) {
                throw this.parseContext.parseError("Unsupported initializer inside composite type", (IASTNode)d);
            }
            type = declarator.getFirst();
            name = declarator.getThird();
        }
        if (Strings.isNullOrEmpty(name)) {
            name = "__anon_type_member_" + nofMember;
        }
        return new CCompositeType.CCompositeTypeMemberDeclaration(type, (String)name);
    }

    private Triple<CType, IASTInitializer, String> convert(IASTDeclarator d, CType specifier) {
        CArrayType arrayType;
        while (d != null && d.getClass() == CASTDeclarator.class && d.getPointerOperators().length == 0 && d.getAttributes().length == 0 && d.getAttributeSpecifiers().length == 0 && d.getInitializer() == null && d.getNestedDeclarator() != null) {
            d = d.getNestedDeclarator();
        }
        if (d instanceof IASTFunctionDeclarator) {
            return this.convert((IASTFunctionDeclarator)d, specifier, false);
        }
        if (d != null) {
            specifier = this.handleDeclaratorAttributes(d, specifier);
        }
        ArrayList<Object> modifiers = new ArrayList<Object>(1);
        IASTInitializer initializer = null;
        String name = null;
        Integer bitFieldSize = null;
        for (IASTDeclarator currentDecl = d; currentDecl != null; currentDecl = currentDecl.getNestedDeclarator()) {
            if (currentDecl instanceof IASTFieldDeclarator) {
                if (bitFieldSize != null) {
                    throw this.parseContext.parseError("Unsupported declaration with two bitfield descriptions", (IASTNode)d);
                }
                IASTExpression bitField = ((IASTFieldDeclarator)currentDecl).getBitFieldSize();
                if (bitField instanceof CASTLiteralExpression) {
                    CExpression cExpression = this.convertExpressionWithoutSideEffects(bitField);
                    if (cExpression instanceof CIntegerLiteralExpression) {
                        bitFieldSize = ((CIntegerLiteralExpression)cExpression).getValue().intValue();
                    } else {
                        throw this.parseContext.parseError("Unsupported bitfield specifier", (IASTNode)d);
                    }
                }
            }
            if (currentDecl instanceof IASTFunctionDeclarator) {
                throw this.parseContext.parseError("Unsupported declaration nested function declarations", (IASTNode)d);
            }
            modifiers.addAll(Arrays.asList(currentDecl.getPointerOperators()));
            if (currentDecl instanceof IASTArrayDeclarator) {
                modifiers.addAll(Arrays.asList(((IASTArrayDeclarator)currentDecl).getArrayModifiers()));
            }
            if (currentDecl.getInitializer() != null) {
                if (initializer != null) {
                    throw this.parseContext.parseError("Unsupported declaration with two initializers", (IASTNode)d);
                }
                initializer = currentDecl.getInitializer();
            }
            if (currentDecl.getName().toString().isEmpty()) continue;
            if (name != null) {
                throw this.parseContext.parseError("Unsupported declaration with two names", (IASTNode)d);
            }
            name = ASTConverter.convert(currentDecl.getName());
        }
        name = Strings.nullToEmpty(name);
        CType type = specifier;
        ArrayList<IASTArrayModifier> tmpArrMod = new ArrayList<IASTArrayModifier>();
        for (IASTNode iASTNode : modifiers) {
            if (iASTNode instanceof IASTArrayModifier) {
                tmpArrMod.add((IASTArrayModifier)iASTNode);
                continue;
            }
            if (iASTNode instanceof IASTPointerOperator) {
                for (int i = tmpArrMod.size() - 1; i >= 0; --i) {
                    type = this.convert((IASTArrayModifier)tmpArrMod.get(i), type);
                }
                tmpArrMod.clear();
                type = this.typeConverter.convert((IASTPointerOperator)iASTNode, type);
                continue;
            }
            throw new AssertionError();
        }
        for (int i = tmpArrMod.size() - 1; i >= 0; --i) {
            type = this.convert((IASTArrayModifier)tmpArrMod.get(i), type);
        }
        if (type instanceof CArrayType && (arrayType = (CArrayType)type).getLength() == null && initializer instanceof IASTEqualsInitializer) {
            IASTInitializerClause iASTInitializerClause = ((IASTEqualsInitializer)initializer).getInitializerClause();
            if (iASTInitializerClause instanceof IASTInitializerList) {
                @Nullable BigInteger length = BigInteger.ZERO;
                BigInteger position = BigInteger.ZERO;
                block5: for (IASTInitializerClause x : ((IASTInitializerList)iASTInitializerClause).getClauses()) {
                    if (length == null) break;
                    if (x instanceof ICASTDesignatedInitializer) {
                        for (ICASTDesignator designator : ((ICASTDesignatedInitializer)x).getDesignators()) {
                            if (designator instanceof CASTArrayRangeDesignator) {
                                BigInteger c = this.evaluateIntegerConstantExpression(((CASTArrayRangeDesignator)designator).getRangeCeiling());
                                position = c.add(BigInteger.ONE);
                                length = (BigInteger)Comparators.max((Comparable)length, (Comparable)position);
                                continue;
                            }
                            if (designator instanceof CASTArrayDesignator) {
                                BigInteger s = this.evaluateIntegerConstantExpression(((CASTArrayDesignator)designator).getSubscriptExpression());
                                position = s.add(BigInteger.ONE);
                                length = (BigInteger)Comparators.max((Comparable)length, (Comparable)position);
                                continue;
                            }
                            length = null;
                            continue block5;
                        }
                        continue;
                    }
                    position = position.add(BigInteger.ONE);
                    length = (BigInteger)Comparators.max((Comparable)position, (Comparable)length);
                }
                if (length != null) {
                    CIntegerLiteralExpression lengthExp = new CIntegerLiteralExpression(this.getLocation((IASTNode)initializer), CNumericTypes.INT, length);
                    type = new CArrayType(arrayType.isConst(), arrayType.isVolatile(), arrayType.getType(), lengthExp);
                }
            } else if (iASTInitializerClause instanceof CASTLiteralExpression && (arrayType.getType().equals(CNumericTypes.CHAR) || arrayType.getType().equals(CNumericTypes.SIGNED_CHAR) || arrayType.getType().equals(CNumericTypes.UNSIGNED_CHAR))) {
                CASTLiteralExpression literalExpression = (CASTLiteralExpression)iASTInitializerClause;
                int length = literalExpression.getLength() - 1;
                CIntegerLiteralExpression lengthExp = new CIntegerLiteralExpression(this.getLocation((IASTNode)initializer), CNumericTypes.INT, BigInteger.valueOf(length));
                type = new CArrayType(arrayType.isConst(), arrayType.isVolatile(), arrayType.getType(), lengthExp);
            }
        }
        if (bitFieldSize != null) {
            type = this.typeConverter.convertBitFieldType(bitFieldSize, type);
        }
        return Triple.of(type, initializer, name);
    }

    private CType handleDeclaratorAttributes(IASTDeclarator d, CType type) {
        for (IASTAttribute attribute : d.getAttributes()) {
            String name = ASTConverter.getAttributeString(attribute.getName());
            if (!name.equals("mode")) continue;
            if (!((type = type.getCanonicalType()) instanceof CSimpleType)) {
                throw this.parseContext.parseError("Mode attribute unsupported for type " + type, (IASTNode)d);
            }
            String mode = ASTConverter.getAttributeString(attribute.getArgumentClause().getTokenCharImage());
            type = this.handleModeAttribute((CSimpleType)type, mode, (IASTNode)d);
        }
        return type;
    }

    private static String getAttributeString(char[] chars) {
        String s = String.valueOf(chars);
        if (s.startsWith("__") && s.endsWith("__")) {
            return s.substring(2, s.length() - 2);
        }
        return s;
    }

    private ImmutableSet<CFunctionDeclaration.FunctionAttribute> getAttributes(IASTFunctionDeclarator d) {
        EnumSet<CFunctionDeclaration.FunctionAttribute> attributes = EnumSet.noneOf(CFunctionDeclaration.FunctionAttribute.class);
        for (IASTAttribute attribute : d.getAttributes()) {
            String name = ASTConverter.getAttributeString(attribute.getName());
            if (!KNOWN_FUNCTION_ATTRIBUTES.containsKey((Object)name)) {
                throw new CFAGenerationRuntimeException("Unrecognized attribute in declaration of " + d.getName() + ": " + name);
            }
            ((Optional)KNOWN_FUNCTION_ATTRIBUTES.get((Object)name)).ifPresent(attributes::add);
        }
        String functionName = ASTConverter.convert(d.getName());
        if (this.options.isNonReturningFunction(functionName)) {
            attributes.add(CFunctionDeclaration.FunctionAttribute.NO_RETURN);
        }
        return Sets.immutableEnumSet(attributes);
    }

    private CSimpleType handleModeAttribute(CSimpleType type, String mode, IASTNode context) {
        CSimpleType newType;
        if (type.getType() != CBasicType.INT || type.isComplex() || type.isImaginary()) {
            throw this.parseContext.parseError("Mode attribute unsupported for type " + type, context);
        }
        switch (mode) {
            case "word": {
                newType = this.machinemodel.getPointerEquivalentSimpleType();
                break;
            }
            case "byte": 
            case "QI": {
                newType = CNumericTypes.CHAR;
                break;
            }
            case "HI": {
                assert (this.machinemodel.getSizeofShort() == 2);
                newType = CNumericTypes.SHORT_INT;
                break;
            }
            case "SI": {
                assert (this.machinemodel.getSizeofInt() == 4);
                newType = CNumericTypes.INT;
                break;
            }
            case "DI": {
                if (this.machinemodel.getSizeofLongInt() == 8) {
                    newType = CNumericTypes.LONG_INT;
                    break;
                }
                if (this.machinemodel.getSizeofLongLongInt() == 8) {
                    newType = CNumericTypes.LONG_LONG_INT;
                    break;
                }
                throw new AssertionError((Object)"unexpected machine model");
            }
            default: {
                throw this.parseContext.parseError("Unsupported mode " + mode, context);
            }
        }
        return new CSimpleType(type.isConst(), type.isVolatile(), newType.getType(), newType.isLong(), newType.isShort(), type.isSigned(), type.isUnsigned(), false, false, newType.isLongLong());
    }

    private CType convert(IASTArrayModifier am, CType type) {
        if (am instanceof ICASTArrayModifier) {
            ICASTArrayModifier a = (ICASTArrayModifier)am;
            CExpression lengthExp = this.convertExpressionWithoutSideEffects(a.getConstantExpression());
            if (lengthExp != null) {
                lengthExp = this.simplifyExpressionRecursively(lengthExp);
            }
            return new CArrayType(a.isConst(), a.isVolatile(), type, lengthExp);
        }
        throw this.parseContext.parseError("Unknown array modifier", (IASTNode)am);
    }

    private Triple<CType, IASTInitializer, String> convert(IASTFunctionDeclarator d, CType returnType, boolean isStaticFunction) {
        String origname;
        CFunctionTypeWithNames fType;
        CSimpleType t;
        if (!(d instanceof IASTStandardFunctionDeclarator)) {
            throw this.parseContext.parseError("Unknown non-standard function definition", (IASTNode)d);
        }
        IASTStandardFunctionDeclarator sd = (IASTStandardFunctionDeclarator)d;
        returnType = this.typeConverter.convertPointerOperators(d.getPointerOperators(), returnType);
        if (returnType instanceof CSimpleType && (t = (CSimpleType)returnType).getType() == CBasicType.UNSPECIFIED) {
            returnType = new CSimpleType(t.isConst(), t.isVolatile(), CBasicType.INT, t.isLong(), t.isShort(), t.isSigned(), t.isUnsigned(), t.isComplex(), t.isImaginary(), t.isLongLong());
        }
        List<CParameterDeclaration> paramsList = this.convert(sd.getParameters());
        CType type = fType = new CFunctionTypeWithNames(returnType, paramsList, sd.takesVarArgs());
        if (d.getNestedDeclarator() != null) {
            Triple<CType, IASTInitializer, String> nestedDeclarator = this.convert(d.getNestedDeclarator(), type);
            assert (d.getName().getRawSignature().isEmpty()) : d;
            assert (nestedDeclarator.getSecond() == null);
            type = nestedDeclarator.getFirst();
            origname = nestedDeclarator.getThird();
        } else {
            origname = ASTConverter.convert(d.getName());
        }
        Object qualifiedName = origname;
        if (isStaticFunction) {
            qualifiedName = this.staticVariablePrefix + origname;
        }
        fType.setName((String)qualifiedName);
        for (CParameterDeclaration param : paramsList) {
            param.setQualifiedName(FunctionScope.createQualifiedName((String)qualifiedName, param.getName()));
        }
        return Triple.of(type, d.getInitializer(), origname);
    }

    private Pair<CStorageClass, ? extends CType> convert(IASTDeclSpecifier d) {
        CStorageClass sc = this.typeConverter.convertCStorageClass(d);
        if (d instanceof IASTCompositeTypeSpecifier) {
            return Pair.of(sc, this.convert((IASTCompositeTypeSpecifier)d));
        }
        if (d instanceof IASTElaboratedTypeSpecifier) {
            return Pair.of(sc, this.typeConverter.convert((IASTElaboratedTypeSpecifier)d));
        }
        if (d instanceof IASTEnumerationSpecifier) {
            return Pair.of(sc, this.convert((IASTEnumerationSpecifier)d));
        }
        if (d instanceof IASTNamedTypeSpecifier) {
            return Pair.of(sc, this.typeConverter.convert((IASTNamedTypeSpecifier)d));
        }
        if (d instanceof IASTSimpleDeclSpecifier) {
            return Pair.of(sc, this.typeConverter.convert((IASTSimpleDeclSpecifier)d));
        }
        throw this.parseContext.parseError("unknown declSpecifier", (IASTNode)d);
    }

    private CCompositeType convert(IASTCompositeTypeSpecifier d) {
        CComplexType.ComplexTypeKind kind;
        ArrayList<CCompositeType.CCompositeTypeMemberDeclaration> list = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(d.getMembers().length);
        int nofMember = 0;
        for (IASTDeclaration c : d.getMembers()) {
            List<CCompositeType.CCompositeTypeMemberDeclaration> newCs = this.convertDeclarationInCompositeType(c, nofMember);
            ++nofMember;
            assert (!newCs.isEmpty());
            list.addAll(newCs);
        }
        switch (d.getKey()) {
            case 1: {
                kind = CComplexType.ComplexTypeKind.STRUCT;
                break;
            }
            case 2: {
                kind = CComplexType.ComplexTypeKind.UNION;
                break;
            }
            default: {
                throw this.parseContext.parseError("Unknown key " + d.getKey() + " for composite type", (IASTNode)d);
            }
        }
        Object name = ASTConverter.convert(d.getName());
        String origName = name;
        if (((String)name).isEmpty()) {
            name = "__anon_type_";
            name = d.getStorageClass() == 1 ? (String)name + ((IASTSimpleDeclaration)d.getParent()).getDeclarators()[0].getName().getRawSignature() : (String)name + anonTypeCounter++;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            CCompositeType.CCompositeTypeMemberDeclaration member = (CCompositeType.CCompositeTypeMemberDeclaration)it.next();
            if (!member.getType().isIncomplete()) continue;
            if (kind != CComplexType.ComplexTypeKind.STRUCT) {
                this.parseContext.parseError("Member " + member + " has incomplete type in union " + (String)name, (IASTNode)d);
            }
            if (it.hasNext()) {
                this.parseContext.parseError("Member " + member + " in non-last position of struct " + (String)name + " has incomplete type", (IASTNode)d);
            }
            if (member.getType().getCanonicalType() instanceof CArrayType) continue;
            this.parseContext.parseError("Member " + member + " of struct " + (String)name + " has incomplete non-array type", (IASTNode)d);
        }
        CCompositeType compositeType = new CCompositeType(d.isConst(), d.isVolatile(), kind, list, (String)name, origName);
        compositeType.accept(new FillInBindingVisitor(kind, this.scope.getFileSpecificTypeName((String)name), compositeType));
        return compositeType;
    }

    private CEnumType convert(IASTEnumerationSpecifier d) {
        ArrayList<CEnumType.CEnumerator> list = new ArrayList<CEnumType.CEnumerator>(d.getEnumerators().length);
        Long lastValue = -1L;
        for (IASTEnumerationSpecifier.IASTEnumerator c : d.getEnumerators()) {
            CEnumType.CEnumerator newC = this.convert(c, lastValue);
            list.add(newC);
            lastValue = newC.hasValue() ? Long.valueOf(newC.getValue()) : null;
        }
        Object name = ASTConverter.convert(d.getName());
        String origName = name;
        if (((String)name).isEmpty()) {
            name = "__anon_type_" + anonTypeCounter++;
        }
        CEnumType enumType = new CEnumType(d.isConst(), d.isVolatile(), list, (String)name, origName);
        CSimpleType integerType = this.getEnumerationType(enumType);
        for (CEnumType.CEnumerator enumValue : enumType.getEnumerators()) {
            enumValue.setEnum(enumType);
            enumValue.setType(integerType);
        }
        return enumType;
    }

    private CSimpleType getEnumerationType(CEnumType enumType) {
        LongSummaryStatistics enumStatistics = enumType.getEnumerators().stream().filter(CEnumType.CEnumerator::hasValue).mapToLong(CEnumType.CEnumerator::getValue).summaryStatistics();
        Preconditions.checkState((enumStatistics.getCount() > 0L ? 1 : 0) != 0, (String)"enumeration does not provide any values: %s", (Object)enumType);
        BigInteger minValue = BigInteger.valueOf(enumStatistics.getMin());
        BigInteger maxValue = BigInteger.valueOf(enumStatistics.getMax());
        for (CSimpleType integerType : ENUM_REPRESENTATION_CANDIDATE_TYPES) {
            if (minValue.compareTo(this.machinemodel.getMinimalIntegerValue(integerType)) < 0 || maxValue.compareTo(this.machinemodel.getMaximalIntegerValue(integerType)) > 0) continue;
            return integerType;
        }
        return CNumericTypes.UNSIGNED_LONG_LONG_INT;
    }

    private CEnumType.CEnumerator convert(IASTEnumerationSpecifier.IASTEnumerator e, Long lastValue) {
        Long value = null;
        value = e.getValue() == null && lastValue != null ? Long.valueOf(lastValue + 1L) : Long.valueOf(this.evaluateIntegerConstantExpression(e.getValue()).longValueExact());
        String name = ASTConverter.convert(e.getName());
        CEnumType.CEnumerator result = new CEnumType.CEnumerator(this.getLocation((IASTNode)e), name, this.scope.createScopedNameOf(name), CNumericTypes.SIGNED_INT, value);
        this.scope.registerDeclaration(result);
        return result;
    }

    private IASTExpression toExpression(IASTInitializerClause i) {
        if (i instanceof IASTExpression) {
            return (IASTExpression)i;
        }
        throw this.parseContext.parseError("Initializer clause in unexpected location", (IASTNode)i);
    }

    private CInitializer convert(IASTInitializerClause i, CType type, @Nullable CVariableDeclaration declaration) {
        if (i instanceof IASTExpression) {
            CExpression exp = this.convertExpressionWithoutSideEffects((IASTExpression)i);
            return new CInitializerExpression(exp.getFileLocation(), exp);
        }
        if (i instanceof IASTInitializerList) {
            return this.convert((IASTInitializerList)i, type, declaration);
        }
        if (i instanceof ICASTDesignatedInitializer) {
            return this.convert((ICASTDesignatedInitializer)i, type, declaration);
        }
        throw this.parseContext.parseError("unknown initializer claus: " + i.getClass().getSimpleName(), (IASTNode)i);
    }

    private CInitializer convert(IASTInitializer i, CType type, @Nullable CVariableDeclaration declaration) {
        if (i == null) {
            return null;
        }
        if (i instanceof IASTInitializerList) {
            return this.convert((IASTInitializerList)i, type, declaration);
        }
        if (i instanceof IASTEqualsInitializer) {
            return this.convert((IASTEqualsInitializer)i, type, declaration);
        }
        if (i instanceof ICASTDesignatedInitializer) {
            return this.convert((ICASTDesignatedInitializer)i, type, declaration);
        }
        throw this.parseContext.parseError("unknown initializer: " + i.getClass().getSimpleName(), (IASTNode)i);
    }

    private CInitializer convert(ICASTDesignatedInitializer init, CType type, @Nullable CVariableDeclaration declaration) {
        ICASTDesignator[] desInit = init.getDesignators();
        CInitializer cInit = this.convert(init.getOperand(), type, declaration);
        FileLocation fileLoc = cInit.getFileLocation();
        ArrayList<CDesignator> designators = new ArrayList<CDesignator>(desInit.length);
        for (ICASTDesignator designator : desInit) {
            CDesignator r;
            if (designator instanceof ICASTFieldDesignator) {
                r = new CFieldDesignator(fileLoc, ASTConverter.convert(((ICASTFieldDesignator)designator).getName()));
            } else if (designator instanceof ICASTArrayDesignator) {
                r = new CArrayDesignator(fileLoc, this.convertExpressionWithoutSideEffects(((ICASTArrayDesignator)designator).getSubscriptExpression()));
            } else if (designator instanceof IGCCASTArrayRangeDesignator) {
                r = new CArrayRangeDesignator(fileLoc, this.convertExpressionWithoutSideEffects(((IGCCASTArrayRangeDesignator)designator).getRangeFloor()), this.convertExpressionWithoutSideEffects(((IGCCASTArrayRangeDesignator)designator).getRangeCeiling()));
            } else {
                throw this.parseContext.parseError("Unsupported Designator", (IASTNode)designator);
            }
            designators.add(r);
        }
        return new CDesignatedInitializer(fileLoc, designators, cInit);
    }

    private CInitializer convert(IASTInitializerList iList, CType type, @Nullable CVariableDeclaration declaration) {
        IASTInitializerClause result;
        ArrayList<CInitializer> initializerList = new ArrayList<CInitializer>();
        if (declaration != null && iList.getSize() == 1 && (type instanceof CSimpleType || type instanceof CPointerType) && (result = this.unpackBracedInitializer(iList)) != null) {
            return this.convert(result, type, declaration);
        }
        if (type instanceof CArrayType) {
            type = ((CArrayType)type).getType();
        }
        for (IASTInitializerClause i : iList.getClauses()) {
            CInitializer newI = this.convert(i, type, declaration);
            if (newI == null) continue;
            initializerList.add(newI);
        }
        return new CInitializerList(this.getLocation((IASTNode)iList), initializerList);
    }

    private @Nullable IASTInitializerClause unpackBracedInitializer(IASTInitializerList pIList) {
        if (pIList.getSize() == 1) {
            IASTInitializerClause clause = pIList.getClauses()[0];
            if (clause instanceof IASTInitializerList) {
                return this.unpackBracedInitializer((IASTInitializerList)clause);
            }
            return clause;
        }
        return null;
    }

    private CInitializer convert(IASTEqualsInitializer i, CType type, @Nullable CVariableDeclaration declaration) {
        IASTInitializerClause ic = i.getInitializerClause();
        if (ic instanceof IASTExpression) {
            CInitializerExpression result;
            IASTExpression e = (IASTExpression)ic;
            CAstNode initializer = this.convertExpressionWithSideEffects(e);
            if (initializer == null) {
                return null;
            }
            if (initializer instanceof CAssignment) {
                this.sideAssignmentStack.addPreSideAssignment(initializer);
                result = new CInitializerExpression(this.getLocation((IASTNode)e), ((CAssignment)initializer).getLeftHandSide());
            } else if (initializer instanceof CFunctionCallExpression) {
                FileLocation loc = this.getLocation((IASTNode)i);
                if (declaration != null && !declaration.getType().getCanonicalType().isConst()) {
                    CIdExpression var = new CIdExpression(loc, declaration);
                    this.sideAssignmentStack.addPostSideAssignment(new CFunctionCallAssignmentStatement(loc, var, (CFunctionCallExpression)initializer));
                    return null;
                }
                CIdExpression var = this.createTemporaryVariable(e);
                this.sideAssignmentStack.addPreSideAssignment(new CFunctionCallAssignmentStatement(loc, var, (CFunctionCallExpression)initializer));
                result = new CInitializerExpression(loc, var);
            } else if (initializer instanceof CExpression) {
                result = new CInitializerExpression(this.getLocation((IASTNode)ic), (CExpression)initializer);
            } else {
                throw this.parseContext.parseError("Initializer is not free of side-effects, it is a " + initializer.getClass().getSimpleName(), (IASTNode)e);
            }
            if (!this.areInitializerAssignable(type, result.getExpression())) {
                if (type.getCanonicalType() instanceof CPointerType && CTypes.isIntegerType(result.getExpression().getExpressionType())) {
                    if (declaration != null) {
                        this.logger.logf(Level.WARNING, "%s: Initialization of pointer variable %s with integer expression %s.", new Object[]{result.getFileLocation(), type.toASTString(declaration.getName()), result});
                    }
                } else {
                    throw this.parseContext.parseError("Type " + type + " of declaration and type " + ((CExpression)initializer).getExpressionType() + " of initializer are not assignment compatible", (IASTNode)e);
                }
            }
            return result;
        }
        if (ic instanceof IASTInitializerList) {
            return this.convert((IASTInitializerList)ic, type, declaration);
        }
        throw this.parseContext.parseError("unknown initializer: " + i.getClass().getSimpleName(), (IASTNode)i);
    }

    private boolean areInitializerAssignable(CType pDeclarationType, CExpression pInitializerExpression) {
        return pDeclarationType.canBeAssignedFrom(pInitializerExpression.getExpressionType()) || this.isStringInitialization(pDeclarationType, pInitializerExpression) || pInitializerExpression instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)pInitializerExpression).getValue().intValue() == 0 && pDeclarationType.canBeAssignedFrom(CPointerType.POINTER_TO_VOID);
    }

    private boolean isStringInitialization(CType pDeclarationType, CExpression pInitializerExpression) {
        if (pInitializerExpression instanceof CStringLiteralExpression) {
            CType canonicalType = CPointerType.POINTER_TO_VOID;
            if (pDeclarationType instanceof CArrayType) {
                canonicalType = ((CArrayType)pDeclarationType).getType().getCanonicalType();
            }
            if (pDeclarationType instanceof CPointerType) {
                canonicalType = ((CPointerType)pDeclarationType).getType().getCanonicalType();
            }
            return CTypes.copyDequalified(canonicalType).equals(CNumericTypes.CHAR);
        }
        return false;
    }

    private List<CParameterDeclaration> convert(IASTParameterDeclaration[] ps) {
        ArrayList<CParameterDeclaration> paramsList = new ArrayList<CParameterDeclaration>(ps.length);
        for (IASTParameterDeclaration c : ps) {
            if (!c.getRawSignature().equals("void")) {
                paramsList.add(this.convert(c));
                continue;
            }
            assert (ps.length == 1);
        }
        return paramsList;
    }

    private CParameterDeclaration convert(IASTParameterDeclaration p) {
        Pair<CStorageClass, ? extends CType> specifier = this.convert(p.getDeclSpecifier());
        if (specifier.getFirst() != CStorageClass.AUTO) {
            throw this.parseContext.parseError("Unsupported storage class for parameters", (IASTNode)p);
        }
        Triple<CType, IASTInitializer, String> declarator = this.convert(p.getDeclarator(), specifier.getSecond());
        if (declarator.getSecond() != null) {
            throw this.parseContext.parseError("Unsupported initializer for parameters", (IASTNode)p);
        }
        CType type = declarator.getFirst();
        if (type instanceof CFunctionTypeWithNames) {
            CFunctionTypeWithNames functionType = (CFunctionTypeWithNames)type;
            type = new CPointerType(false, false, functionType);
        }
        return new CParameterDeclaration(this.getLocation((IASTNode)p), type, declarator.getThird());
    }

    FileLocation getLocation(IASTNode n) {
        return this.parseContext.getLocation(n);
    }

    static String convert(IASTName n) {
        return n.toString();
    }

    CType convert(IASTTypeId t) {
        Pair<CStorageClass, ? extends CType> specifier = this.convert(t.getDeclSpecifier());
        if (specifier.getFirst() != CStorageClass.AUTO) {
            throw this.parseContext.parseError("Unsupported storage class for type ids", (IASTNode)t);
        }
        Triple<CType, IASTInitializer, String> declarator = this.convert(t.getAbstractDeclarator(), specifier.getSecond());
        if (declarator.getSecond() != null) {
            throw this.parseContext.parseError("Unsupported initializer for type ids", (IASTNode)t);
        }
        if (declarator.getThird() != null && !declarator.getThird().trim().isEmpty()) {
            throw this.parseContext.parseError("Unsupported name for type ids", (IASTNode)t);
        }
        return declarator.getFirst();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        KNOWN_FUNCTION_ATTRIBUTES = builder.put((Object)"ldv_model", Optional.empty()).put((Object)"ldv_model_inline", Optional.empty()).put((Object)"access", Optional.empty()).put((Object)"alias", Optional.empty()).put((Object)"aligned", Optional.empty()).put((Object)"alloc_align", Optional.empty()).put((Object)"alloc_size", Optional.empty()).put((Object)"always_inline", Optional.empty()).put((Object)"assume_aligned", Optional.empty()).put((Object)"cold", Optional.empty()).put((Object)"const", Optional.empty()).put((Object)"deprecated", Optional.empty()).put((Object)"unavailable", Optional.empty()).put((Object)"error", Optional.empty()).put((Object)"warning", Optional.empty()).put((Object)"externally_visible", Optional.empty()).put((Object)"flatten", Optional.empty()).put((Object)"format", Optional.empty()).put((Object)"format_arg", Optional.empty()).put((Object)"gnu_inline", Optional.empty()).put((Object)"hot", Optional.empty()).put((Object)"ifunc", Optional.empty()).put((Object)"interrupt", Optional.empty()).put((Object)"interrupt_handler", Optional.empty()).put((Object)"leaf", Optional.empty()).put((Object)"malloc", Optional.empty()).put((Object)"no_icf", Optional.empty()).put((Object)"no_instrument_function", Optional.empty()).put((Object)"no_profile_instrument_function", Optional.empty()).put((Object)"no_reorder", Optional.empty()).put((Object)"no_sanitize", Optional.empty()).put((Object)"no_sanitize_address", Optional.empty()).put((Object)"no_address_safety_analysis", Optional.empty()).put((Object)"no_sanitize_thread", Optional.empty()).put((Object)"no_sanitize_undefined", Optional.empty()).put((Object)"no_sanitize_coverage", Optional.empty()).put((Object)"no_split_stack", Optional.empty()).put((Object)"no_stack_limit", Optional.empty()).put((Object)"noclone", Optional.empty()).put((Object)"noinline", Optional.empty()).put((Object)"noipa", Optional.empty()).put((Object)"nonnull", Optional.empty()).put((Object)"noplt", Optional.empty()).put((Object)"noreturn", Optional.of(CFunctionDeclaration.FunctionAttribute.NO_RETURN)).put((Object)"nothrow", Optional.empty()).put((Object)"optimize", Optional.empty()).put((Object)"patchable_function_entry", Optional.empty()).put((Object)"pure", Optional.empty()).put((Object)"returns_nonnull", Optional.empty()).put((Object)"returns_twice", Optional.empty()).put((Object)"section", Optional.empty()).put((Object)"sentinel", Optional.empty()).put((Object)"simd", Optional.empty()).put((Object)"stack_protect", Optional.empty()).put((Object)"no_stack_protector", Optional.empty()).put((Object)"target", Optional.empty()).put((Object)"symver", Optional.empty()).put((Object)"tainted_args", Optional.empty()).put((Object)"target_clones", Optional.empty()).put((Object)"unused", Optional.empty()).put((Object)"used", Optional.empty()).put((Object)"retain", Optional.empty()).put((Object)"visibility", Optional.empty()).put((Object)"warn_unused_result", Optional.empty()).put((Object)"weak", Optional.empty()).put((Object)"weakref", Optional.empty()).put((Object)"zero_call_used_regs", Optional.empty()).put((Object)"cdecl", Optional.empty()).put((Object)"fastcall", Optional.empty()).put((Object)"thiscall", Optional.empty()).put((Object)"ms_abi", Optional.empty()).put((Object)"sysv_abi", Optional.empty()).put((Object)"callee_pop_aggregate_return", Optional.empty()).put((Object)"ms_hook_prologue", Optional.empty()).put((Object)"naked", Optional.empty()).put((Object)"regparm", Optional.empty()).put((Object)"sseregparm", Optional.empty()).put((Object)"force_align_arg_pointer", Optional.empty()).put((Object)"stdcall", Optional.empty()).put((Object)"no_caller_saved_registers", Optional.empty()).put((Object)"indirect_branch", Optional.empty()).put((Object)"function_return", Optional.empty()).put((Object)"nocf_check", Optional.empty()).put((Object)"cf_check", Optional.empty()).put((Object)"indirect_return", Optional.empty()).put((Object)"fentry_name", Optional.empty()).put((Object)"fentry_section", Optional.empty()).put((Object)"nodirect_extern_access", Optional.empty()).put((Object)"mode", Optional.empty()).put((Object)"dllexport", Optional.empty()).put((Object)"dllimport", Optional.empty()).buildOrThrow();
        anonTypeCounter = 0;
        containsProblemTypeVisitor = new ContainsProblemTypeVisitor();
        ENUM_REPRESENTATION_CANDIDATE_TYPES = ImmutableList.of((Object)CNumericTypes.SIGNED_INT, (Object)CNumericTypes.UNSIGNED_INT, (Object)CNumericTypes.SIGNED_LONG_LONG_INT);
    }

    private static class ContainsProblemTypeVisitor
    extends DefaultCTypeVisitor<Boolean, NoException> {
        private ContainsProblemTypeVisitor() {
        }

        @Override
        public Boolean visitDefault(CType pT) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(CArrayType t) {
            return t.getType().accept(this);
        }

        @Override
        public Boolean visit(CElaboratedType t) {
            CComplexType realType = t.getRealType();
            if (realType != null) {
                return realType.accept(this);
            }
            return false;
        }

        @Override
        public Boolean visit(CFunctionType t) {
            for (CType parameterType : t.getParameters()) {
                if (!parameterType.accept(this).booleanValue()) continue;
                return true;
            }
            return t.getReturnType().accept(this);
        }

        @Override
        public Boolean visit(CPointerType t) {
            return t.getType().accept(this);
        }

        @Override
        public Boolean visit(CProblemType t) {
            return true;
        }

        @Override
        public Boolean visit(CTypedefType t) {
            return t.getRealType().accept(this);
        }

        @Override
        public Boolean visit(CBitFieldType pCBitFieldType) {
            return pCBitFieldType.getType().accept(this);
        }
    }

    static enum CONDITION {
        NORMAL,
        ALWAYS_FALSE,
        ALWAYS_TRUE;

    }
}

