/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTLiteralConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ParseContext;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.Triple;

public class ASTConverterTest {
    private final ASTLiteralConverter converter32 = new ASTLiteralConverter(MachineModel.LINUX32, ParseContext.dummy());
    private final ASTLiteralConverter converter64 = new ASTLiteralConverter(MachineModel.LINUX64, ParseContext.dummy());

    @Test
    public final void testCharacterExpression() {
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\000'", null))).isEqualTo((Object)Character.valueOf('\u0000'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\077'", null))).isEqualTo((Object)Character.valueOf('?'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\xFF'", null))).isEqualTo((Object)Character.valueOf('\u00ff'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\xBC'", null))).isEqualTo((Object)Character.valueOf('\u00bc'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\x80'", null))).isEqualTo((Object)Character.valueOf('\u0080'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\X7F'", null))).isEqualTo((Object)Character.valueOf('\u007f'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\\\'", null))).isEqualTo((Object)Character.valueOf('\\'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\''", null))).isEqualTo((Object)Character.valueOf('\''));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\\"'", null))).isEqualTo((Object)Character.valueOf('\"'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\0'", null))).isEqualTo((Object)Character.valueOf('\u0000'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\a'", null))).isEqualTo((Object)7);
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\b'", null))).isEqualTo((Object)Character.valueOf('\b'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\f'", null))).isEqualTo((Object)Character.valueOf('\f'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\n'", null))).isEqualTo((Object)Character.valueOf('\n'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\r'", null))).isEqualTo((Object)Character.valueOf('\r'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\t'", null))).isEqualTo((Object)Character.valueOf('\t'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\\v'", null))).isEqualTo((Object)11);
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'a'", null))).isEqualTo((Object)Character.valueOf('a'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("' '", null))).isEqualTo((Object)Character.valueOf(' '));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'9'", null))).isEqualTo((Object)Character.valueOf('9'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\u00b4'", null))).isEqualTo((Object)Character.valueOf('\u00b4'));
        Truth.assertThat((Comparable)Character.valueOf(this.converter32.parseCharacterLiteral("'\u00b4'", null))).isEqualTo((Object)Character.valueOf('\u00b4'));
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression1() {
        this.converter32.parseCharacterLiteral("", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression2() {
        this.converter32.parseCharacterLiteral("'\\'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression3() {
        this.converter32.parseCharacterLiteral("'aa'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression4() {
        this.converter32.parseCharacterLiteral("'\\777'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression5() {
        this.converter32.parseCharacterLiteral("'\\xFFF'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression6() {
        this.converter32.parseCharacterLiteral("'\\z'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression7() {
        this.converter32.parseCharacterLiteral("'\\0777'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression8() {
        this.converter32.parseCharacterLiteral("'\\088'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression9() {
        this.converter32.parseCharacterLiteral("'\\xGG'", null);
    }

    @Test
    public final void testInvalidIntegerExpressions() {
        ImmutableList converters = ImmutableList.of((Object)this.converter32, (Object)this.converter64);
        ImmutableList invalidValues = ImmutableList.of((Object)"18446744073709551617u", (Object)"36893488147419103232", (Object)"36893488147419103232u", (Object)"100020003000400050006000700080009000u");
        for (ASTLiteralConverter c : converters) {
            for (String s : invalidValues) {
                try {
                    c.parseIntegerLiteral(FileLocation.DUMMY, s, null);
                    Truth.assert_().fail();
                }
                catch (CFAGenerationRuntimeException e) {
                    Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Integer value is too large to be represented by the highest possible type (unsigned long long int):");
                }
            }
        }
    }

    private String parseIntegerExpression32(String s) {
        return this.parseIntegerExpression(s, this.converter32);
    }

    private String parseIntegerExpression64(String s) {
        return this.parseIntegerExpression(s, this.converter64);
    }

    private String parseIntegerExpression(String pExpression, ASTLiteralConverter pConverter) {
        CLiteralExpression exp = pConverter.parseIntegerLiteral(FileLocation.DUMMY, pExpression, null);
        return ((CIntegerLiteralExpression)exp).getValue().toString();
    }

    @Test
    public final void testIntegerExpression() {
        this.check("0", "0");
        this.check("1", "1");
        this.check("2", "2");
        this.check("3", "3u");
        this.check("4", "4");
        this.check("5", "5u");
        this.check("63", "077");
        this.check("2147483647", "2147483647");
        this.check("2147483647", "0x7FFFFFFF");
        this.check("2147483648", "2147483648");
        this.check("2147483648", "0x80000000");
        this.check("4294967295", "4294967295");
        this.check("4294967295", "0xFFFFFFFF");
        this.check("4294967296", "4294967296");
        this.check("4000000000", "4000000000");
        this.check("4000000000", "4000000000u");
        this.check("18446744073709551600", "0xfffffffffffffff0u");
        this.check("18446744073709551600", "0xfffffffffffffff0");
        this.check("9223372036854775807", "9223372036854775807");
        this.check("9223372036854775807", "0x7FFFFFFFFFFFFFFF");
        this.check("9223372036854775808", "9223372036854775808u");
        this.check("9223372036854775808", "0x8000000000000000u");
        this.check("9223372036854775808", "9223372036854775808u");
        this.check("9223372036854775808", "0x8000000000000000u");
        this.check("18446744073709551615", "18446744073709551615u");
        this.check("18446744073709551615", "0xFFFFFFFFFFFFFFFF");
        this.check("18446744073709551615", "0xFFFFFFFFFFFFFFFFu");
        this.check("18446711088360718336", "0xffffe20000000000U");
        this.check("18446604435732824064", "0xffff810000000000U");
        this.check("0", "0b0");
        this.check("0", "0B0");
        this.check("255", "0b11111111");
        this.check("255", "0B11111111");
    }

    private void check(String expected, String input) {
        for (String postfix : ImmutableList.of((Object)"", (Object)"l", (Object)"ll", (Object)"L", (Object)"LL", (Object)"lL", (Object)"Ll")) {
            Truth.assertThat((String)this.parseIntegerExpression32(input + postfix)).isEqualTo((Object)expected);
            Truth.assertThat((String)this.parseIntegerExpression64(input + postfix)).isEqualTo((Object)expected);
        }
    }

    @Test
    public final void testValidFloatExpressions() {
        ImmutableList converters = ImmutableList.of((Object)this.converter32, (Object)this.converter64);
        ImmutableList input_output = ImmutableList.of(Triple.of("0", "0.0", CNumericTypes.DOUBLE), Triple.of("-0", "0.0", CNumericTypes.DOUBLE), Triple.of("0xf", "15.0", CNumericTypes.DOUBLE), Triple.of("5e2f", "500.0", CNumericTypes.FLOAT), Triple.of("5e+2f", "500.0", CNumericTypes.FLOAT), Triple.of("0x5e2f", "24111.0", CNumericTypes.FLOAT), Triple.of("0x5e-2f", "94.0", CNumericTypes.FLOAT), Triple.of("3.41E+38", "341000000000000000445911848520865808384.0", CNumericTypes.DOUBLE));
        for (ASTLiteralConverter converter : converters) {
            for (Triple triple : input_output) {
                String inputValue = (String)triple.getFirst();
                String expectedValue = (String)triple.getSecond();
                CType inputType = (CType)triple.getThird();
                CFloatLiteralExpression literal = (CFloatLiteralExpression)converter.parseFloatLiteral(FileLocation.DUMMY, inputType, inputValue, null);
                Truth.assertThat((String)literal.getValue().toString()).isEqualTo((Object)expectedValue);
                Truth.assertThat((Object)inputType).isSameInstanceAs((Object)literal.getExpressionType());
            }
        }
    }

    @Ignore
    public final void testInvalidFloatExpressions() {
        ImmutableList converters = ImmutableList.of((Object)this.converter32, (Object)this.converter64);
        ImmutableList values = ImmutableList.of((Object)"3.41e+38f", (Object)"-4.2e+38f", (Object)"1.8e+308", (Object)"-2.3e+308", (Object)"1.2e+4932l", (Object)"-1.2e+4932l");
        for (ASTLiteralConverter converter : converters) {
            for (String value : values) {
                try {
                    converter.parseFloatLiteral(FileLocation.DUMMY, null, value, null);
                    Truth.assertWithMessage((String)("Failed because of value: " + value)).fail();
                }
                catch (CFAGenerationRuntimeException e) {
                    Truth.assertThat((String)e.getMessage()).isAnyOf((Object)"unable to parse floating point literal (inf)", (Object)"unable to parse floating point literal (-inf)", new Object[0]);
                }
            }
        }
    }
}

