/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ParseContext;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloat;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatNative;

class ASTLiteralConverter {
    private final MachineModel machine;
    private final ParseContext parseContext;

    ASTLiteralConverter(MachineModel pMachineModel, ParseContext pParseContext) {
        this.machine = pMachineModel;
        this.parseContext = pParseContext;
    }

    private void check(boolean assertion, String msg, IASTNode astNode) throws CFAGenerationRuntimeException {
        if (!assertion) {
            throw this.parseContext.parseError(msg, astNode);
        }
    }

    CLiteralExpression convert(IASTLiteralExpression e, CType type, FileLocation fileLoc) {
        if (!(type instanceof CSimpleType) && e.getKind() != 3) {
            throw this.parseContext.parseError("Invalid type " + type + " for literal expression", (IASTNode)e);
        }
        String valueStr = String.valueOf(e.getValue());
        if (valueStr.endsWith("i") || valueStr.endsWith("j")) {
            return this.handleImaginaryNumber(fileLoc, (CSimpleType)type, e, valueStr);
        }
        switch (e.getKind()) {
            case 2: {
                return new CCharLiteralExpression(fileLoc, type, this.parseCharacterLiteral(valueStr, (IASTNode)e));
            }
            case 0: {
                return this.parseIntegerLiteral(fileLoc, valueStr, e);
            }
            case 1: {
                return this.parseFloatLiteral(fileLoc, type, valueStr, e);
            }
            case 3: {
                return new CStringLiteralExpression(fileLoc, type, valueStr);
            }
        }
        throw this.parseContext.parseError("Unknown literal", (IASTNode)e);
    }

    private CImaginaryLiteralExpression handleImaginaryNumber(FileLocation fileLoc, CSimpleType type, IASTLiteralExpression exp, String valueStr) {
        valueStr = valueStr.substring(0, valueStr.length() - 1);
        type = new CSimpleType(type.isConst(), type.isVolatile(), type.getType(), type.isLong(), type.isShort(), type.isSigned(), type.isUnsigned(), type.isComplex(), true, type.isLongLong());
        switch (exp.getKind()) {
            case 2: {
                return new CImaginaryLiteralExpression(fileLoc, type, new CCharLiteralExpression(fileLoc, type, this.parseCharacterLiteral(valueStr, (IASTNode)exp)));
            }
            case 0: {
                CLiteralExpression intLiteralExp = this.parseIntegerLiteral(fileLoc, valueStr, exp);
                return new CImaginaryLiteralExpression(fileLoc, intLiteralExp.getExpressionType(), intLiteralExp);
            }
            case 1: {
                CLiteralExpression floatLiteralExp = this.parseFloatLiteral(fileLoc, type, valueStr, exp);
                return new CImaginaryLiteralExpression(fileLoc, floatLiteralExp.getExpressionType(), floatLiteralExp);
            }
        }
        throw this.parseContext.parseError("Unknown imaginary literal", (IASTNode)exp);
    }

    @VisibleForTesting
    CLiteralExpression parseIntegerLiteral(FileLocation pFileLoc, String pValueStr, IASTLiteralExpression pExp) {
        Suffix denotedSuffix = this.extractDenotedSuffix(pValueStr, (IASTNode)pExp);
        ConstantType type = this.parseType(pValueStr);
        BigInteger integerValue = this.parseRawIntegerValue(type, pValueStr.substring(0, pValueStr.length() - denotedSuffix.getLength()), (IASTNode)pExp);
        ImmutableList<Suffix> suffixCandiates = this.getSuffixCandidates(denotedSuffix, type);
        Suffix actualRequiredSuffix = this.getLeastRepresentedTypeForValue(integerValue, this.machine, suffixCandiates, pExp);
        int bits = this.machine.getSizeof(actualRequiredSuffix.getType()) * this.machine.getSizeofCharInBits();
        if (actualRequiredSuffix.isSigned() && integerValue.testBit(bits - 1)) {
            throw this.parseContext.parseError("Type must not be signed while simultaneously having its most significant bit set", (IASTNode)pExp);
        }
        BigInteger mask = BigInteger.ZERO.setBit(bits).subtract(BigInteger.ONE);
        assert (integerValue.and(mask).bitLength() <= bits);
        return new CIntegerLiteralExpression(pFileLoc, actualRequiredSuffix.getType(), integerValue);
    }

    @VisibleForTesting
    CLiteralExpression parseFloatLiteral(FileLocation pFileLoc, CType pType, String pValueStr, IASTLiteralExpression pExp) {
        CFloatNative cFloat = pValueStr.endsWith("L") || pValueStr.endsWith("l") ? new CFloatNative(pValueStr, 2) : (pValueStr.endsWith("F") || pValueStr.endsWith("f") ? new CFloatNative(pValueStr, 0) : new CFloatNative(pValueStr, 1));
        if (((CFloat)cFloat).isInfinity()) {
            if (((CFloat)cFloat).isNegative()) {
                return CFloatLiteralExpression.forNegativeInfinity(pFileLoc, pType);
            }
            return CFloatLiteralExpression.forPositiveInfinity(pFileLoc, pType);
        }
        try {
            BigDecimal value = new BigDecimal(((Object)cFloat).toString());
            return new CFloatLiteralExpression(pFileLoc, pType, value);
        }
        catch (NumberFormatException e) {
            throw this.parseContext.parseError(String.format("unable to parse floating point literal (%s)", ((Object)cFloat).toString()), (IASTNode)pExp);
        }
    }

    @VisibleForTesting
    char parseCharacterLiteral(String s, IASTNode e) {
        int result;
        this.check(s.length() >= 3, "invalid character literal (too short)", e);
        if (s.charAt(0) == 'L' || s.charAt(0) == 'u' || s.charAt(0) == 'U') {
            throw this.parseContext.parseError("Wide-character literals are currently unsupported", e);
        }
        this.check(s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'', "character literal without quotation marks", e);
        s = s.substring(1, s.length() - 1);
        if (s.length() == 1) {
            result = s.charAt(0);
            this.check(result != 92, "invalid quoting sequence", e);
        } else {
            this.check(s.charAt(0) == '\\', "character literal too long", e);
            s = s.substring(1);
            this.check(s.length() >= 1, "invalid quoting sequence", e);
            char c = s.charAt(0);
            if (c == 'x' || c == 'X') {
                this.check(!(s = s.substring(1)).isEmpty() && s.length() <= 3, "character literal with illegal hex number", e);
                try {
                    result = (char)Integer.parseInt(s, 16);
                    this.check(result <= 255, "hex escape sequence out of range", e);
                }
                catch (NumberFormatException exception) {
                    throw this.parseContext.parseError("character literal with illegal hex number", e);
                }
            } else if (Character.isDigit(c)) {
                this.check(s.length() <= 3, "character literal with illegal octal number", e);
                try {
                    result = (char)Integer.parseInt(s, 8);
                    this.check(result <= 255, "octal escape sequence out of range", e);
                }
                catch (NumberFormatException exception) {
                    throw this.parseContext.parseError("character literal with illegal octal number", e);
                }
            } else {
                this.check(s.length() == 1, "character literal too long", e);
                switch (c) {
                    case 'a': {
                        result = 7;
                        break;
                    }
                    case 'b': {
                        result = 8;
                        break;
                    }
                    case 'f': {
                        result = 12;
                        break;
                    }
                    case 'n': {
                        result = 10;
                        break;
                    }
                    case 'r': {
                        result = 13;
                        break;
                    }
                    case 't': {
                        result = 9;
                        break;
                    }
                    case 'v': {
                        result = 11;
                        break;
                    }
                    case '\"': {
                        result = 34;
                        break;
                    }
                    case '\'': {
                        result = 39;
                        break;
                    }
                    case '\\': {
                        result = 92;
                        break;
                    }
                    default: {
                        throw this.parseContext.parseError("unknown character literal", e);
                    }
                }
            }
        }
        return (char)result;
    }

    private ConstantType parseType(String pRawValue) {
        if (pRawValue.startsWith("0x") || pRawValue.startsWith("0X")) {
            return ConstantType.HEXADECIMAL;
        }
        if (pRawValue.startsWith("0b") || pRawValue.startsWith("0B")) {
            return ConstantType.BINARY;
        }
        if (pRawValue.startsWith("0")) {
            return ConstantType.OCTAL;
        }
        return ConstantType.DECIMAL;
    }

    private BigInteger parseRawIntegerValue(ConstantType type, String s, IASTNode e) {
        BigInteger result;
        try {
            switch (type) {
                case BINARY: {
                    s = s.substring(2);
                    result = new BigInteger(s, 2);
                    break;
                }
                case OCTAL: {
                    result = new BigInteger(s, 8);
                    break;
                }
                case DECIMAL: {
                    result = new BigInteger(s, 10);
                    break;
                }
                case HEXADECIMAL: {
                    s = s.substring(2);
                    result = new BigInteger(s, 16);
                    break;
                }
                default: {
                    throw this.parseContext.parseError(String.format("invalid constant type: %s", type.name()), e);
                }
            }
        }
        catch (NumberFormatException exception) {
            throw this.parseContext.parseError("invalid number", e);
        }
        this.check(result.compareTo(BigInteger.ZERO) >= 0, "invalid number", e);
        return result;
    }

    private Suffix extractDenotedSuffix(String pIntegerLiteral, IASTNode pExpression) {
        Suffix suffix = Suffix.NONE;
        int last = pIntegerLiteral.length() - 1;
        if (pIntegerLiteral.charAt(last) == 'U' || pIntegerLiteral.charAt(last) == 'u') {
            --last;
            suffix = Suffix.U;
        }
        if (pIntegerLiteral.charAt(last) == 'L' || pIntegerLiteral.charAt(last) == 'l') {
            --last;
            Suffix suffix2 = suffix = suffix == Suffix.NONE ? Suffix.L : Suffix.UL;
        }
        if (pIntegerLiteral.charAt(last) == 'L' || pIntegerLiteral.charAt(last) == 'l') {
            --last;
            Suffix suffix3 = suffix = suffix == Suffix.L ? Suffix.LL : Suffix.ULL;
        }
        if (pIntegerLiteral.charAt(last) == 'U' || pIntegerLiteral.charAt(last) == 'u') {
            if (!suffix.isSigned()) {
                throw this.parseContext.parseError("invalid duplicate modifier U in integer literal", pExpression);
            }
            --last;
            suffix = suffix == Suffix.L ? Suffix.UL : Suffix.ULL;
        }
        return suffix;
    }

    private ImmutableList<Suffix> getSuffixCandidates(Suffix pDenotedSuffix, ConstantType pType) {
        Stream<Suffix> stream = Arrays.stream(Suffix.values()).filter(x -> x.compareTo(pDenotedSuffix) >= 0);
        switch (pDenotedSuffix) {
            case NONE: 
            case L: 
            case LL: {
                if (pType != ConstantType.DECIMAL) break;
                stream = stream.filter(x -> x.isSigned());
                break;
            }
            case U: 
            case UL: 
            case ULL: {
                stream = stream.filter(x -> !x.isSigned());
                break;
            }
            default: {
                throw new CFAGenerationRuntimeException(String.format("Unhandled suffix: %s", pDenotedSuffix.name()));
            }
        }
        return (ImmutableList)stream.collect(ImmutableList.toImmutableList());
    }

    private Suffix getLeastRepresentedTypeForValue(BigInteger pValue, MachineModel pMachineModel, ImmutableList<Suffix> pSuffixes, IASTLiteralExpression pExp) {
        Preconditions.checkState((!pSuffixes.isEmpty() ? 1 : 0) != 0, (Object)"List with possible suffixes must not be empty");
        int numberOfBits = pValue.bitLength();
        int actualCandidateBitSize = -1;
        for (Suffix suffix : pSuffixes) {
            CSimpleType candidate = suffix.getType();
            int candidateBitSize = pMachineModel.getSizeof(candidate) * pMachineModel.getSizeofCharInBits();
            actualCandidateBitSize = suffix.isSigned() ? candidateBitSize - 1 : candidateBitSize;
            if (actualCandidateBitSize < numberOfBits) continue;
            return suffix;
        }
        assert (actualCandidateBitSize > 0 && numberOfBits > actualCandidateBitSize);
        throw new CFAGenerationRuntimeException(String.format("Integer value is too large to be represented by the highest possible type (unsigned long long int): %s.", pExp));
    }

    private static enum Suffix {
        NONE{

            @Override
            public boolean isSigned() {
                return true;
            }

            @Override
            public CSimpleType getType() {
                return CNumericTypes.INT;
            }

            @Override
            public int getLength() {
                return 0;
            }
        }
        ,
        U{

            @Override
            public boolean isSigned() {
                return false;
            }

            @Override
            public CSimpleType getType() {
                return CNumericTypes.UNSIGNED_INT;
            }

            @Override
            public int getLength() {
                return 1;
            }
        }
        ,
        L{

            @Override
            public boolean isSigned() {
                return true;
            }

            @Override
            public CSimpleType getType() {
                return CNumericTypes.LONG_INT;
            }

            @Override
            public int getLength() {
                return 1;
            }
        }
        ,
        UL{

            @Override
            public boolean isSigned() {
                return false;
            }

            @Override
            public CSimpleType getType() {
                return CNumericTypes.UNSIGNED_LONG_INT;
            }

            @Override
            public int getLength() {
                return 2;
            }
        }
        ,
        LL{

            @Override
            public boolean isSigned() {
                return true;
            }

            @Override
            public CSimpleType getType() {
                return CNumericTypes.LONG_LONG_INT;
            }

            @Override
            public int getLength() {
                return 2;
            }
        }
        ,
        ULL{

            @Override
            public boolean isSigned() {
                return false;
            }

            @Override
            public CSimpleType getType() {
                return CNumericTypes.UNSIGNED_LONG_LONG_INT;
            }

            @Override
            public int getLength() {
                return 3;
            }
        };


        public abstract boolean isSigned();

        public abstract CSimpleType getType();

        public abstract int getLength();
    }

    private static enum ConstantType {
        BINARY,
        OCTAL,
        DECIMAL,
        HEXADECIMAL;

    }
}

