/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ParseContext;
import org.sosy_lab.cpachecker.util.Pair;

class ASTOperatorConverter {
    private final ParseContext parseContext;
    private static final ImmutableSet<CBinaryExpression.BinaryOperator> BOOLEAN_BINARY_OPERATORS = Sets.immutableEnumSet((Enum)CBinaryExpression.BinaryOperator.EQUALS, (Enum[])new CBinaryExpression.BinaryOperator[]{CBinaryExpression.BinaryOperator.NOT_EQUALS, CBinaryExpression.BinaryOperator.GREATER_EQUAL, CBinaryExpression.BinaryOperator.GREATER_THAN, CBinaryExpression.BinaryOperator.LESS_EQUAL, CBinaryExpression.BinaryOperator.LESS_THAN});

    ASTOperatorConverter(ParseContext pParseContext) {
        this.parseContext = pParseContext;
    }

    CUnaryExpression.UnaryOperator convertUnaryOperator(IASTUnaryExpression e) {
        switch (e.getOperator()) {
            case 5: {
                return CUnaryExpression.UnaryOperator.AMPER;
            }
            case 3: {
                return CUnaryExpression.UnaryOperator.MINUS;
            }
            case 8: {
                return CUnaryExpression.UnaryOperator.SIZEOF;
            }
            case 4: {
                throw new IllegalArgumentException("For the star operator, CPointerExpression should be used instead of CUnaryExpression with a star operator.");
            }
            case 6: {
                return CUnaryExpression.UnaryOperator.TILDE;
            }
            case 15: {
                return CUnaryExpression.UnaryOperator.ALIGNOF;
            }
        }
        throw this.parseContext.parseError("Unknown unary operator", (IASTNode)e);
    }

    Pair<CBinaryExpression.BinaryOperator, Boolean> convertBinaryOperator(IASTBinaryExpression e) {
        CBinaryExpression.BinaryOperator operator;
        boolean isAssign = false;
        switch (e.getOperator()) {
            case 1: {
                operator = CBinaryExpression.BinaryOperator.MULTIPLY;
                break;
            }
            case 2: {
                operator = CBinaryExpression.BinaryOperator.DIVIDE;
                break;
            }
            case 3: {
                operator = CBinaryExpression.BinaryOperator.MODULO;
                break;
            }
            case 4: {
                operator = CBinaryExpression.BinaryOperator.PLUS;
                break;
            }
            case 5: {
                operator = CBinaryExpression.BinaryOperator.MINUS;
                break;
            }
            case 6: {
                operator = CBinaryExpression.BinaryOperator.SHIFT_LEFT;
                break;
            }
            case 7: {
                operator = CBinaryExpression.BinaryOperator.SHIFT_RIGHT;
                break;
            }
            case 8: {
                operator = CBinaryExpression.BinaryOperator.LESS_THAN;
                break;
            }
            case 9: {
                operator = CBinaryExpression.BinaryOperator.GREATER_THAN;
                break;
            }
            case 10: {
                operator = CBinaryExpression.BinaryOperator.LESS_EQUAL;
                break;
            }
            case 11: {
                operator = CBinaryExpression.BinaryOperator.GREATER_EQUAL;
                break;
            }
            case 12: {
                operator = CBinaryExpression.BinaryOperator.BINARY_AND;
                break;
            }
            case 13: {
                operator = CBinaryExpression.BinaryOperator.BINARY_XOR;
                break;
            }
            case 14: {
                operator = CBinaryExpression.BinaryOperator.BINARY_OR;
                break;
            }
            case 17: {
                operator = null;
                isAssign = true;
                break;
            }
            case 18: {
                operator = CBinaryExpression.BinaryOperator.MULTIPLY;
                isAssign = true;
                break;
            }
            case 19: {
                operator = CBinaryExpression.BinaryOperator.DIVIDE;
                isAssign = true;
                break;
            }
            case 20: {
                operator = CBinaryExpression.BinaryOperator.MODULO;
                isAssign = true;
                break;
            }
            case 21: {
                operator = CBinaryExpression.BinaryOperator.PLUS;
                isAssign = true;
                break;
            }
            case 22: {
                operator = CBinaryExpression.BinaryOperator.MINUS;
                isAssign = true;
                break;
            }
            case 23: {
                operator = CBinaryExpression.BinaryOperator.SHIFT_LEFT;
                isAssign = true;
                break;
            }
            case 24: {
                operator = CBinaryExpression.BinaryOperator.SHIFT_RIGHT;
                isAssign = true;
                break;
            }
            case 25: {
                operator = CBinaryExpression.BinaryOperator.BINARY_AND;
                isAssign = true;
                break;
            }
            case 26: {
                operator = CBinaryExpression.BinaryOperator.BINARY_XOR;
                isAssign = true;
                break;
            }
            case 27: {
                operator = CBinaryExpression.BinaryOperator.BINARY_OR;
                isAssign = true;
                break;
            }
            case 28: {
                operator = CBinaryExpression.BinaryOperator.EQUALS;
                break;
            }
            case 29: {
                operator = CBinaryExpression.BinaryOperator.NOT_EQUALS;
                break;
            }
            default: {
                throw this.parseContext.parseError("Unknown binary operator", (IASTNode)e);
            }
        }
        return Pair.of(operator, isAssign);
    }

    CTypeIdExpression.TypeIdOperator convertTypeIdOperator(IASTTypeIdExpression e) {
        switch (e.getOperator()) {
            case 2: {
                return CTypeIdExpression.TypeIdOperator.ALIGNOF;
            }
            case 0: {
                return CTypeIdExpression.TypeIdOperator.SIZEOF;
            }
            case 3: {
                return CTypeIdExpression.TypeIdOperator.TYPEOF;
            }
        }
        throw this.parseContext.parseError("Unknown type id operator", (IASTNode)e);
    }

    static boolean isBooleanExpression(CExpression e) {
        if (e instanceof CBinaryExpression) {
            return BOOLEAN_BINARY_OPERATORS.contains((Object)((CBinaryExpression)e).getOperator());
        }
        return false;
    }
}

