/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.common.io.MoreFiles;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToIntFunction;
import org.sosy_lab.cpachecker.exceptions.CParserException;

public class BOMParser {
    private static final int MAX_BOM_LENGTH = Arrays.stream(ByteOrderMark.values()).max(Comparator.comparingInt((ToIntFunction<ByteOrderMark>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$static$0(org.sosy_lab.cpachecker.cfa.parser.eclipse.c.BOMParser$ByteOrderMark ), (Lorg/sosy_lab/cpachecker/cfa/parser/eclipse/c/BOMParser$ByteOrderMark;)I)())).orElseThrow().sequence.size();

    public static String filterAndDecode(Path pFilename) throws IOException, CParserException {
        try (BufferedInputStream in = new BufferedInputStream(MoreFiles.asByteSource((Path)pFilename, (OpenOption[])new OpenOption[0]).openStream());){
            String code;
            ArrayList<Integer> codeBeginning = new ArrayList<Integer>();
            int c = 0;
            ByteOrderMark bom = ByteOrderMark.NO_BOM;
            in.mark(MAX_BOM_LENGTH);
            for (int counter = 0; (c = in.read()) > -1 && counter < MAX_BOM_LENGTH; ++counter) {
                codeBeginning.add(c);
                bom = BOMParser.getBOM(codeBeginning);
                if (bom == ByteOrderMark.NO_BOM || bom == ByteOrderMark.UNKNOWN_BOM) continue;
            }
            switch (bom) {
                case NO_BOM: {
                    in.reset();
                    break;
                }
                case UNKNOWN_BOM: {
                    throw new CParserException("Byte Order Mark is unknown");
                }
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)in, bom.charset);){
                code = CharStreams.toString((Readable)reader);
            }
            if (bom != ByteOrderMark.NO_BOM && !CharMatcher.ascii().matchesAllOf((CharSequence)code)) {
                throw new CParserException(bom.charset + " encoded file has non-ascii values");
            }
            String string = code;
            return string;
        }
    }

    private static ByteOrderMark getBOM(List<Integer> codeBeginning) {
        if (BOMParser.isPureAscii(codeBeginning)) {
            return ByteOrderMark.NO_BOM;
        }
        for (ByteOrderMark bom : ByteOrderMark.values()) {
            if (!codeBeginning.equals(bom.sequence)) continue;
            return bom;
        }
        return ByteOrderMark.UNKNOWN_BOM;
    }

    private static boolean isPureAscii(List<Integer> code) {
        for (int b : code) {
            if (127 >= b) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ int lambda$static$0(ByteOrderMark bom) {
        return bom.sequence.size();
    }

    private static enum ByteOrderMark {
        NO_BOM(Charset.defaultCharset(), (ImmutableList<Integer>)ImmutableList.of()),
        UTF8_BOM(StandardCharsets.UTF_8, (ImmutableList<Integer>)ImmutableList.of((Object)239, (Object)187, (Object)191)),
        UTF16_BE_BOM(StandardCharsets.UTF_16BE, (ImmutableList<Integer>)ImmutableList.of((Object)254, (Object)255, (Object)254, (Object)255)),
        UTF16_LE_BOM(StandardCharsets.UTF_16LE, (ImmutableList<Integer>)ImmutableList.of((Object)255, (Object)254, (Object)255, (Object)254)),
        UTF32_BE_BOM(Charset.forName("UTF-32BE"), (ImmutableList<Integer>)ImmutableList.of((Object)0, (Object)0, (Object)254, (Object)255, (Object)0, (Object)0, (Object)254, (Object)255)),
        UTF32_LE_BOM(Charset.forName("UTF-32LE"), (ImmutableList<Integer>)ImmutableList.of((Object)255, (Object)254, (Object)0, (Object)0, (Object)255, (Object)254, (Object)0, (Object)0)),
        UNKNOWN_BOM(Charset.defaultCharset(), (ImmutableList<Integer>)ImmutableList.of());

        private final ImmutableList<Integer> sequence;
        private final Charset charset;

        private ByteOrderMark(Charset charset, ImmutableList<Integer> sequence) {
            this.charset = charset;
            this.sequence = sequence;
        }
    }
}

