/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.TreeMultimap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ParseResultWithCommentLocations;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.SyntacticBlock;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.parser.Parsers;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAFunctionBuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CheckBindingVisitor;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FillInAllBindingsVisitor;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FunctionScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.GlobalScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ParseContext;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ProgramDeclarations;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.Sideassignments;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;

class CFABuilder
extends ASTVisitor {
    private final List<Triple<List<IASTFunctionDefinition>, String, GlobalScope>> functionDeclarations = new ArrayList<Triple<List<IASTFunctionDefinition>, String, GlobalScope>>();
    private final NavigableMap<String, FunctionEntryNode> cfas = new TreeMap<String, FunctionEntryNode>();
    private final TreeMultimap<String, CFANode> cfaNodes = TreeMultimap.create();
    private final List<String> eliminateableDuplicates = new ArrayList<String>();
    private final List<Triple<ADeclaration, String, GlobalScope>> globalDeclarations = new ArrayList<Triple<ADeclaration, String, GlobalScope>>();
    private final List<Pair<ADeclaration, String>> globalDecls = new ArrayList<Pair<ADeclaration, String>>();
    private final Set<String> globalInitializedVariables = new HashSet<String>();
    private final List<FileLocation> acslCommentPositions = new ArrayList<FileLocation>();
    private final List<SyntacticBlock> blocks = new ArrayList<SyntacticBlock>();
    private final List<Path> parsedFiles = new ArrayList<Path>();
    private GlobalScope fileScope = new GlobalScope();
    private Scope artificialScope;
    private ProgramDeclarations programDeclarations = new ProgramDeclarations();
    private ASTConverter astCreator;
    private final ParseContext parseContext;
    private final Parsers.EclipseCParserOptions options;
    private final MachineModel machine;
    private final LogManagerWithoutDuplicates logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CheckBindingVisitor checkBinding;
    private boolean encounteredAsm = false;
    private Sideassignments sideAssignmentStack = null;

    public CFABuilder(Parsers.EclipseCParserOptions pOptions, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ParseContext pParseContext, MachineModel pMachine) {
        this.options = pOptions;
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.shutdownNotifier = pShutdownNotifier;
        this.parseContext = pParseContext;
        this.machine = pMachine;
        this.checkBinding = new CheckBindingVisitor(pLogger);
        this.shouldVisitDeclarations = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitProblems = true;
        this.shouldVisitTranslationUnit = true;
    }

    public void analyzeTranslationUnit(IASTTranslationUnit ast, String staticVariablePrefix, Scope pFallbackScope) throws InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        if (!Strings.isNullOrEmpty((String)ast.getFilePath())) {
            this.parsedFiles.add(Path.of(ast.getFilePath(), new String[0]));
        }
        this.sideAssignmentStack = new Sideassignments();
        this.artificialScope = pFallbackScope;
        this.fileScope = new GlobalScope(new HashMap<String, CSimpleDeclaration>(), new HashMap<String, CSimpleDeclaration>(), new HashMap<String, CFunctionDeclaration>(), new HashMap<String, CComplexTypeDeclaration>(), new HashMap<String, CTypeDefDeclaration>(), this.programDeclarations, staticVariablePrefix, this.artificialScope);
        this.astCreator = new ASTConverter(this.options, this.fileScope, this.logger, this.parseContext, this.machine, staticVariablePrefix, this.sideAssignmentStack);
        this.functionDeclarations.add(Triple.of(new ArrayList(), staticVariablePrefix, this.fileScope));
        ast.accept((ASTVisitor)this);
        if (this.options.shouldCollectACSLAnnotations()) {
            for (IASTComment comment : ast.getComments()) {
                String commentString = String.valueOf(comment.getComment());
                if (!commentString.startsWith("/*@") && !commentString.startsWith("//@")) continue;
                this.acslCommentPositions.add(this.astCreator.getLocation((IASTNode)comment));
            }
        }
        this.shutdownNotifier.shutdownIfNecessary();
    }

    public int visit(IASTDeclaration declaration) {
        if (this.shutdownNotifier.shouldShutdown()) {
            return 2;
        }
        this.sideAssignmentStack.enterBlock();
        if (declaration instanceof IASTSimpleDeclaration) {
            return this.handleSimpleDeclaration((IASTSimpleDeclaration)declaration);
        }
        if (declaration instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fd = (IASTFunctionDefinition)declaration;
            this.functionDeclarations.get(this.functionDeclarations.size() - 1).getFirst().add(fd);
            CFunctionDeclaration functionDefinition = this.astCreator.convert(fd);
            if (this.sideAssignmentStack.hasPreSideAssignments() || this.sideAssignmentStack.hasPostSideAssignments()) {
                throw this.parseContext.parseError("Function definition has side effect", (IASTNode)fd);
            }
            this.fileScope.registerFunctionDeclaration(functionDefinition);
            if (!this.eliminateableDuplicates.contains(functionDefinition.toASTString())) {
                this.globalDeclarations.add(Triple.of(functionDefinition, fd.getDeclSpecifier().getRawSignature() + " " + fd.getDeclarator().getRawSignature(), this.fileScope));
                this.globalDecls.add(Pair.of(functionDefinition, fd.getDeclSpecifier().getRawSignature() + " " + fd.getDeclarator().getRawSignature()));
                this.eliminateableDuplicates.add(functionDefinition.toASTString());
            }
            this.sideAssignmentStack.leaveBlock();
            return 1;
        }
        if (declaration instanceof IASTProblemDeclaration) {
            this.visit(((IASTProblemDeclaration)declaration).getProblem());
            this.sideAssignmentStack.leaveBlock();
            return 1;
        }
        if (declaration instanceof IASTASMDeclaration) {
            this.encounteredAsm = true;
            @Nullable IASTFileLocation fileloc = declaration.getFileLocation();
            if (fileloc != null) {
                this.logger.log(Level.FINER, new Object[]{"Ignoring inline assembler code at line", fileloc.getStartingLineNumber()});
            } else {
                this.logger.log(Level.FINER, new Object[]{"Ignoring inline assembler code at unknown line."});
            }
            this.sideAssignmentStack.leaveBlock();
            return 1;
        }
        throw this.parseContext.parseError("Unknown declaration type " + declaration.getClass().getSimpleName(), (IASTNode)declaration);
    }

    private int handleSimpleDeclaration(IASTSimpleDeclaration sd) {
        if (sd.getDeclarators().length == 0 && sd.getDeclSpecifier() instanceof IASTSimpleDeclSpecifier) {
            this.sideAssignmentStack.leaveBlock();
            return 1;
        }
        List<CDeclaration> newDs = this.astCreator.convert(sd);
        assert (!newDs.isEmpty());
        if (this.sideAssignmentStack.hasConditionalExpression() || this.sideAssignmentStack.hasPostSideAssignments()) {
            throw this.parseContext.parseError("Initializer of global variable has side effect", (IASTNode)sd);
        }
        String rawSignature = sd.getRawSignature();
        for (CAstNode astNode : this.sideAssignmentStack.getAndResetPreSideAssignments()) {
            if (astNode instanceof CComplexTypeDeclaration) {
                this.globalDeclarations.add(Triple.of((ADeclaration)((Object)astNode), rawSignature, this.fileScope));
                this.globalDecls.add(Pair.of((ADeclaration)((Object)astNode), rawSignature));
                continue;
            }
            if (astNode instanceof CVariableDeclaration) {
                CInitializer initializer = ((CVariableDeclaration)astNode).getInitializer();
                if (initializer instanceof CInitializerList) {
                    this.globalDeclarations.add(Triple.of((ADeclaration)((Object)astNode), rawSignature, this.fileScope));
                    this.globalDecls.add(Pair.of((ADeclaration)((Object)astNode), rawSignature));
                    continue;
                }
                throw this.parseContext.parseError("Initializer of global variable has side effect", (IASTNode)sd);
            }
            throw this.parseContext.parseError("Initializer of global variable has side effect", (IASTNode)sd);
        }
        for (CDeclaration newD : newDs) {
            boolean used = true;
            if (newD instanceof CVariableDeclaration) {
                CInitializer init = ((CVariableDeclaration)newD).getInitializer();
                if (init != null) {
                    init.accept(this.checkBinding);
                    if (!this.globalInitializedVariables.add(newD.getName())) {
                        throw this.parseContext.parseError("Variable " + newD.getName() + " initialized for the second time", newD);
                    }
                }
                this.fileScope.registerDeclaration(newD);
            } else if (newD instanceof CFunctionDeclaration) {
                this.fileScope.registerFunctionDeclaration((CFunctionDeclaration)newD);
            } else if (newD instanceof CComplexTypeDeclaration) {
                used = this.fileScope.registerTypeDeclaration((CComplexTypeDeclaration)newD);
            } else if (newD instanceof CTypeDefDeclaration) {
                used = this.fileScope.registerTypeDeclaration((CTypeDefDeclaration)newD);
            }
            if (!used || this.eliminateableDuplicates.contains(newD.toASTString())) continue;
            this.globalDeclarations.add(Triple.of(newD, rawSignature, this.fileScope));
            this.globalDecls.add(Pair.of(newD, rawSignature));
            this.eliminateableDuplicates.add(newD.toASTString());
        }
        this.sideAssignmentStack.leaveBlock();
        return 1;
    }

    public int visit(IASTProblem problem) {
        if (this.shutdownNotifier.shouldShutdown()) {
            return 2;
        }
        throw this.parseContext.parseError(problem);
    }

    public ParseResult createCFA() throws CParserException, InterruptedException {
        if (this.functionDeclarations.size() > 1) {
            this.programDeclarations.completeUncompletedElaboratedTypes();
        }
        for (Triple<ADeclaration, String, GlobalScope> triple : this.globalDeclarations) {
            FillInAllBindingsVisitor fillInAllBindingsVisitor = new FillInAllBindingsVisitor(triple.getThird(), this.programDeclarations);
            ((CDeclaration)triple.getFirst()).getType().accept(fillInAllBindingsVisitor);
        }
        for (Triple<Object, String, GlobalScope> triple : this.functionDeclarations) {
            GlobalScope actScope = triple.getThird();
            ImmutableMap<String, CFunctionDeclaration> actFunctions = actScope.getFunctions();
            ImmutableMap<String, CComplexTypeDeclaration> actTypes = actScope.getTypes();
            ImmutableMap<String, CTypeDefDeclaration> actTypeDefs = actScope.getTypeDefs();
            ImmutableMap<String, CSimpleDeclaration> actVars = actScope.getGlobalVars();
            for (IASTFunctionDefinition declaration : (List)triple.getFirst()) {
                this.handleFunctionDefinition(actScope, triple.getSecond(), declaration, actFunctions, actTypes, actTypeDefs, actVars);
            }
        }
        if (this.encounteredAsm) {
            this.logger.log(Level.WARNING, new Object[]{"Inline assembler ignored, analysis is probably unsound!"});
        }
        if (this.checkBinding.foundUndefinedIdentifiers()) {
            throw new CParserException("Invalid C code because of undefined identifiers mentioned above.");
        }
        if (this.acslCommentPositions.isEmpty()) {
            return new ParseResult(this.cfas, this.cfaNodes, this.globalDecls, this.parsedFiles);
        }
        return new ParseResultWithCommentLocations(this.cfas, this.cfaNodes, this.globalDecls, this.parsedFiles, this.acslCommentPositions, this.blocks);
    }

    private void handleFunctionDefinition(GlobalScope actScope, String fileName, IASTFunctionDefinition declaration, ImmutableMap<String, CFunctionDeclaration> functions, ImmutableMap<String, CComplexTypeDeclaration> types, ImmutableMap<String, CTypeDefDeclaration> typedefs, ImmutableMap<String, CSimpleDeclaration> globalVars) throws InterruptedException {
        FunctionScope localScope = new FunctionScope(functions, types, typedefs, globalVars, fileName, this.artificialScope);
        CFAFunctionBuilder functionBuilder = new CFAFunctionBuilder(this.options, this.logger, this.shutdownNotifier, localScope, this.parseContext, this.machine, fileName, this.sideAssignmentStack, this.checkBinding);
        declaration.accept((ASTVisitor)functionBuilder);
        this.shutdownNotifier.shutdownIfNecessary();
        FunctionEntryNode startNode = functionBuilder.getStartNode();
        String functionName = startNode.getFunctionName();
        if (this.cfas.containsKey(functionName)) {
            throw new CFAGenerationRuntimeException("Duplicate function " + functionName + " in " + startNode.getFileLocation() + " and " + ((FunctionEntryNode)this.cfas.get(functionName)).getFileLocation());
        }
        this.cfas.put(functionName, startNode);
        this.cfaNodes.putAll((Object)functionName, functionBuilder.getCfaNodes());
        this.globalDeclarations.addAll(Collections2.transform(functionBuilder.getGlobalDeclarations(), pInput -> Triple.of((ADeclaration)pInput.getFirst(), (String)pInput.getSecond(), actScope)));
        this.globalDecls.addAll(functionBuilder.getGlobalDeclarations());
        this.encounteredAsm |= functionBuilder.didEncounterAsm();
        this.blocks.addAll(functionBuilder.getBlocks());
        functionBuilder.finish();
    }

    public int leave(IASTTranslationUnit ast) {
        if (this.shutdownNotifier.shouldShutdown()) {
            return 2;
        }
        return 3;
    }
}

