/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.core.runtime.CoreException;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.Parsers;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFABuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.EclipseCdtWrapper;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ParseContext;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.Sideassignments;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.CParserException;

class EclipseCParser
implements CParser {
    private final EclipseCdtWrapper eclipseCdt;
    private final MachineModel machine;
    private final LogManager logger;
    private final Parsers.EclipseCParserOptions options;
    private final ShutdownNotifier shutdownNotifier;
    private final Timer parseTimer = new Timer();
    private final Timer cfaTimer = new Timer();
    private static final CharMatcher LEGAL_VAR_NAME_CHARACTERS = CharMatcher.is((char)'_').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();

    public EclipseCParser(LogManager pLogger, Parsers.EclipseCParserOptions pOptions, MachineModel pMachine, ShutdownNotifier pShutdownNotifier) {
        this.logger = pLogger;
        this.machine = pMachine;
        this.options = pOptions;
        this.shutdownNotifier = pShutdownNotifier;
        this.eclipseCdt = new EclipseCdtWrapper(pOptions, pShutdownNotifier);
    }

    private static Path fixPath(Path path) {
        if (!path.toString().isEmpty() && !path.isAbsolute() && path.getParent() == null) {
            return Path.of(".", new String[0]).resolve(path);
        }
        return path;
    }

    private ParseResult parseSomething(List<? extends CParser.FileToParse> pInput, CSourceOriginMapping pSourceOriginMapping, CProgramScope scope, FileParseWrapper pWrapperFunction) throws CParserException, InterruptedException {
        Preconditions.checkNotNull(pInput);
        Preconditions.checkNotNull((Object)pSourceOriginMapping);
        Preconditions.checkNotNull((Object)pWrapperFunction);
        HashMap<Path, Path> fileNameMapping = new HashMap<Path, Path>();
        for (CParser.FileToParse fileToParse : pInput) {
            fileNameMapping.put(EclipseCParser.fixPath(fileToParse.getFileName()), fileToParse.getFileName());
        }
        FixedPathSourceOriginMapping sourceOriginMapping = new FixedPathSourceOriginMapping(pSourceOriginMapping, fileNameMapping);
        ParseContext parseContext = new ParseContext(this.createNiceFileNameFunction(fileNameMapping.keySet()), sourceOriginMapping);
        ArrayList<IASTTranslationUnit> astUnits = new ArrayList<IASTTranslationUnit>(pInput.size());
        for (CParser.FileToParse fileToParse : pInput) {
            Path fileName = EclipseCParser.fixPath(fileToParse.getFileName());
            try {
                astUnits.add(this.parse(pWrapperFunction.wrap(fileName, fileToParse), parseContext));
            }
            catch (IOException e) {
                throw new CParserException("IO failed!", e);
            }
        }
        return this.buildCFA(astUnits, parseContext, scope);
    }

    @Override
    public ParseResult parseFiles(List<String> pFilenames) throws CParserException, InterruptedException {
        return this.parseSomething(Lists.transform(pFilenames, name -> new CParser.FileToParse(Path.of(name, new String[0]))), new CSourceOriginMapping(), CProgramScope.empty(), (pFileName, pContent) -> EclipseCdtWrapper.wrapFile(pFileName));
    }

    @Override
    public ParseResult parseString(List<CParser.FileContentToParse> pCodeFragments, CSourceOriginMapping sourceOriginMapping) throws CParserException, InterruptedException {
        return this.parseSomething(pCodeFragments, sourceOriginMapping, CProgramScope.empty(), (pFileName, pContent) -> {
            Preconditions.checkArgument((boolean)(pContent instanceof CParser.FileContentToParse));
            return EclipseCdtWrapper.wrapCode(pFileName, ((CParser.FileContentToParse)pContent).getFileContent());
        });
    }

    @Override
    public ParseResult parseString(Path pFileName, String pCode, CSourceOriginMapping sourceOriginMapping, Scope pScope) throws CParserException, InterruptedException {
        return this.parseSomething((List<? extends CParser.FileToParse>)ImmutableList.of((Object)new CParser.FileContentToParse(pFileName, pCode)), sourceOriginMapping, pScope instanceof CProgramScope ? (CProgramScope)pScope : CProgramScope.empty(), (fileName, content) -> {
            Preconditions.checkArgument((boolean)(content instanceof CParser.FileContentToParse));
            return EclipseCdtWrapper.wrapCode(fileName, ((CParser.FileContentToParse)content).getFileContent());
        });
    }

    private IASTStatement[] parseCodeFragmentReturnBody(String pCode) throws CParserException, InterruptedException {
        IASTTranslationUnit ast = this.parse(EclipseCdtWrapper.wrapCode(Path.of("fragment", new String[0]), pCode), ParseContext.dummy());
        IASTDeclaration[] declarations = ast.getDeclarations();
        if (declarations == null || declarations.length != 1 || !(declarations[0] instanceof IASTFunctionDefinition)) {
            throw new CParserException("Not a single function: " + ast.getRawSignature());
        }
        IASTFunctionDefinition func = (IASTFunctionDefinition)declarations[0];
        IASTStatement body = func.getBody();
        if (!(body instanceof IASTCompoundStatement)) {
            throw new CParserException("Function has an unexpected " + body.getClass().getSimpleName() + " as body: " + func.getRawSignature());
        }
        return ((IASTCompoundStatement)body).getStatements();
    }

    private ASTConverter prepareTemporaryConverter(Scope scope) {
        Sideassignments sa = new Sideassignments();
        sa.enterBlock();
        return new ASTConverter(this.options, scope, new LogManagerWithoutDuplicates(this.logger), ParseContext.dummy(), this.machine, "", sa);
    }

    @Override
    public CAstNode parseSingleStatement(String pCode, Scope scope) throws CParserException, InterruptedException {
        IASTStatement[] statements = this.parseCodeFragmentReturnBody(pCode);
        ASTConverter converter = this.prepareTemporaryConverter(scope);
        if ((statements.length != 2 || statements[1] != null) && statements.length != 1) {
            throw new CParserException("Not exactly one statement in function body: " + pCode);
        }
        try {
            return converter.convert(statements[0]);
        }
        catch (CFAGenerationRuntimeException e) {
            throw new CParserException(e);
        }
    }

    @Override
    public List<CAstNode> parseStatements(String pCode, Scope scope) throws CParserException, InterruptedException {
        IASTStatement[] statements = this.parseCodeFragmentReturnBody(pCode);
        ASTConverter converter = this.prepareTemporaryConverter(scope);
        ArrayList<CAstNode> nodeList = new ArrayList<CAstNode>(statements.length);
        for (IASTStatement statement : statements) {
            if (statement == null) continue;
            try {
                nodeList.add(converter.convert(statement));
            }
            catch (CFAGenerationRuntimeException e) {
                throw new CParserException(e);
            }
        }
        if (nodeList.size() < 1) {
            throw new CParserException("No statement found in function body: " + pCode);
        }
        return nodeList;
    }

    private IASTTranslationUnit parse(FileContent codeReader, ParseContext parseContext) throws CParserException, InterruptedException {
        this.parseTimer.start();
        try {
            IASTProblem[] result = this.eclipseCdt.getASTTranslationUnit(codeReader);
            for (IASTPreprocessorIncludeStatement iASTPreprocessorIncludeStatement : result.getIncludeDirectives()) {
                if (iASTPreprocessorIncludeStatement.isResolved()) continue;
                if (iASTPreprocessorIncludeStatement.isSystemInclude()) {
                    throw new CFAGenerationRuntimeException("File includes system headers, either preprocess it manually or specify -preprocess.");
                }
                throw parseContext.parseError("Included file " + iASTPreprocessorIncludeStatement.getName() + " is missing", (IASTNode)iASTPreprocessorIncludeStatement);
            }
            int n = 0;
            IASTProblem[] iASTProblemArray = result.getPreprocessorProblems();
            int n2 = iASTProblemArray.length;
            if (n < n2) {
                IASTTranslationUnit iASTTranslationUnit = iASTProblemArray[n];
                throw parseContext.parseError((IASTProblem)iASTTranslationUnit);
            }
            iASTProblemArray = result;
            return iASTProblemArray;
        }
        catch (CoreException | CFAGenerationRuntimeException e) {
            throw new CParserException(e);
        }
        finally {
            this.parseTimer.stop();
        }
    }

    private ParseResult buildCFA(List<IASTTranslationUnit> asts, ParseContext parseContext, Scope pScope) throws CParserException, InterruptedException {
        Preconditions.checkArgument((!asts.isEmpty() ? 1 : 0) != 0);
        this.cfaTimer.start();
        try {
            CFABuilder builder = new CFABuilder(this.options, this.logger, this.shutdownNotifier, parseContext, this.machine);
            if (asts.size() == 1) {
                builder.analyzeTranslationUnit(asts.get(0), "", pScope);
            } else {
                for (IASTTranslationUnit ast : asts) {
                    String staticVariablePrefix = LEGAL_VAR_NAME_CHARACTERS.negate().replaceFrom((CharSequence)parseContext.mapFileNameToNameForHumans(ast.getFilePath()), (CharSequence)"_");
                    builder.analyzeTranslationUnit(ast, staticVariablePrefix, pScope);
                }
            }
            ParseResult parseResult = builder.createCFA();
            return parseResult;
        }
        catch (CFAGenerationRuntimeException e) {
            throw new CParserException(e);
        }
        finally {
            this.cfaTimer.stop();
        }
    }

    private Function<String, String> createNiceFileNameFunction(Collection<Path> pFileNames) {
        Iterator fileNames = Iterators.transform(pFileNames.iterator(), Path::toString);
        if (pFileNames.size() == 1) {
            String mainFileName = (String)fileNames.next();
            return pInput -> mainFileName.equals(pInput) ? "" : pInput;
        }
        String commonStringPrefix = (String)fileNames.next();
        while (fileNames.hasNext()) {
            commonStringPrefix = Strings.commonPrefix((CharSequence)commonStringPrefix, (CharSequence)((CharSequence)fileNames.next()));
        }
        int pos = commonStringPrefix.lastIndexOf(File.separator);
        String commonPathPrefix = pos < 0 ? commonStringPrefix : commonStringPrefix.substring(0, pos + 1);
        return pInput -> {
            if (pInput.isEmpty()) {
                return pInput;
            }
            if (pInput.charAt(0) == '\"' && pInput.charAt(pInput.length() - 1) == '\"') {
                pInput = pInput.substring(1, pInput.length() - 1);
            }
            if (pInput.startsWith(commonPathPrefix)) {
                return pInput.substring(commonPathPrefix.length()).intern();
            }
            return pInput.intern();
        };
    }

    @Override
    public Timer getParseTime() {
        return this.parseTimer;
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.cfaTimer;
    }

    private static class FixedPathSourceOriginMapping
    extends CSourceOriginMapping {
        private final CSourceOriginMapping delegate;
        private final ImmutableMap<Path, Path> fileNameMapping;

        FixedPathSourceOriginMapping(CSourceOriginMapping pDelegate, Map<Path, Path> pFileNameMapping) {
            this.delegate = pDelegate;
            this.fileNameMapping = ImmutableMap.copyOf(pFileNameMapping);
        }

        @Override
        public CSourceOriginMapping.CodePosition getOriginLineFromAnalysisCodeLine(Path pAnalysisFile, int pAnalysisCodeLine) {
            Path analysisFile = (Path)this.fileNameMapping.getOrDefault((Object)pAnalysisFile, (Object)pAnalysisFile);
            CSourceOriginMapping.CodePosition result = this.delegate.getOriginLineFromAnalysisCodeLine(analysisFile, pAnalysisCodeLine);
            if (result.getFileName().equals(analysisFile)) {
                result = result.withFileName(pAnalysisFile);
            }
            return result;
        }

        @Override
        public boolean isMappingToIdenticalLineNumbers() {
            return this.delegate.isMappingToIdenticalLineNumbers();
        }
    }

    private static interface FileParseWrapper {
        public FileContent wrap(Path var1, CParser.FileToParse var2) throws IOException;
    }
}

