/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ShutdownNotifierLogAdapter;

public class EclipseCdtWrapper {
    private static final int PARSER_OPTIONS = 4;
    private final ILanguage language;
    private final IParserLogService parserLog;
    private final ShutdownNotifier shutdownNotifier;

    public EclipseCdtWrapper(CParser.ParserOptions pOptions, ShutdownNotifier pShutdownNotifier) {
        this.shutdownNotifier = pShutdownNotifier;
        this.parserLog = new ShutdownNotifierLogAdapter(this.shutdownNotifier);
        switch (pOptions.getDialect()) {
            case C99: {
                this.language = new CLanguage((ICParserExtensionConfiguration)new ANSICParserExtensionConfiguration());
                break;
            }
            case GNUC: {
                this.language = GCCLanguage.getDefault();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown C dialect");
            }
        }
    }

    static FileContent wrapCode(Path pFileName, String pCode) {
        return FileContent.create((String)pFileName.toString(), (char[])pCode.toCharArray());
    }

    public static FileContent wrapFile(Path pFileName) throws IOException {
        String code = Files.readString(pFileName, Charset.defaultCharset());
        return EclipseCdtWrapper.wrapCode(pFileName, code);
    }

    public IASTTranslationUnit getASTTranslationUnit(FileContent pCode) throws CFAGenerationRuntimeException, CoreException, InterruptedException {
        try {
            IASTTranslationUnit iASTTranslationUnit = this.language.getASTTranslationUnit(pCode, StubScannerInfo.instance, (IncludeFileContentProvider)FileContentProvider.instance, null, 4, this.parserLog);
            return iASTTranslationUnit;
        }
        finally {
            this.shutdownNotifier.shutdownIfNecessary();
        }
    }

    private static class FileContentProvider
    extends InternalFileContentProvider {
        private static final InternalFileContentProvider instance = new FileContentProvider();

        private FileContentProvider() {
        }

        public InternalFileContent getContentForInclusion(String pFilePath, IMacroDictionary pMacroDictionary) {
            return InternalParserUtil.createExternalFileContent((String)pFilePath, (String)InternalParserUtil.SYSTEM_DEFAULT_ENCODING);
        }

        public InternalFileContent getContentForInclusion(IIndexFileLocation pIfl, String pAstPath) {
            return InternalParserUtil.createFileContent((IIndexFileLocation)pIfl);
        }
    }

    private static class StubScannerInfo
    implements IScannerInfo {
        private static final ImmutableMap<String, String> MACROS;
        private static final IScannerInfo instance;

        private StubScannerInfo() {
        }

        public Map<String, String> getDefinedSymbols() {
            return MACROS;
        }

        public String[] getIncludePaths() {
            return new String[0];
        }

        static {
            ImmutableMap.Builder macrosBuilder = ImmutableMap.builder();
            macrosBuilder.put((Object)"_Static_assert(c, m)", (Object)"");
            macrosBuilder.put((Object)"_Noreturn", (Object)"");
            macrosBuilder.put((Object)"__builtin_constant_p", (Object)"__builtin_constant_p");
            macrosBuilder.put((Object)"__builtin_types_compatible_p(t1,t2)", (Object)"__builtin_types_compatible_p(({t1 arg1; arg1;}), ({t2 arg2; arg2;}))");
            macrosBuilder.put((Object)"__offsetof__", (Object)"__offsetof__");
            macrosBuilder.put((Object)"__builtin_offsetof(t,f)", (Object)"__builtin_offsetof(((t){}).f)");
            macrosBuilder.put((Object)"__func__", (Object)"\"__func__\"");
            macrosBuilder.put((Object)"__FUNCTION__", (Object)"\"__FUNCTION__\"");
            macrosBuilder.put((Object)"__PRETTY_FUNCTION__", (Object)"\"__PRETTY_FUNCTION__\"");
            macrosBuilder.put((Object)"__builtin_va_arg(ap,t)", (Object)"(t)__builtin_va_arg(ap)");
            macrosBuilder.put((Object)"__GNUC__", (Object)"4");
            macrosBuilder.put((Object)"__GNUC_MINOR__", (Object)"7");
            macrosBuilder.put((Object)"_Float128", (Object)"__float128");
            macrosBuilder.put((Object)"_Float32", (Object)"float");
            macrosBuilder.put((Object)"_Float32x", (Object)"double");
            macrosBuilder.put((Object)"_Float64", (Object)"double");
            macrosBuilder.put((Object)"_Float64x", (Object)"long double");
            MACROS = macrosBuilder.buildOrThrow();
            instance = new StubScannerInfo();
        }
    }

    private static class CLanguage
    extends GCCLanguage {
        private final ICParserExtensionConfiguration parserConfig;

        public CLanguage(ICParserExtensionConfiguration pParserConfig) {
            this.parserConfig = pParserConfig;
        }

        protected ICParserExtensionConfiguration getParserExtensionConfiguration() {
            return this.parserConfig;
        }
    }
}

