/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.AbstractScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

class FunctionScope
extends AbstractScope {
    private final Scope artificialScope;
    private final Map<String, CFunctionDeclaration> localFunctions = new HashMap<String, CFunctionDeclaration>();
    private final Map<String, CFunctionDeclaration> globalFunctions;
    private final Deque<Map<String, CComplexTypeDeclaration>> typesStack = new ArrayDeque<Map<String, CComplexTypeDeclaration>>();
    private final Map<String, CTypeDefDeclaration> typedefs;
    private final Deque<Map<String, CVariableDeclaration>> labelsStack = new ArrayDeque<Map<String, CVariableDeclaration>>();
    private final Deque<Map<String, CFALabelNode>> labelsNodeStack = new ArrayDeque<Map<String, CFALabelNode>>();
    private final Deque<Map<String, CSimpleDeclaration>> varsStack = new ArrayDeque<Map<String, CSimpleDeclaration>>();
    private final Deque<Map<String, CSimpleDeclaration>> varsStackWitNewNames = new ArrayDeque<Map<String, CSimpleDeclaration>>();
    private final Deque<Map<String, CSimpleDeclaration>> varsList = new ArrayDeque<Map<String, CSimpleDeclaration>>();
    private final Deque<Map<String, CSimpleDeclaration>> varsListWithNewNames = new ArrayDeque<Map<String, CSimpleDeclaration>>();
    private CFunctionDeclaration currentFunction = null;
    private Optional<CVariableDeclaration> returnVariable = null;

    public FunctionScope(ImmutableMap<String, CFunctionDeclaration> pFunctions, ImmutableMap<String, CComplexTypeDeclaration> pTypes, ImmutableMap<String, CTypeDefDeclaration> pTypedefs, ImmutableMap<String, CSimpleDeclaration> pGlobalVars, String currentFile, Scope pArtificialScope) {
        super(currentFile);
        this.globalFunctions = pFunctions;
        this.typedefs = pTypedefs;
        this.typesStack.addLast((Map<String, CComplexTypeDeclaration>)pTypes);
        this.varsStack.push((Map<String, CSimpleDeclaration>)pGlobalVars);
        this.varsStack.push((Map<String, CSimpleDeclaration>)pGlobalVars);
        this.varsList.push((Map<String, CSimpleDeclaration>)pGlobalVars);
        this.varsListWithNewNames.push((Map<String, CSimpleDeclaration>)pGlobalVars);
        this.artificialScope = pArtificialScope;
        this.enterBlock();
    }

    public FunctionScope() {
        this((ImmutableMap<String, CFunctionDeclaration>)ImmutableMap.of(), (ImmutableMap<String, CComplexTypeDeclaration>)ImmutableMap.of(), (ImmutableMap<String, CTypeDefDeclaration>)ImmutableMap.of(), (ImmutableMap<String, CSimpleDeclaration>)ImmutableMap.of(), "", CProgramScope.empty());
    }

    @Override
    public boolean isGlobalScope() {
        return false;
    }

    public void enterFunction(CFunctionDeclaration pFuncDef) {
        Preconditions.checkState((this.currentFunction == null ? 1 : 0) != 0);
        this.currentFunction = (CFunctionDeclaration)Preconditions.checkNotNull((Object)pFuncDef);
        String functionName = pFuncDef.getName();
        Preconditions.checkArgument((this.globalFunctions.containsKey(functionName) || this.localFunctions.containsKey(functionName) ? 1 : 0) != 0, (String)"function '%s' not available in global scope (%s) or local scope (%s)", (Object)functionName, this.globalFunctions.keySet(), this.localFunctions.keySet());
        if (this.currentFunction.getType().getReturnType().getCanonicalType() instanceof CVoidType) {
            this.returnVariable = Optional.empty();
        } else {
            String name = "__retval__";
            this.returnVariable = Optional.of(new CVariableDeclaration(this.currentFunction.getFileLocation(), false, CStorageClass.AUTO, this.currentFunction.getType().getReturnType(), name, name, this.createScopedNameOf(name), null));
        }
    }

    public void enterBlock() {
        this.typesStack.addLast(new HashMap());
        this.labelsStack.addLast(new HashMap());
        this.labelsNodeStack.addLast(new HashMap());
        this.varsStack.addLast(new HashMap());
        this.varsStackWitNewNames.addLast(new HashMap());
        this.varsList.addLast(this.varsStack.getLast());
        this.varsListWithNewNames.addLast(this.varsStackWitNewNames.getLast());
    }

    public void leaveBlock() {
        Preconditions.checkState((this.varsStack.size() > 2 ? 1 : 0) != 0);
        this.varsStack.removeLast();
        this.varsStackWitNewNames.removeLast();
        this.typesStack.removeLast();
        this.labelsStack.removeLast();
        this.labelsNodeStack.removeLast();
    }

    public Collection<CSimpleDeclaration> getVariablesOfMostLocalScope() {
        return this.getVariablesOfMostLocalScopes().iterator().next();
    }

    public Iterable<Collection<CSimpleDeclaration>> getVariablesOfMostLocalScopes() {
        Preconditions.checkState((!this.varsStackWitNewNames.isEmpty() ? 1 : 0) != 0, (Object)"at least function scope should be open");
        return Iterables.transform(() -> this.varsStackWitNewNames.descendingIterator(), vars -> Collections.unmodifiableCollection(vars.values()));
    }

    @Override
    public boolean variableNameInUse(String name) {
        Preconditions.checkNotNull((Object)name);
        Iterator<Map<String, CSimpleDeclaration>> it = this.varsListWithNewNames.descendingIterator();
        while (it.hasNext()) {
            Map<String, CSimpleDeclaration> vars = it.next();
            if (vars.get(name) == null) continue;
            return true;
        }
        return this.artificialScope.variableNameInUse(name);
    }

    @Override
    public CSimpleDeclaration lookupVariable(String name) {
        Preconditions.checkNotNull((Object)name);
        Iterator<Map<String, CSimpleDeclaration>> it = this.varsStack.descendingIterator();
        while (it.hasNext()) {
            Map<String, CSimpleDeclaration> vars = it.next();
            CSimpleDeclaration binding = vars.get(name);
            if (binding == null) continue;
            return binding;
        }
        return this.artificialScope.lookupVariable(name);
    }

    @Override
    public @Nullable CFunctionDeclaration lookupFunction(String name) {
        Preconditions.checkNotNull((Object)name);
        CFunctionDeclaration returnDecl = this.localFunctions.get(name);
        if (returnDecl != null) {
            return returnDecl;
        }
        returnDecl = this.globalFunctions.get(name);
        if (returnDecl != null) {
            return returnDecl;
        }
        return this.artificialScope.lookupFunction(name);
    }

    @Override
    public @Nullable CComplexType lookupType(String name) {
        Preconditions.checkNotNull((Object)name);
        Iterator<Map<String, CComplexTypeDeclaration>> it = this.typesStack.descendingIterator();
        while (it.hasNext()) {
            Map<String, CComplexTypeDeclaration> types = it.next();
            CComplexTypeDeclaration declaration = types.get(this.getFileSpecificTypeName(name));
            if (declaration != null) {
                return declaration.getType();
            }
            declaration = types.get(name);
            if (declaration == null) continue;
            return declaration.getType();
        }
        return this.artificialScope.lookupType(name);
    }

    @Override
    public @Nullable CType lookupTypedef(String name) {
        Preconditions.checkNotNull((Object)name);
        CTypeDefDeclaration declaration = this.typedefs.get(name);
        if (declaration != null) {
            return declaration.getType();
        }
        return this.artificialScope.lookupTypedef(name);
    }

    @Override
    public String createScopedNameOf(String pName) {
        if (!this.artificialScope.isGlobalScope()) {
            return this.artificialScope.createScopedNameOf(pName);
        }
        return FunctionScope.createQualifiedName(this.getCurrentFunctionName(), pName);
    }

    public static String createQualifiedName(String pFunction, String pName) {
        return (pFunction + "::" + pName).intern();
    }

    @Override
    public void registerDeclaration(CSimpleDeclaration declaration) {
        assert (declaration instanceof CVariableDeclaration || declaration instanceof CEnumType.CEnumerator || declaration instanceof CParameterDeclaration) : "Tried to register a declaration which does not define a name in the standard namespace: " + declaration;
        assert (!(declaration.getType() instanceof CFunctionTypeWithNames));
        String name = declaration.getOrigName();
        assert (name != null);
        Map<String, CSimpleDeclaration> vars = this.varsStack.getLast();
        Map<String, CSimpleDeclaration> varsWithNewNames = this.varsStackWitNewNames.getLast();
        if (vars.containsKey(name)) {
            throw new CFAGenerationRuntimeException("Variable " + name + " already declared", declaration);
        }
        vars.put(name, declaration);
        varsWithNewNames.put(declaration.getName(), declaration);
    }

    @Override
    public boolean registerTypeDeclaration(CComplexTypeDeclaration declaration) {
        Preconditions.checkArgument((declaration.getName() == null ? 1 : 0) != 0);
        String typeName = declaration.getType().getQualifiedName();
        if (this.lookupType(typeName) != null) {
            throw new CFAGenerationRuntimeException("Shadowing types are currently not supported", declaration);
        }
        this.typesStack.peekLast().put(typeName, declaration);
        return true;
    }

    public CVariableDeclaration lookupLocalLabel(String name) {
        Preconditions.checkNotNull((Object)name);
        Iterator<Map<String, CVariableDeclaration>> it = this.labelsStack.descendingIterator();
        while (it.hasNext()) {
            Map<String, CVariableDeclaration> labels = it.next();
            CVariableDeclaration label = labels.get(name);
            if (label == null) continue;
            return label;
        }
        return null;
    }

    public void registerLocalLabel(CVariableDeclaration label) {
        Preconditions.checkNotNull((Object)label.getName());
        String labelName = label.getOrigName();
        if (this.containsLocalLabel(labelName)) {
            throw new CFAGenerationRuntimeException("Label " + labelName + " already in use");
        }
        this.labelsStack.peekLast().put(labelName, label);
    }

    public boolean containsLocalLabel(String labelName) {
        return this.labelsStack.peekLast().containsKey(labelName);
    }

    public boolean containsLabelCFANode(CFALabelNode node) {
        return this.labelsNodeStack.peekLast().containsKey(node.getLabel());
    }

    public void addLabelCFANode(CFALabelNode node) {
        this.labelsNodeStack.peekLast().put(node.getLabel(), node);
    }

    public CFALabelNode lookupLocalLabelNode(String name) {
        Iterator<Map<String, CFALabelNode>> it = this.labelsNodeStack.descendingIterator();
        while (it.hasNext()) {
            Map<String, CFALabelNode> nodes = it.next();
            CFALabelNode node = nodes.get(name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void registerLocalFunction(CFunctionDeclaration function) {
        this.localFunctions.put(function.getName(), function);
    }

    public String getCurrentFunctionName() {
        Preconditions.checkState((this.currentFunction != null ? 1 : 0) != 0);
        return this.currentFunction.getOrigName();
    }

    public Optional<CVariableDeclaration> getReturnVariable() {
        Preconditions.checkState((this.returnVariable != null ? 1 : 0) != 0);
        return this.returnVariable;
    }

    public String toString() {
        return "Functions: " + Joiner.on((char)' ').join(this.globalFunctions.keySet()) + Joiner.on((char)' ').join(this.localFunctions.keySet());
    }
}

