/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.cdt.core.dom.ast.IType;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.AbstractScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ProgramDeclarations;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

class GlobalScope
extends AbstractScope {
    private final Scope fallbackScope;
    private final Map<String, CSimpleDeclaration> globalVars;
    private final Map<String, CSimpleDeclaration> globalVarsWithNewNames;
    private final Map<String, CFunctionDeclaration> functions;
    private final Map<String, CComplexTypeDeclaration> types;
    private final Map<String, CTypeDefDeclaration> typedefs;
    private final ProgramDeclarations programDeclarations;

    public GlobalScope(Map<String, CSimpleDeclaration> globalVars, Map<String, CSimpleDeclaration> globalVarsWithNewNames, Map<String, CFunctionDeclaration> functions, Map<String, CComplexTypeDeclaration> types, Map<String, CTypeDefDeclaration> typedefs, ProgramDeclarations programDeclarations, String currentFile, Scope pFallbackScope) {
        super(currentFile);
        this.globalVars = globalVars;
        this.globalVarsWithNewNames = globalVarsWithNewNames;
        this.functions = functions;
        this.types = types;
        this.typedefs = typedefs;
        this.programDeclarations = programDeclarations;
        this.fallbackScope = pFallbackScope;
    }

    public GlobalScope() {
        this(new HashMap<String, CSimpleDeclaration>(), new HashMap<String, CSimpleDeclaration>(), new HashMap<String, CFunctionDeclaration>(), new HashMap<String, CComplexTypeDeclaration>(), new HashMap<String, CTypeDefDeclaration>(), new ProgramDeclarations(), "", CProgramScope.empty());
    }

    @Override
    public boolean isGlobalScope() {
        return true;
    }

    @Override
    public boolean variableNameInUse(String name) {
        return this.globalVarsWithNewNames.containsKey(Preconditions.checkNotNull((Object)name)) || this.programDeclarations.variableNameInUse(name) || this.fallbackScope.variableNameInUse(name);
    }

    @Override
    public CSimpleDeclaration lookupVariable(String name) {
        CSimpleDeclaration result = this.globalVars.get(Preconditions.checkNotNull((Object)name));
        if (result == null) {
            result = this.fallbackScope.lookupVariable(name);
        }
        return result;
    }

    @Override
    public @Nullable CFunctionDeclaration lookupFunction(String name) {
        CFunctionDeclaration result = this.functions.get(Preconditions.checkNotNull((Object)name));
        if (result == null) {
            result = this.fallbackScope.lookupFunction(name);
        }
        return result;
    }

    @Override
    public @Nullable CComplexType lookupType(String name) {
        CComplexTypeDeclaration declaration;
        Preconditions.checkNotNull((Object)name);
        if (this.isFileSpecificTypeName(name)) {
            declaration = this.types.get(name);
            name = this.removeFileSpecificPartOfTypeName(name);
        } else {
            declaration = this.types.get(this.getFileSpecificTypeName(name));
        }
        if (declaration != null) {
            return declaration.getType();
        }
        declaration = this.types.get(name);
        if (declaration != null) {
            return declaration.getType();
        }
        return this.fallbackScope.lookupType(name);
    }

    @Override
    public CType lookupTypedef(String name) {
        Preconditions.checkNotNull((Object)name);
        CTypeDefDeclaration declaration = this.typedefs.get(this.getFileSpecificTypeName(name));
        if (declaration != null) {
            return declaration.getType();
        }
        declaration = this.typedefs.get(name);
        if (declaration != null) {
            return declaration.getType();
        }
        return this.fallbackScope.lookupTypedef(name);
    }

    public @Nullable CTypeDefDeclaration lookupTypedefForTypename(String name) {
        for (CTypeDefDeclaration d : this.typedefs.values()) {
            if (!(d.getType() instanceof CComplexType) || !((CComplexType)d.getType()).getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    @Override
    public String createScopedNameOf(String pName) {
        return pName;
    }

    public void registerFunctionDeclaration(CFunctionDeclaration declaration) {
        String name = declaration.getName();
        assert (name != null);
        if (this.globalVars.containsKey(name)) {
            throw new CFAGenerationRuntimeException("Name of global variable " + name + " from " + this.globalVars.get(name).getFileLocation() + " is reused as function declaration", declaration);
        }
        this.functions.put(name, declaration);
        this.programDeclarations.registerFunctionDeclaration(declaration);
    }

    @Override
    public void registerDeclaration(CSimpleDeclaration declaration) {
        assert (declaration instanceof CVariableDeclaration || declaration instanceof CEnumType.CEnumerator) : "Tried to register a declaration which does not define a name in the standard namespace: " + declaration;
        assert (!(declaration.getType().getCanonicalType() instanceof CFunctionType)) : "Tried to register a variable with the type of a function: " + declaration;
        String name = declaration.getOrigName();
        assert (name != null);
        if (this.functions.containsKey(name)) {
            throw new CFAGenerationRuntimeException("Name of function " + name + " from " + this.functions.get(name).getFileLocation() + " is reused as identifier in global scope", declaration);
        }
        this.globalVars.put(name, declaration);
        this.globalVarsWithNewNames.put(declaration.getName(), declaration);
    }

    @Override
    public boolean registerTypeDeclaration(CComplexTypeDeclaration declaration) {
        boolean programContainsExactNamedType;
        CComplexType type = declaration.getType();
        String name = type.getQualifiedName();
        boolean isOnlyElaboratedType = type.getCanonicalType() instanceof CElaboratedType;
        if (type.getName().isEmpty()) {
            return true;
        }
        if (type instanceof CElaboratedType) {
            if (isOnlyElaboratedType) assert (this.isFileSpecificTypeName(type.getName())) : "The type should have the correct name before registering it.";
            if (this.types.containsKey(this.getFileSpecificTypeName(name)) || this.types.containsKey(this.removeFileSpecificPartOfTypeName(name))) {
                return false;
            }
        }
        boolean programContainsEqualType = !isOnlyElaboratedType && this.programDeclarations.containsEqualType(declaration);
        boolean bl = programContainsExactNamedType = !isOnlyElaboratedType && this.programDeclarations.containsTypeWithExactName(name);
        if (this.types.containsKey(this.getFileSpecificTypeName(name))) {
            assert (!(type.getCanonicalType() instanceof CElaboratedType));
            String fileSpecificTypeName = this.getFileSpecificTypeName(name);
            CComplexTypeDeclaration oldDeclaration = this.types.get(fileSpecificTypeName);
            CComplexType oldType = oldDeclaration.getType();
            if (!(oldType.getCanonicalType() instanceof CElaboratedType) && oldType.getCanonicalType() != type) {
                throw new CFAGenerationRuntimeException("Redeclaring " + name + " in " + declaration.getFileLocation() + ", originally declared in " + oldDeclaration.getFileLocation());
            }
            if (programContainsEqualType) {
                CComplexTypeDeclaration oldProgDeclaration = this.programDeclarations.getEqualType(declaration);
                this.overwriteTypeIfNecessary(type, oldProgDeclaration.getType());
                type = oldProgDeclaration.getType();
            } else if (programContainsExactNamedType) {
                declaration = this.createRenamedTypeDeclaration(declaration);
                name = declaration.getType().getQualifiedName();
                this.overwriteTypeIfNecessary(type, declaration.getType());
            }
            if (oldType.getCanonicalType() instanceof CElaboratedType) {
                ((CElaboratedType)oldType).setRealType(type);
            }
            this.types.remove(fileSpecificTypeName);
        } else if (programContainsEqualType) {
            declaration = this.programDeclarations.getEqualType(declaration);
            this.overwriteTypeIfNecessary(type, declaration.getType());
        } else if (programContainsExactNamedType) {
            declaration = this.createRenamedTypeDeclaration(declaration);
            name = declaration.getType().getQualifiedName();
            this.overwriteTypeIfNecessary(type, declaration.getType());
        }
        if (!programContainsEqualType) {
            this.programDeclarations.registerTypeDeclaration(declaration);
        }
        this.types.put(name, declaration);
        return true;
    }

    private void overwriteTypeIfNecessary(CType oldType, CType newType) {
        IType iType = ASTTypeConverter.getTypeFromTypeConversion(oldType, this.currentFile);
        if (iType != null) {
            ASTTypeConverter.overwriteType(iType, newType, this.currentFile);
        }
    }

    private CComplexTypeDeclaration createRenamedTypeDeclaration(CComplexTypeDeclaration oldDeclaration) {
        assert (!this.isFileSpecificTypeName(oldDeclaration.getType().getName())) : "The type is already renamed to its file specific version.";
        CComplexType oldType = (CComplexType)oldDeclaration.getType().getCanonicalType();
        return new CComplexTypeDeclaration(oldDeclaration.getFileLocation(), oldDeclaration.isGlobal(), this.createRenamedType(oldType));
    }

    private CComplexType createRenamedType(CComplexType oldType) {
        assert (!this.isFileSpecificTypeName(oldType.getName())) : "The type is already renamed to its file specific version.";
        String newName = this.getFileSpecificTypeName(oldType.getName());
        if (oldType instanceof CCompositeType) {
            CCompositeType oldCompositeType = (CCompositeType)oldType;
            CCompositeType renamedCompositeType = new CCompositeType(oldType.isConst(), oldType.isVolatile(), oldType.getKind(), newName, oldType.getOrigName());
            CElaboratedType renamedElaboratedType = new CElaboratedType(renamedCompositeType.isConst(), renamedCompositeType.isVolatile(), renamedCompositeType.getKind(), renamedCompositeType.getName(), renamedCompositeType.getOrigName(), renamedCompositeType);
            this.overwriteTypeIfNecessary(oldType, renamedElaboratedType);
            ArrayList<CCompositeType.CCompositeTypeMemberDeclaration> newMembers = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(oldCompositeType.getMembers().size());
            for (CCompositeType.CCompositeTypeMemberDeclaration decl : oldCompositeType.getMembers()) {
                if (decl.getType() instanceof CPointerType) {
                    newMembers.add(new CCompositeType.CCompositeTypeMemberDeclaration(this.createPointerField((CPointerType)decl.getType(), oldType, renamedElaboratedType), decl.getName()));
                    continue;
                }
                newMembers.add(new CCompositeType.CCompositeTypeMemberDeclaration(decl.getType(), decl.getName()));
            }
            renamedCompositeType.setMembers(newMembers);
            return renamedCompositeType;
        }
        if (oldType instanceof CEnumType) {
            ArrayList<CEnumType.CEnumerator> list = new ArrayList<CEnumType.CEnumerator>(((CEnumType)oldType).getEnumerators().size());
            for (CEnumType.CEnumerator c : ((CEnumType)oldType).getEnumerators()) {
                CEnumType.CEnumerator newC = new CEnumType.CEnumerator(c.getFileLocation(), c.getName(), c.getQualifiedName(), c.getType(), c.hasValue() ? Long.valueOf(c.getValue()) : null);
                list.add(newC);
            }
            CEnumType renamedEnumType = new CEnumType(oldType.isConst(), oldType.isVolatile(), list, newName, oldType.getOrigName());
            for (CEnumType.CEnumerator enumValue : renamedEnumType.getEnumerators()) {
                enumValue.setEnum(renamedEnumType);
            }
            return renamedEnumType;
        }
        if (oldType instanceof CElaboratedType) {
            CComplexType renamedRealType = null;
            if (((CElaboratedType)oldType).getRealType() != null) {
                renamedRealType = this.createRenamedType(((CElaboratedType)oldType).getRealType());
            }
            return new CElaboratedType(oldType.isConst(), oldType.isVolatile(), oldType.getKind(), newName, oldType.getOrigName(), renamedRealType);
        }
        throw new AssertionError((Object)"Unhandled CComplexType.");
    }

    private CType createPointerField(CPointerType oldType, CType eqType, CType newType) {
        if (oldType.getType() instanceof CPointerType) {
            return new CPointerType(oldType.isConst(), oldType.isVolatile(), this.createPointerField((CPointerType)oldType.getType(), eqType, newType));
        }
        if (oldType.getType().getCanonicalType().equals(eqType.getCanonicalType())) {
            return new CPointerType(oldType.isConst(), oldType.isVolatile(), newType);
        }
        return new CPointerType(oldType.isConst(), oldType.isVolatile(), oldType.getType());
    }

    public boolean registerTypeDeclaration(CTypeDefDeclaration declaration) {
        String name = declaration.getName();
        if (this.typedefs.containsKey(name)) {
            CTypeDefDeclaration oldDeclaration = this.typedefs.get(name);
            CType type = declaration.getType();
            CType oldType = oldDeclaration.getType();
            if (oldType.getCanonicalType() instanceof CElaboratedType && type.getCanonicalType() instanceof CCompositeType && ((CElaboratedType)oldType).getName().equals(((CCompositeType)type).getName())) {
                this.typedefs.put(name, declaration);
                return true;
            }
            if (!type.getCanonicalType().equals(oldType.getCanonicalType())) {
                throw new CFAGenerationRuntimeException("Redeclaring " + name + " in " + declaration.getFileLocation() + " with type " + type.toASTString("") + ", originally declared in " + oldDeclaration.getFileLocation() + " with type " + oldType.toASTString(""));
            }
            return false;
        }
        this.typedefs.put(name, declaration);
        return true;
    }

    public ImmutableMap<String, CFunctionDeclaration> getFunctions() {
        return ImmutableMap.copyOf(this.functions);
    }

    public ImmutableMap<String, CComplexTypeDeclaration> getTypes() {
        return ImmutableMap.copyOf(this.types);
    }

    public ImmutableMap<String, CSimpleDeclaration> getGlobalVars() {
        return ImmutableMap.copyOf(this.globalVars);
    }

    public ImmutableMap<String, CTypeDefDeclaration> getTypeDefs() {
        return ImmutableMap.copyOf(this.typedefs);
    }

    public String toString() {
        return "Functions: " + Joiner.on((char)' ').join(this.functions.keySet());
    }
}

