/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import java.nio.file.Path;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;

class ParseContext {
    private static final CharMatcher SEMICOLON = CharMatcher.is((char)';');
    private final Function<String, String> niceFileNameFunction;
    private final CSourceOriginMapping sourceOriginMapping;

    ParseContext(Function<String, String> pNiceFileNameFunction, CSourceOriginMapping pSourceOriginMapping) {
        this.niceFileNameFunction = pNiceFileNameFunction;
        this.sourceOriginMapping = pSourceOriginMapping;
    }

    static ParseContext dummy() {
        return new ParseContext((Function<String, String>)Functions.identity(), new CSourceOriginMapping());
    }

    CFAGenerationRuntimeException parseError(String msg, CAstNode astNode) {
        throw new CFAGenerationRuntimeException((String)(astNode == null ? msg : astNode.getFileLocation() + ": " + msg + ": " + astNode.toASTString()));
    }

    CFAGenerationRuntimeException parseError(String msg, IASTNode node) {
        throw new CFAGenerationRuntimeException(node == null ? msg : this.createMessage(msg, node));
    }

    CFAGenerationRuntimeException parseError(IASTProblem problem) {
        throw new CFAGenerationRuntimeException(this.createMessage(problem.getMessage(), (IASTNode)problem));
    }

    <P extends IASTProblemHolder & IASTNode> CFAGenerationRuntimeException parseError(P problem) {
        throw new CFAGenerationRuntimeException(this.createMessage(problem.getProblem().getMessage(), problem));
    }

    private String createMessage(String msg, IASTNode node) {
        IASTNode fullLine;
        StringBuilder sb = new StringBuilder();
        FileLocation fileLocation = this.getLocation(node);
        if (fileLocation.isRealLocation()) {
            sb.append(fileLocation);
            sb.append(": ");
        }
        if (Strings.isNullOrEmpty((String)msg)) {
            sb.append("Problem");
        } else {
            sb.append(msg);
        }
        sb.append(": ");
        String rawSignature = node.getRawSignature();
        sb.append(rawSignature);
        for (fullLine = node; fullLine != null && !(fullLine instanceof IASTStatement) && !(fullLine instanceof IASTDeclaration); fullLine = fullLine.getParent()) {
        }
        if (fullLine != null && fullLine != node) {
            String lineRawSignature = fullLine.getRawSignature();
            String codeWithoutWhitespace = CharMatcher.whitespace().removeFrom((CharSequence)rawSignature);
            String lineWithoutWhitespace = CharMatcher.whitespace().removeFrom((CharSequence)lineRawSignature);
            if (!(codeWithoutWhitespace = SEMICOLON.trimFrom((CharSequence)codeWithoutWhitespace)).equals(lineWithoutWhitespace = SEMICOLON.trimFrom((CharSequence)lineWithoutWhitespace))) {
                sb.append(" (full line is ");
                sb.append(lineRawSignature);
                sb.append(")");
            }
        }
        return sb.toString();
    }

    FileLocation getLocation(IASTNode n) {
        IASTFileLocation l = n.getFileLocation();
        if (l == null) {
            return FileLocation.DUMMY;
        }
        Path fileName = Path.of(l.getFileName(), new String[0]);
        int startingLineInInput = l.getStartingLineNumber();
        int endingLineInInput = l.getEndingLineNumber();
        CSourceOriginMapping.CodePosition startingInOrigin = this.sourceOriginMapping.getOriginLineFromAnalysisCodeLine(fileName, startingLineInInput);
        int startingLineInOrigin = startingInOrigin.getLineNumber();
        CSourceOriginMapping.CodePosition endingInOrigin = this.sourceOriginMapping.getOriginLineFromAnalysisCodeLine(fileName, endingLineInInput);
        int endingLineInOrigin = endingInOrigin.getLineNumber();
        if (!startingInOrigin.getFileName().equals(endingInOrigin.getFileName())) {
            return FileLocation.MULTIPLE_FILES;
        }
        Path originFileName = startingInOrigin.getFileName();
        boolean offsetRelatedToOrigin = this.sourceOriginMapping.isMappingToIdenticalLineNumbers();
        return new FileLocation(originFileName, this.mapFileNameToNameForHumans(originFileName.toString()), l.getNodeOffset(), l.getNodeLength(), startingLineInInput, endingLineInInput, startingLineInOrigin, endingLineInOrigin, offsetRelatedToOrigin);
    }

    String mapFileNameToNameForHumans(String fileName) {
        return (String)this.niceFileNameFunction.apply((Object)fileName);
    }
}

