/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.Pair;

public class ProgramDeclarations {
    private final Map<String, CSimpleDeclaration> globalVars = new HashMap<String, CSimpleDeclaration>();
    private final Map<String, CFunctionDeclaration> functions = new HashMap<String, CFunctionDeclaration>();
    private final Map<String, CComplexTypeDeclaration> types = new HashMap<String, CComplexTypeDeclaration>();
    private final Map<String, CElaboratedType> elaboratedTypes = new HashMap<String, CElaboratedType>();
    private final Map<String, CTypeDefDeclaration> typedefs = new HashMap<String, CTypeDefDeclaration>();
    private final Multimap<String, String> origNamesToQualifiedNames = HashMultimap.create();

    public void registerTypeDeclaration(CComplexTypeDeclaration declaration) {
        CComplexType type = declaration.getType();
        String qualifiedName = type.getQualifiedName();
        if (type.getCanonicalType() instanceof CElaboratedType) {
            this.elaboratedTypes.put(qualifiedName, (CElaboratedType)type);
            this.origNamesToQualifiedNames.put((Object)type.getOrigName(), (Object)type.getQualifiedName());
            return;
        }
        if (this.types.containsKey(qualifiedName)) {
            CComplexTypeDeclaration oldDecl = this.types.get(qualifiedName);
            if (!(oldDecl.getType().getCanonicalType() instanceof CElaboratedType) || !ProgramDeclarations.areEqualTypes(oldDecl.getType().getCanonicalType(), type.getCanonicalType())) {
                throw new CFAGenerationRuntimeException("There is already a type registered with the qualified name: " + qualifiedName);
            }
        } else {
            this.origNamesToQualifiedNames.put((Object)type.getOrigName(), (Object)type.getQualifiedName());
        }
        if (!type.getOrigName().isEmpty()) {
            this.completeElaboratedTypes(type);
        }
        this.types.put(qualifiedName, declaration);
    }

    private void completeElaboratedTypes(CComplexType type) {
        if (!type.getName().endsWith(type.getOrigName())) {
            type = this.types.get(type.getKind().toASTString() + " " + type.getOrigName()).getType();
        }
        for (String name : this.origNamesToQualifiedNames.get((Object)type.getOrigName())) {
            if (!this.elaboratedTypes.containsKey(name)) continue;
            CElaboratedType elabType = this.elaboratedTypes.get(name);
            if (elabType.getRealType() == null) {
                elabType.setRealType(type);
            }
            this.elaboratedTypes.remove(name);
        }
    }

    public void registerTypeDefDeclaration(CTypeDefDeclaration declaration) {
        String name = declaration.getName();
        this.origNamesToQualifiedNames.put((Object)declaration.getOrigName(), (Object)name);
        CTypeDefDeclaration shouldBeNull = this.typedefs.put(name, declaration);
        Verify.verify((shouldBeNull == null ? 1 : 0) != 0, (String)"There is already a typedeftype registered with the name: %s", (Object)name);
    }

    public void registerFunctionDeclaration(CFunctionDeclaration declaration) {
        String name = declaration.getName();
        if (this.globalVars.containsKey(name)) {
            throw new CFAGenerationRuntimeException("Name of global variable " + name + " from " + this.globalVars.get(name).getFileLocation() + " is reused as function declaration", declaration);
        }
        this.functions.put(name, declaration);
    }

    public void registerVariableDeclaration(CVariableDeclaration declaration) {
        String name = declaration.getName();
        CSimpleDeclaration shouldBeNull = this.globalVars.put(name, declaration);
        Verify.verify((shouldBeNull == null ? 1 : 0) != 0, (String)"There is already a global variable registered with the name: %s", (Object)name);
    }

    public boolean variableNameInUse(String name) {
        return this.globalVars.containsKey(name);
    }

    public CComplexType lookupType(String typeName, String origName) {
        CComplexTypeDeclaration returnType = this.types.get(typeName);
        if (returnType != null) {
            return returnType.getType();
        }
        returnType = this.types.get("struct " + origName);
        if (returnType != null) {
            return returnType.getType();
        }
        Collection typeNames = this.origNamesToQualifiedNames.get((Object)origName);
        for (String name : typeNames) {
            returnType = this.types.get(name);
            if (returnType == null) continue;
            return returnType.getType();
        }
        return null;
    }

    public boolean containsTypeWithExactName(String typeName) {
        return this.types.containsKey(typeName);
    }

    public boolean containsTypeDefWithExactName(String typeDefName) {
        return this.typedefs.containsKey(typeDefName);
    }

    public boolean containsFunctionWithExactName(String functionName) {
        return this.functions.containsKey(functionName);
    }

    public boolean containsVariableWithExactName(String variableName) {
        return this.globalVars.containsKey(variableName);
    }

    public boolean containsEqualType(CComplexTypeDeclaration declaration) {
        return this.getOrContainsEqualType(declaration).getFirst();
    }

    public boolean containsEqualTypeDef(CTypeDefDeclaration declaration) {
        return this.getOrContainsEqualTypeDef(declaration).getFirst();
    }

    public CComplexTypeDeclaration getEqualType(CComplexTypeDeclaration declaration) {
        return this.getOrContainsEqualType(declaration).getSecond();
    }

    public CTypeDefDeclaration getEqualTypeDefDeclaration(CTypeDefDeclaration declaration) {
        return this.getOrContainsEqualTypeDef(declaration).getSecond();
    }

    private Pair<Boolean, CTypeDefDeclaration> getOrContainsEqualTypeDef(CTypeDefDeclaration declaration) {
        for (String name : this.origNamesToQualifiedNames.get((Object)declaration.getOrigName())) {
            if (!this.typedefs.containsKey(name)) continue;
            CType oldType = this.typedefs.get(name).getType().getCanonicalType();
            CType newType = declaration.getType().getCanonicalType();
            if (!ProgramDeclarations.areEqualTypes(oldType.getCanonicalType(), newType.getCanonicalType())) continue;
            return Pair.of(true, this.typedefs.get(name));
        }
        return Pair.of(false, null);
    }

    private Pair<Boolean, CComplexTypeDeclaration> getOrContainsEqualType(CComplexTypeDeclaration declaration) {
        CComplexType newType = (CComplexType)declaration.getType().getCanonicalType();
        for (String name : this.origNamesToQualifiedNames.get((Object)newType.getOrigName())) {
            CComplexTypeDeclaration oldDecl;
            if (!this.types.containsKey(name) || !ProgramDeclarations.areEqualTypes((oldDecl = this.types.get(name)).getType().getCanonicalType(), newType)) continue;
            return Pair.of(true, oldDecl);
        }
        return Pair.of(false, null);
    }

    public void completeUncompletedElaboratedTypes() {
        HashSet<String> handledTypes = new HashSet<String>();
        for (CElaboratedType type : this.elaboratedTypes.values()) {
            String origName = type.getOrigName();
            if (handledTypes.contains(origName)) continue;
            handledTypes.add(origName);
            CElaboratedType newType = new CElaboratedType(type.isConst(), type.isVolatile(), type.getKind(), type.getOrigName(), type.getOrigName(), null);
            for (String name : this.origNamesToQualifiedNames.get((Object)origName)) {
                CElaboratedType elabType;
                if (!this.elaboratedTypes.containsKey(name) || (elabType = this.elaboratedTypes.get(name)).getRealType() != null) continue;
                elabType.setRealType(newType);
            }
        }
    }

    private static boolean areEqualTypes(CType type1, CType type2) {
        return ProgramDeclarations.areEqualTypes(type1, type2, new HashMap<Pair<CType, CType>, Boolean>());
    }

    private static boolean areEqualTypes(CType type1, CType type2, Map<Pair<CType, CType>, Boolean> foundTypes) {
        assert (type1.equals(type1.getCanonicalType()) && type2.equals(type2.getCanonicalType()));
        if (type1 == type2) {
            return true;
        }
        if (!(type1.getClass() == type2.getClass() || type1 instanceof CComplexType && type2 instanceof CElaboratedType || type2 instanceof CComplexType && type1 instanceof CElaboratedType)) {
            return false;
        }
        Pair<CType, CType> typePair = Pair.of(type1, type2);
        if (type1 instanceof CComplexType) {
            boolean isOuterTypeEqual = ((CComplexType)type1).equalsWithOrigName(type2);
            if (isOuterTypeEqual) {
                if (type1 instanceof CCompositeType) {
                    if (!foundTypes.containsKey(typePair)) {
                        boolean areEqual = ProgramDeclarations.areEqualCompositeTypes((CCompositeType)type1, (CCompositeType)type2, foundTypes);
                        foundTypes.put(typePair, areEqual);
                        return areEqual;
                    }
                    return foundTypes.get(typePair);
                }
                if (type1 instanceof CEnumType) {
                    return ProgramDeclarations.areEqualEnumTypes((CEnumType)type1, (CEnumType)type2);
                }
                if (type1 instanceof CElaboratedType) {
                    return true;
                }
                throw new AssertionError((Object)("Unhandled CComplexType with kind: " + type1.getClass()));
            }
            if (type1.getClass() != type2.getClass() || type1 instanceof CElaboratedType) {
                return ((CComplexType)type1).getOrigName().equals(((CComplexType)type2).getOrigName());
            }
            return false;
        }
        if (type1 instanceof CPointerType && (((CPointerType)type1).getType() instanceof CComplexType || ((CPointerType)type1).getType() instanceof CFunctionType || ((CPointerType)type1).getType() instanceof CPointerType)) {
            return ProgramDeclarations.areEqualTypes(((CPointerType)type1).getType(), ((CPointerType)type1).getType(), foundTypes);
        }
        if (type1 instanceof CArrayType && (((CArrayType)type1).getType() instanceof CComplexType || ((CArrayType)type1).getType() instanceof CFunctionType || ((CArrayType)type1).getType() instanceof CPointerType)) {
            CArrayType a1 = (CArrayType)type1;
            CArrayType a2 = (CArrayType)type2;
            if (a1.getLength() instanceof CIntegerLiteralExpression && a2.getLength() instanceof CIntegerLiteralExpression ? !((CIntegerLiteralExpression)a1.getLength()).getValue().equals(((CIntegerLiteralExpression)a2.getLength()).getValue()) : !Objects.equals(a1.getLength(), a2.getLength())) {
                return false;
            }
            return ProgramDeclarations.areEqualTypes(((CArrayType)type1).getType(), ((CArrayType)type2).getType(), foundTypes);
        }
        if (type1 instanceof CFunctionType) {
            return ProgramDeclarations.areEqualFunctionTypes((CFunctionType)type1, (CFunctionType)type2, foundTypes);
        }
        return type1.equals(type2);
    }

    private static boolean areEqualCompositeTypes(CCompositeType type1, CCompositeType type2, Map<Pair<CType, CType>, Boolean> foundTypes) {
        List<CCompositeType.CCompositeTypeMemberDeclaration> members1 = type1.getMembers();
        List<CCompositeType.CCompositeTypeMemberDeclaration> members2 = type2.getMembers();
        if (members1.size() != members2.size()) {
            return false;
        }
        boolean areEqual = true;
        for (int i = 0; i < members1.size() && areEqual; ++i) {
            String member1Name = members1.get(i).getName();
            String member2Name = members2.get(i).getName();
            CType typeM1 = members1.get(i).getType();
            CType typeM2 = members2.get(i).getType();
            boolean isAnonymousField = member1Name.contains("_anon_type_member_") && member2Name.contains("_anon_type_member_");
            areEqual = member1Name.equals(member2Name) || isAnonymousField;
            areEqual = areEqual && ProgramDeclarations.areEqualTypes(typeM1.getCanonicalType(), typeM2.getCanonicalType(), foundTypes);
        }
        return areEqual;
    }

    private static boolean areEqualEnumTypes(CEnumType type1, CEnumType type2) {
        ImmutableList<CEnumType.CEnumerator> members1 = type1.getEnumerators();
        ImmutableList<CEnumType.CEnumerator> members2 = type2.getEnumerators();
        if (members1.size() != members2.size()) {
            return false;
        }
        boolean areEqual = true;
        for (int i = 0; i < members1.size() && areEqual; ++i) {
            CEnumType.CEnumerator member1 = (CEnumType.CEnumerator)members1.get(i);
            CEnumType.CEnumerator member2 = (CEnumType.CEnumerator)members2.get(i);
            areEqual = member1.getName().equals(member2.getName());
            areEqual = areEqual && (member1.hasValue() && member2.hasValue() && member1.getValue() == member2.getValue() || !member1.hasValue() && !member2.hasValue());
        }
        return areEqual;
    }

    private static boolean areEqualFunctionTypes(CFunctionType type1, CFunctionType type2, Map<Pair<CType, CType>, Boolean> foundTypes) {
        boolean areEqual = type1 instanceof CFunctionTypeWithNames && type2 instanceof CFunctionTypeWithNames && !type1.getName().equals(type2.getName()) || !(type1 instanceof CFunctionTypeWithNames) || !(type2 instanceof CFunctionTypeWithNames);
        areEqual = areEqual && ProgramDeclarations.areEqualTypes(type1.getReturnType().getCanonicalType(), type2.getReturnType().getCanonicalType(), foundTypes);
        List<CType> params1 = type1.getParameters();
        List<CType> params2 = type2.getParameters();
        areEqual = areEqual && params1.size() == params2.size();
        for (int i = 0; areEqual && i < params1.size(); ++i) {
            areEqual = ProgramDeclarations.areEqualTypes(params1.get(i).getCanonicalType(), params2.get(i).getCanonicalType(), foundTypes);
        }
        return areEqual;
    }
}

