/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c.export;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.export.CWriter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.EclipseCdtWrapper;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class EclipseCWriter
implements CWriter {
    private final EclipseCdtWrapper eclipseCdt;

    public EclipseCWriter(CParser.ParserOptions pOptions, ShutdownNotifier pShutdownNotifier) {
        this.eclipseCdt = new EclipseCdtWrapper(pOptions, pShutdownNotifier);
    }

    @Override
    public String exportCfa(CFA pCfa) throws IOException, CPAException, InterruptedException {
        Preconditions.checkArgument((pCfa.getLanguage() == Language.C ? 1 : 0) != 0, (Object)"CFA can only be exported to C for C input programs, at the moment.");
        Preconditions.checkArgument((pCfa.getFileNames().size() == 1 ? 1 : 0) != 0, (Object)"CFA can only be exported for a single input program, at the moment.");
        try {
            IASTTranslationUnit astUnit = this.eclipseCdt.getASTTranslationUnit(EclipseCdtWrapper.wrapFile(pCfa.getFileNames().get(0)));
            Verify.verify((astUnit.getPreprocessorProblemsCount() == 0 ? 1 : 0) != 0, (String)"Problems should have been caught during CFA generation.", (Object[])new Object[0]);
            return astUnit.getRawSignature();
        }
        catch (CoreException pE) {
            throw new CPAException("Failed to export CFA to C program because AST parsing failed.");
        }
    }
}

