/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayCreationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayLengthExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JAssignment;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNode;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBooleanLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JConstructorDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JEnumConstantExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldAccess;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JNullLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JObjectReferenceReturn;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JReferencedMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JSuperConstructorInvocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JThisExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableRunTimeType;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTDebug;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.NameConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JConstructorType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JMethodType;
import org.sosy_lab.cpachecker.cfa.types.java.JReferenceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

class ASTConverter {
    private static final boolean NOT_FINAL = false;
    private static final int FIRST = 0;
    private final LogManager logger;
    private Scope scope;
    private final ASTTypeConverter typeConverter;
    private List<JDeclaration> forInitDeclarations = new ArrayList<JDeclaration>();
    private Deque<JAstNode> preSideAssignments = new ArrayDeque<JAstNode>();
    private Deque<JAstNode> postSideAssignments = new ArrayDeque<JAstNode>();
    private ConditionalExpression conditionalExpression = null;
    private JIdExpression conditionalTemporaryVariable = null;
    private JIdExpression enhancedForLoopIterator;
    private static final ImmutableMap<String, JBasicType> unboxingMap = ImmutableMap.builder().put((Object)"java.lang.Boolean", (Object)JBasicType.BOOLEAN).put((Object)"java.lang.Byte", (Object)JBasicType.BYTE).put((Object)"java.lang.Character", (Object)JBasicType.CHAR).put((Object)"java.lang.Float", (Object)JBasicType.FLOAT).put((Object)"java.lang.Integer", (Object)JBasicType.INT).put((Object)"java.lang.Long", (Object)JBasicType.LONG).put((Object)"java.lang.Short", (Object)JBasicType.SHORT).put((Object)"java.lang.Double", (Object)JBasicType.DOUBLE).put((Object)"java.lang.Void", (Object)JBasicType.VOID).buildOrThrow();
    private static final ImmutableSet<JBinaryExpression.BinaryOperator> BOOLEAN_BINARY_OPERATORS = Sets.immutableEnumSet((Enum)JBinaryExpression.BinaryOperator.EQUALS, (Enum[])new JBinaryExpression.BinaryOperator[]{JBinaryExpression.BinaryOperator.NOT_EQUALS, JBinaryExpression.BinaryOperator.GREATER_EQUAL, JBinaryExpression.BinaryOperator.GREATER_THAN, JBinaryExpression.BinaryOperator.LESS_EQUAL, JBinaryExpression.BinaryOperator.LESS_THAN, JBinaryExpression.BinaryOperator.LOGICAL_AND, JBinaryExpression.BinaryOperator.LOGICAL_OR, JBinaryExpression.BinaryOperator.CONDITIONAL_AND, JBinaryExpression.BinaryOperator.CONDITIONAL_OR});

    public ASTConverter(Scope pScope, LogManager pLogger) {
        this.scope = pScope;
        this.logger = pLogger;
        this.typeConverter = new ASTTypeConverter(this.scope);
    }

    public int numberOfPostSideAssignments() {
        return this.postSideAssignments.size();
    }

    public int numberOfSideAssignments() {
        return this.preSideAssignments.size() + this.postSideAssignments.size();
    }

    public int numberOfPreSideAssignments() {
        return this.preSideAssignments.size();
    }

    public JAstNode getNextSideAssignment() {
        if (this.numberOfPreSideAssignments() > 0) {
            return this.preSideAssignments.removeFirst();
        }
        return this.postSideAssignments.removeFirst();
    }

    public JAstNode getNextPreSideAssignment() {
        return this.preSideAssignments.removeFirst();
    }

    public JAstNode getNextPostSideAssignment() {
        return this.postSideAssignments.removeFirst();
    }

    public void resetConditionalExpression() {
        this.conditionalExpression = null;
    }

    public ConditionalExpression getConditionalExpression() {
        return this.conditionalExpression;
    }

    public JIdExpression getConditionalTemporaryVariable() {
        return this.conditionalTemporaryVariable;
    }

    private static void check(boolean assertion, String msg, ASTNode astNode) throws CFAGenerationRuntimeException {
        if (!assertion) {
            throw new CFAGenerationRuntimeException(msg, astNode);
        }
    }

    public List<JDeclaration> getForInitDeclaration() {
        return this.forInitDeclarations;
    }

    public int numberOfForInitDeclarations() {
        return this.forInitDeclarations.size();
    }

    private String getQualifiedName(String var) {
        return this.scope.createQualifiedName(var);
    }

    private JType convert(ITypeBinding pTypeBinding) {
        return this.typeConverter.convert(pTypeBinding);
    }

    private JType convert(Type pType) {
        return this.typeConverter.convert(pType);
    }

    private JArrayType convert(ArrayType pType) {
        return (JArrayType)this.typeConverter.convert((Type)pType);
    }

    public JClassOrInterfaceType convertClassOrInterfaceType(ITypeBinding pClassBinding) {
        return this.typeConverter.convertClassOrInterfaceType(pClassBinding);
    }

    public JMethodDeclaration convert(MethodDeclaration md) {
        IMethodBinding methodBinding = md.resolveBinding();
        if (methodBinding == null) {
            this.logger.log(Level.WARNING, new Object[]{"Could not resolve Binding for Method Declaration "});
            this.logger.log(Level.WARNING, new Object[]{md.getName()});
            return JMethodDeclaration.createUnresolvedMethodDeclaration();
        }
        String methodName = NameConverter.convertName(methodBinding);
        Preconditions.checkArgument((boolean)this.scope.isMethodRegistered(methodName));
        return this.scope.lookupMethod(methodName);
    }

    private JClassOrInterfaceType getDeclaringClassType(IMethodBinding mi) {
        JType declaringClassType = null;
        if (mi != null) {
            declaringClassType = this.convert(mi.getDeclaringClass());
        }
        JClassOrInterfaceType declaringClass = declaringClassType instanceof JClassOrInterfaceType ? (JClassOrInterfaceType)declaringClassType : JClassType.createUnresolvableType();
        return declaringClass;
    }

    public FileLocation getFileLocation(ASTNode l) {
        if (l == null) {
            return FileLocation.DUMMY;
        }
        if (l.getRoot().getNodeType() != 15) {
            this.logger.log(Level.WARNING, new Object[]{"Can't find Placement Information for :" + l});
            return FileLocation.DUMMY;
        }
        CompilationUnit co = (CompilationUnit)l.getRoot();
        return new FileLocation(this.scope.getFileOfCurrentType(), l.getStartPosition(), l.getLength(), co.getLineNumber(l.getStartPosition()), co.getLineNumber(l.getLength() + l.getStartPosition()));
    }

    public List<JDeclaration> convert(FieldDeclaration fd) {
        List vdfs = fd.fragments();
        return Collections3.transformedImmutableListCopy((Collection)vdfs, this::handleFieldDeclarationFragment);
    }

    private JDeclaration handleFieldDeclarationFragment(VariableDeclarationFragment pVdf) {
        NameAndInitializer nameAndInitializer = this.getNamesAndInitializer(pVdf);
        String fieldName = nameAndInitializer.getName();
        Preconditions.checkArgument((boolean)this.scope.isFieldRegistered(fieldName));
        JFieldDeclaration fieldDecl = this.scope.lookupField(fieldName);
        if (!this.preSideAssignments.isEmpty() || !this.postSideAssignments.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"Sideeffects of initializer of field " + fieldName + " will be ignored"});
            this.preSideAssignments.clear();
            this.postSideAssignments.clear();
        }
        fieldDecl.updateInitializer(nameAndInitializer.getInitializer());
        return fieldDecl;
    }

    private NameAndInitializer getNamesAndInitializer(VariableDeclarationFragment d) {
        JInitializerExpression initializerExpression = null;
        if (d.getInitializer() != null) {
            JExpression iniExpr = this.convertExpressionWithoutSideEffects(d.getInitializer());
            initializerExpression = new JInitializerExpression(this.getFileLocation((ASTNode)d), iniExpr);
        }
        String name = NameConverter.convertName(d.resolveBinding());
        return new NameAndInitializer(name, initializerExpression);
    }

    public List<JDeclaration> convert(VariableDeclarationStatement vds) {
        ArrayList<JDeclaration> variableDeclarations = new ArrayList<JDeclaration>();
        List variableDeclarationFragments = vds.fragments();
        FileLocation fileLoc = this.getFileLocation((ASTNode)vds);
        Type type = vds.getType();
        ModifierBean mB = ModifierBean.getModifiers(vds.modifiers());
        assert (!mB.isAbstract()) : "Local Variable has abstract modifier?";
        assert (!mB.isNative()) : "Local Variable has native modifier?";
        assert (mB.getVisibility() == VisibilityModifier.NONE) : "Local Variable has Visibility modifier?";
        assert (!mB.isStatic()) : "Local Variable has static modifier?";
        assert (!mB.isStrictFp()) : "Local Variable has strictFp modifier?";
        assert (!mB.isSynchronized()) : "Local Variable has synchronized modifier?";
        for (VariableDeclarationFragment vdf : variableDeclarationFragments) {
            NameAndInitializer nameAndInitializer = this.getNamesAndInitializer(vdf);
            String name = nameAndInitializer.getName();
            name = this.addCounterToName(name);
            JVariableDeclaration newD = new JVariableDeclaration(fileLoc, this.convert(type), name, nameAndInitializer.getName(), this.getQualifiedName(name), nameAndInitializer.getInitializer(), mB.isFinal());
            variableDeclarations.add(newD);
        }
        return variableDeclarations;
    }

    public JDeclaration convert(SingleVariableDeclaration d) {
        Type type = d.getType();
        ModifierBean mB = ModifierBean.getModifiers(d.modifiers());
        assert (!mB.isAbstract) : "Local Variable has abstract modifier?";
        assert (!mB.isNative) : "Local Variable has native modifier?";
        assert (mB.visibility == VisibilityModifier.NONE) : "Local Variable has Visibility modifier?";
        assert (!mB.isStatic) : "Local Variable has static modifier?";
        assert (!mB.isStrictFp) : "Local Variable has strictFp modifier?";
        assert (!mB.isSynchronized) : "Local Variable has synchronized modifier?";
        JInitializerExpression initializerExpression = null;
        if (d.getInitializer() != null) {
            JExpression iniExpr = (JExpression)this.convertExpressionWithSideEffects(d.getInitializer());
            initializerExpression = new JInitializerExpression(this.getFileLocation((ASTNode)d), iniExpr);
        }
        String name = d.getName().getFullyQualifiedName();
        name = this.addCounterToName(name);
        return new JVariableDeclaration(this.getFileLocation((ASTNode)d), this.convert(type), name, d.getName().getFullyQualifiedName(), this.getQualifiedName(name), initializerExpression, mB.isFinal());
    }

    public JReturnStatement convert(ReturnStatement s) {
        JExpression expr = this.convertExpressionWithoutSideEffects(s.getExpression());
        return new JReturnStatement(this.getFileLocation((ASTNode)s), Optional.ofNullable(expr));
    }

    public JExpression convertExpressionWithoutSideEffects(Expression e) {
        JAstNode node = this.convertExpressionWithSideEffects(e);
        if (node instanceof JCastExpression) {
            return this.addSideassignmentsForCasts(node, e);
        }
        if (node == null || node instanceof JExpression) {
            return (JExpression)node;
        }
        if (node instanceof JMethodInvocationExpression) {
            return this.addSideassignmentsForExpressionsWithoutMethodInvocationSideEffects(node, e);
        }
        if (node instanceof JAssignment) {
            this.addSideassignmentsForExpressionsWithoutAssignmentSideEffects(node, e);
            return ((JAssignment)node).getLeftHandSide();
        }
        throw new AssertionError((Object)("unknown expression " + node));
    }

    private JIdExpression addSideassignmentsForCasts(JAstNode node, Expression e) {
        JIdExpression tmp = this.createTemporaryVariable(e);
        this.preSideAssignments.add(new JExpressionAssignmentStatement(node.getFileLocation(), tmp, (JExpression)node));
        return tmp;
    }

    private void addSideassignmentsForExpressionsWithoutAssignmentSideEffects(JAstNode node, Expression e) {
        if (e instanceof PostfixExpression) {
            this.postSideAssignments.add(node);
        } else {
            this.preSideAssignments.add(node);
        }
    }

    private JExpression addSideassignmentsForExpressionsWithoutMethodInvocationSideEffects(JAstNode node, Expression e) {
        JIdExpression tmp = this.createTemporaryVariable(e);
        this.preSideAssignments.add(new JMethodInvocationAssignmentStatement(node.getFileLocation(), tmp, (JMethodInvocationExpression)node));
        return tmp;
    }

    private JIdExpression createTemporaryVariable(Expression e) {
        String name = "__CPAchecker_TMP_";
        return this.createTemporaryVariableWithName(e, name);
    }

    private JIdExpression createTemporaryVariableWithName(Expression e, String name) {
        int i = 0;
        while (this.scope.variableNameInUse((String)name + i, (String)name + i)) {
            ++i;
        }
        name = (String)name + i;
        JVariableDeclaration decl = new JVariableDeclaration(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), (String)name, (String)name, this.getQualifiedName((String)name), null, false);
        this.scope.registerDeclarationOfThisClass(decl);
        this.preSideAssignments.add(decl);
        JIdExpression tmp = new JIdExpression(decl.getFileLocation(), this.convert(e.resolveTypeBinding()), (String)name, decl);
        return tmp;
    }

    public JStatement convert(ExpressionStatement s) {
        JAstNode node = this.convertExpressionWithSideEffects(s.getExpression());
        if (node instanceof JExpressionAssignmentStatement) {
            return (JExpressionAssignmentStatement)node;
        }
        if (node instanceof JMethodInvocationAssignmentStatement) {
            return (JMethodInvocationAssignmentStatement)node;
        }
        if (node instanceof JMethodInvocationExpression) {
            return new JMethodInvocationStatement(this.getFileLocation((ASTNode)s), (JMethodInvocationExpression)node);
        }
        if (node instanceof JExpression) {
            return new JExpressionStatement(this.getFileLocation((ASTNode)s), (JExpression)node);
        }
        throw new AssertionError((Object)("Unhandled node type " + node.getClass().getCanonicalName()));
    }

    public JStatement convert(SuperConstructorInvocation sCI) {
        JIdExpression functionName;
        JIdExpression idExpression;
        String simpleName;
        String name;
        IMethodBinding binding = sCI.resolveConstructorBinding();
        if (binding != null) {
            this.scope.registerClass(binding.getDeclaringClass());
        }
        List p = sCI.arguments();
        List<JExpression> params = this.convert(p);
        if (binding != null) {
            name = NameConverter.convertName(binding);
            simpleName = binding.getName();
        } else {
            name = sCI.toString();
            simpleName = sCI.toString();
        }
        JConstructorDeclaration declaration = (JConstructorDeclaration)this.scope.lookupMethod(name);
        if (declaration == null) {
            if (binding != null) {
                ModifierBean mb = ModifierBean.getModifiers(binding);
                declaration = this.scope.createExternConstructorDeclaration(this.convertConstructorType(binding), name, simpleName, mb.getVisibility(), mb.isStrictFp(), (JClassType)this.getDeclaringClassType(binding));
            } else {
                declaration = JConstructorDeclaration.createUnresolvedConstructorDeclaration();
            }
        }
        if ((idExpression = (functionName = binding != null ? new JIdExpression(this.getFileLocation((ASTNode)sCI), this.convert(binding.getReturnType()), name, declaration) : new JIdExpression(this.getFileLocation((ASTNode)sCI), JClassType.createUnresolvableType(), name, declaration))).getDeclaration() != null) {
            functionName = new JIdExpression(idExpression.getFileLocation(), idExpression.getExpressionType(), name, declaration);
        }
        return new JMethodInvocationStatement(this.getFileLocation((ASTNode)sCI), new JSuperConstructorInvocation(this.getFileLocation((ASTNode)sCI), (JClassType)this.getDeclaringClassType(binding), (JExpression)functionName, params, declaration));
    }

    private JConstructorType convertConstructorType(IMethodBinding pBinding) {
        Preconditions.checkArgument((boolean)pBinding.isConstructor());
        JClassType declaringClass = (JClassType)this.getDeclaringClassType(pBinding);
        ITypeBinding[] paramBindings = pBinding.getParameterTypes();
        ArrayList<JType> paramTypes = new ArrayList<JType>();
        for (ITypeBinding type : paramBindings) {
            paramTypes.add(this.convert(type));
        }
        return new JConstructorType(declaringClass, paramTypes, pBinding.isVarargs());
    }

    private JConstructorType convertConstructorType(IMethodBinding pBinding, List<?> arguments) {
        Preconditions.checkArgument((boolean)pBinding.isConstructor());
        JClassType declaringClass = (JClassType)this.getDeclaringClassType(pBinding);
        return new JConstructorType(declaringClass, this.getJTypesOfParameters(arguments), pBinding.isVarargs());
    }

    private JMethodType convertMethodType(IMethodBinding pBinding) {
        Preconditions.checkArgument((!pBinding.isConstructor() ? 1 : 0) != 0);
        JClassOrInterfaceType declaringClass = this.getDeclaringClassType(pBinding);
        ITypeBinding[] paramBindings = pBinding.getParameterTypes();
        ArrayList<JType> paramTypes = new ArrayList<JType>();
        for (ITypeBinding type : paramBindings) {
            paramTypes.add(this.convert(type));
        }
        return new JMethodType(declaringClass, paramTypes, pBinding.isVarargs());
    }

    public JAstNode convertExpressionWithSideEffects(Expression e) {
        if (e == null) {
            this.logger.log(Level.FINE, new Object[]{"Expression to convert is null"});
            return null;
        }
        switch (e.getNodeType()) {
            case 7: {
                return this.convert((Assignment)e);
            }
            case 27: {
                return this.convert((InfixExpression)e);
            }
            case 34: {
                return this.convert((NumberLiteral)e);
            }
            case 13: {
                return this.convert((CharacterLiteral)e);
            }
            case 45: {
                return this.convert((StringLiteral)e);
            }
            case 33: {
                return this.convert((NullLiteral)e);
            }
            case 38: {
                return this.convert((PrefixExpression)e);
            }
            case 37: {
                return this.convert((PostfixExpression)e);
            }
            case 40: {
                return this.convert((QualifiedName)e);
            }
            case 9: {
                return this.convert((BooleanLiteral)e);
            }
            case 22: {
                return this.convert((FieldAccess)e);
            }
            case 42: {
                return this.convert((SimpleName)e);
            }
            case 36: {
                return this.convertExpressionWithoutSideEffects(((ParenthesizedExpression)e).getExpression());
            }
            case 32: {
                return this.convert((MethodInvocation)e);
            }
            case 14: {
                return this.convert((ClassInstanceCreation)e);
            }
            case 2: {
                return this.convert((ArrayAccess)e);
            }
            case 3: {
                return this.convert((ArrayCreation)e);
            }
            case 4: {
                return this.convert((ArrayInitializer)e);
            }
            case 16: {
                return this.convert((ConditionalExpression)e);
            }
            case 52: {
                return this.convert((ThisExpression)e);
            }
            case 62: {
                return this.convert((InstanceofExpression)e);
            }
            case 11: {
                return this.convert((CastExpression)e);
            }
            case 58: {
                return this.convert((VariableDeclarationExpression)e);
            }
            case 47: {
                return this.convert((SuperFieldAccess)e);
            }
            case 57: {
                return this.convert((TypeLiteral)e);
            }
            case 48: {
                return this.convert((SuperMethodInvocation)e);
            }
        }
        this.logger.log(Level.WARNING, new Object[]{"Expression of type " + ASTDebug.getTypeName(e.getNodeType()) + " not implemented"});
        return null;
    }

    private JAstNode convert(SuperMethodInvocation e) {
        JClassOrInterfaceType type;
        List p;
        IMethodBinding methodBinding = e.resolveMethodBinding();
        JClassOrInterfaceType declaringClassType = null;
        if (methodBinding != null) {
            declaringClassType = (JClassOrInterfaceType)this.convert(methodBinding.getDeclaringClass());
            this.scope.registerClass(methodBinding.getDeclaringClass());
        }
        Object params = !(p = e.arguments()).isEmpty() ? this.convert(p) : ImmutableList.of();
        JExpression methodName = this.convertExpressionWithoutSideEffects((Expression)e.getName());
        JMethodDeclaration declaration = null;
        if (methodName instanceof JIdExpression) {
            JIdExpression idExpression = (JIdExpression)methodName;
            String name = idExpression.getName();
            declaration = this.scope.lookupMethod(name);
            if (idExpression.getDeclaration() != null) {
                methodName = new JIdExpression(idExpression.getFileLocation(), idExpression.getExpressionType(), name, declaration);
            }
        }
        if (declaration == null) {
            if (methodBinding != null) {
                ModifierBean mb = ModifierBean.getModifiers(methodBinding);
                declaration = this.scope.createExternMethodDeclaration(this.convertMethodType(methodBinding), methodName.toASTString(), methodBinding.getName(), VisibilityModifier.PUBLIC, mb.isFinal(), mb.isAbstract(), mb.isStatic(), mb.isNative(), mb.isSynchronized(), mb.isStrictFp(), declaringClassType);
            } else {
                declaration = JMethodDeclaration.createUnresolvedMethodDeclaration();
            }
        }
        JMethodInvocationExpression miv = new JMethodInvocationExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), methodName, (List<? extends JExpression>)params, declaration);
        if (methodBinding != null && (type = miv.getDeclaringType()) instanceof JClassType) {
            miv.setRunTimeBinding((JClassType)type);
        }
        return miv;
    }

    private JAstNode convert(TypeLiteral pTypeLiteral) {
        ITypeBinding iTypeBinding = pTypeLiteral.resolveTypeBinding();
        JType jType = this.typeConverter.convert(iTypeBinding);
        return new JClassLiteralExpression(this.getFileLocation((ASTNode)pTypeLiteral), jType);
    }

    private JAstNode convert(SuperFieldAccess e) {
        boolean canBeResolved;
        IVariableBinding vb = e.resolveFieldBinding();
        boolean bl = canBeResolved = vb != null;
        if (canBeResolved) {
            return this.convert(e.getName());
        }
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        String name = e.getName().getIdentifier();
        return new JIdExpression(fileLoc, type, name, null);
    }

    private JAstNode convert(CastExpression e) {
        return new JCastExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), this.convertExpressionWithoutSideEffects(e.getExpression()));
    }

    private JIdExpression convert(VariableDeclarationExpression vde) {
        ArrayList<JVariableDeclaration> variableDeclarations = new ArrayList<JVariableDeclaration>();
        List variableDeclarationFragments = vde.fragments();
        FileLocation fileLoc = this.getFileLocation((ASTNode)vde);
        Type type = vde.getType();
        ModifierBean mB = ModifierBean.getModifiers(vde.modifiers());
        assert (!mB.isAbstract()) : "Local Variable has abstract modifier?";
        assert (!mB.isNative()) : "Local Variable has native modifier?";
        assert (mB.getVisibility() == VisibilityModifier.NONE) : "Local Variable has Visibility modifier?";
        assert (!mB.isStatic()) : "Local Variable has static modifier?";
        assert (!mB.isStrictFp()) : "Local Variable has strictFp modifier?";
        assert (!mB.isSynchronized()) : "Local Variable has synchronized modifier?";
        for (VariableDeclarationFragment vdf : variableDeclarationFragments) {
            NameAndInitializer nameAndInitializer = this.getNamesAndInitializer(vdf);
            String name = nameAndInitializer.getName();
            name = this.addCounterToName(name);
            JVariableDeclaration newD = new JVariableDeclaration(fileLoc, this.convert(type), name, nameAndInitializer.getName(), this.getQualifiedName(name), nameAndInitializer.getInitializer(), mB.isFinal());
            variableDeclarations.add(newD);
        }
        this.forInitDeclarations.addAll(variableDeclarations);
        return null;
    }

    private String addCounterToName(String pName) {
        if (!this.scope.variableNameInUse((String)pName, (String)pName)) {
            return pName;
        }
        int i = 0;
        String sep = "__";
        while (this.scope.variableNameInUse((String)pName + sep + i, (String)pName)) {
            ++i;
        }
        pName = (String)pName + sep + i;
        return pName;
    }

    private JExpression convert(InstanceofExpression e) {
        FileLocation fileloc = this.getFileLocation((ASTNode)e);
        Expression leftOperandOfExpression = e.getLeftOperand();
        JExpression leftOperand = this.convertExpressionWithoutSideEffects(leftOperandOfExpression);
        if (leftOperand instanceof ALiteralExpression || leftOperand instanceof JArraySubscriptExpression) {
            leftOperand = this.createTemporaryVariableWithName(leftOperandOfExpression, leftOperandOfExpression.toString() + "_");
        }
        JType typeOfRightOperand = this.convert(e.getRightOperand().resolveBinding());
        assert (leftOperand instanceof JIdExpression) : "There are other expressions for instanceOf?";
        assert (typeOfRightOperand instanceof JReferenceType) : "There are other types for this expression?";
        JIdExpression referenceVariableLeftOperand = (JIdExpression)leftOperand;
        JType instanceOfType = this.convert(e.resolveTypeBinding());
        assert (instanceOfType instanceof JSimpleType);
        if (((JSimpleType)instanceOfType).getType() != JBasicType.UNSPECIFIED) assert (((JSimpleType)instanceOfType).getType() == JBasicType.BOOLEAN) : "InstanceofExpression is not always of type boolean!";
        return this.createInstanceOfExpression(referenceVariableLeftOperand, (JReferenceType)typeOfRightOperand, fileloc);
    }

    JExpression createInstanceOfExpression(JExpression pLeftOperand, JReferenceType pRightOperand, FileLocation pLocation) {
        List<JType> allPossibleClasses;
        boolean isRightOperandArray;
        if (pRightOperand instanceof JArrayType) {
            isRightOperandArray = true;
            JType elementType = ((JArrayType)pRightOperand).getElementType();
            allPossibleClasses = this.getSubClasses(elementType);
        } else {
            isRightOperandArray = false;
            allPossibleClasses = this.getSubClasses(pRightOperand);
        }
        if (pRightOperand instanceof JInterfaceType && allPossibleClasses.isEmpty()) {
            return new JBooleanLiteralExpression(pLocation, false);
        }
        return this.createInstanceOfDisjunction(pLeftOperand, allPossibleClasses, JSimpleType.getBoolean(), pLocation, isRightOperandArray);
    }

    private List<JType> getSubClasses(JType pType) {
        Set<JClassType> subClassTypeSet;
        if (pType instanceof JSimpleType) {
            ArrayList<JType> result = new ArrayList<JType>(1);
            result.add(pType);
            return result;
        }
        assert (pType instanceof JInterfaceType || pType instanceof JClassType) : "Unhandled type " + pType;
        if (pType instanceof JInterfaceType) {
            subClassTypeSet = ((JInterfaceType)pType).getAllKnownImplementingClassesOfInterface();
        } else {
            JClassType classType = (JClassType)pType;
            subClassTypeSet = classType.getAllSubTypesOfClass();
            subClassTypeSet.add(classType);
        }
        return new ArrayList<JType>(subClassTypeSet);
    }

    private JExpression createInstanceOfDisjunction(JExpression pLeftOperand, List<JType> pConcreteTypes, JType pExpressionType, FileLocation pLocation, boolean isRightOperandArray) {
        AbstractExpression currentCondition;
        JType firstElement = pConcreteTypes.remove(0);
        if (!(firstElement instanceof JClassType)) {
            if (isRightOperandArray) {
                return firstElement.equals(pLeftOperand.getExpressionType()) ? new JBooleanLiteralExpression(pLocation, true) : new JBooleanLiteralExpression(pLocation, false);
            }
            throw new CFAGenerationRuntimeException("Arguments for instance of must be reference type or null type");
        }
        if (pLeftOperand instanceof JIdExpression) {
            currentCondition = this.convertClassRunTimeCompileTimeAccord(pLocation, (JIdExpression)pLeftOperand, (JReferenceType)((JClassType)firstElement));
        } else if (pLeftOperand instanceof JRunTimeTypeExpression) {
            currentCondition = new JRunTimeTypeEqualsType(pLeftOperand.getFileLocation(), (JRunTimeTypeExpression)pLeftOperand, (JClassType)firstElement);
        } else {
            throw new CFAGenerationRuntimeException("Can only create instance of disjunction with JIdExpression or JRunTimeTypeExpression");
        }
        for (JType currentSubType : pConcreteTypes) {
            JRunTimeTypeEqualsType newCondition;
            if (pLeftOperand instanceof JIdExpression) {
                newCondition = this.convertClassRunTimeCompileTimeAccord(pLocation, (JIdExpression)pLeftOperand, (JReferenceType)((JClassType)currentSubType));
            } else if (pLeftOperand instanceof JRunTimeTypeExpression) {
                newCondition = new JRunTimeTypeEqualsType(pLeftOperand.getFileLocation(), (JRunTimeTypeExpression)pLeftOperand, (JClassType)currentSubType);
            } else {
                throw new CFAGenerationRuntimeException("Can only create instance of disjunction with JIdExpression or JRunTimeTypeExpression");
            }
            currentCondition = new JBinaryExpression(pLocation, pExpressionType, (JExpression)((Object)currentCondition), newCondition, JBinaryExpression.BinaryOperator.CONDITIONAL_OR);
        }
        return currentCondition;
    }

    private JRunTimeTypeEqualsType convertClassRunTimeCompileTimeAccord(FileLocation pFileloc, JIdExpression pDeclaration, JReferenceType pJReferenceType) {
        JVariableRunTimeType runTimeTyp = new JVariableRunTimeType(pFileloc, pDeclaration);
        return new JRunTimeTypeEqualsType(pFileloc, runTimeTyp, pJReferenceType);
    }

    private JAstNode convert(ThisExpression e) {
        return new JThisExpression(this.getFileLocation((ASTNode)e), (JClassOrInterfaceType)this.convert(e.resolveTypeBinding()));
    }

    private JAstNode convert(FieldAccess e) {
        JExpression identifier;
        boolean canBeResolved;
        if (this.isArrayLengthExpression(e)) {
            return this.createJArrayLengthExpression(e);
        }
        boolean bl = canBeResolved = e.resolveFieldBinding() != null;
        if (canBeResolved) {
            this.scope.registerClass(e.resolveFieldBinding().getDeclaringClass());
        }
        if (!((identifier = this.convertExpressionWithoutSideEffects((Expression)e.getName())) instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException("Identifier of FieldAccess could not be processed.", (ASTNode)e);
        }
        JIdExpression idExpIdentifier = (JIdExpression)identifier;
        JExpression qualifier = this.convertExpressionWithoutSideEffects(e.getExpression());
        if (qualifier instanceof JThisExpression) {
            return idExpIdentifier;
        }
        if (!(qualifier instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException("Qualifier of FieldAccess could not be processed.", (ASTNode)e);
        }
        JSimpleDeclaration decl = idExpIdentifier.getDeclaration();
        if (!(decl instanceof JFieldDeclaration)) {
            throw new CFAGenerationRuntimeException("Identifier of FieldAccess does not identify a field.", (ASTNode)e);
        }
        return new JFieldAccess(idExpIdentifier.getFileLocation(), idExpIdentifier.getExpressionType(), idExpIdentifier.getName(), (JFieldDeclaration)decl, (JIdExpression)qualifier);
    }

    private boolean isArrayLengthExpression(FieldAccess e) {
        return e.getExpression() instanceof ArrayAccess;
    }

    private JArrayLengthExpression createJArrayLengthExpression(FieldAccess e) {
        JExpression qualifierExpression = this.convertExpressionWithoutSideEffects(e.getExpression());
        return JArrayLengthExpression.getInstance(qualifierExpression, this.getFileLocation((ASTNode)e));
    }

    private JAstNode convert(ClassInstanceCreation cIC) {
        IMethodBinding binding = cIC.resolveConstructorBinding();
        AnonymousClassDeclaration anonymousDeclaration = cIC.getAnonymousClassDeclaration();
        if (anonymousDeclaration != null) {
            this.scope.addAnonymousClassDeclaration(anonymousDeclaration);
        }
        if (binding != null) {
            this.scope.registerClass(binding.getDeclaringClass());
        }
        List<JExpression> params = this.getParameterExpressions(cIC);
        String name = this.getFullName(cIC);
        JConstructorDeclaration declaration = this.getConstructorDeclaration(cIC);
        JIdExpression functionName = new JIdExpression(this.getFileLocation((ASTNode)cIC), this.convert(cIC.resolveTypeBinding()), name, declaration);
        if (declaration.getParameters().size() != params.size()) {
            throw new AssertionError((Object)"Error in converting ClassInstanceCreation to JClassInstanceCreation. Amount of parameters does not match.");
        }
        return new JClassInstanceCreation(this.getFileLocation((ASTNode)cIC), declaration.getType().getReturnType(), (JExpression)functionName, params, declaration);
    }

    private JConstructorDeclaration getConstructorDeclaration(ClassInstanceCreation pCIC) {
        AnonymousClassDeclaration anonymousDecl = pCIC.getAnonymousClassDeclaration();
        String fullName = this.getFullName(pCIC);
        JConstructorDeclaration declaration = anonymousDecl == null ? (JConstructorDeclaration)this.scope.lookupMethod(fullName) : this.getConstructorOfAnonymousClass(anonymousDecl, pCIC.resolveConstructorBinding());
        if (declaration == null) {
            declaration = this.getDefaultConstructor(pCIC);
        }
        return declaration;
    }

    private JConstructorDeclaration getDefaultConstructor(ClassInstanceCreation pCIC) {
        String fullName = this.getFullName(pCIC);
        String simpleName = this.getSimpleName(pCIC);
        IMethodBinding constructorBinding = pCIC.resolveConstructorBinding();
        if (constructorBinding != null) {
            ModifierBean mb = ModifierBean.getModifiers(constructorBinding);
            JConstructorType jConstructorType = this.convertConstructorType(constructorBinding, pCIC.arguments());
            ArrayList<JParameterDeclaration> parameterDeclarations = new ArrayList<JParameterDeclaration>();
            for (JType parameter : jConstructorType.getParameters()) {
                parameterDeclarations.add(new JParameterDeclaration(this.getFileLocation((ASTNode)pCIC), parameter, parameter instanceof JClassOrInterfaceType ? ((JClassOrInterfaceType)parameter).getSimpleName() : ((JSimpleType)parameter).toString(), parameter instanceof JClassOrInterfaceType ? ((JClassOrInterfaceType)parameter).getName() : ((JSimpleType)parameter).toString(), parameter instanceof JClassType && ((JClassType)parameter).isFinal()));
            }
            return new JConstructorDeclaration(this.getFileLocation((ASTNode)pCIC), jConstructorType, fullName, simpleName, (List<JParameterDeclaration>)ImmutableList.copyOf(parameterDeclarations), mb.getVisibility(), mb.isStrictFp(), this.getDeclaringClassType(constructorBinding));
        }
        this.logger.logf(Level.FINEST, "No matching class for class instance creation \"%s\" in scope, trying to resolve by imports", new Object[]{fullName});
        Set<ImportDeclaration> importDeclarations = ASTConverter.getImportDeclarations((ASTNode)pCIC);
        Optional<Constructor<?>> constructorOptional = this.matchConstructor(pCIC.getType().toString(), pCIC.arguments(), importDeclarations);
        if (constructorOptional.isPresent()) {
            JClassOrInterfaceType declaringClass = this.scope.getCurrentClassType();
            JClassType jTypeFromConstructor = this.createOrFindJClassTypeFromConstructor(constructorOptional.orElseThrow());
            JConstructorType constructorType = new JConstructorType(jTypeFromConstructor, this.getJTypesOfParameters(pCIC.arguments()), constructorOptional.orElseThrow().isVarArgs());
            return new JConstructorDeclaration(this.getFileLocation((ASTNode)pCIC), constructorType, fullName, simpleName, this.createJParameterDeclarationsForArguments(pCIC.arguments()), this.getVisibilityModifierForConstructor(constructorOptional.orElseThrow()), jTypeFromConstructor.isStrictFp(), declaringClass);
        }
        return new JConstructorDeclaration(this.getFileLocation((ASTNode)pCIC), JConstructorType.createUnresolvableConstructorType(), fullName, simpleName, this.createJParameterDeclarationsForArguments(pCIC.arguments()), VisibilityModifier.NONE, false, JClassType.createUnresolvableType());
    }

    private JClassType createOrFindJClassTypeFromConstructor(Constructor<?> pConstructor) {
        VisibilityModifier visibilityModifierForConstructor = this.getVisibilityModifierForConstructor(pConstructor);
        Class<?> pClazz = pConstructor.getDeclaringClass();
        TypeHierarchy typeHierarchy = this.scope.getTypeHierarchy();
        JClassType jClassTypeFromClass = ASTConverter.createJClassTypeFromClass(pClazz, visibilityModifierForConstructor, typeHierarchy);
        typeHierarchy.updateTypeHierarchy(jClassTypeFromClass);
        return jClassTypeFromClass;
    }

    public static JClassType createJClassTypeFromClass(Class<?> pClazz, VisibilityModifier pVisibilityModifier, TypeHierarchy pTypeHierarchy) {
        JClassType jTypeOfSuperClass;
        String name = pClazz.getName();
        if (pTypeHierarchy.containsClassType(name)) {
            return pTypeHierarchy.getClassType(name);
        }
        String simpleName = pClazz.getSimpleName();
        Class<?> superclass = pClazz.getSuperclass();
        JClassType typeOfObject = JClassType.getTypeOfObject();
        if ("java.lang.Object".equals(superclass.getName())) {
            jTypeOfSuperClass = typeOfObject;
        } else {
            Set<JClassType> directSubClassesOfTypeObject = typeOfObject.getDirectSubClasses();
            Optional<JClassType> superClassInTypeOfObject = directSubClassesOfTypeObject.stream().filter(v -> v.getName().equals(superclass.getName())).findFirst();
            if (superClassInTypeOfObject.isPresent()) {
                return superClassInTypeOfObject.orElseThrow();
            }
            jTypeOfSuperClass = ASTConverter.createJClassTypeFromClass(superclass, VisibilityModifier.PUBLIC, pTypeHierarchy);
        }
        ModifierBean modifiers = ModifierBean.getModifiers(pClazz.getModifiers());
        return JClassType.valueOf(name, simpleName, pVisibilityModifier, modifiers.isFinal, modifiers.isAbstract, modifiers.isStrictFp, jTypeOfSuperClass, (Set<JInterfaceType>)ImmutableSet.of());
    }

    private static Set<ImportDeclaration> getImportDeclarations(ASTNode astNode) {
        ASTNode compilationUnit = astNode.getParent();
        while (!(compilationUnit instanceof CompilationUnit)) {
            compilationUnit = compilationUnit.getParent();
        }
        return FluentIterable.from((Iterable)((CompilationUnit)compilationUnit).imports()).filter(ImportDeclaration.class).toSet();
    }

    private VisibilityModifier getVisibilityModifierForConstructor(Constructor<?> pConstructor) {
        VisibilityModifier visibilityModifier;
        int i = pConstructor.toGenericString().indexOf(32);
        String visibilityModifierString = pConstructor.toGenericString().substring(0, i);
        try {
            visibilityModifier = VisibilityModifier.valueOf(visibilityModifierString.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            visibilityModifier = VisibilityModifier.NONE;
        }
        return visibilityModifier;
    }

    private static Optional<ImportDeclaration> getMatchingImportDeclaration(String pTypeAsString, Set<ImportDeclaration> pImportDeclarations) {
        for (ImportDeclaration importDeclaration : pImportDeclarations) {
            Pattern pattern = Pattern.compile("\\.[A-Z].*;$");
            Matcher matcher = pattern.matcher(importDeclaration.toString());
            String importedClass = "";
            while (matcher.find()) {
                importedClass = importDeclaration.toString().substring(matcher.start(), matcher.end()).replace(".", "").replace(";", "");
            }
            if (!importedClass.equals(pTypeAsString)) continue;
            return Optional.of(importDeclaration);
        }
        return Optional.empty();
    }

    private Optional<Constructor<?>> matchConstructor(String pClassName, List<?> pArguments, Set<ImportDeclaration> pImportDeclarations) {
        Class<?> cls;
        Optional<ImportDeclaration> matchingImportDeclaration = ASTConverter.getMatchingImportDeclaration(pClassName, pImportDeclarations);
        if (!matchingImportDeclaration.isPresent()) {
            try {
                cls = Class.forName("java.lang." + pClassName);
            }
            catch (ClassNotFoundException pE) {
                return Optional.empty();
            }
        }
        try {
            cls = Class.forName(matchingImportDeclaration.orElseThrow().getName().getFullyQualifiedName());
        }
        catch (ClassNotFoundException pE) {
            return Optional.empty();
        }
        Optional<List<Class<?>>> argumentsAsClassArray = this.convertArgumentListToClassList(pArguments, pImportDeclarations);
        if (argumentsAsClassArray.isEmpty()) {
            return Optional.empty();
        }
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            boolean match = true;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != argumentsAsClassArray.orElseThrow().size()) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i].isAssignableFrom(argumentsAsClassArray.orElseThrow().get(i))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return Optional.of(constructor);
        }
        return Optional.empty();
    }

    private Optional<List<Class<?>>> convertArgumentListToClassList(List<?> pArguments, Set<ImportDeclaration> pImportDeclarations) {
        ArrayList result = new ArrayList(pArguments.size());
        for (Object argument : pArguments) {
            Optional<JSimpleDeclaration> optionalOfSimpleDeclaration = this.getJSimpleDeclarationOfArgument(argument);
            if (optionalOfSimpleDeclaration.isPresent()) {
                JType simpleDeclarationType = argument instanceof ArrayAccess ? ((JArrayType)optionalOfSimpleDeclaration.orElseThrow().getType()).getElementType() : optionalOfSimpleDeclaration.orElseThrow().getType();
                Optional<Class<?>> classOfJType = ASTConverter.getClassOfJType(simpleDeclarationType, pImportDeclarations);
                result.add(classOfJType.orElseThrow());
                continue;
            }
            if (argument instanceof Expression && !(argument instanceof InfixExpression)) {
                ITypeBinding binding = ((Expression)argument).resolveTypeBinding();
                if (binding != null) {
                    JType jType = this.typeConverter.convert(binding);
                    result.add(ASTConverter.getClassOfJType(jType, pImportDeclarations).orElseThrow());
                    continue;
                }
                return Optional.empty();
            }
            if (argument instanceof InfixExpression) {
                JBinaryExpression expression = (JBinaryExpression)this.convert((InfixExpression)argument);
                result.add(ASTConverter.getClassOfJType(expression.getExpressionType(), pImportDeclarations).orElseThrow());
                continue;
            }
            throw new AssertionError((Object)("Cannot find class of " + argument));
        }
        if (pArguments.size() != result.size()) {
            throw new AssertionError((Object)"Error while converting arguments into array of classes.");
        }
        return Optional.of(ImmutableList.copyOf(result));
    }

    private Optional<JSimpleDeclaration> getJSimpleDeclarationOfArgument(Object pArgument) {
        String argumentName;
        if (pArgument instanceof ArrayAccess) {
            argumentName = ((ArrayAccess)pArgument).getArray().toString();
        } else if (pArgument instanceof InfixExpression) {
            JExpression jExpression = this.convert((InfixExpression)pArgument);
            argumentName = jExpression.getExpressionType().toString();
        } else {
            argumentName = pArgument.toString();
        }
        JSimpleDeclaration simpleDeclaration = this.scope.lookupVariable(argumentName);
        if (simpleDeclaration != null) {
            return Optional.of(simpleDeclaration);
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static Optional<Class<?>> getClassOfJType(JType pJType, Set<ImportDeclaration> pImportDeclarations) {
        if (pJType instanceof JSimpleType) {
            return Optional.of(ASTConverter.getClassOfPrimitiveType((JSimpleType)pJType));
        }
        if (pJType instanceof JClassOrInterfaceType) {
            String jTypeName = ((JClassOrInterfaceType)pJType).getName();
            Optional<ImportDeclaration> matchingImportDeclaration = ASTConverter.getMatchingImportDeclaration(jTypeName, pImportDeclarations);
            Optional<Class<?>> cls = Optional.empty();
            if (matchingImportDeclaration.isPresent()) {
                try {
                    cls = Optional.of(Class.forName(matchingImportDeclaration.orElseThrow().getName().getFullyQualifiedName()));
                }
                catch (ClassNotFoundException pE) {
                    cls = Optional.empty();
                }
            }
            if (!cls.isPresent()) {
                try {
                    cls = Optional.of(Class.forName(jTypeName));
                }
                catch (ClassNotFoundException pE) {
                    cls = Optional.empty();
                }
            }
            if (!cls.isPresent()) {
                try {
                    String className = "java.lang." + jTypeName;
                    cls = Optional.of(Class.forName(className));
                }
                catch (ClassNotFoundException pE) {
                    cls = Optional.empty();
                }
            }
            if (!cls.isPresent()) {
                return cls;
            }
            return cls;
        }
        if (pJType instanceof JArrayType) {
            JType elementTypeOfJArrayType = ((JArrayType)pJType).getElementType();
            Optional<Class<?>> typeOfArray = ASTConverter.getClassOfJType(elementTypeOfJArrayType, pImportDeclarations);
            int dimensionsOfArray = ((JArrayType)pJType).getDimensions();
            Class<?> array = Array.newInstance(typeOfArray.orElseThrow(), 0).getClass();
            for (int i = 1; i < dimensionsOfArray; ++i) {
                array = Array.newInstance(array, 0).getClass();
            }
            return Optional.of(array);
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static Class<?> getClassOfPrimitiveType(JSimpleType pJSimpleType) {
        Class<Object> cls;
        switch (pJSimpleType.getType()) {
            case BOOLEAN: {
                cls = Boolean.TYPE;
                break;
            }
            case CHAR: {
                cls = Character.TYPE;
                break;
            }
            case DOUBLE: {
                cls = Double.TYPE;
                break;
            }
            case FLOAT: {
                cls = Float.TYPE;
                break;
            }
            case INT: {
                cls = Integer.TYPE;
                break;
            }
            case VOID: {
                cls = Void.TYPE;
                break;
            }
            case LONG: {
                cls = Long.TYPE;
                break;
            }
            case SHORT: {
                cls = Short.TYPE;
                break;
            }
            case BYTE: {
                cls = Byte.TYPE;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown primitive type " + pJSimpleType));
            }
        }
        return cls;
    }

    private List<JType> getJTypesOfParameters(List<?> arguments) {
        ArrayList<JType> parameterList = new ArrayList<JType>();
        for (Object argument : arguments) {
            JSimpleDeclaration jSimpleDeclaration = this.scope.lookupVariable(argument.toString());
            if (jSimpleDeclaration != null) {
                parameterList.add(jSimpleDeclaration.getType());
                continue;
            }
            if (argument instanceof Expression) {
                if (argument instanceof InfixExpression) {
                    parameterList.add(this.convert((InfixExpression)argument).getExpressionType());
                    continue;
                }
                parameterList.add(this.typeConverter.convert((Expression)argument));
                continue;
            }
            throw new CFAGenerationRuntimeException("Could not process argument: " + argument + " .");
        }
        return ImmutableList.copyOf(parameterList);
    }

    private List<JParameterDeclaration> createJParameterDeclarationsForArguments(List<?> arguments) {
        ArrayList<JParameterDeclaration> parameterList = new ArrayList<JParameterDeclaration>();
        for (Object argument : arguments) {
            Optional<JSimpleDeclaration> simpleDeclarationOptional = this.getJSimpleDeclarationOfArgument(argument);
            if (simpleDeclarationOptional.isPresent()) {
                parameterList.add(this.convertSimpleDeclarationToParameterDeclaration(simpleDeclarationOptional.orElseThrow()).orElseThrow());
                continue;
            }
            if (argument instanceof Expression) {
                String qualifiedName;
                String name;
                JType jType;
                if (argument instanceof InfixExpression) {
                    jType = this.convert((InfixExpression)argument).getExpressionType();
                    if (jType instanceof JSimpleType) {
                        name = ((JSimpleType)jType).toString();
                        qualifiedName = ((JSimpleType)jType).toString();
                    } else {
                        name = ((JClassType)jType).getSimpleName();
                        qualifiedName = ((JClassType)jType).getName();
                    }
                } else if (argument instanceof StringLiteral) {
                    jType = this.convert((StringLiteral)argument).getExpressionType();
                    name = ((JClassType)jType).getSimpleName();
                    qualifiedName = ((JClassType)jType).getName();
                } else {
                    ITypeBinding binding = ((Expression)argument).resolveTypeBinding();
                    jType = this.typeConverter.convert(binding);
                    if (binding != null) {
                        name = binding.getName();
                        qualifiedName = binding.getQualifiedName();
                    } else {
                        name = jType.toString();
                        qualifiedName = jType.toString();
                    }
                }
                parameterList.add(new JParameterDeclaration(this.getFileLocation((ASTNode)argument), jType, name, qualifiedName, jType instanceof JClassType && ((JClassType)jType).isFinal()));
                continue;
            }
            throw new CFAGenerationRuntimeException("Could not process argument: " + argument + " .");
        }
        return ImmutableList.copyOf(parameterList);
    }

    private Optional<JParameterDeclaration> convertSimpleDeclarationToParameterDeclaration(JSimpleDeclaration js) {
        if (js instanceof JVariableDeclaration) {
            return Optional.of(new JParameterDeclaration(js.getFileLocation(), js.getType(), js.getName(), js.getQualifiedName(), ((JVariableDeclaration)js).isFinal()));
        }
        if (js instanceof JParameterDeclaration) {
            return Optional.of((JParameterDeclaration)js);
        }
        throw new CFAGenerationRuntimeException("Could not convert " + js.getName() + " to ParameterDeclaration");
    }

    private JConstructorDeclaration getConstructorOfAnonymousClass(AnonymousClassDeclaration pAnonymousDecl, IMethodBinding pInstanceCreation) {
        ITypeBinding anonymousDeclBinding = pAnonymousDecl.resolveBinding();
        if (anonymousDeclBinding != null) {
            Object parameterTypes;
            Object parameterDeclarations;
            FileLocation fileLoc = this.getFileLocation((ASTNode)pAnonymousDecl);
            boolean takesVarArgs = false;
            boolean isStrictFP = false;
            JClassOrInterfaceType returnType = this.convertClassOrInterfaceType(anonymousDeclBinding);
            if (pInstanceCreation != null) {
                parameterDeclarations = this.getParameterDeclarations(pInstanceCreation.getParameterTypes(), fileLoc);
                parameterTypes = new ArrayList(parameterDeclarations.size());
            } else {
                parameterDeclarations = ImmutableList.of();
                parameterTypes = ImmutableList.of();
            }
            Iterator iterator = parameterDeclarations.iterator();
            while (iterator.hasNext()) {
                JParameterDeclaration d = (JParameterDeclaration)iterator.next();
                parameterTypes.add(d.getType());
            }
            JConstructorType constructorType = new JConstructorType(returnType, (List<JType>)parameterTypes, false);
            String fullName = NameConverter.convertAnonymousClassConstructorName(anonymousDeclBinding, (List<JType>)parameterTypes);
            JClassOrInterfaceType declaringClass = this.convertClassOrInterfaceType(anonymousDeclBinding.getDeclaringClass());
            return new JConstructorDeclaration(fileLoc, constructorType, fullName, fullName, (List<JParameterDeclaration>)parameterDeclarations, VisibilityModifier.PRIVATE, false, declaringClass);
        }
        this.logger.logf(Level.WARNING, "Binding for anonymous class %s can't be resolved.", new Object[]{pAnonymousDecl.toString()});
        return null;
    }

    private List<JParameterDeclaration> getParameterDeclarations(ITypeBinding[] pBindings, FileLocation pFileLoc) {
        ArrayList<JParameterDeclaration> declarations = new ArrayList<JParameterDeclaration>(pBindings.length);
        for (ITypeBinding binding : pBindings) {
            declarations.add(this.getParameterDeclaration(binding, pFileLoc));
        }
        return declarations;
    }

    private JParameterDeclaration getParameterDeclaration(ITypeBinding pBinding, FileLocation pFileLoc) {
        JType parameterType = this.convert(pBinding);
        String simpleName = pBinding.getName();
        String qualifiedName = pBinding.getQualifiedName();
        return new JParameterDeclaration(pFileLoc, parameterType, simpleName, qualifiedName, false);
    }

    private String getFullName(ClassInstanceCreation pCIC) {
        IMethodBinding binding = pCIC.resolveConstructorBinding();
        if (binding != null) {
            return NameConverter.convertName(binding);
        }
        AnonymousClassDeclaration anonymousDeclaration = pCIC.getAnonymousClassDeclaration();
        if (anonymousDeclaration != null) {
            return NameConverter.convertClassOrInterfaceToFullName(anonymousDeclaration.resolveBinding());
        }
        return pCIC.toString();
    }

    private String getSimpleName(ClassInstanceCreation pCIC) {
        IMethodBinding binding = pCIC.resolveConstructorBinding();
        if (binding != null) {
            return this.getSimpleName(binding.getDeclaringClass());
        }
        AnonymousClassDeclaration anonymousDeclaration = pCIC.getAnonymousClassDeclaration();
        if (anonymousDeclaration != null) {
            return this.getSimpleName(anonymousDeclaration.resolveBinding());
        }
        return pCIC.toString();
    }

    private String getSimpleName(ITypeBinding pBinding) {
        String name = pBinding.getName();
        if (name.isEmpty()) {
            name = NameConverter.convertClassOrInterfaceToFullName(pBinding);
        }
        return name;
    }

    private List<JExpression> getParameterExpressions(ClassInstanceCreation pCIC) {
        List p = pCIC.arguments();
        return this.convert(p);
    }

    private JAstNode convert(ConditionalExpression e) {
        JIdExpression tmp;
        this.conditionalTemporaryVariable = tmp = this.createTemporaryVariable((Expression)e);
        this.conditionalExpression = e;
        return tmp;
    }

    private JAstNode convert(ArrayInitializer initializer) {
        if (initializer == null) {
            this.logger.log(Level.FINE, new Object[]{"Array initializer to convert is null"});
            return null;
        }
        JArrayType type = (JArrayType)this.convert(initializer.resolveTypeBinding());
        ArrayList<JExpression> initializerExpressions = new ArrayList<JExpression>();
        List expressions = initializer.expressions();
        for (Expression exp : expressions) {
            initializerExpressions.add(this.convertExpressionWithoutSideEffects(exp));
        }
        return new JArrayInitializer(this.getFileLocation((ASTNode)initializer), initializerExpressions, type);
    }

    private JAstNode convert(ArrayCreation Ace) {
        FileLocation fileloc = this.getFileLocation((ASTNode)Ace);
        JArrayInitializer initializer = (JArrayInitializer)this.convertExpressionWithoutSideEffects((Expression)Ace.getInitializer());
        JArrayType type = this.convert(Ace.getType());
        ArrayList<JExpression> length = new ArrayList<JExpression>(type.getDimensions());
        List dim = Ace.dimensions();
        if (initializer != null) {
            for (int dimension = 0; dimension < type.getDimensions(); ++dimension) {
                length.add(new JIntegerLiteralExpression(fileloc, BigInteger.valueOf(dimension)));
            }
        } else {
            for (Expression exp : dim) {
                length.add(this.convertExpressionWithoutSideEffects(exp));
            }
        }
        return new JArrayCreationExpression(fileloc, type, initializer, length);
    }

    private JAstNode convert(ArrayAccess e) {
        JExpression subscriptExpression = this.convertExpressionWithoutSideEffects(e.getArray());
        JExpression index = this.convertExpressionWithoutSideEffects(e.getIndex());
        assert (subscriptExpression != null);
        assert (index != null);
        return new JArraySubscriptExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), subscriptExpression, index);
    }

    private JAstNode convert(QualifiedName e) {
        boolean canBeResolved;
        if (this.isArrayLengthExpression(e)) {
            return this.createJArrayLengthExpression(e);
        }
        IBinding binding = e.resolveBinding();
        boolean bl = canBeResolved = binding != null;
        if (canBeResolved) {
            if (binding instanceof IMethodBinding) {
                String name = NameConverter.convertName((IMethodBinding)e.resolveBinding());
                return new JIdExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, null);
            }
            if (binding instanceof IVariableBinding) {
                IVariableBinding vb = (IVariableBinding)binding;
                if (vb.isEnumConstant()) {
                    return new JEnumConstantExpression(this.getFileLocation((ASTNode)e), (JClassType)this.convert(e.resolveTypeBinding()), NameConverter.convertName((IVariableBinding)e.resolveBinding()));
                }
                return this.convertQualifiedVariableIdentificationExpression(e);
            }
            String name = e.getFullyQualifiedName();
            return new JIdExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, null);
        }
        String name = e.getFullyQualifiedName();
        return new JIdExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, null);
    }

    private boolean isArrayLengthExpression(QualifiedName e) {
        JExpression qualifierExpression = this.convertExpressionWithoutSideEffects((Expression)e.getQualifier());
        String lengthExpression = "length";
        IBinding lengthBinding = e.resolveBinding();
        return lengthBinding != null && lengthBinding.getName().equals("length") && this.isArrayType(qualifierExpression.getExpressionType()) || this.isMainArgumentArray(e, qualifierExpression);
    }

    private boolean isMainArgumentArray(QualifiedName e, JExpression qualifierExpression) {
        IBinding lengthBinding = e.resolveBinding();
        if (qualifierExpression instanceof JIdExpression) {
            JSimpleDeclaration qualifierDecl = ((JIdExpression)qualifierExpression).getDeclaration();
            return lengthBinding == null && qualifierDecl instanceof JParameterDeclaration && this.isArrayType(qualifierDecl.getType());
        }
        return false;
    }

    private JArrayLengthExpression createJArrayLengthExpression(QualifiedName e) {
        JExpression qualifierExpression = this.convertExpressionWithoutSideEffects((Expression)e.getQualifier());
        return JArrayLengthExpression.getInstance(qualifierExpression, this.getFileLocation((ASTNode)e));
    }

    private boolean isArrayType(JType pType) {
        return pType instanceof JArrayType;
    }

    private JAstNode convertQualifiedVariableIdentificationExpression(QualifiedName e) {
        JExpression identifier = this.convertExpressionWithoutSideEffects((Expression)e.getName());
        if (!(identifier instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException("Identifier of FieldAccess could not be processed.", (ASTNode)e);
        }
        JIdExpression idExpIdentifier = (JIdExpression)identifier;
        JExpression qualifier = this.convertExpressionWithoutSideEffects((Expression)e.getQualifier());
        if (qualifier instanceof JThisExpression) {
            return idExpIdentifier;
        }
        if (!(qualifier instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException("Qualifier of FieldAccess could not be processed.", (ASTNode)e);
        }
        JSimpleDeclaration decl = idExpIdentifier.getDeclaration();
        if (!(decl instanceof JFieldDeclaration)) {
            throw new CFAGenerationRuntimeException("Identifier of FieldAccess does not identify a field.", (ASTNode)e);
        }
        return new JFieldAccess(idExpIdentifier.getFileLocation(), idExpIdentifier.getExpressionType(), idExpIdentifier.getName(), (JFieldDeclaration)decl, (JIdExpression)qualifier);
    }

    public JMethodInvocationExpression convert(FunctionEntryNode newFunctionEntryNode, JMethodInvocationExpression oldMethodCall) {
        JMethodDeclaration declaration = (JMethodDeclaration)newFunctionEntryNode.getFunctionDefinition();
        String name = newFunctionEntryNode.getFunctionName();
        JIdExpression methodName = new JIdExpression(oldMethodCall.getFileLocation(), JSimpleType.getUnspecified(), name, declaration);
        if (oldMethodCall instanceof JReferencedMethodInvocationExpression) {
            return new JReferencedMethodInvocationExpression(oldMethodCall.getFileLocation(), oldMethodCall.getExpressionType(), methodName, oldMethodCall.getParameterExpressions(), declaration, ((JReferencedMethodInvocationExpression)oldMethodCall).getReferencedVariable());
        }
        return new JMethodInvocationExpression(oldMethodCall.getFileLocation(), oldMethodCall.getExpressionType(), methodName, oldMethodCall.getParameterExpressions(), declaration);
    }

    private JAstNode convert(MethodInvocation mi) {
        List p;
        IMethodBinding methodBinding = mi.resolveMethodBinding();
        ModifierBean mb = methodBinding != null ? ModifierBean.getModifiers(methodBinding) : null;
        JClassOrInterfaceType declaringClassType = null;
        if (methodBinding != null) {
            ITypeBinding declaringClass = methodBinding.getDeclaringClass();
            declaringClassType = (JClassOrInterfaceType)this.convert(declaringClass);
            this.scope.registerClass(declaringClass);
        }
        Object params = !(p = mi.arguments()).isEmpty() ? this.convert(p) : ImmutableList.of();
        JExpression methodName = this.convertExpressionWithoutSideEffects((Expression)mi.getName());
        JMethodDeclaration declaration = null;
        JExpression referencedVariableName = null;
        if (mb != null && !mb.isStatic && mi.getExpression() != null) {
            referencedVariableName = this.convertExpressionWithoutSideEffects(mi.getExpression());
        }
        if (methodName instanceof JIdExpression) {
            JIdExpression idExpression = (JIdExpression)methodName;
            String name = idExpression.getName();
            declaration = this.scope.lookupMethod(name);
            if (idExpression.getDeclaration() != null) {
                methodName = new JIdExpression(idExpression.getFileLocation(), idExpression.getExpressionType(), name, declaration);
            }
        }
        if (declaration == null) {
            if (methodBinding != null) {
                assert (mb != null);
                declaration = this.scope.createExternMethodDeclaration(this.convertMethodType(methodBinding), methodName.toASTString(), methodBinding.getName(), VisibilityModifier.PUBLIC, mb.isFinal(), mb.isAbstract(), mb.isStatic(), mb.isNative(), mb.isSynchronized(), mb.isStrictFp(), declaringClassType);
            } else {
                declaration = JMethodDeclaration.createUnresolvedMethodDeclaration();
            }
        }
        if (!(referencedVariableName instanceof JIdExpression)) {
            return new JMethodInvocationExpression(this.getFileLocation((ASTNode)mi), this.convert(mi.resolveTypeBinding()), methodName, (List<? extends JExpression>)params, declaration);
        }
        return new JReferencedMethodInvocationExpression(this.getFileLocation((ASTNode)mi), this.convert(mi.resolveTypeBinding()), methodName, (List<? extends JExpression>)params, declaration, (JIdExpression)referencedVariableName);
    }

    private List<JExpression> convert(List<Expression> el) {
        ArrayList<JExpression> result = new ArrayList<JExpression>(el.size());
        for (Expression expression : el) {
            result.add(this.convertExpressionWithoutSideEffects(expression));
        }
        return result;
    }

    private JAstNode convert(SimpleName e) {
        boolean canBeResolved;
        String name = null;
        JMethodDeclaration declaration = null;
        IBinding binding = e.resolveBinding();
        boolean bl = canBeResolved = binding != null;
        if (canBeResolved) {
            if (binding instanceof IVariableBinding) {
                return this.convertSimpleVariable(e, (IVariableBinding)binding);
            }
            if (binding instanceof IMethodBinding) {
                name = NameConverter.convertName((IMethodBinding)binding);
                declaration = this.scope.lookupMethod(name);
            } else if (binding instanceof ITypeBinding) {
                name = e.getIdentifier();
            }
        } else {
            name = e.getIdentifier();
        }
        assert (name != null);
        return new JIdExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, declaration);
    }

    private JAstNode convertSimpleVariable(SimpleName e, IVariableBinding vb) {
        if (((IVariableBinding)e.resolveBinding()).isEnumConstant()) {
            return new JEnumConstantExpression(this.getFileLocation((ASTNode)e), (JClassType)this.convert(e.resolveTypeBinding()), NameConverter.convertName((IVariableBinding)e.resolveBinding()));
        }
        String name = NameConverter.convertName(vb);
        JSimpleDeclaration declaration = this.scope.lookupVariable(name);
        if (declaration == null) {
            declaration = this.createVariableDeclarationFromBinding(e, vb);
        }
        assert (name.equals(declaration.getOrigName())) : "Created a false declaration for " + e;
        JType type = this.convert(e.resolveTypeBinding());
        return new JIdExpression(this.getFileLocation((ASTNode)e), type, declaration.getName(), declaration);
    }

    private JSimpleDeclaration createVariableDeclarationFromBinding(SimpleName e, IVariableBinding vb) {
        if (!vb.isField()) {
            throw new CFAGenerationRuntimeException("Declaration of Variable " + e.getIdentifier() + " not found.", (ASTNode)e);
        }
        String name = NameConverter.convertName(vb);
        String simpleName = vb.getName();
        ModifierBean mb = ModifierBean.getModifiers(vb.getModifiers());
        JType type = this.convert(e.resolveTypeBinding());
        JFieldDeclaration decl = this.scope.createExternFieldDeclaration(type, name, simpleName, mb.isFinal(), mb.isStatic(), mb.getVisibility(), mb.isVolatile(), mb.isTransient());
        return decl;
    }

    private JAstNode convert(Assignment e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        JLeftHandSide leftHandSide = (JLeftHandSide)this.convertExpressionWithoutSideEffects(e.getLeftHandSide());
        JBinaryExpression.BinaryOperator op = this.convert(e.getOperator(), leftHandSide.getExpressionType());
        if (op == null) {
            JAstNode rightHandSide = this.convertExpressionWithSideEffects(e.getRightHandSide());
            if (rightHandSide instanceof JExpression) {
                return new JExpressionAssignmentStatement(fileLoc, leftHandSide, (JExpression)rightHandSide);
            }
            if (rightHandSide instanceof JMethodInvocationExpression) {
                return new JMethodInvocationAssignmentStatement(fileLoc, leftHandSide, (JMethodInvocationExpression)rightHandSide);
            }
            if (rightHandSide instanceof JAssignment) {
                this.preSideAssignments.add(rightHandSide);
                return new JExpressionAssignmentStatement(fileLoc, leftHandSide, ((JAssignment)rightHandSide).getLeftHandSide());
            }
            throw new CFAGenerationRuntimeException("Expression is not free of side-effects");
        }
        JExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getRightHandSide());
        JBinaryExpression exp = new JBinaryExpression(fileLoc, type, leftHandSide, rightHandSide, op);
        return new JExpressionAssignmentStatement(fileLoc, leftHandSide, exp);
    }

    private JBinaryExpression.BinaryOperator convert(Assignment.Operator op, JType type) {
        String invalidTypeMsg = "Invalid type '" + type + "' for assignment with binary operation.";
        JBasicType basicType = type instanceof JSimpleType ? ((JSimpleType)type).getType() : null;
        if (op.equals(Assignment.Operator.ASSIGN)) {
            return null;
        }
        if (basicType != null) {
            switch (basicType) {
                case BOOLEAN: {
                    return this.convertBooleanOperator(op);
                }
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case BYTE: {
                    return this.convertNumberOperator(op);
                }
            }
            throw new CFAGenerationRuntimeException(invalidTypeMsg);
        }
        throw new CFAGenerationRuntimeException(invalidTypeMsg);
    }

    private JBinaryExpression.BinaryOperator convertBooleanOperator(Assignment.Operator op) {
        if (op.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_AND;
        }
        if (op.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_OR;
        }
        if (op.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_XOR;
        }
        throw new CFAGenerationRuntimeException("Invalid operator " + op + " for boolean assignment");
    }

    private JBinaryExpression.BinaryOperator convertNumberOperator(Assignment.Operator op) {
        if (op.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.BINARY_AND;
        }
        if (op.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.BINARY_OR;
        }
        if (op.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.BINARY_XOR;
        }
        if (op.equals(Assignment.Operator.DIVIDE_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.DIVIDE;
        }
        if (op.equals(Assignment.Operator.LEFT_SHIFT_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.SHIFT_LEFT;
        }
        if (op.equals(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.SHIFT_RIGHT_SIGNED;
        }
        if (op.equals(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.SHIFT_RIGHT_UNSIGNED;
        }
        if (op.equals(Assignment.Operator.MINUS_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.MINUS;
        }
        if (op.equals(Assignment.Operator.PLUS_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.PLUS;
        }
        if (op.equals(Assignment.Operator.REMAINDER_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.MODULO;
        }
        if (op.equals(Assignment.Operator.TIMES_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.MULTIPLY;
        }
        throw new CFAGenerationRuntimeException("Invalid operator " + op + " for number assignment.");
    }

    private JExpression convert(BooleanLiteral e) {
        return new JBooleanLiteralExpression(this.getFileLocation((ASTNode)e), e.booleanValue());
    }

    private JAstNode convert(PrefixExpression e) {
        PrefixExpression.Operator op = e.getOperator();
        if (op.equals(PrefixExpression.Operator.INCREMENT) || op.equals(PrefixExpression.Operator.DECREMENT)) {
            return this.handlePreFixIncOrDec(e, op);
        }
        JExpression operand = this.convertExpressionWithoutSideEffects(e.getOperand());
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        return new JUnaryExpression(fileLoc, this.convert(e.resolveTypeBinding()), operand, this.convert(op));
    }

    private JAstNode convert(PostfixExpression e) {
        PostfixExpression.Operator op = e.getOperator();
        return this.handlePostFixIncOrDec(e, op);
    }

    private JAstNode handlePostFixIncOrDec(PostfixExpression e, PostfixExpression.Operator op) {
        JBinaryExpression.BinaryOperator postOp = null;
        if (op.equals(PostfixExpression.Operator.INCREMENT)) {
            postOp = JBinaryExpression.BinaryOperator.PLUS;
        } else if (op.equals(PostfixExpression.Operator.DECREMENT)) {
            postOp = JBinaryExpression.BinaryOperator.MINUS;
        }
        assert (postOp != null) : "Increment/Decrement Severe Error.";
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        JLeftHandSide operand = (JLeftHandSide)this.convertExpressionWithoutSideEffects(e.getOperand());
        JIntegerLiteralExpression preOne = new JIntegerLiteralExpression(fileLoc, BigInteger.ONE);
        JBinaryExpression preExp = new JBinaryExpression(fileLoc, type, operand, preOne, postOp);
        return new JExpressionAssignmentStatement(fileLoc, operand, preExp);
    }

    private JAstNode handlePreFixIncOrDec(PrefixExpression e, PrefixExpression.Operator op) {
        JBinaryExpression.BinaryOperator preOp = null;
        if (op.equals(PrefixExpression.Operator.INCREMENT)) {
            preOp = JBinaryExpression.BinaryOperator.PLUS;
        } else if (op.equals(PrefixExpression.Operator.DECREMENT)) {
            preOp = JBinaryExpression.BinaryOperator.MINUS;
        }
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        JLeftHandSide operand = (JLeftHandSide)this.convertExpressionWithoutSideEffects(e.getOperand());
        JIntegerLiteralExpression preOne = new JIntegerLiteralExpression(fileLoc, BigInteger.ONE);
        JBinaryExpression preExp = new JBinaryExpression(fileLoc, type, operand, preOne, preOp);
        return new JExpressionAssignmentStatement(fileLoc, operand, preExp);
    }

    private JUnaryExpression.UnaryOperator convert(PrefixExpression.Operator op) {
        if (op.equals(PrefixExpression.Operator.NOT)) {
            return JUnaryExpression.UnaryOperator.NOT;
        }
        if (op.equals(PrefixExpression.Operator.PLUS)) {
            return JUnaryExpression.UnaryOperator.PLUS;
        }
        if (op.equals(PrefixExpression.Operator.COMPLEMENT)) {
            return JUnaryExpression.UnaryOperator.COMPLEMENT;
        }
        if (op.equals(PrefixExpression.Operator.MINUS)) {
            return JUnaryExpression.UnaryOperator.MINUS;
        }
        throw new CFAGenerationRuntimeException("Could not proccess Operator:" + op + ".");
    }

    private JExpression convert(InfixExpression e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        JExpression leftHandSide = this.convertExpressionWithoutSideEffects(e.getLeftOperand());
        assert (leftHandSide != null);
        JExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getRightOperand());
        assert (rightHandSide != null);
        JType leftHandType = leftHandSide.getExpressionType();
        JType rightHandType = rightHandSide.getExpressionType();
        JBinaryExpression.BinaryOperator op = this.convert(e.getOperator(), leftHandType, rightHandType);
        if (type.equals(JSimpleType.getUnspecified()) && op == JBinaryExpression.BinaryOperator.STRING_CONCATENATION && this.scope.containsClassType("java.lang.String")) {
            type = this.scope.getClassType("java.lang.String");
        }
        JBinaryExpression binaryExpression = new JBinaryExpression(fileLoc, type, leftHandSide, rightHandSide, op);
        if (e.hasExtendedOperands()) {
            List extOperands = e.extendedOperands();
            for (Expression extendedOperand : extOperands) {
                binaryExpression = new JBinaryExpression(fileLoc, type, binaryExpression, this.convertExpressionWithoutSideEffects(extendedOperand), op);
            }
        }
        return binaryExpression;
    }

    private JBinaryExpression.BinaryOperator convert(InfixExpression.Operator op, JType pOp1Type, JType pOp2Type) {
        JBasicType jBasicType;
        String invalidTypeMsg = "Invalid operation '" + pOp1Type + " " + op + " " + pOp2Type + "'";
        JBasicType basicTypeOp1 = null;
        JBasicType basicTypeOp2 = null;
        if (pOp1Type instanceof JSimpleType) {
            basicTypeOp1 = ((JSimpleType)pOp1Type).getType();
        }
        if (pOp2Type instanceof JSimpleType) {
            basicTypeOp2 = ((JSimpleType)pOp2Type).getType();
        }
        if (pOp1Type instanceof JClassType && basicTypeOp2 != null) {
            JBasicType jBasicType2 = ASTConverter.unboxJClassType((JClassType)pOp1Type).orElse(null);
            if (jBasicType2 == basicTypeOp2) {
                basicTypeOp1 = jBasicType2;
            }
        } else if (pOp2Type instanceof JClassType && basicTypeOp1 != null && (jBasicType = (JBasicType)ASTConverter.unboxJClassType((JClassType)pOp2Type).orElse(null)) == basicTypeOp1) {
            basicTypeOp2 = jBasicType;
        }
        if (basicTypeOp1 == null || basicTypeOp2 == null) {
            if (op.equals(InfixExpression.Operator.EQUALS)) {
                return JBinaryExpression.BinaryOperator.EQUALS;
            }
            if (op.equals(InfixExpression.Operator.NOT_EQUALS)) {
                return JBinaryExpression.BinaryOperator.NOT_EQUALS;
            }
            if (op.equals(InfixExpression.Operator.PLUS) && (this.isStringType(pOp1Type) || this.isStringType(pOp2Type))) {
                return JBinaryExpression.BinaryOperator.STRING_CONCATENATION;
            }
            throw new CFAGenerationRuntimeException(invalidTypeMsg);
        }
        if (this.isNumericCompatible(basicTypeOp1) && this.isNumericCompatible(basicTypeOp2)) {
            return this.convertNumericOperator(op);
        }
        if (this.isBooleanCompatible(basicTypeOp1) && this.isBooleanCompatible(basicTypeOp2)) {
            return this.convertBooleanOperator(op);
        }
        throw new CFAGenerationRuntimeException(invalidTypeMsg);
    }

    @VisibleForTesting
    public static Optional<JBasicType> unboxJClassType(JClassType pJClassType) {
        return Optional.ofNullable((JBasicType)((Object)unboxingMap.getOrDefault((Object)pJClassType.getName(), null)));
    }

    private boolean isNumericCompatible(JBasicType pType) {
        return pType != null && (pType.isIntegerType() || pType.isFloatingPointType() || pType == JBasicType.UNSPECIFIED);
    }

    private boolean isBooleanCompatible(JBasicType pType) {
        return pType == JBasicType.BOOLEAN || pType == JBasicType.UNSPECIFIED;
    }

    private boolean isStringType(JType t) {
        return t instanceof JClassOrInterfaceType && ((JClassOrInterfaceType)t).getName().equals("java.lang.String");
    }

    private JBinaryExpression.BinaryOperator convertNumericOperator(InfixExpression.Operator op) {
        if (op.equals(InfixExpression.Operator.PLUS)) {
            return JBinaryExpression.BinaryOperator.PLUS;
        }
        if (op.equals(InfixExpression.Operator.MINUS)) {
            return JBinaryExpression.BinaryOperator.MINUS;
        }
        if (op.equals(InfixExpression.Operator.DIVIDE)) {
            return JBinaryExpression.BinaryOperator.DIVIDE;
        }
        if (op.equals(InfixExpression.Operator.TIMES)) {
            return JBinaryExpression.BinaryOperator.MULTIPLY;
        }
        if (op.equals(InfixExpression.Operator.REMAINDER)) {
            return JBinaryExpression.BinaryOperator.MODULO;
        }
        if (op.equals(InfixExpression.Operator.GREATER)) {
            return JBinaryExpression.BinaryOperator.GREATER_THAN;
        }
        if (op.equals(InfixExpression.Operator.LESS)) {
            return JBinaryExpression.BinaryOperator.LESS_THAN;
        }
        if (op.equals(InfixExpression.Operator.GREATER_EQUALS)) {
            return JBinaryExpression.BinaryOperator.GREATER_EQUAL;
        }
        if (op.equals(InfixExpression.Operator.LESS_EQUALS)) {
            return JBinaryExpression.BinaryOperator.LESS_EQUAL;
        }
        if (op.equals(InfixExpression.Operator.LEFT_SHIFT)) {
            return JBinaryExpression.BinaryOperator.SHIFT_LEFT;
        }
        if (op.equals(InfixExpression.Operator.RIGHT_SHIFT_SIGNED)) {
            return JBinaryExpression.BinaryOperator.SHIFT_RIGHT_SIGNED;
        }
        if (op.equals(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED)) {
            return JBinaryExpression.BinaryOperator.SHIFT_RIGHT_UNSIGNED;
        }
        if (op.equals(InfixExpression.Operator.NOT_EQUALS)) {
            return JBinaryExpression.BinaryOperator.NOT_EQUALS;
        }
        if (op.equals(InfixExpression.Operator.EQUALS)) {
            return JBinaryExpression.BinaryOperator.EQUALS;
        }
        if (op.equals(InfixExpression.Operator.AND)) {
            return JBinaryExpression.BinaryOperator.BINARY_AND;
        }
        if (op.equals(InfixExpression.Operator.OR)) {
            return JBinaryExpression.BinaryOperator.BINARY_OR;
        }
        if (op.equals(InfixExpression.Operator.XOR)) {
            return JBinaryExpression.BinaryOperator.BINARY_XOR;
        }
        if (op.equals(InfixExpression.Operator.CONDITIONAL_OR)) {
            return JBinaryExpression.BinaryOperator.CONDITIONAL_OR;
        }
        if (op.equals(InfixExpression.Operator.CONDITIONAL_AND)) {
            return JBinaryExpression.BinaryOperator.CONDITIONAL_AND;
        }
        throw new CFAGenerationRuntimeException("Could not process Operator: " + op);
    }

    private JBinaryExpression.BinaryOperator convertBooleanOperator(InfixExpression.Operator op) {
        if (op.equals(InfixExpression.Operator.CONDITIONAL_AND)) {
            return JBinaryExpression.BinaryOperator.CONDITIONAL_AND;
        }
        if (op.equals(InfixExpression.Operator.CONDITIONAL_OR)) {
            return JBinaryExpression.BinaryOperator.CONDITIONAL_OR;
        }
        if (op.equals(InfixExpression.Operator.NOT_EQUALS)) {
            return JBinaryExpression.BinaryOperator.NOT_EQUALS;
        }
        if (op.equals(InfixExpression.Operator.EQUALS)) {
            return JBinaryExpression.BinaryOperator.EQUALS;
        }
        if (op.equals(InfixExpression.Operator.AND)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_AND;
        }
        if (op.equals(InfixExpression.Operator.OR)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_OR;
        }
        if (op.equals(InfixExpression.Operator.XOR)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_XOR;
        }
        throw new CFAGenerationRuntimeException("Could not proccess Operator: " + op);
    }

    private JExpression convert(NumberLiteral e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        String valueStr = e.getToken();
        JBasicType t = ((JSimpleType)type).getType();
        switch (t) {
            case INT: {
                return new JIntegerLiteralExpression(fileLoc, this.parseIntegerLiteral(valueStr, (ASTNode)e));
            }
            case FLOAT: {
                return new JFloatLiteralExpression(fileLoc, this.parseFloatLiteral(valueStr));
            }
            case DOUBLE: {
                return new JFloatLiteralExpression(fileLoc, this.parseFloatLiteral(valueStr));
            }
        }
        if (valueStr.endsWith("L") || valueStr.endsWith("l")) {
            valueStr = valueStr.substring(0, valueStr.length() - 1);
        }
        if (valueStr.startsWith("0x")) {
            valueStr = valueStr.substring(2);
            return new JIntegerLiteralExpression(this.getFileLocation((ASTNode)e), BigInteger.valueOf(Long.parseLong(valueStr, 16)));
        }
        return new JIntegerLiteralExpression(this.getFileLocation((ASTNode)e), BigInteger.valueOf(Long.parseLong(valueStr)));
    }

    private BigDecimal parseFloatLiteral(String valueStr) {
        BigDecimal value;
        try {
            value = new BigDecimal(valueStr);
        }
        catch (NumberFormatException nfe1) {
            try {
                value = BigDecimal.valueOf(Double.parseDouble(valueStr));
            }
            catch (NumberFormatException nfe2) {
                throw new CFAGenerationRuntimeException("Illegal floating point literal", nfe2);
            }
        }
        return value;
    }

    private BigInteger parseIntegerLiteral(String s, ASTNode e) {
        BigInteger result;
        assert (!s.endsWith("l") && !s.endsWith("L"));
        try {
            if (s.startsWith("0x") || s.startsWith("0X")) {
                s = s.substring(2);
                result = new BigInteger(s, 16);
            } else {
                result = s.startsWith("0") ? new BigInteger(s, 8) : (s.startsWith("0b || 0B") ? new BigInteger(s, 2) : new BigInteger(s, 10));
            }
        }
        catch (NumberFormatException e1) {
            throw new CFAGenerationRuntimeException("Invalid int [" + s + "]", e1);
        }
        ASTConverter.check(this.isInIntegerRange(result), "Invalid int [" + s + "]", e);
        return result;
    }

    private boolean isInIntegerRange(BigInteger value) {
        BigInteger smallestPossibleValue = BigInteger.valueOf(Integer.MIN_VALUE);
        BigInteger biggestPossibleValue = BigInteger.valueOf(Integer.MAX_VALUE);
        return value.compareTo(smallestPossibleValue) >= 0 && value.compareTo(biggestPossibleValue) <= 0;
    }

    public JMethodInvocationAssignmentStatement getIteratorFromIterable(Expression pExpr) {
        JExpression iterable = this.convertExpressionWithoutSideEffects(pExpr);
        if (!(iterable instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException(pExpr + " was not correctly processed.", (ASTNode)pExpr);
        }
        FileLocation fileLoc = this.getFileLocation((ASTNode)pExpr);
        ImmutableList parameters = ImmutableList.of();
        JInterfaceType iteratorTyp = JInterfaceType.createUnresolvableType();
        JIdExpression name = new JIdExpression(fileLoc, iteratorTyp, "iterator", null);
        JReferencedMethodInvocationExpression mi = new JReferencedMethodInvocationExpression(fileLoc, iteratorTyp, name, (List<? extends JExpression>)parameters, null, (JIdExpression)iterable);
        Object varName = "it_";
        int i = 0;
        while (this.scope.variableNameInUse((String)varName + i, (String)varName + i)) {
            ++i;
        }
        varName = (String)varName + i;
        JVariableDeclaration decl = new JVariableDeclaration(fileLoc, iteratorTyp, (String)varName, (String)varName, this.getQualifiedName((String)varName), null, false);
        this.scope.registerDeclarationOfThisClass(decl);
        this.preSideAssignments.add(decl);
        this.enhancedForLoopIterator = new JIdExpression(decl.getFileLocation(), iteratorTyp, (String)varName, decl);
        return new JMethodInvocationAssignmentStatement(fileLoc, this.enhancedForLoopIterator, mi);
    }

    public JExpression createIteratorCondition(Expression e) {
        FileLocation fileloc = this.enhancedForLoopIterator.getFileLocation();
        JSimpleType type = JSimpleType.getBoolean();
        JIdExpression name = new JIdExpression(fileloc, type, "hasNext", null);
        ImmutableList parameters = ImmutableList.of();
        JReferencedMethodInvocationExpression mi = new JReferencedMethodInvocationExpression(fileloc, type, name, (List<? extends JExpression>)parameters, null, this.enhancedForLoopIterator);
        return this.addSideassignmentsForExpressionsWithoutMethodInvocationSideEffects(mi, e);
    }

    public JMethodInvocationAssignmentStatement assignParameterToNextIteratorItem(SingleVariableDeclaration formalParameter) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)formalParameter);
        JSimpleDeclaration param = this.scope.lookupVariable(NameConverter.convertName(formalParameter.resolveBinding()));
        if (param == null) {
            throw new CFAGenerationRuntimeException("Formal Parameter " + formalParameter + " could not be proccessed", (ASTNode)formalParameter);
        }
        JIdExpression paramIdExpr = new JIdExpression(fileLoc, param.getType(), param.getName(), param);
        ImmutableList parameters = ImmutableList.of();
        JIdExpression name = new JIdExpression(fileLoc, param.getType(), "next", null);
        JReferencedMethodInvocationExpression mi = new JReferencedMethodInvocationExpression(fileLoc, param.getType(), name, (List<? extends JExpression>)parameters, null, this.enhancedForLoopIterator);
        this.enhancedForLoopIterator = null;
        return new JMethodInvocationAssignmentStatement(fileLoc, paramIdExpr, mi);
    }

    JStringLiteralExpression convert(StringLiteral e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        return new JStringLiteralExpression(fileLoc, type, e.getLiteralValue());
    }

    JNullLiteralExpression convert(NullLiteral e) {
        return new JNullLiteralExpression(this.getFileLocation((ASTNode)e));
    }

    JCharLiteralExpression convert(CharacterLiteral e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        return new JCharLiteralExpression(fileLoc, type, e.charValue());
    }

    public JExpression convertBooleanExpression(Expression e) {
        JExpression exp = this.convertExpressionWithoutSideEffects(e);
        if (!this.isBooleanExpression(exp)) {
            JBooleanLiteralExpression zero = new JBooleanLiteralExpression(exp.getFileLocation(), false);
            return new JBinaryExpression(exp.getFileLocation(), exp.getExpressionType(), exp, zero, JBinaryExpression.BinaryOperator.NOT_EQUALS);
        }
        return exp;
    }

    public boolean isBooleanExpression(JExpression e) {
        if (e instanceof JBinaryExpression) {
            return BOOLEAN_BINARY_OPERATORS.contains((Object)((JBinaryExpression)e).getOperator());
        }
        if (e instanceof JUnaryExpression) {
            return ((JUnaryExpression)e).getOperator() == JUnaryExpression.UnaryOperator.NOT;
        }
        JType type = e.getExpressionType();
        return type instanceof JSimpleType && ((JSimpleType)type).getType() == JBasicType.BOOLEAN;
    }

    JObjectReferenceReturn getConstructorObjectReturn(ITypeBinding declaringClass) {
        assert (declaringClass.isClass() || declaringClass.isEnum()) : declaringClass.getName() + " is not a Class";
        JClassType objectReturnType = (JClassType)this.convert(declaringClass);
        return new JObjectReferenceReturn(FileLocation.DUMMY, objectReturnType);
    }

    public JRunTimeTypeEqualsType convertClassRunTimeCompileTimeAccord(FileLocation fileloc, JMethodInvocationExpression methodInvocation, JClassOrInterfaceType classType) {
        if (methodInvocation instanceof JReferencedMethodInvocationExpression) {
            JIdExpression referencedVariable = ((JReferencedMethodInvocationExpression)methodInvocation).getReferencedVariable();
            JVariableRunTimeType methodReturnType = new JVariableRunTimeType(fileloc, referencedVariable);
            return new JRunTimeTypeEqualsType(fileloc, methodReturnType, classType);
        }
        return new JRunTimeTypeEqualsType(fileloc, new JThisExpression(fileloc, methodInvocation.getDeclaringType()), classType);
    }

    public void assignRunTimeClass(JReferencedMethodInvocationExpression methodInvocation, JClassInstanceCreation functionCall) {
        JClassOrInterfaceType returnType = functionCall.getExpressionType();
        methodInvocation.setRunTimeBinding(returnType);
    }

    public JExpressionAssignmentStatement getBooleanAssign(JLeftHandSide pLeftHandSide, boolean booleanLiteral) {
        return new JExpressionAssignmentStatement(pLeftHandSide.getFileLocation(), pLeftHandSide, new JBooleanLiteralExpression(pLeftHandSide.getFileLocation(), booleanLiteral));
    }

    public JMethodDeclaration createDefaultConstructor(ITypeBinding classBinding) {
        ImmutableList paramTypes = ImmutableList.of();
        ImmutableList param = ImmutableList.of();
        JConstructorType type = new JConstructorType((JClassType)this.convert(classBinding), (List<JType>)paramTypes, false);
        String simpleName = this.getSimpleName(classBinding);
        return new JConstructorDeclaration(FileLocation.DUMMY, type, NameConverter.convertDefaultConstructorName(classBinding), simpleName, (List<JParameterDeclaration>)param, VisibilityModifier.PUBLIC, false, type.getReturnType());
    }

    static class ModifierBean {
        private final boolean isFinal;
        private final boolean isStatic;
        private final boolean isVolatile;
        private final boolean isTransient;
        private final boolean isNative;
        private final boolean isAbstract;
        private final boolean isStrictFp;
        private final boolean isSynchronized;
        private final VisibilityModifier visibility;

        public ModifierBean(boolean pIsFinal, boolean pIsStatic, boolean pIsVolatile, boolean pIsTransient, VisibilityModifier pVisibility, boolean pIsNative, boolean pIsAbstract, boolean pIsStrictFp, boolean pIsSynchronized) {
            this.visibility = pVisibility;
            this.isFinal = pIsFinal;
            this.isStatic = pIsStatic;
            this.isVolatile = pIsVolatile;
            this.isTransient = pIsTransient;
            this.isNative = pIsNative;
            this.isAbstract = pIsAbstract;
            this.isStrictFp = pIsStrictFp;
            this.isSynchronized = pIsSynchronized;
        }

        public static ModifierBean getModifiers(IMethodBinding imb) {
            return ModifierBean.getModifiers(imb.getModifiers());
        }

        public static ModifierBean getModifiers(int modifiers) {
            boolean isFinal = Modifier.isFinal((int)modifiers);
            boolean isStatic = Modifier.isStatic((int)modifiers);
            boolean isVolatile = Modifier.isVolatile((int)modifiers);
            boolean isTransient = Modifier.isTransient((int)modifiers);
            boolean isNative = Modifier.isNative((int)modifiers);
            boolean isAbstract = Modifier.isAbstract((int)modifiers);
            boolean isStrictFp = Modifier.isStrictfp((int)modifiers);
            boolean isSynchronized = Modifier.isSynchronized((int)modifiers);
            VisibilityModifier visibility = null;
            if (Modifier.isPublic((int)modifiers)) {
                visibility = VisibilityModifier.PUBLIC;
            }
            if (Modifier.isProtected((int)modifiers)) {
                assert (visibility == null) : "Can only declare one Visibility Modifier";
                visibility = VisibilityModifier.PROTECTED;
            }
            if (Modifier.isPrivate((int)modifiers)) {
                assert (visibility == null) : "Can only declare one Visibility Modifier";
                visibility = VisibilityModifier.PRIVATE;
            }
            if (visibility == null) {
                visibility = VisibilityModifier.NONE;
            }
            return new ModifierBean(isFinal, isStatic, isVolatile, isTransient, visibility, isNative, isAbstract, isStrictFp, isSynchronized);
        }

        public static ModifierBean getModifiers(ITypeBinding pBinding) {
            int modifiers = pBinding.getModifiers();
            assert (pBinding.isClass() || pBinding.isEnum() || pBinding.isInterface() || pBinding.isAnnotation() || pBinding.isRecovered()) : "This type can't have modifiers";
            return ModifierBean.getModifiers(modifiers);
        }

        static ModifierBean getModifiers(List<IExtendedModifier> modifiers) {
            VisibilityModifier visibility = null;
            boolean isFinal = false;
            boolean isStatic = false;
            boolean isVolatile = false;
            boolean isTransient = false;
            boolean isNative = false;
            boolean isAbstract = false;
            boolean isStrictFp = false;
            boolean isSynchronized = false;
            block14: for (IExtendedModifier modifier : modifiers) {
                if (!modifier.isModifier()) continue;
                Modifier.ModifierKeyword modifierEnum = ((Modifier)modifier).getKeyword();
                switch (modifierEnum.toFlagValue()) {
                    case 16: {
                        isFinal = true;
                        continue block14;
                    }
                    case 8: {
                        isStatic = true;
                        continue block14;
                    }
                    case 64: {
                        isVolatile = true;
                        continue block14;
                    }
                    case 128: {
                        isTransient = true;
                        continue block14;
                    }
                    case 1: {
                        assert (visibility == null) : "Can only declare one Visibility Modifier";
                        visibility = VisibilityModifier.PUBLIC;
                        continue block14;
                    }
                    case 4: {
                        assert (visibility == null) : "Can only declare one Visibility Modifier";
                        visibility = VisibilityModifier.PROTECTED;
                        continue block14;
                    }
                    case 0: {
                        assert (visibility == null) : "Can only declare one Visibility Modifier";
                        visibility = VisibilityModifier.NONE;
                        continue block14;
                    }
                    case 2: {
                        assert (visibility == null) : "Can only declare one Visibility Modifier";
                        visibility = VisibilityModifier.PRIVATE;
                        continue block14;
                    }
                    case 256: {
                        isNative = true;
                        continue block14;
                    }
                    case 1024: {
                        isAbstract = true;
                        continue block14;
                    }
                    case 2048: {
                        isStrictFp = true;
                        continue block14;
                    }
                    case 32: {
                        isSynchronized = true;
                        continue block14;
                    }
                }
                throw new AssertionError((Object)"Unkown  Modifier");
            }
            if (visibility == null) {
                visibility = VisibilityModifier.NONE;
            }
            return new ModifierBean(isFinal, isStatic, isVolatile, isTransient, visibility, isNative, isAbstract, isStrictFp, isSynchronized);
        }

        public VisibilityModifier getVisibility() {
            return this.visibility;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isVolatile() {
            return this.isVolatile;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public boolean isNative() {
            return this.isNative;
        }

        public boolean isAbstract() {
            return this.isAbstract;
        }

        public boolean isStrictFp() {
            return this.isStrictFp;
        }

        public boolean isSynchronized() {
            return this.isSynchronized;
        }
    }

    private static class NameAndInitializer {
        private final String name;
        private final JInitializerExpression initializer;

        public NameAndInitializer(String pName, JInitializerExpression pInitializer) {
            Preconditions.checkNotNull((Object)pName);
            this.name = pName;
            this.initializer = pInitializer;
        }

        public String getName() {
            return this.name;
        }

        public @Nullable JInitializerExpression getInitializer() {
            return this.initializer;
        }
    }
}

