/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTConverter;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;

public class ASTConverterTest {
    private static JClassType jClassType;

    @BeforeClass
    public static void init() {
        jClassType = ASTConverterTest.createStringJClassType("java.lang.String", "String");
    }

    @Test
    public void testGetClassOfJType() {
        Optional<Class<?>> optionalOfPrimitiveType = ASTConverter.getClassOfJType(JSimpleType.getBoolean(), (Set<ImportDeclaration>)ImmutableSet.of());
        Truth.assertThat(optionalOfPrimitiveType.orElseThrow()).isEqualTo(Boolean.TYPE);
    }

    @Test
    public void testGetClassOfPrimitiveType() {
        Truth.assertThat(ASTConverter.getClassOfPrimitiveType(JSimpleType.getInt())).isEqualTo(Integer.TYPE);
        Truth.assertThat(ASTConverter.getClassOfPrimitiveType(JSimpleType.getLong())).isEqualTo(Long.TYPE);
        Truth.assertThat(ASTConverter.getClassOfPrimitiveType(JSimpleType.getVoid())).isEqualTo(Void.TYPE);
    }

    @Test
    public void testGetClassOfJTypeForNonPrimitiveType() {
        Optional<Class<?>> optionalOfStringClass = ASTConverter.getClassOfJType(jClassType, (Set<ImportDeclaration>)ImmutableSet.of());
        Truth.assertThat(optionalOfStringClass.orElseThrow()).isEqualTo(String.class);
    }

    @Test
    public void testGetArrayClass() {
        JArrayType jArrayTypeOfString = new JArrayType(jClassType, 3);
        Optional<Class<?>> optionalOfArrayClass = ASTConverter.getClassOfJType(jArrayTypeOfString, (Set<ImportDeclaration>)ImmutableSet.of());
        Truth.assertThat((Boolean)optionalOfArrayClass.orElseThrow().isArray()).isTrue();
        Truth.assertThat((String)optionalOfArrayClass.orElseThrow().toGenericString()).isEqualTo((Object)"java.lang.String[][][]");
    }

    private static JClassType createStringJClassType(String pFullyQualifiedName, String pString) {
        return JClassType.valueOf(pFullyQualifiedName, pString, VisibilityModifier.PUBLIC, true, false, false, JClassType.getTypeOfObject(), (Set<JInterfaceType>)ImmutableSet.of());
    }

    @Test
    public void testUnboxing() {
        JClassType jClassTypeOfInteger = ASTConverterTest.createStringJClassType("java.lang.Integer", "Integer");
        Truth.assertThat((Comparable)((Object)ASTConverter.unboxJClassType(jClassTypeOfInteger).orElseThrow())).isEqualTo((Object)JBasicType.INT);
    }
}

