/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.NameConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeConverter;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;

class ASTTypeConverter
extends TypeConverter {
    private final Scope scope;

    public ASTTypeConverter(Scope pScope) {
        this.scope = pScope;
    }

    @Override
    public JInterfaceType convertInterfaceType(ITypeBinding t) {
        if (t.isClass()) {
            return JInterfaceType.createUnresolvableType();
        }
        Preconditions.checkArgument((boolean)t.isInterface());
        String typeName = NameConverter.convertClassOrInterfaceToFullName(t);
        if (this.scope.containsInterfaceType(typeName)) {
            return this.scope.getInterfaceType(typeName);
        }
        return this.scope.createNewInterfaceType(t);
    }

    @Override
    public JClassType convertClassType(ITypeBinding t) {
        Preconditions.checkArgument((t.isClass() || t.isEnum() ? 1 : 0) != 0);
        String typeName = NameConverter.convertClassOrInterfaceToFullName(t);
        if (this.scope.containsClassType(typeName)) {
            return this.scope.getClassType(typeName);
        }
        if (this.scope.containsClassType("java.lang." + typeName)) {
            return this.scope.getClassType("java.lang." + typeName);
        }
        return this.scope.createNewClassType(t);
    }
}

