/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodEntryNode;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAMethodBuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;
import org.sosy_lab.cpachecker.util.Pair;

class CFABuilder
extends ASTVisitor {
    private static final boolean SKIP_CHILDREN = false;
    private static final boolean VISIT_CHILDREN = true;
    private final Map<String, JMethodDeclaration> allParsedMethodDeclaration = new HashMap<String, JMethodDeclaration>();
    private final NavigableMap<String, FunctionEntryNode> cfas = new TreeMap<String, FunctionEntryNode>();
    private final TreeMultimap<String, CFANode> cfaNodes = TreeMultimap.create();
    private final Scope scope;
    private final ASTConverter astCreator;
    private final LogManager logger;

    public CFABuilder(LogManager pLogger, Scope pScope) {
        this.logger = pLogger;
        this.scope = pScope;
        this.astCreator = new ASTConverter(this.scope, this.logger);
    }

    public NavigableMap<String, FunctionEntryNode> getCFAs() {
        return this.cfas;
    }

    public TreeMultimap<String, CFANode> getCFANodes() {
        return this.cfaNodes;
    }

    public List<Pair<ADeclaration, String>> getStaticFieldDeclarations() {
        Map<String, JFieldDeclaration> staticFieldDeclarations = this.scope.getStaticFieldDeclarations();
        ArrayList<Pair<ADeclaration, String>> result = new ArrayList<Pair<ADeclaration, String>>(staticFieldDeclarations.size());
        for (Map.Entry<String, JFieldDeclaration> entry : staticFieldDeclarations.entrySet()) {
            ADeclaration declaration = entry.getValue();
            result.add(Pair.of(declaration, entry.getKey()));
        }
        return result;
    }

    public boolean visit(AnonymousClassDeclaration pClassDeclaration) {
        ITypeBinding classBinding = pClassDeclaration.resolveBinding();
        if (classBinding == null) {
            this.logger.logf(Level.WARNING, "Binding for anonymous class %s can't be resolved. Skipping class body.", new Object[]{pClassDeclaration.toString()});
            return false;
        }
        this.scope.enterClass(this.astCreator.convertClassOrInterfaceType(pClassDeclaration.resolveBinding()));
        return super.visit(pClassDeclaration);
    }

    public void endVisit(AnonymousClassDeclaration pClassDeclaration) {
        this.createConstructors(pClassDeclaration);
        this.scope.leaveClass();
    }

    private void createConstructors(AnonymousClassDeclaration pClassDeclaration) {
        CFAMethodBuilder methodBuilder = new CFAMethodBuilder(this.logger, this.scope, this.astCreator);
        methodBuilder.createConstructors(pClassDeclaration);
        this.addMethodToCfas(methodBuilder.getStartNode(), methodBuilder.getCfaNodes());
    }

    public boolean visit(TypeDeclaration typeDec) {
        ITypeBinding classBinding = typeDec.resolveBinding();
        if (!typeDec.isPackageMemberTypeDeclaration()) {
            ASTConverter.ModifierBean mB = ASTConverter.ModifierBean.getModifiers(typeDec.resolveBinding());
            if (mB.isStatic() || typeDec.isInterface()) {
                this.scope.enterClass(this.astCreator.convertClassOrInterfaceType(classBinding));
                return true;
            }
            return false;
        }
        this.scope.enterClass(this.astCreator.convertClassOrInterfaceType(classBinding));
        return true;
    }

    public boolean visit(MethodDeclaration md) {
        CFAMethodBuilder methodBuilder = new CFAMethodBuilder(this.logger, this.scope, this.astCreator);
        md.accept((ASTVisitor)methodBuilder);
        JMethodEntryNode startNode = methodBuilder.getStartNode();
        Set<CFANode> allMethodNodes = methodBuilder.getCfaNodes();
        this.addMethodToCfas(startNode, allMethodNodes);
        return false;
    }

    private void addMethodToCfas(FunctionEntryNode pStartNode, Set<CFANode> pMethodNodes) {
        String methodName = pStartNode.getFunctionName();
        if (this.cfas.containsKey(methodName)) {
            throw new CFAGenerationRuntimeException("Duplicate method " + methodName);
        }
        this.cfas.put(methodName, pStartNode);
        this.cfaNodes.putAll((Object)methodName, pMethodNodes);
        this.allParsedMethodDeclaration.put(methodName, (JMethodDeclaration)pStartNode.getFunctionDefinition());
    }

    public boolean visit(FieldDeclaration fd) {
        List<JDeclaration> newDs = this.astCreator.convert(fd);
        assert (!newDs.isEmpty());
        if (this.astCreator.numberOfPreSideAssignments() > 0) {
            throw new CFAGenerationRuntimeException("Initializer of field variable has side effect.", (ASTNode)fd);
        }
        return false;
    }

    public void endVisit(TypeDeclaration typeDef) {
        ASTConverter.ModifierBean mB;
        if (!(typeDef.isPackageMemberTypeDeclaration() || (mB = ASTConverter.ModifierBean.getModifiers(typeDef.resolveBinding())).isStatic() || typeDef.isInterface())) {
            return;
        }
        ITypeBinding classBinding = typeDef.resolveBinding();
        boolean hasDefaultConstructor = this.hasDefaultConstructor(classBinding);
        if (hasDefaultConstructor) {
            CFAMethodBuilder methodBuilder = new CFAMethodBuilder(this.logger, this.scope, this.astCreator);
            methodBuilder.createDefaultConstructor(classBinding);
            JMethodEntryNode startNode = methodBuilder.getStartNode();
            String methodName = startNode.getFunctionName();
            if (this.cfas.containsKey(methodName)) {
                throw new CFAGenerationRuntimeException("Duplicate default Constructor " + methodName);
            }
            this.cfas.put(methodName, startNode);
            this.cfaNodes.putAll((Object)methodName, methodBuilder.getCfaNodes());
            this.allParsedMethodDeclaration.put(methodName, null);
        }
        this.scope.leaveClass();
    }

    private boolean hasDefaultConstructor(ITypeBinding classBinding) {
        IMethodBinding[] declaredMethods;
        if (classBinding.isInterface()) {
            return false;
        }
        for (IMethodBinding declaredMethod : declaredMethods = classBinding.getDeclaredMethods()) {
            if (declaredMethod.isDefaultConstructor()) {
                return true;
            }
            if (!declaredMethod.isConstructor()) continue;
            return false;
        }
        return true;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Map<String, JMethodDeclaration> getAllParsedMethodDeclaration() {
        return this.allParsedMethodDeclaration;
    }

    public ASTConverter getAstCreator() {
        return this.astCreator;
    }

    public void preVisit(ASTNode problem) {
        if (8 == (problem.getFlags() & 8) || 1 == (problem.getFlags() & 1)) {
            throw new CFAGenerationRuntimeException("Syntax error.", problem);
        }
    }
}

