/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNode;

class CFAGenerationRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 6850281425209171013L;
    private static final CharMatcher SEMICOLON = CharMatcher.is((char)';');

    public CFAGenerationRuntimeException(String msg) {
        super(msg);
    }

    public CFAGenerationRuntimeException(Throwable cause) {
        super(cause.getMessage(), cause);
    }

    public CFAGenerationRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public CFAGenerationRuntimeException(String msg, ASTNode astNode) {
        this(astNode == null ? msg : CFAGenerationRuntimeException.createMessage(msg, astNode));
    }

    public CFAGenerationRuntimeException(String msg, JAstNode astNode) {
        this((String)(astNode == null ? msg : astNode.getFileLocation() + ": " + msg + ": " + astNode.toASTString()));
    }

    private static String createMessage(String msg, ASTNode node) {
        ASTNode fullLine;
        String rawSignature = node.toString();
        StringBuilder sb = new StringBuilder();
        sb.append("Line ");
        sb.append(node.getStartPosition());
        sb.append(": ");
        if (Strings.isNullOrEmpty((String)msg)) {
            sb.append("An unspecified problem occurred.");
        } else {
            sb.append(msg);
        }
        sb.append("\n");
        sb.append(rawSignature);
        for (fullLine = node; fullLine != null && !(fullLine instanceof Statement) && !(fullLine instanceof BodyDeclaration); fullLine = fullLine.getParent()) {
        }
        if (fullLine != null && !fullLine.equals((Object)node)) {
            String lineRawSignature = fullLine.toString();
            String codeWithoutWhitespace = CharMatcher.whitespace().removeFrom((CharSequence)rawSignature);
            String lineWithoutWhitespace = CharMatcher.whitespace().removeFrom((CharSequence)lineRawSignature);
            if (!(codeWithoutWhitespace = SEMICOLON.trimFrom((CharSequence)codeWithoutWhitespace)).equals(lineWithoutWhitespace = SEMICOLON.trimFrom((CharSequence)lineWithoutWhitespace))) {
                sb.append(" (full line is ");
                sb.append(lineRawSignature);
                sb.append(")");
            }
        }
        return sb.toString();
    }
}

