/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JConstructorDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JReferencedMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JStatement;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JStatementEdge;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFABuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JMethodType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

class DynamicBindingCreator {
    private final ASTConverter astCreator;
    private final CFABuilder cfaBuilder;
    private final Map<String, List<MethodDefinition>> subMethodsOfMethod = new HashMap<String, List<MethodDefinition>>();
    private final Map<String, List<MethodDefinition>> methodTypeBindingsOfMethod = new HashMap<String, List<MethodDefinition>>();

    public DynamicBindingCreator(CFABuilder builder) {
        this.cfaBuilder = builder;
        this.astCreator = builder.getAstCreator();
    }

    public void trackAndCreateDynamicBindings() {
        NavigableMap<String, FunctionEntryNode> cfAs = this.cfaBuilder.getCFAs();
        this.trackOverridenMethods(cfAs);
        this.completeMethodBindings();
        for (FunctionEntryNode value : cfAs.values()) {
            this.insertBindings(value);
        }
    }

    private void trackOverridenMethods(Map<String, FunctionEntryNode> cfAs) {
        Map<String, JMethodDeclaration> allParsedMethodDeclaration = this.cfaBuilder.getAllParsedMethodDeclaration();
        for (Map.Entry<String, FunctionEntryNode> entry : cfAs.entrySet()) {
            String functionName = entry.getKey();
            FunctionEntryNode currEntryNode = entry.getValue();
            JMethodDeclaration currMethod = allParsedMethodDeclaration.get(functionName);
            assert (allParsedMethodDeclaration.containsKey(functionName));
            if (currMethod == null || this.isConstructor(currMethod)) continue;
            this.trackOverridenMethods(currMethod, currEntryNode);
        }
    }

    private boolean isConstructor(JMethodDeclaration pFunction) {
        return pFunction instanceof JConstructorDeclaration;
    }

    private void completeMethodBindings() {
        for (Map.Entry<String, List<MethodDefinition>> entry : this.subMethodsOfMethod.entrySet()) {
            this.methodTypeBindingsOfMethod.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        HashMap workMap = new HashMap();
        for (Map.Entry<String, List<MethodDefinition>> entry : this.subMethodsOfMethod.entrySet()) {
            workMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        Map<String, JMethodDeclaration> map = this.cfaBuilder.getAllParsedMethodDeclaration();
        for (String methodName : workMap.keySet()) {
            JMethodDeclaration methodDeclaration = map.get(methodName);
            if (methodDeclaration == null || this.isConstructor(methodDeclaration)) continue;
            this.completeBindingsOfMethod(methodDeclaration, methodName);
        }
    }

    private void completeBindingsOfMethod(JMethodDeclaration methodDeclaration, String methodName) {
        JClassOrInterfaceType methodDeclaringType = methodDeclaration.getDeclaringClass();
        if (methodDeclaringType instanceof JClassType) {
            this.completeBindingsForDeclaringClassType((JClassType)methodDeclaringType, methodName);
        } else if (methodDeclaringType instanceof JInterfaceType) {
            this.completeBindingsForDeclaringInterfaceType((JInterfaceType)methodDeclaringType, methodName);
        }
    }

    private void completeBindingsForDeclaringInterfaceType(JInterfaceType methodDeclaringType, String methodName) {
        Set<JClassType> directImplementingClasses = methodDeclaringType.getKnownInterfaceImplementingClasses();
        for (JClassType implementingClasses : directImplementingClasses) {
            this.completeBindingsForClass(implementingClasses, methodName, methodName);
        }
        Set<JInterfaceType> subInterfaces = methodDeclaringType.getAllSubInterfacesOfInterface();
        for (JInterfaceType subInterface : subInterfaces) {
            for (JClassType implementingClasses : subInterface.getKnownInterfaceImplementingClasses()) {
                this.completeBindingsForClass(implementingClasses, methodName, methodName);
            }
        }
    }

    private void completeBindingsForDeclaringClassType(JClassType methodDeclaringType, String methodName) {
        Set<JClassType> directSubClasses = methodDeclaringType.getDirectSubClasses();
        for (JClassType subClass : directSubClasses) {
            this.completeBindingsForClass(subClass, methodName, methodName);
        }
    }

    private void completeBindingsForClass(JClassType classType, String methodNametoBeRegistered, String methodNameToRegister) {
        String nextMethodNameToRegister = this.updateBinding(classType, methodNametoBeRegistered, methodNameToRegister);
        Set<JClassType> directSubClasses = classType.getDirectSubClasses();
        for (JClassType subClass : directSubClasses) {
            this.completeBindingsForClass(subClass, methodNametoBeRegistered, nextMethodNameToRegister);
        }
    }

    private String updateBinding(JClassType classType, String methodNametoBeRegistered, String methodNameToRegister) {
        List<MethodDefinition> subMethodBindings = this.subMethodsOfMethod.get(methodNameToRegister);
        String nextMethodNameToRegister = methodNameToRegister;
        Pair<Boolean, String> hasBindingAndBindingMethodName = this.typeHasBinding(classType, subMethodBindings);
        if (hasBindingAndBindingMethodName.getFirst().booleanValue()) {
            nextMethodNameToRegister = hasBindingAndBindingMethodName.getSecond();
        } else {
            MethodDefinition methodDefinition = new MethodDefinition((FunctionEntryNode)this.cfaBuilder.getCFAs().get(methodNameToRegister), classType);
            this.methodTypeBindingsOfMethod.get(methodNametoBeRegistered).add(methodDefinition);
        }
        return nextMethodNameToRegister;
    }

    private Pair<Boolean, String> typeHasBinding(JClassOrInterfaceType classType, List<MethodDefinition> subMethodBindings) {
        for (MethodDefinition methodTypeBindingPair : subMethodBindings) {
            boolean result = methodTypeBindingPair.getDefiningType().equals(classType);
            if (!result) continue;
            return Pair.of(true, methodTypeBindingPair.getMethodEntryNode().getFunctionName());
        }
        return Pair.of(false, null);
    }

    private void insertBindings(FunctionEntryNode initialNode) {
        ArrayDeque<CFANode> workList = new ArrayDeque<CFANode>();
        HashSet<CFANode> processed = new HashSet<CFANode>();
        workList.addLast(initialNode);
        while (!workList.isEmpty()) {
            CFANode node = (CFANode)workList.pollFirst();
            if (!processed.add(node)) continue;
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                AStatementEdge statement;
                JStatement expr;
                if (edge instanceof AStatementEdge && (expr = (JStatement)(statement = (AStatementEdge)edge).getStatement()) instanceof AFunctionCall) {
                    this.createBindings(statement, (AFunctionCall)((Object)expr), processed);
                }
                CFANode successorNode = edge.getSuccessor();
                if (!node.getFunctionName().equals(successorNode.getFunctionName())) continue;
                workList.add(successorNode);
            }
        }
    }

    private void createBindings(AStatementEdge edge, AFunctionCall functionCall, Set<CFANode> pProcessed) {
        JMethodInvocationExpression functionCallExpression = (JMethodInvocationExpression)functionCall.getFunctionCallExpression();
        String functionName = functionCallExpression.getFunctionNameExpression().toASTString();
        if (this.bindingForMethodExists(functionName)) {
            if (functionCallExpression instanceof JReferencedMethodInvocationExpression) {
                if (!functionCallExpression.hasKnownRunTimeBinding()) {
                    this.createMethodInvocationBindings(edge, pProcessed, functionName);
                } else {
                    this.createOnlyReferencedMethodInvocationBinding(edge, this.subMethodsOfMethod.get(functionName));
                }
            } else if (this.invocationDependsOnRuntimeType(functionCallExpression)) {
                this.createMethodInvocationBindings(edge, pProcessed, functionName);
            }
        }
    }

    private boolean bindingForMethodExists(String pMethodName) {
        return this.methodTypeBindingsOfMethod.get(pMethodName) != null && !this.methodTypeBindingsOfMethod.get(pMethodName).isEmpty();
    }

    private boolean invocationDependsOnRuntimeType(JMethodInvocationExpression pMethodInvocation) {
        JMethodDeclaration method = pMethodInvocation.getDeclaration();
        return !method.isStatic() && !method.isFinal() && !(pMethodInvocation.getDeclaringType() instanceof JInterfaceType) && !((JClassType)pMethodInvocation.getDeclaringType()).isFinal() && !pMethodInvocation.hasKnownRunTimeBinding();
    }

    private void createMethodInvocationBindings(AStatementEdge edge, Set<CFANode> pProcessed, String functionName) {
        CFANode prevNode = edge.getPredecessor();
        CFANode postConditionNode = edge.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(edge);
        List<MethodDefinition> typesDefiningMethod = this.methodTypeBindingsOfMethod.get(functionName);
        for (MethodDefinition overridesThisMethod : typesDefiningMethod) {
            if (overridesThisMethod.isAbstract()) continue;
            prevNode = this.createBinding(edge, overridesThisMethod, prevNode, postConditionNode, pProcessed);
        }
        this.createLastBinding(edge, prevNode, postConditionNode, pProcessed);
    }

    private void createOnlyReferencedMethodInvocationBinding(AStatementEdge edge, List<MethodDefinition> subMethods) {
        AbstractStatement newFunctionCall;
        FunctionEntryNode onlyFunction = null;
        HashMap<JClassOrInterfaceType, FunctionEntryNode> map = new HashMap<JClassOrInterfaceType, FunctionEntryNode>();
        AFunctionCall oldFunctionCall = (AFunctionCall)edge.getStatement();
        JReferencedMethodInvocationExpression oldFunctionCallExpression = (JReferencedMethodInvocationExpression)oldFunctionCall.getFunctionCallExpression();
        JClassOrInterfaceType runTimeBinding = oldFunctionCallExpression.getRunTimeBinding();
        for (MethodDefinition methodDefinition : subMethods) {
            JClassOrInterfaceType typeThatDefinesMethod = methodDefinition.getDefiningType();
            FunctionEntryNode methodEntry = methodDefinition.getMethodEntryNode();
            if (runTimeBinding.equals(typeThatDefinesMethod)) {
                onlyFunction = methodEntry;
                break;
            }
            map.put(typeThatDefinesMethod, methodEntry);
        }
        if (onlyFunction == null) {
            for (JClassOrInterfaceType jClassOrInterfaceType : runTimeBinding.getAllSuperTypesOfType()) {
                if (!map.containsKey(jClassOrInterfaceType)) continue;
                onlyFunction = (FunctionEntryNode)map.get(jClassOrInterfaceType);
                break;
            }
        }
        if (onlyFunction == null) {
            throw new IllegalArgumentException("No binding for function of type " + runTimeBinding.getName() + " found.");
        }
        CFANode postNode = edge.getSuccessor();
        CFANode cFANode = edge.getPredecessor();
        CFACreationUtils.removeEdgeFromNodes(edge);
        FileLocation fileloc = oldFunctionCallExpression.getFileLocation();
        JReferencedMethodInvocationExpression newFunctionCallExpression = (JReferencedMethodInvocationExpression)this.astCreator.convert(onlyFunction, oldFunctionCallExpression);
        if (oldFunctionCall instanceof JMethodInvocationAssignmentStatement) {
            JMethodInvocationAssignmentStatement oldFunctionCallAssignmentStatement = (JMethodInvocationAssignmentStatement)oldFunctionCall;
            newFunctionCall = new JMethodInvocationAssignmentStatement(fileloc, oldFunctionCallAssignmentStatement.getLeftHandSide(), newFunctionCallExpression);
        } else {
            assert (edge.getStatement() instanceof JMethodInvocationStatement) : "Statement is no Function Call";
            newFunctionCall = new JMethodInvocationStatement(fileloc, newFunctionCallExpression);
        }
        JStatementEdge functionCallEdge = new JStatementEdge(newFunctionCall.toASTString(), (JStatement)((Object)newFunctionCall), edge.getFileLocation(), cFANode, postNode);
        CFACreationUtils.addEdgeToCFA(functionCallEdge, null);
    }

    private void createLastBinding(AStatementEdge edge, CFANode prevNode, CFANode postConditionNode, Set<CFANode> pProcessed) {
        AFunctionCallExpression functionCall = ((AFunctionCall)edge.getStatement()).getFunctionCallExpression();
        AExpression functionName = functionCall.getFunctionNameExpression();
        JMethodDeclaration decl = this.cfaBuilder.getScope().lookupMethod(functionName.toASTString());
        CFANode nextPrevNode = prevNode;
        NavigableMap<String, FunctionEntryNode> cfas = this.cfaBuilder.getCFAs();
        String declarationName = decl.getName();
        if (!decl.isAbstract() && cfas.containsKey(declarationName)) {
            nextPrevNode = this.createBinding(edge, new MethodDefinition((FunctionEntryNode)cfas.get(declarationName), decl.getDeclaringClass()), prevNode, postConditionNode, pProcessed);
        }
        BlankEdge postConditionEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), nextPrevNode, postConditionNode, "");
        CFACreationUtils.addEdgeToCFA(postConditionEdge, null);
    }

    private CFANode createBinding(AStatementEdge edge, MethodDefinition overridesThisMethod, CFANode prevNode, CFANode postConditionNode, Set<CFANode> pProcessed) {
        AbstractStatement newFunctionCall;
        AFunctionCall functionCall = (AFunctionCall)edge.getStatement();
        JMethodInvocationExpression oldFunctionCallExpression = (JMethodInvocationExpression)functionCall.getFunctionCallExpression();
        FileLocation fileloc = oldFunctionCallExpression.getFileLocation();
        AFunctionDeclaration callInFunction = prevNode.getFunction();
        JMethodInvocationExpression newFunctionCallExpression = this.astCreator.convert(overridesThisMethod.getMethodEntryNode(), oldFunctionCallExpression);
        TreeMultimap<String, CFANode> cfas = this.cfaBuilder.getCFANodes();
        CFANode successfulNode = new CFANode(callInFunction);
        cfas.put((Object)callInFunction.getName(), (Object)successfulNode);
        pProcessed.add(successfulNode);
        CFANode unsuccessfulNode = new CFANode(callInFunction);
        cfas.put((Object)callInFunction.getName(), (Object)unsuccessfulNode);
        pProcessed.add(unsuccessfulNode);
        JClassOrInterfaceType definingType = overridesThisMethod.getDefiningType();
        this.createConditionEdges(prevNode, successfulNode, unsuccessfulNode, definingType, newFunctionCallExpression, fileloc);
        if (functionCall instanceof JMethodInvocationAssignmentStatement) {
            JMethodInvocationAssignmentStatement oldFunctionCallAssignmentStatement = (JMethodInvocationAssignmentStatement)functionCall;
            JLeftHandSide leftSide = oldFunctionCallAssignmentStatement.getLeftHandSide();
            newFunctionCall = new JMethodInvocationAssignmentStatement(fileloc, leftSide, newFunctionCallExpression);
        } else {
            assert (edge.getStatement() instanceof JMethodInvocationStatement) : "Statement is no Function Call";
            newFunctionCall = new JMethodInvocationStatement(fileloc, newFunctionCallExpression);
        }
        CFANode postFunctionCallNode = new CFANode(callInFunction);
        this.cfaBuilder.getCFANodes().put((Object)callInFunction.getName(), (Object)postFunctionCallNode);
        pProcessed.add(postFunctionCallNode);
        JStatementEdge functionCallEdge = new JStatementEdge(edge.getRawStatement(), (JStatement)((Object)newFunctionCall), edge.getFileLocation(), successfulNode, postFunctionCallNode);
        CFACreationUtils.addEdgeToCFA(functionCallEdge, null);
        BlankEdge postConditionEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), postFunctionCallNode, postConditionNode, "");
        CFACreationUtils.addEdgeToCFA(postConditionEdge, null);
        return unsuccessfulNode;
    }

    private void createConditionEdges(CFANode prevNode, CFANode successfulNode, CFANode unsuccessfulNode, JClassOrInterfaceType classTypeOfNewMethodInvocation, JMethodInvocationExpression methodInvocation, FileLocation fileloc) {
        JRunTimeTypeEqualsType exp = this.astCreator.convertClassRunTimeCompileTimeAccord(fileloc, methodInvocation, classTypeOfNewMethodInvocation);
        String rawSignature = exp.toASTString();
        JAssumeEdge JAssumeEdgeFalse = new JAssumeEdge("!(" + rawSignature + ")", fileloc, prevNode, unsuccessfulNode, exp, false);
        CFACreationUtils.addEdgeToCFA(JAssumeEdgeFalse, null);
        JAssumeEdge JAssumeEdgeTrue = new JAssumeEdge(rawSignature, fileloc, prevNode, successfulNode, exp, true);
        CFACreationUtils.addEdgeToCFA(JAssumeEdgeTrue, null);
    }

    private void trackOverridenMethods(JMethodDeclaration declaration, FunctionEntryNode entryNode) {
        String functionName = entryNode.getFunctionDefinition().getName();
        if (!this.subMethodsOfMethod.containsKey(functionName)) {
            this.subMethodsOfMethod.put(functionName, new ArrayList());
        }
        MethodDefinition toBeRegistered = this.getMethodDefinition(declaration, entryNode);
        JClassOrInterfaceType declaringClassType = declaration.getDeclaringClass();
        Set<? extends JClassOrInterfaceType> declaringClassesSuperTypes = declaringClassType.getAllSuperTypesOfType();
        this.registerForSuperClass(declaringClassesSuperTypes, toBeRegistered, declaration);
    }

    private void registerForSuperClass(Set<? extends JClassOrInterfaceType> pSuperClasses, MethodDefinition pToBeRegistered, JMethodDeclaration pBindingToBeRegistered) {
        TypeHierarchy typeHierarchy = this.cfaBuilder.getScope().getTypeHierarchy();
        for (JClassOrInterfaceType jClassOrInterfaceType : pSuperClasses) {
            if (typeHierarchy.isExternType(jClassOrInterfaceType)) continue;
            Set<JMethodDeclaration> methods = typeHierarchy.getMethodDeclarations(jClassOrInterfaceType);
            for (JMethodDeclaration m : methods) {
                if (!this.overrides(m, pBindingToBeRegistered)) continue;
                this.registerMethod(m, pToBeRegistered);
            }
        }
    }

    private boolean overrides(JMethodDeclaration pPossiblyOverwriting, JMethodDeclaration pPossiblyOverwritten) {
        JType sndReturnType;
        JMethodType firstType = pPossiblyOverwriting.getType();
        JMethodType sndType = pPossiblyOverwritten.getType();
        if (!pPossiblyOverwriting.getSimpleName().equals(pPossiblyOverwritten.getSimpleName())) {
            return false;
        }
        JType firstReturnType = firstType.getReturnType();
        if (!(firstReturnType.equals(sndReturnType = sndType.getReturnType()) || firstReturnType instanceof JClassOrInterfaceType && sndReturnType instanceof JClassOrInterfaceType && this.isSubType((JClassOrInterfaceType)firstReturnType, (JClassOrInterfaceType)sndReturnType))) {
            return false;
        }
        List<JType> firstParameters = firstType.getParameters();
        List<JType> secondParameters = sndType.getParameters();
        if (firstParameters.size() != secondParameters.size()) {
            return false;
        }
        for (int i = 0; i < firstParameters.size(); ++i) {
            if (firstParameters.get(i).equals(secondParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isSubType(JClassOrInterfaceType pPossibleSubtype, JClassOrInterfaceType pPossibleSuperType) {
        return pPossibleSubtype.getAllSuperTypesOfType().contains(pPossibleSuperType);
    }

    private void registerMethod(JMethodDeclaration pMethodDeclaration, MethodDefinition pToBeRegistered) {
        String overridenMethodName = pMethodDeclaration.getQualifiedName();
        if (!this.subMethodsOfMethod.containsKey(overridenMethodName)) {
            this.subMethodsOfMethod.put(overridenMethodName, new ArrayList());
        }
        this.subMethodsOfMethod.get(overridenMethodName).add(pToBeRegistered);
    }

    private MethodDefinition getMethodDefinition(JMethodDeclaration declaration, FunctionEntryNode entryNode) {
        JClassOrInterfaceType classType = declaration.getDeclaringClass();
        return new MethodDefinition(entryNode, classType);
    }

    private static class MethodDefinition {
        private final FunctionEntryNode methodEntryNode;
        private final JClassOrInterfaceType definingType;

        MethodDefinition(FunctionEntryNode pMethodEntryNode, JClassOrInterfaceType pDefiningType) {
            this.methodEntryNode = pMethodEntryNode;
            this.definingType = pDefiningType;
        }

        FunctionEntryNode getMethodEntryNode() {
            return this.methodEntryNode;
        }

        JClassOrInterfaceType getDefiningType() {
            return this.definingType;
        }

        boolean isAbstract() {
            return this.methodEntryNode instanceof JMethodEntryNode && ((JMethodEntryNode)this.methodEntryNode).getFunctionDefinition().isAbstract();
        }
    }
}

